<!--
// This file contains all of the behavior-layer stuff for the Liquid evoSkin for b2evolution by Isaac Z. Schlueter
// Please give credit-in-code if you use any of the scripts I wrote.  It helps people find info on functions if
// they reuse.  Thanks.
// Isaac Z. Schlueter http://isaacschlueter.com

// by Scott Andrew lePera
// add an eventlistener to browsers that can do it somehow.
function addEvent(obj, evType, fn)
{
	if (obj.addEventListener)
	{
		obj.addEventListener(evType, fn, false);
		return true;
	}
	else if (obj.attachEvent)
	{
		var r = obj.attachEvent('on'+evType, fn);
		return r;
	}
	else return false;
}

// Dunstan Orchard
// http://1976design.com/blog/archive/2003/11/10/updates/
// Altered from original idea by Simon Willison at:
// http://simon.incutio.com/archive/2002/12/20/blockquoteCitations
function extractBlockquoteInfo()
{
	if(!document.getElementsByTagName) return;
	var quotes = document.getElementsByTagName('blockquote');
	for (i = 0; i < quotes.length; i++)
	{
		cite = quotes[i].getAttribute('cite');
		title = quotes[i].getAttribute('title');
		quotes[i].removeAttribute('title');

		if ((cite) && (cite != ''))
		{
			if ( (cite.match('http://', 'i')) || (cite.match('ftp://', 'i')) || (cite.match('person://', 'i')) )
			{
				newlink = document.createElement('a');
				newlink.setAttribute('href', cite);
				newlink.setAttribute('title', 'Go to ' + cite);
				if ((title) && (title != ''))
				{
					newlink.appendChild(document.createTextNode(title));
				}
				else
				{
					newlink.appendChild(document.createTextNode('Quote source'));
				}
				newdiv = document.createElement('div');
				newdiv.className = 'source';
				newdiv.appendChild(document.createTextNode('\u2014 '));
				newdiv.appendChild(newlink);
				quotes[i].appendChild(newdiv);
			}
			else
			{
				newdiv = document.createElement('div');
				newdiv.className = 'source';
				newdiv.appendChild(document.createTextNode('\u2014 ' + cite));
				quotes[i].appendChild(newdiv);
			}
		}
		else if ((title) && (title != ''))
		{
			newdiv = document.createElement('div');
			newdiv.className = 'source';
			newdiv.appendChild(document.createTextNode('\u2014 ' + title));
			quotes[i].appendChild(newdiv);
		}
	}
}

// PPK superhard Rocks and makes of good happy feelings the cookie! 
// http://www.quirksmode.org/js/cookies.html
function createCookie(name,value,days)
{
	if (days)
	{
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}
function readCookie(name)
{
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++)
	{
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}
function eraseCookie(name)
{
	createCookie(name,"",-1);
}

// Isaac Z. Schlueter http://isaacschlueter.com
// These functions make the cool pulldown on the help menu.  Send it an object, and it'll pull it down.
// In theory, you should be able to just swap the numbers and pull up, but I didn't get that to work.
var puller;
function pullDown(lnk, start, finish, units)
{
	if(!lnk) return;
	if(!units) units='em';
	var delay;
	var hgt = start;
	puller = lnk;
	for(var h=start; h<=(finish * 10.0);h++)
		setTimeout("setHeight(puller,'"+(Math.round( 10.0 * (h * 0.1)) / 10.0)+units+"')",(h/120.0)*800);
}
function setHeight(lnk,hgt)
{
	if(lnk.style.setProperty) lnk.style.setProperty('height',hgt,null);
	else if(lnk.style.setAttribute) lnk.style.setAttribute('height',hgt);
}

// fontController (Do you take font?  From the mike?!?)
// By Isaac Z. Schlueter http://isaacschlueter.com/
// This function also requires a few things to be set up in the CSS: a .clicked, .hide, and so forth.
// You may find a writeup of this someday at http://isaacschlueter.com/all?s=liquid+evoskin if I get around to blogging it
// These bits set up some buttons to do 5 things: Make fonts big, makes fonts wee, monospace, serif, and sans-serif
// Inspired by other ideas on other sites, but not copied.
function fontController () {
// list of each different class
// these classes should be defined in the CSS.
// you can stick other things on them besides just font-family, you know!
var serif = 'serif';
var sansSerif = 'sans-serif';
var monospace = 'monospace';

var Size = 1; // default size, in ems
var sizeInc = 0.1; // amount the size changes with each click, in ems
var Family = sansSerif; // default fontclass
var wrapperId = 'wrapper'; // the ID of the element where the fonts get changed
var defSize = Size; // don't change this
var defFamily = Family; // don't change this

function fontSetup(serifId, sansId, monoId, bigId, weeId, defaultId, helpId)
{
	if(!(document.getElementById && addEvent)) return;

	// do this stuff first to minimize FOUC.
	// The only true way to remove FOUC, of course, is to read the cookie and apply the style as the page
	// is being displayed, for example, with a PHP script inline in the displayed page.
	var newFamily = readCookie('fontclass');
	var newSize = readCookie('fontsize');
	if(newFamily) Family = newFamily;
	if(newSize) Size = newSize;
	doFontStuff(Family,Size,null,null,null,false);

	if(!serifId) serifId = 'serif';
	if(!sansId) sansId = 'sans';
	if(!monoId) monoId = 'mono';
	if(!bigId) bigId = 'big';
	if(!weeId) weeId = 'wee';
	if(!defaultId) defaultId = 'default';
	if(!helpId) helpId = 'help';
	
	var wrapper = document.getElementById(wrapperId);
	var fontControl = document.getElementById('fontControl');
	var serifButton = document.getElementById(serifId);
	if(serifButton) addEvent(serifButton,'mousedown',doSerif);
	var sansButton = document.getElementById(sansId);
	if(sansButton) addEvent(sansButton,'mousedown',doSans);
	var monoButton = document.getElementById(monoId);
	if(monoButton) addEvent(monoButton,'mousedown',doMono);
	
	if(newFamily)
	{
		if(Family == serif) serifButton.className='clicked';
		if(Family == sansSerif) sansButton.className='clicked';
		if(Family == monospace) monoButton.className='clicked';
	}
	
	var weeButton = document.getElementById(weeId);
	if(weeButton) {
		addEvent(weeButton,'click',doWee);
		addEvent(weeButton,'mousedown',doPush);
		addEvent(weeButton,'mouseup',doPop);
	}
	var bigButton = document.getElementById(bigId);
	if(bigButton) {
		addEvent(bigButton,'click',doBig);
		addEvent(bigButton,'mousedown',doPush);
		addEvent(bigButton,'mouseup',doPop);
	}
	var defaultButton = document.getElementById(defaultId);
	if(defaultButton) {
		addEvent(defaultButton,'click',doDefault);
		addEvent(defaultButton,'mousedown',doPush);
		addEvent(defaultButton,'mouseup',doPop);
	}
	var helpButton = document.getElementById(helpId);
	if(helpButton) 
	{
		addEvent(helpButton,'mousedown',doHelp);
		addEvent(helpButton,'mouseup',doHelp);
	}
	
	for(var i=0;fontControl.childNodes[i];i++)
	{
		if(fontControl.childNodes[i].nodeType!=1)continue;
		if(fontControl.childNodes[i].tagName.toLowerCase()=='div'&&fontControl.childNodes[i].className=='hide')
		{
			var helpDiv = fontControl.childNodes[i];
			break;
		}
	}
	if(helpDiv)
	{
		if(helpDiv.getElementsByTagName)
		{
			helpImgs=helpDiv.getElementsByTagName('img');
			for(var i=0;helpImgs[i];i++)
			{
				if(helpImgs[i].getAttribute('alt')==serifId) addEvent(helpImgs[i],'mousedown',doSerif);
				if(helpImgs[i].getAttribute('alt')==sansId) addEvent(helpImgs[i],'mousedown',doSans);
				if(helpImgs[i].getAttribute('alt')==monoId) addEvent(helpImgs[i],'mousedown',doMono);
				if(helpImgs[i].getAttribute('alt')==weeId) addEvent(helpImgs[i],'mousedown',doWee);
				if(helpImgs[i].getAttribute('alt')==bigId) addEvent(helpImgs[i],'mousedown',doBig);
				if(helpImgs[i].getAttribute('alt')==defaultId) addEvent(helpImgs[i],'mousedown',defInHelp);
				if(helpImgs[i].getAttribute('alt')==helpId || helpImgs[i].getAttribute('alt')=='X') addEvent(helpImgs[i],'mousedown',helpInHelp);
			}
			helpAs=helpDiv.getElementsByTagName('a');
			for(var i=0;helpAs[i];i++) addEvent(helpAs[i],'mousedown',helpInHelp);
		}
	}
}
function doSerif(e) { doFontStuff(serif,null,e,true,true); }
function doSans(e) { doFontStuff(sansSerif,null,e, true,true); }
function doMono(e) { doFontStuff(monospace,null,e, true,true); }
function doWee(e) { doFontStuff(null,Math.round( 10.0 * ((Size * 1.0) - (sizeInc * 1.0))) / 10.0); }
function doBig(e) { doFontStuff(null,Math.round( 10.0 * ((Size * 1.0) + (sizeInc * 1.0))) / 10.0); }
function doPush(e) {
	if (window.event && window.event.srcElement) var lnk = window.event.srcElement;
	else if (e && e.target) var lnk = e.target;
	if(!lnk) return;
	lnk.className = 'clicked';
}
function doPop(e) {
	if (window.event && window.event.srcElement) var lnk = window.event.srcElement;
	else if (e && e.target) var lnk = e.target;
	if(!lnk) return;
	lnk.className = '';
}

function doDefault(e,lnk) {
	eraseCookie('fontsize');
	eraseCookie('fontclass');
	Size = defSize;
	Family = defFamily;
	if(!lnk)
	{
		if (window.event && window.event.srcElement) var lnk = window.event.srcElement;
		else if (e && e.target) var lnk = e.target;
	}
	if(!document.getElementById) return;
	var Body = document.getElementById(wrapperId);
	if(!Body) return;
	Body.className = '';
	if(Body.style.setProperty) Body.style.setProperty('font-size','',null);
	else if(Body.style.setAttribute) Body.style.setAttribute('fontSize','');
	if(lnk) hideHelp(lnk);
	doFontStuff(null,null,e,false,true,lnk);
}
function doHelp(e) {
	if (window.event && window.event.srcElement) var lnk = window.event.srcElement;
	else if (e && e.target) var lnk = e.target;
	if(!lnk) return;
	
	if (!document.createElement) return;
	if (!document.createElementNS)
	{
		document.createElementNS = function(ns, elt)
		{
			return document.createElement(elt);
		}
	}
	if(lnk.className=='clicked')
	{
		if(e.type=='mousedown') return;
		else if(e.type=='mouseup')
		{
			if(lnk.getAttribute('keepit')) 
			{
				lnk.removeAttribute('keepit');
				return;
			}
			else
			{
				lnk.className='';
				hideHelp(lnk);
			}
		}
	}
	else
	{
		if(e.type=='mouseup') return;
		else if(e.type=='mousedown')
		{
			lnk.className='clicked';
			lnk.setAttribute('keepit','1');
			showHelp(lnk);
		}
	}
}
function helpInHelp(e) {
	if (window.event && window.event.srcElement) var lnk = window.event.srcElement;
	else if (e && e.target) var lnk = e.target;
	if(!lnk) return;
	var par = getParent(lnk,'div',1.0);
	hideHelp(par);
}
function defInHelp(e) {
	if (window.event && window.event.srcElement) var lnk = window.event.srcElement;
	else if (e && e.target) var lnk = e.target;
	if(!lnk) return;
	doDefault(null,getParent(lnk,'div',1));
}
function showHelp(lnk)
{
	if(!lnk) return;
	var par = getParent(lnk,'div');
	if(!par) return;
	for(var i=0;par.childNodes[i];i++)
	{
		if(par.childNodes[i].nodeType != 1) continue;
		if(par.childNodes[i].className=='hide') 
		{
			par.childNodes[i].className='helptext';
			pullDown(par.childNodes[i],0,14);
		}
		if(par.childNodes[i].id=='help'&&par.childNodes[i].className!='clicked') par.childNodes[i].className='clicked';
	}
}

function hideHelp(lnk)
{
	if(!lnk) return;
	var par = getParent(lnk,'div');
	if(!par) return;
	for(var i=0;par.childNodes[i];i++)
	{
		if(par.childNodes[i].nodeType != 1) continue;
		if(par.childNodes[i].className=='helptext')
		{
			if(par.childNodes[i].style.setProperty) par.childNodes[i].style.setProperty('height','0',null);
			else if(par.childNodes[i].style.setAttribute) par.childNodes[i].style.setAttribute('height','0');
			par.childNodes[i].className='hide';
		}
		if(par.childNodes[i].getAttribute('id')=='help'&&par.childNodes[i].className=='clicked') par.childNodes[i].className='';
	}
}
function doFontStuff(newFamily, newSize, e, clickIt, unClickIt,lnk) {
	if(!document.getElementById);
	var Body = document.getElementById(wrapperId);
	if(!Body) return;
	
	if(e)
	{
		if (window.event && window.event.srcElement) var lnk = window.event.srcElement;
		else if (e && e.target) var lnk = e.target;
	}
	
	if(newFamily)
	{
		if(newFamily!=defFamily || lnk)
		{
			Body.className = newFamily;
			if(!Family) return;
			Family = newFamily;
			createCookie('fontclass', Family, 365);
		}
	}
	if(newSize)
	{
		if(Body.style.setProperty) Body.style.setProperty('font-size',newSize + 'em',null);
		else if(Body.style.setAttribute) Body.style.setAttribute('fontSize',newSize + 'em');
		if(!Size) return;
		Size = newSize;
		createCookie('fontsize', Size, 365);
	}
	if(lnk)
	{
		if(unClickIt)
		{ // this means we want to unclick everything else in this family of buttons
			var par = getParent(lnk, 'div');
			if(!par) return;
			if(par.childNodes)
			{
				for(var i=0;par.childNodes[i];i++)
				{
					if(par.childNodes[i].nodeType != 1 || par.childNodes[i] == lnk) continue;
					if(par.childNodes[i].className == 'clicked'&&par.childNodes[i].id!='help') par.childNodes[i].className='';
				}
			}
		}
		if(clickIt && lnk.className!='clicked') lnk.className='clicked';
	}
}
function getParent(el, pTagName, goUpAnyways)
{
	if (el == null) return null;
	else if(el.nodeType == 1 && el.tagName.toLowerCase() == pTagName.toLowerCase()) 
	{
		if(goUpAnyways>0) return getParent(el.parentNode,pTagName,1.0*goUpAnyways-1.0)
		else return el;
	}
	else return getParent(el.parentNode, pTagName, goUpAnyways);
}
 // End of fontControl namespace, execute code
fontSetup();
}



// float clearer (required for IE5 Mac)
function fixmacie(classname) {
	if(!document.getElementsByTagName) return;
	var divs=document.getElementsByTagName("DIV");
	for(var d=0; d < divs.length;d++) {
		if(divs[d].className.indexOf(classname)==0) {
			divs[d].innerHTML+= "<div class='mac-clearfix'> </div>";
		}
	}
}

window.onload = function(e) {
	extractBlockquoteInfo();
	fontController();
	// it's a mac, not an opera in disguise, and not 5.2, where the bug was fixed.
	if( navigator.appVersion.indexOf('Mac')!=-1 && navigator.appVersion.indexOf('Opera') == -1 && navigator.userAgent.indexOf('5.2')==-1)
		fixmacie('bPost');
}

