/*
ProcterGamble

SiB

cookieControl.js

V 0.1

handles everything to do with cookies: 
- check existance
- read
- write
  - delete

created 05-11-2003 oBu
last edited 05-11-2003 oBu

*/


// checks existance of a cookie
// expects the cookies name
// returns true|false
function cookieExists(strCookieName){
	return (document.cookie.indexOf(strCookieName) != -1);
}

// writes a cookie
// expects: the cookies name, value, expiry-date, path, domain, and secure-flag
function writeCookie(strName, strValue, dExpires, strPath, strDomain, bSecure){
	document.cookie = strName + "=" + escape(strValue) + ((dExpires) ? ";expires=" + dExpires.toGMTString() : "") + ((strPath) ? ";path=" + strPath : "") + ((strDomain) ? ";domain=" + strDomain : "") + ((bSecure) ? ";secure" : "");
	
}

// reads a cookie
// expects the cookies name
// returns the cookies value
function readCookie(strCookieName){
	// read_cookie returns the value of the cookie with name strCookieName
	// determine the start index of the cookievalue
	var iStartIndex = document.cookie.indexOf(strCookieName + '=');
	iStartIndex = document.cookie.indexOf('=', iStartIndex) + 1;
	// determine the end index of the cookievalue
	var iEndIndex = document.cookie.indexOf(';', iStartIndex);
	if (iEndIndex == -1)  {
		iEndIndex = document.cookie.length;
	}
	// get the cookievalue, reversing the escaped format by using the unescape method
	var strCookieValue = unescape(document.cookie.substring(iStartIndex, iEndIndex));
	return strCookieValue;
}
