var pageProtocol = (location.protocol.toLowerCase().indexOf('https') >= 0 ? "https://" : "http://");
// Define this as URL to load FTT expressions file from UTE
var TacodaFTTURL = pageProtocol + "te.ivillage.com/scripts/TacodaFTTExpr.js";
var TacodaFTTEnabled = true;
var TacodaFTTExprLoaded = false;
if (typeof(TacodaFTTExpression) == 'undefined') {
	var TacodaFTTExpression = "";
}
// Fix for Mac IE 5.5
if (!Array.prototype.push) {
  Array.prototype.push = function () {
    for (var i = 0; i < arguments.length; i++) {
      this[this.length] = arguments[i];
    }
    return this.length;      // push() should return the new array length
  };
}

function Tacoda_AMS_FTT_ErrorHandler() {
  window.status = "An error was found.  FTT Disabled.";
  return false;
}

function Tacoda_AMS_FTT_LoadExpressions() {
  document.write('<script src="' + TacodaFTTURL + '" lang="Javascript"></s' + 'cript>');
}

function Tacoda_AMS_FTT_GetCookie(TacodaCookieName) {
  var TacodaDocumentCookies = document.cookie;
  var TacodaCookiePrefix = TacodaCookieName + "=";
  var begin = TacodaDocumentCookies.indexOf("; " + TacodaCookiePrefix);
  if (begin == -1) {
    begin = TacodaDocumentCookies.indexOf(TacodaCookiePrefix);
    if (begin != 0) return null;
  } else begin += 2;
  var end = TacodaDocumentCookies.indexOf(";", begin);
  if (end == -1) end = TacodaDocumentCookies.length;
  return unescape(TacodaDocumentCookies.substring(begin + TacodaCookiePrefix.length, end));
}

function Tacoda_AMS_FTT_ExistsCookie(TacodaCookieName) {
  var TacodaDocumentCookies = document.cookie;
  var TacodaCookiePrefix = TacodaCookieName + "=";
  var begin = TacodaDocumentCookies.indexOf("; " + TacodaCookiePrefix);
  if (begin == -1) {
    begin = TacodaDocumentCookies.indexOf(TacodaCookiePrefix);
    if (begin == 0) return true;
    return false;
  }
  return true;
}

function Tacoda_AMS_FTT_GetValue(TacodaValueName) {
  var TacodaFTTCookieValue = Tacoda_AMS_FTT_GetCookie(TacodaFTTCookie);

  if (TacodaFTTCookieValue != null) {
    var begin = TacodaFTTCookieValue.indexOf(TacodaValueName + "^");
    if (begin == -1) return null;
    begin = TacodaFTTCookieValue.indexOf("^", begin) + 1;
    var end = TacodaFTTCookieValue.indexOf("^", begin);
    if (end == -1) return TacodaFTTCookieValue.substring(begin);
    return TacodaFTTCookieValue.substring(begin, end);
  }
  return null;
}

function Tacoda_AMS_FTT_ExistsValue (TacodaValueName) {
  var TacodaFTTCookieValue = Tacoda_AMS_FTT_GetCookie(TacodaFTTCookie);

  if (TacodaFTTCookieValue != null) {
    var begin = TacodaFTTCookieValue.indexOf(TacodaValueName + "^");
    if (begin == -1) return false;
    return true;
  }
  return false;
}

function Tacoda_AMS_FTT_UserInSeg (TacodaSegID) {
  var TacodaSegCookie = Tacoda_AMS_FTT_GetCookie(TacodaFTTSegmentCookie);

  var id = "00000" + TacodaSegID;
  var begin = TacodaSegCookie.indexOf("AMS_" + id.substr(id.length - 6));
  if (begin == -1) return false;
  return true;
}

function Tacoda_AMS_FTT_Process(TacodaImageURL) {  
  var expressionResult = "";
  var TacodaFTTOnErrorOrig = window.onerror;
  window.onerror = Tacoda_AMS_FTT_ErrorHandler;

  for (var i=0; i < TacodaFTTExpression.length; i++) {
    var result = eval(TacodaFTTExpression[i]);
    if (result) {
      if (expressionResult == null) expressionResult = TacodaFTTRuleID[i];
      else expressionResult += "|" + TacodaFTTRuleID[i];
    }
  }

  var TacodaFTTFakeImage = new Image();
  TacodaFTTFakeImage.src = TacodaImageURL + "?" + expressionResult;

  window.onerror = TacodaFTTOnErrorOrig;
  return;
}

function parseFTTCookie (cookieValues) {
  var fttFields = cookieValues.split("|");
  var tempField;
  var fttKeyVals = "";
  var tempDate;
  for (var i=0; i<fttFields.length; i++) {
    tempValues = fttFields[i].split("^");
    // See if this key starts with rtt.  If not, it's state data and
	// we don't send to DART.
	if (tempValues[0].indexOf("rtt") == 0) {
      fttKeyVals += tempValues[0] + "=" + tempValues[1] + ";";
	}
  }
  return fttKeyVals;
}

Tacoda_AMS_FTT_LoadExpressions();

// Fast Track Cookie.  Needs to be parsed before inserting into DART key-values.
document.dartFTT = Tacoda_AMS_DDC_getCookie("tacoda_ftt");
if (document.dartFTT != "" && document.dartFTT != null) {
  document.dartFTT = parseFTTCookie(document.dartFTT);
}
