// Copyright 2001 ClickAgents, Inc. All rights reserved.

CALoaded = true;
CAFullVersion = CAVersion + ".20";

function CAShowAd() {
  
  CAOptions = '&v=' + CAFullVersion;
  CAFullOptions = '';
  CATextTest = 0;
  CAProtocol = "http://";
  CABannerType = self.CABannerType || "js";
  CANetworkDisableNoCache = 0 || 0; 

  if (self.CASecure) CAProtocol = "https://";
  if (self.CACategory) CAOptions += '&c=' + self.CACategory;
  if (self.CABorder)   CAOptions += '&border=1';
  if (self.CAPlacement) CAFullOptions += '&p=' + self.CAPlacement; 
  if (self.CAKWParam)  CAOptions += '&r=' + self.CAKWParam;
  if (self.CAKeywords) CAOptions += '&k=' + escape(self.CAKeywords);
  if (self.CAKeyCode) CAOptions += '&' + self.CAKeyCode;
  if (self.CAHCat) CAOptions += '&hcat=' + self.CAHCat;
  if (self.CAPBhav) CAOptions += '&pbhav=' + self.CAPBhav;
  if (self.CATagCascade) CAOptions += '&tc=' + self.CATagCascade;
  if (self.CAAID) CAFullOptions += '&aid=' + self.CAAID;
  if (self.CAPID) CAFullOptions += '&pid=' + self.CAPID;

  if (self.CAKeyCodes) {
    var tempKC = CAKeyCodes.join("&"); 
    CAOptions += '&' + tempKC;
  }

  CASizes = '';
  HardSize = 1;

  if (self.CAWidth) {
    CAWidth = self.CAWidth;
  } else {
    CAWidth = '';
  }

  if (self.CAHeight) {
    CAHeight = self.CAHeight;
  } else {
    CAHeight = '';
  }

  CAIFrame = self.CAIFrame || 0;
  CAIFrameMSizes = self.CAIFrameMSizes || 0;

  if (CABannerType != 'pop') {

    //non pops should default to type js
    CABannerType = 'js';

    //if 'Width' and 'Height' are passed in, use them
    //otherwise, use Width_Height if it exists

    if (CAWidth && CAHeight) {
      CASizes = '&size=' + CAWidth + 'x' + CAHeight;
    } else if (self.CAWidths_Heights) {
      if (CAIFrame) {
        //Using IFrame will normally disable using MSizes, but an optional
        //parameter IFrameMSizes allows them both to be used.
        var firstSize = self.CAWidths_Heights[0];
        if (CAIFrameMSizes) {
          CASizes = '&msizes=' + self.CAWidths_Heights.join(",");
        } else {
          CASizes = '&size=' + firstSize;
        }
        //Set Width & Height for the IFrame
        var firstSizeArray = firstSize.split('x');
        CAWidth = firstSizeArray[0];
        CAHeight = firstSizeArray[1];
      } else {
        var ArLen = self.CAWidths_Heights.length;
        if (ArLen > 1) HardSize = 0;

        CASizes = '&msizes=' + CAWidths_Heights.join(",");
      }
    } else {
      //if no size info is passed in, the size list from host site record or network is used
      //so we can't predict the size
      HardSize = 0;
    }
    
    if (self.CABannerSizeOrder) CAFullOptions += '&bso=' + self.CABannerSizeOrder;

    //Do not show text for non-standard banners. CANoText must come after this test.
    if (CAWidth == 468 && CAHeight == 60) {
      CATextTest = 0;
    }else {
      if(! self.CANoText) CATextTest = 1; 
      self.CANoText = true;
    }

    if (! self.CANoText) CAOptions += '&text=1';
    if (self.CATargetCurrent) CAOptions += '&target=self';
  } else {
    CASizes = '&size=' + self.CAPopSize;
  }

  CARandom   = Math.round(Math.random()*1000) + 1;
  CATempDisableNoCache = 0;

  if (CANetworkDisableNoCache) {
    CATempDisableNoCache = 1;
  }

  //Publisher setting overrides the network setting
  if (self.CACacheBanners && self.CACacheBanners == 'yes') {
    CATempDisableNoCache = 1;
  } else if (self.CACacheBanners && self.CACacheBanners == 'no') {
    CATempDisableNoCache = 2;
  }

  if (CATempDisableNoCache == 1) {
    //don't send no-cache headers 
    CARandom = 1;
    CAOptions += '&disable_no_cache=1';
  } else if (CATempDisableNoCache == 2) {
    //send no-cache headers 
    CAOptions += '&disable_no_cache=0';
  }

  CAHostInfo = "host=" + CAHost + "&b=" + CAID + "." + CARandom;

  if (self.CAServer == null) CAServer = "ads";

  CAFullServer   = CAProtocol + CAServer + ".clickagents.com/";

  CABanner   = CAFullServer + 'advance.ca?' + CAHostInfo + CAOptions + CAFullOptions + CASizes;

  if (CABannerType == 'js' && HardSize) CADimensions();

  // blank then out so they will only apply for this request. 
  // When there are multiple tags on the same page, we don't want an old
  // tag with these variables to 'infect' a newer tag that doesn't
  // use these variables
  CAWidth = '';
  CAHeight = '';

  if (CATextTest == 1) self.CANoText = false;

  if (navigator.userAgent.indexOf("MSIE") >= 0) {
    // don't try to set the bgcolor etc in the IFRAME for MSIE 3 
    if (navigator.appVersion.indexOf('MSIE 3') < 0) {
      if (self.CABgColor)    CABanner += '&bgcolor='    + escape(self.CABgColor);
      if (self.CALinkColor)  CABanner += '&linkcolor='  + escape(self.CALinkColor);
      if (self.CAAlinkColor) CABanner += '&alinkcolor=' + escape(self.CAAlinkColor);
      if (self.CAVlinkColor) CABanner += '&vlinkcolor=' + escape(self.CAVlinkColor);
    }
    if (CAIFrame == 1 && CABannerType == 'js') {
      if (HardSize) {
        document.write('<IFRAME ID="VC" NAME="VC" WIDTH="' + IWidth + '" HEIGHT="' + IHeight + '" ');
      } else {
        document.write('<IFRAME ID="VC" NAME="VC" ');
      }
      document.write('SCROLLING="no" FRAMEBORDER="0" FRAMESPACING="0" MARGINHEIGHT="0" ');
      document.write('MARGINWIDTH="0" BORDER="0" HSPACE="0" VSPACE="0" ');
      document.write('ALIGN="center" SRC="' + CABanner + '&t=html">');
      document.write('</IFRAME>');
    } else {
      document.write('<SCRIPT SRC="' + CABanner + '&t=' + CABannerType + '"');
      document.write(' LANGUAGE="JavaScript"></SCR' + 'IPT>');
    }
  } else {
    // should be all Netscapes that are reading this file 
    if (self.CAVersion == 1.0 && parseInt(navigator.appVersion) < 5 ) {
      document.write('<table border=0 cellpadding=0 cellspacing=0><tr><td>');
      if (HardSize) {
        document.write('<ILAYER ID="VC" VISIBILITY="hide" BGCOLOR="" WIDTH="' + IWidth);
        document.write('" HEIGHT="' + IHeight + '"></ILAYER>');
      } else {
        document.write('<ILAYER ID="VC" VISIBILITY="hide" BGCOLOR="" ');
        document.write('></ILAYER>');
      }
      document.write('</td></tr></table>');
    } else {
      document.write('<SCRIPT SRC="' + CABanner + '&t=' + CABannerType + '"');
      document.write(' LANGUAGE="JavaScript"></SCR' + 'IPT>');
    }
  }
}

function CADimensions() {
  if (self.CANoText) {
    if (self.CABorder) {
      IWidth  = CAWidth + 4;  
      IHeight = CAHeight + 4;
    } else {
      IWidth  = CAWidth;  
      IHeight = CAHeight;
    }       
  } else {
    if (self.CABorder) {
      IWidth  = CAWidth + 4;
      IHeight = CAHeight + 24;
    } else {
      IWidth  = CAWidth;
      IHeight = CAHeight + 24;
    }       
  }
}
