
/**
* @author kumar mcmillan <kumarmcm/us.ibm.com>
* @copyright IBM E-Business Innovations 2004
* base javascript functions for use in the base template
**/

/**
* lightweight browser sniffer only used to see if we are in netscape 4
* heavyweight version is here: http://www.mozilla.org/docs/web-developer/sniffer/browser_type.html
**/
var sniffer = navigator.userAgent.toLowerCase();
var browser_version_major = parseInt(navigator.appVersion);
var browser_version_minor = parseFloat(navigator.appVersion);
var browser_is_mozilla = (sniffer.indexOf('mozilla') != -1);
var browser_is_msie = (sniffer.indexOf('msie') != -1);
var browser_is_opera = (sniffer.indexOf('opera') != -1);
var browser_is_safari = (sniffer.indexOf('safari') != -1);
var browser_is_nav  = (browser_is_mozilla && (sniffer.indexOf('spoofer')==-1)
												&& (sniffer.indexOf('compatible') == -1) && (browser_is_opera == false)
												&& (sniffer.indexOf('webtv')==-1) && (sniffer.indexOf('hotjava')==-1));
var browser_is_netscape = (sniffer.indexOf('netscape') != -1);

/**
* detects whether browser is receiving non-styled content - so popup window can be more accessible
* @return bool
**/
function browser_gets_no_style()
{	
	return (browser_is_nav && browser_version_major <= 4);
} // END function browser_gets_no_style()

/**
* http://www.netspade.com/articles/javascript/cookies.xml
* Gets the value of the specified cookie.
*
* @param string name  Name of the desired cookie.
*
* @return string containing value of specified cookie,
*   or null if cookie does not exist.
**/
function get_cookie(name)
{
	var dc = document.cookie;
	var prefix = name + "=";
	var begin = dc.indexOf("; " + prefix);
	if (begin == -1)
	{
		begin = dc.indexOf(prefix);
		if (begin != 0) return null;
	}
	else
	{
		begin += 2;
	}
	var end = document.cookie.indexOf(";", begin);
	if (end == -1)
	{
		end = dc.length;
	}
	return unescape(dc.substring(begin + prefix.length, end));
}

/**
* @param array elements property of forms object
* @return string query string from elements
**/
function get_query_string(elements)
{
	var query_string = '';
	for(index=0, length=elements.length, last_index=length-1; index < length; index++) {
		query_string += elements[index].name + '=' + escape(elements[index].value) + (index != last_index ? '&': '');
	}
	return query_string;
} // END function get_query_string(elements)

/**
* builds a query string with the href and sends user to legacy_link.php which will negotiate how 
* and when to send the user to the actual legacy href
*
* @param obj anchor anchor object
* @return bool false to not execute link
**/
function legacy_link(anchor)
{	
	// changed 10/24/04 to always return true to disable transition pop-up logic.  IBM and NCAA agreed transition pop-up no longer needed.
	return true;
	
	/*
	// by default, we want to let the browser decide the width/height {@see legacy_link_get_window_args()}
	var legacy_window_width = 0;
	var legacy_window_height = 0;
	
	// otherwise let's try and detect it:
	if(document.body && document.body.clientWidth) {
		// MSIE :
		legacy_window_width = window.innerWidth;
		legacy_window_height= window.innerHeight;
	}
	else if(window.innerWidth) {
		// Javascript 1.2
		legacy_window_width = window.innerWidth;
		legacy_window_height= window.innerHeight;
	}
	else {
		// who knows.. probably netscape 4.7 or older, make it accessible
		legacy_window_width = 500;
		legacy_window_height= 500;
	}
	
	if(get_cookie('legacy_dont_warn')) {
		var legacy = window.open(anchor.href, 'legacy', legacy_link_get_window_args(legacy_window_width, legacy_window_height));
		legacy.focus();
		return false;
	}
	
	var legacy_negotiator_width = 350; //300;
	var legacy_negotiator_height = 225; //180;
	var legacy_negotiator_screenX = 450;
	var legacy_negotiator_screenY = 275;
	
	var url = legacy_link_get_rel_path() 
		+ 'legacy_link.php?url=' + escape(anchor.href) 
		+ '&legacy_window_width=' + legacy_window_width
		+ '&legacy_window_height=' + legacy_window_height;
	
	legacy_negotiator = open_info_window(
		url, 'legacy_negotiator', legacy_negotiator_width, legacy_negotiator_height, 
		legacy_negotiator_screenX, legacy_negotiator_screenY, 'yes');
	legacy_negotiator.focus();
	
	return false;
	*/
} // END function legacy_link(anchor)

/**
* called when a user is reading the legacy link notice, and is asked if he/she wants to be notified 
* each time that a link is legacy or not.  This is an improvement from the old form submission method, 
* which seemed to fail on certain poorly made popup blockers
* 
* @param obj form
* @param obj anchor object
* @param int legacy_window_width
* @param int legacy_window_height
**/
function legacy_link_continue(form, anchor, legacy_window_width, legacy_window_height)
{
	if(browser_is_netscape == false) {
		// Netscape 7 seems to think this is a "security error" so screw Netscape and skip it ...
		auto_close = window.setTimeout('self.close()', 500);
	}
	// add checkbox value onto URL:
	var legacy_dont_warn = (form[CHECKBOX_LEGACY_DONT_WARN].checked ? form[CHECKBOX_LEGACY_DONT_WARN].value: 0);
	anchor.href += legacy_dont_warn;
	
	if(browser_is_opera) {
		// Opera will not focus the window, so always force a new one by way of a unique target:
		var date = new Date();
		anchor.target += date.getMilliseconds();
	}
	
	legacy = window.open(anchor.href, anchor.target, legacy_link_get_window_args(legacy_window_width, legacy_window_height));
	legacy.focus();
	return false;
} // END function legacy_link_continue(form, anchor, legacy_window_width, legacy_window_height)

/**
* gets relative path to the root of the filesystem in order for legacy_link() to find the php handler file
* IMPORTANT NOTE: when on a test server, we are assuming the site is accessed like: http://localhost/<subdirectory>
* for production, this doesn't matter because we will always have the root as http://<domain.com>/
*
* @return string relative path to root of website filesystem
**/
function legacy_link_get_rel_path()
{
	var href = new String(window.location);
	var directories = href.replace(/^http(s)?:\/\//, '');
	var rel_path_count = 0;
	var rel_path = "";
	
	directories = directories.split("/");
	rel_path_count = directories.length - 2; // count all directories minus the domain name and the current directory

	if(directories[0] == 'localhost') {
		// we are on a test machine, this is where it gets tricky
		rel_path_count--; // assume the dev site is in a subdirectory of http://localhost/ ... is there another way?
	}
	
	for(path_count=1; path_count <= rel_path_count; path_count++) {
		rel_path = rel_path + "../"; // descend until we reach the root
	}
	
	return rel_path;
} // END function legacy_link_get_rel_path()

/**
* @param int width carry default browser width, if detected
* @param int height carry default browser height, if detected
* @return string arguments to be passed to window.open() to define the new window properties
**/
function legacy_link_get_window_args(width, height)
{
	var args = 'directories=yes,location=yes,menubar=yes,personalbar=yes,hotkeys=yes,toolbar=yes'
		+ ',resizable=yes,screenX=20,screenY=20,left=20,top=20,scrollbars=yes,status=yes,titlebar=yes';
	// most browsers should set the window to the user's default width and height, but for IE on XP,
	// the width/height of a non-user defined popup window will be carried over as default, which isn't good.
	// if we can detect the user's default window size, then let's use it, otherwise let the browser get the window size
	// by default :
	if(width > 0 && height > 0) {
		args += ',height=' + height + ',width=' + width;
		// getting a strange bug where MSIE height isn't correct and the window is not resizable
		if(browser_is_msie == false) {
			',innerHeight=' + height + ',innerWidth=' + width;
		}
	}
	return args;
} // END function legacy_link_get_window_args()

/**
* called when a user is reading the legacy link notice, and is asked if he/she wants to be notified 
* each time that a link is legacy or not
* @see legacy_link_continue()
* @param obj form
* @param int legacy_window_width
* @param int legacy_window_height
**/
function legacy_link_onsubmit(form, legacy_window_width, legacy_window_height)
{	
	auto_close = window.setTimeout('self.close()', 500);
	var form_action = '';
	if(	form.elements && browser_is_mozilla == true && browser_is_safari == false &&	
		 	browser_is_msie == false && browser_is_opera == false && browser_gets_no_style() == false ) {
		form_action = form.action + '?' + get_query_string(form.elements);
	}
	// note than an empty form action seems to be sufficient for most browsers :
	legacy = window.open(form_action, form.target, legacy_link_get_window_args(legacy_window_width, legacy_window_height));
	legacy.focus();
	return true;
} // END function legacy_link_onsubmit()

/**
* common onload function for general ncaa pages
**/
function ncaa_onload()
{
	if(browser_gets_no_style()) {
		skip_to_content();
	}
} // END function ncaa_onload()

/**
* opens a generic popup window size for information
* @return obj new window
**/
function open_info_window(url, target, window_width, window_height, window_screenX, window_screenY, resize)
{
	var window_scrollbars = 0;
	
	if(browser_gets_no_style()) {
		// make accessible:
		window_scrollbars = 1;
		window_screenX = 25;
		window_screenY = 25;
		
		window_width += 100;
		if(window_width > 500) {
			window_width = 500;
		}
		
		window_height += 200;
		if(window_height > 500) {
			window_height = 500;
		}
	} // END if browser_gets_no_style()
	
	var new_window = window.open(
		url, target, 
		'toolbar=0,scrollbars=' + window_scrollbars + ',location=0,statusbar=0,menubar=0,width=' + window_width + 
			',height=' + window_height + 
			',left=' + window_screenX + 
			',top=' + window_screenY + 
			',screenX=' + window_screenX + 
			',screenY=' + window_screenY +
			',resizeable=' + resize);
	return new_window;
} // END function open_info_window(url, target)

function page_emailer(anchor)
{
	anchor.href += '?url=' + escape(window.location) + '&title=' + escape(document.title);
	var window_width = 400;
	var window_height = 500;
	var window_screenX = 50;
	var window_screenY = 50;
	open_info_window(anchor.href, anchor.target, window_width, window_height, window_screenX, window_screenY);
	return false;
} // END function page_emailer(anchor)

function page_printer(anchor)
{
	if(browser_gets_no_style()) {
		// they don't really need to get a print preview since it will just be confusing
		// for netscape 4.7, the print preview is a little confusing
		window.print();
		return false;
	}
	anchor.href += '?url=' + escape(window.location) + '&title=' + escape(document.title);
	return true;
} // END function page_printer(anchor)

/**
* pops up a window with information on how to view power point documents
*
* @param obj anchor anchor object
* @return bool false to not execute link
**/
function ppt_viewing_info(anchor)
{
	var window_width = 300;
	var window_height = 345;
	var window_screenX = 450;
	var window_screenY = 345;
	open_info_window(anchor.href, anchor.target, window_width, window_height, window_screenX, window_screenY, 'yes');
	return false;
} // END ppt_viewing_info(anchor)

//Preload images over states for navgation
function preloadImages() 
{ 
	// hmm... really shouldn't be using an abs path for preloading images, 
	// but the host detection would be unreliable (commenting out)
	//var url = new String(window.location);
	//var paths = url.replace(/^http(s)?:\/\/[^\/]+/, "");
	//var domain = url.replace(paths, "");
	//alert(domain);
	
	var imagesPath = "/styles/images/navigation/";
	
	images_0 = new Image();
	images_0.src = imagesPath + "about_the_ncaa_over.gif";
	//alert('preloading image : ' + images_0.src);
	images_1 = new Image();
	images_1.src = imagesPath + "academics_and_athletics_over.gif";
	//alert('preloading image : ' + images_1.src);
	images_2 = new Image();
	images_2.src = imagesPath + "legislation_and_governance_over.gif";
	//alert('preloading image : ' + images_2.src);
	images_3 = new Image();
	images_3.src = imagesPath + "media_and_events_over.gif";
	//alert('preloading image : ' + images_3.src);
	images_4 = new Image();
	images_4.src = imagesPath + "sports_over.gif";
	//alert('preloading image : ' + images_4.src);
	
} // END function preloadImages() 

/**
* Hover function
**/
sfHover = function() 
{
	var sfEls = document.getElementById("navigation_global").getElementsByTagName("LI");

	for (var i=0; i<sfEls.length; i++) {
		sfEls[i].onmouseover=function() {
			this.className+=" sfhover";
		}
		
		sfEls[i].onmouseout=function() {
			this.className=this.className.replace(new RegExp(" sfhover\\b"), "");
		}
	}
}

/**
* skips to content, used only for netscape 4
* @see ncaa_onload()
**/
function skip_to_content()
{
	window.location.href = '#base_content_container_target';
} // END function skip_to_content()

//====================================================================//


// Load these at startup if we are on a page that needs the global nav
var existing_onload = window.onload; 
if(hide_global_nav == false) {
	if (document.all) { //MS IE
		if (window.attachEvent) {
			window.attachEvent("onload", sfHover, preloadImages());
		} else { //IE 5.2 Mac does not support attachEvent
			window.onload = function() { 
				// preserve and onload if it has already been declared:
				if (existing_onload) {
					existing_onload(); 
				}
				preloadImages(); 
				sfHover(); 
			}
		} // END else of if (window.attachEvent)
	} // END if document.all 
	else {
		// for browsers like safari which dont' seem to load the images even though they are in the styles:
		preloadImages();
	} // END else of if document.all
} // END if not hiding global nav