function getStyle(el, style) { 
	if(!document.getElementById) return;

	var value = el.style[toCamelCase(style)];

	if(!value) {
		if (document.defaultView && typeof (document.defaultView.getComputedStyle) == "function") {		// DOM
			value = document.defaultView.getComputedStyle(el, "").getPropertyValue(style);
		} else if (el.currentStyle) {			// IE
			value = el.currentStyle[toCamelCase(style)];
		} else {	// Safari hack
			var foo = toCamelCase("client-"+style);
			value = el[foo];
		}
	}

	return value; 

} 


function setStyle(obj, style, value) { 
	obj.style[style] = value; 
} 


function toCamelCase( sInput ) {
	var oStringList = sInput.split('-');
	if(oStringList.length == 1) {
		return oStringList[0];
	}
	var ret = sInput.indexOf("-") == 0 ? oStringList[0].charAt(0).toUpperCase() + oStringList[0].substring(1) : oStringList[0];
	for(var i = 1, len = oStringList.length; i < len; i++) {
		var s = oStringList[i];
		ret += s.charAt(0).toUpperCase() + s.substring(1);
	}
	return ret; 

} 


function equalizeHeight(parent, subclass) {
	var row = document.getElementById(parent);

	if (row) {
		var cells = getElementsByClassName(subclass, "", row);
	}

	var i=0, maxh = 0, h = 0, len = cells.length;

	for(i=0; i<len; i++) {
		h = cells[i].offsetHeight;
		if (h=="") {
			h = cells[i].height;
		}
		if (h=="") {
			return;
		}
		maxh = Math.max( maxh, h );
	}

	for(i=0; i<len; i++) {
		setStyle(cells[i], "height", maxh+"px" );			// cells[i].style.height = cells[i].style.height + (maxh - heights[i]);
	}

}



