/* $Id: clhook4.js,v 1.17 2005/05/03 18:08:20 hxmc Exp $
 */

/*******************************************************************************
 * Global Variable: clhookStatus
 *
 * Defines when the file was last checked into CVS and is used to show the state
 * info, such as SNF/HP Passport versions supported and HPP registration
 * server used.
 *
 * To show the OVRD and HP Passport version of the clhook at the top of the
 * page use clhook=status query parameter.
 */
var clhookStatus = "$Date: 2005/05/03 18:08:20 $ (SNF4-HPP4.1)";

/*******************************************************************************
 * Global Variable: hppEnabled
 *
 * If HP Passport enabled, set this variable to 'true' else to 'false'.
 * Based on this variable, the top banner will be displayed with HPP links.
 */
var hppEnabled = true;

/*******************************************************************************
 * Global Variable: regServer
 *
 * Defines the HP Passport Registration Server URL.
 * For production environment this variable should be set as
 *   https://passport2.hp.com
 * For staging environment this variable should be set as
 *   https://hpptest.external.hp.com
 * For Application Integration Environment this variable should be set as
 *   https://cltest1.atl.hp.com
 */
var regServer = "https://passport2.hp.com";

/*******************************************************************************
 * Global Variable: regPath
 *
 * Defines the HP Passport Registration Server servlet path.
 */
var regPath = "/hpp";

/*******************************************************************************
 * Global Variable: applicationId
 *
 * Defines application identifier.
 * Default value for this variable is "hpcl"
 */
var applicationId = "hpcl";

/*******************************************************************************
 * Global Variable: defaultURL
 *
 * Defines the application home page URL and it will be used to redirect the
 * user after logout.
 */
var defaultURL = "http://www.managementsoftware.hp.com/";

/*******************************************************************************
 * Global Variable: applicationLanguage
 *
 * Defines the applcation default language code.
 */
var applicationLanguage = " en ";

/*******************************************************************************
 *  Global Variable: languageSupport
 *
 *  Set this variable to 'Y' if the application supports languages other than
 *  English.
 */
var languageSupport = 'Y';

/*******************************************************************************
 * Global Variable: displayNewuserlink
 *
 * Set this variable to 'Y' to display the newuer registration link in the top
 * banner.
 */
var displayNewuserlink = 'Y';

/*******************************************************************************
 * Set the Reception Desk state.
 */
var rdProduction = 1;
var rdStaging = 2;
var rdTest = 3;

var rdState = rdProduction;

/*******************************************************************************
 * Set the HP Passport state.
 */
var hppProduction = 1;
var hppStaging = 2;
var hppTest = 3;

var hppState = hppProduction;

/*******************************************************************************
 * Select the HP Passport registration server based on the HPP state.
 */
if ( hppState == hppStaging )
{
  regServer = "https://hpptest2.external.hp.com";
  clhookStatus = clhookStatus + " (hpp staging)";
}
else if ( hppState == hppTest )
{
  regServer = "https://cltest1.atl.hp.com";
  clhookStatus = clhookStatus + " (hpp test)";
}
else // default to production
{
  regServer = "https://passport2.hp.com";
  clhookStatus = clhookStatus + " (hpp production)";
}

/*******************************************************************************
 * Applications need to set the applicationId appropriately.
 *
 * For hp branding of HPP login and create/edit profile pages set the variable
 * applicationId = "managementsoftware".
 *
 * For OpenView branding of HPCL login and create/edit pages
 * set the variable applicationId = "ovrd".
 *
 * To control the branding display, RD sets the default application id to "ovrd"
 * and modify it based on the URL (if necessary)
 *
 * Control the branding, HP or OpenView set the application id based on the URL.
 */
applicationId = "ovrd";

// default to OpenView branding
if ( location.href.indexOf( "managementsoftware." ) > 0 )
  applicationId = "hpcl";
else if ( location.href.indexOf( "fromOV=false" ) > 0 )
  applicationId = "hpcl";
else if ( location.href.indexOf( "-mgmtsw." ) > 0 )
  applicationId = "hpcl";
else if ( location.href.indexOf( "ovrd.external.hp.com" ) > 0 )
  applicationId = "hpcl";
else if ( location.href.indexOf( "ovrdtest.external.hp.com" ) > 0 )
  applicationId = "hpcl";
else if ( location.href.indexOf( "devresource.hp.com" ) > 0 )
  applicationId = "hpcl";
else if ( location.href.indexOf( "://dro" ) > 0 )
  applicationId = "hpcl";

/*******************************************************************************
 * Set the RD URL. Default to the production RD server.
 */
var receptionDeskHref = "https://ovrd.external.hp.com";

if ( rdState == rdProduction )
{
  receptionDeskHref = "https://ovrd.external.hp.com";
}
else if ( rdState == rdStaging )
{
  receptionDeskHref = "https://sg-ovrdtest.external.hp.com";
}
else if ( rdState == rdTest )
{
  receptionDeskHref = "https://sg-ovrdtest.external.hp.com";
}

/*******************************************************************************
 * Misc text messages.
 */
var hppCookieName = "CL_Cookie";
var welcomeString = "Welcome, ";
var signInText = "Sign-in with HP Passport";
var signOutText = "Sign-out";
var editProfileText = "Edit your profile";
var newUserText = "Register";

var countryCookie = "cc";
var countryCodeUS = "US";
var countryCodeJP = "JP";
var countryCodeDefault = countryCodeUS;
var languageCookie = "lang";
var languageCodeUS = "en";
var languageCodeJP = "ja";
var languageCodeDefault = languageCodeUS;
var languageTextUS_en = "United States-English";
var languageTextUS_ja = "\u30A2\u30E1\u30EA\u30AB\u5408\u8846\u56FD\u2212\u82F1\u8A9E";
var languageTextJP_en = "Japan-Japanese";
var languageTextJP_ja = "\u65E5\u672C\u2212\u65E5\u672C\u8A9E";
var languageSelect_en = "Select";
var languageSelect_ja = "\u9078\u629E";
var languageGoToURL_en = "Go to URL";
var languageGoToURL_ja = "URL \u306b\u79fb\u52d5";
var languageTitle_en = "this link will jump to the country selected in the list";
var languageTitle_ja = "\u3053\u306E\u30EA\u30F3\u30AF\u306F\u3001\u30EA\u30B9\u30C8\u304B\u3089\u9078\u629E\u3055\u308C\u305F\u56FD\u307E\u305F\u306F\u5730\u57DF\u306E\u30B5\u30A4\u30C8\u306B\u9032\u307F\u307E\u3059";
var languageAlt_en = "Jump to current country selection";
var languageAlt_ja = "\u73FE\u5728\u306E\u56FD\u307E\u305F\u306F\u5730\u57DF\u306E\u9078\u629E\u306B\u9032\u3080";

/*******************************************************************************
 * Redirect ".openview.com" to ".openview.hp.com". This is used to deal with
 * the SiteMinder requirement that all domains belong to ".hp.com" so that the
 * proper cookies are available for the user's session.
 */
if (location.href.indexOf( ".openview.com" ) > 0 )
{
  var loc1 = location.href;
  var pos1 = loc1.indexOf( ".openview.com" ) + 9;
  var pos2 = loc1.length;
  var loc2 = loc1.substring( 0, pos1 ) + ".hp" + loc1.substring( pos1, pos2 );

  location.replace( loc2 );
}
if ( location.href.indexOf( "/openview.com" ) > 0 )
{
  var loc1 = location.href;
  var pos1 = loc1.indexOf( "/openview.com" ) + 9;
  var pos2 = loc1.length;
  var loc2 = loc1.substring( 0, pos1 ) + ".hp" + loc1.substring( pos1, pos2 );

  location.replace( loc2 );
}

/*******************************************************************************
 * Redirect DRC license plate URL.
 */
if ( location.href.indexOf( "h20214.www2.hp.com" ) > 0 )
{
  var loc1 = location.href;
  var pos1 = loc1.indexOf( "h20214.www2.hp.com" );
  var pos2 = pos1 + 11;
  var pos3 = loc1.length;
  var loc2 = loc1.substring( 0, pos1 ) + "devresource" + loc1.substring( pos2, pos3 );

  location.replace( loc2 );
}

/*******************************************************************************
 * Redirect trulogica URL.
 */
if ( location.href.indexOf( "www.trulogica.com" ) > 0 )
{
  var loc1 = location.href;
  var pos1 = loc1.indexOf( "trulogica" );
  var pos2 = pos1 + 9;
  var pos3 = loc1.length;
  var loc2 = loc1.substring( 0, pos1 ) + "managementsoftware.hp" + loc1.substring( pos2, pos3 );

  location.replace( loc2 );
}

/*******************************************************************************
 * Redirect Management Software license plate URL.
 */
if ( location.href.indexOf( "h20229.www2.hp.com" ) > 0 )
{
  var loc1 = location.href;
  var pos1 = loc1.indexOf( "h20229.www2.hp.com" );
  var pos2 = pos1 + 11;
  var pos3 = loc1.length;
  var loc2 = loc1.substring( 0, pos1 ) + "managementsoftware" + loc1.substring( pos2, pos3 );

  location.replace( loc2 );
}

/*******************************************************************************
 * Redirect Support/eCare license plate URL.
 */
if ( location.href.indexOf( "h20230.www2.hp.com" ) > 0 )
{
  var loc1 = location.href;
  var pos1 = loc1.indexOf( "h20230.www2.hp.com" );
  var pos2 = pos1 + 11;
  var pos3 = loc1.length;
  var loc2 = loc1.substring( 0, pos1 ) + "support.openview" + loc1.substring( pos2, pos3 );

  location.replace( loc2 );
}

/*******************************************************************************
 * Create a last host and last page cookie that contains the URL of the current
 * page. The last host and last page cookies excludes reception desk forms pages,
 * forms administration pages, and RD protected pages.
 */
var lastHostCookieName = "ovrd_last_host";
var lastHostCookieValue = escape( location.protocol + "//" + location.hostname );

var lastPageCookieName = "ovrd_last_page";
var lastPageCookieValue = escape( location.href );

// Check if current page is an RD form or the forms administrator
if ( lastPageCookieValue.indexOf( ".hp.com/icc/" ) < 0 &&
     lastPageCookieValue.indexOf( ".hp.com/xdform/" ) < 0 &&
     lastPageCookieValue.indexOf( ".hp.com/rdp/" ) < 0 )
{
  createCookie( lastHostCookieName, lastHostCookieValue, 0 );
  createCookie( lastPageCookieName, lastPageCookieValue, 0 );
}

/*******************************************************************************
 * Generate the HP Passport line at the top of the page.
 */
document.write( "<table width=\"740\" summary=\"Login Area\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">" );
document.write( "<tr class=\"decoration\">" );
document.write( "<td width=\"10\" height=\"24\"></td>" );

// Show the clhook status information if the query param "clhook=status" is set.
if ( location.href.indexOf( "clhook=status" ) > 0 )
{
  document.write( "<td width=\"740\" bgcolor=\"ffcc66\" class=\"smallbold\">clhook: "
                + clhookStatus + "</td>" );
}
// Generate the HPP links if "hppEnabled" is true.
else if ( hppEnabled )
{
  // Generate the appropriate login information
  if ( LoggedIn() )
  {
    var userName = GetUserName();
    var inEditProfilePage = false;

    if ( location.href.indexOf( "/rdp/edit-profile/" ) > 0 )
    {
      inEditProfilePage = true;
    }

    // Generate the login information - width 270, begin 11, end 280
    document.write( "<td width=\"260\" align=\"left\" class=\"smallbold\">"
                  + welcomeString + userName + "</td>" );
    document.write( "<td width=\"10\"><img src=\"" + assertURL()
                  + "/img/s.gif\" width=\"10\" height=\"24\" alt=\"\" border=\"0\"></td>" );

    if ( inEditProfilePage )
    {
      // Generate the edit profile link disabled - width 155, begin 281, end 435
      document.write( "<td width=\"155\" align=\"left\" class=\"color003366\">"
                    + "&raquo;&nbsp;"
                    + "<a href=\"javascript:SignOut()\" class=\"small\">"
                    + signOutText + "</a>&nbsp;"
                    + "<span class=\"color666666\">|</span>"
                    + "&nbsp;&nbsp;&nbsp;" + editProfileText + "</td>" );
    }
    else
    {
      // Generate the edit profile link enabled - width 155, begin 281, end 435
      document.write( "<td width=\"155\" align=\"left\" class=\"color003366\">"
                    + "&raquo;&nbsp;"
                    + "<a href=\"javascript:SignOut()\" class=\"small\">"
                    + signOutText + "</a>&nbsp;"
                    + "<span class=\"color666666\">|</span>&nbsp;&raquo;&nbsp;"
                    + "<a href=\"javascript:EditProfile()\" class=\"small\">"
                    + editProfileText + "</a></td>" );
    }
  }
  else
  {
    // Generate the sign in link - width 230, begin 11, end 230
    document.write( "<td width=\"230\">"
                  + "<img src=\"" + assertURL()
                  + "/img/s.gif\" width=\"20\" height=\"24\" alt=\"\" border=\"0\"></td>" );

    if ( displayNewuserlink == 'Y' )
    {
      // Generate the new user link - width 205, begin 231, end 435
      document.write( "<td width=\"190\" align=\"left\" class=\"color003366\">"
                    + "&raquo;&nbsp;"
                    + "<a href=\"javascript:SignIn()\" class=\"small\" "
                    + "title=\"link to sign in with Hewlett-Packard Passport\">"
                    + signInText + "</a>&nbsp;"
                    + "<span class=\"color666666\">|</span>&nbsp;&raquo;&nbsp;"
                    + "<a href=\"javascript:newUser()\" class=\"small\" "
                    + "title=\"link to register with Hewlett-Packard Passport\">"
                    + newUserText + "</a></td>" );
    }
    else
    {
      // Generate without new user link - width 205, begin 231, end 435
      document.write( "<td width=\"190\" align=\"left\" class=\"color003366\">"
                    + "&raquo;&nbsp;"
                    + "<a href=\"javascript:SignIn()\" class=\"small\" "
                    + "title=\"link to sign in with Hewlett-Packard Passport\">"
                    + signInText + "</a></td>" );
    }
  }
}
else // Do not generate any HPP links - width 425, begin 11, end 435
{
  document.write( "<td width=\"425\" class=\"" + small + "\"></td>" );
}

// Render the language link for the support portal
var currentHrefLC = location.href.toLowerCase();

// The list of eCare servers for both production and test
if ( currentHrefLC.indexOf( "support.openview.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "tux436.q-tam.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "tux436-f.q-tam.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "tux436-ecare.q-tam.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "htx437.cce.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "htx437-f.cce.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "htx437-ecare.cce.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "hpat962.external.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "hpat962-ecare.external.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "htx423.legacy.cce.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "htx424.legacy.cce.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "ux-vip.cce.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "ux-sgbu.gslb.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "tux604.tam.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "espdev.cnd.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "neutron.external.hp.com" ) > 0 ||
     currentHrefLC.indexOf( "languagelink=show" ) > 0 ) // for testing only
{
  var languageSelectedJA = "";
  var languageSelectedUS = "";

  var languageCodeCurrent = getLanguage();

  if (languageCodeCurrent == languageCodeJP)
  {
    languageSelectedJA = " selected=\"selected\"";
  }
  else
  {
    languageSelectedUS = " selected=\"selected\"";
  }

  // Generate language option - width 285, begin 436, end 720
  document.write( "<td width=\"285\" align=\"right\">"
                + "<table align=\"right\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">"
                + "<form name=\"countryForm\" method=\"POST\">"
                + "<tr>"
                + "<td class=\"small\">" + formatMessage(languageCodeCurrent, "languageSelect") + ":</td>"
                + "<td><img src=\"" + assertURL() + "/img/s.gif\" width=\"4\" height=\"1\" border=\"0\" alt=\"\"></td>"
                + "<td><select name=\"countrySelect\" id=\"countrySelect\" style=\"font-size:12px\">"
                + "<option" + languageSelectedJA + ">" + formatMessage(languageCodeCurrent, "languageTextJP") + "</option>"
                + "<option" + languageSelectedUS + ">" + formatMessage(languageCodeCurrent, "languageTextUS") + "</option>"
                + "</select></td>"
                + "<td><img src=\"" + assertURL() + "/img/s.gif\" width=\"8\" height=\"1\" border=\"0\" alt=\"\"></td>"
                + "<td><a id=\"country_select\""
                + " onmouseover=\"status='" + formatMessage(languageCodeCurrent, "languageGoToURL") + "';return true;\""
                + " title=\"" + formatMessage(languageCodeCurrent, "languageTitle") + "\""
                + " onclick=\"switchLanguage()\""
                + " onmouseout=\"status='';return true;\""
                + " href=\"javascript:switchLanguage();\""
                + " onBlur=\"status='';return true;\""
                + " onFocus=\"status='" + formatMessage(languageCodeCurrent, "languageGoToURL") + "';return true;\">"
                + "<img height=\"13\" alt=\"" + formatMessage(languageCodeCurrent, "languageAlt") + "\" src=\"" + assertURL() + "/img/hpweb_1-2_arrw_sbmt.gif\" width=\"14\" border=\"0\">"
                + "</a></td>"
                + "</tr>"
                + "</form>"
                + "</table></td>" );
}
else
{
  // Generate blank language cell - width 285, begin 436, end 720
  //document.write( "<td width=\"285\"><img src=\"" + assertURL()
  //              + "/img/s.gif\" width=\"285\" height=\"24\" border=\"0\" alt=\"\"></td>" );
  document.write( "<td align=\"right\" width=\"285\" class=\"countryInd\">United States-English</td>" );
}

// Generate filler cell - width 20, begin 721, end 740
document.write( "<td width=\"20\"><img src=\"" + assertURL()
              + "/img/s.gif\" width=\"20\" height=\"24\" border=\"0\" alt=\"\"></td>" );

document.write( "</tr></table>" );

/*******************************************************************************
 * RD Function createCookie
 *
 * Create a cookie with the specified cookie name and value. If the expiresIn
 * parameter is greater then 0 the cookie is set to expire in the specified
 * minutes, otherwise this cookie parameter is not set.
 */
function createCookie( cookieName, cookieValue, expiresIn )
{
  var cookieContents = cookieName + "=" + cookieValue
                     + "; domain=.hp.com"
                     + "; path=/";

  if ( expiresIn > 0 )
  {
    var expires = new Date();
    expires.setTime( expires.getTime() + expiresIn * 60000 );

    // expiresIn minutes
    cookieContents = cookieContents + "; expires=" + expires.toGMTString();
  }
  document.cookie = cookieContents;

  logDebug( "create cookie: " + cookieContents );
}

/*******************************************************************************
 * RD Function getDefaultURL
 *
 * Get the default URL that is used as the redirect page after HPP sign out. The
 * default is either based on the last non-RD form host accessed or a preset
 * default.
 */
function getDefaultURL()
{
  var lastHost = getCookie( lastHostCookieName );

  if ( lastHost.length > 0 )
  {
    return lastHost;
  }
  else
  {
    return defaultURL;
  }
}

/*******************************************************************************
 * HPP Function SignIn
 *
 * Redirect to RD HPP to RD servlet, which is a protected page. This will
 * trigger another redirect to the HPP sign in page. Once sign in is completed
 * redirect to HPP to RD servlet, which starts an RD session, then redirect back
 * to this page.
 */
function SignIn()
{
  var signInHref = receptionDeskHref
                 + "/hpp/hpp2rd"
                 + "?dest_url=" + escape( location.href )
                 + "&hpappid=" + applicationId;

  location.href = signInHref;
}

/*******************************************************************************
 * HPP Function newUser
 *
 * Redirect to New User Registration page then back to the current page when
 * completed.
 */
function newUser()
{
  registerUser( location.href )
}

function registerUser( redirectURL )
{
  var newUserHref;
  var smlocale = getLocale();

  if ( smlocale == "" )
    smlocale = "US-EN";

  var redirectHref = receptionDeskHref + "/hpp/hpp2rd"
                   + "?dest_url=" + escape( redirectURL )
                   + "&hpappid=" + applicationId;

  var smredirect = "&smredirect="
                 + escape( regServer + regPath + "/welcome.jsp?smredirect=" )
                 + escape( redirectHref );

  if ( languageSupport == 'Y' )
  {
    newUserHref = regServer + regPath + "/newuser.do"
                + "?SMLOCALE=" + smlocale
                + "&hpappid=" + applicationId
                + smredirect;
  }
  else
  {
     newUserHref = regServer + regPath + "/newuser.do"
                 + "?SMLOCALE=US-EN"
                 + "&hpappid=" + applicationId
                 + smredirect;
  }

  location.href = newUserHref;
}

/*******************************************************************************
 * HPP Function forgotPassword
 *
 * Redirect to Forgot Password page then back to the current page when
 * completed.
 */
function forgotPassword()
{
  var forgotPasswordHref;
  var smlocale = getLocale();

  if ( smlocale == "" )
    smlocale = "US-EN";

  var smredirect = regServer + regPath + "/welcome.jsp"
                 + "?smredirect=" + location.href;

  if ( languageSupport == 'Y' )
  {
    forgotPasswordHref = regServer + regPath + "/forgotpassword.do"
                       + "?SMLOCALE=" + smlocale
                       + "&hpappid=" + applicationId
                       + "&smredirect=" + escape( smredirect );
  }
  else
  {
    forgotPasswordHref = regServer + regPath + "/forgotpassword.do"
                       + "?SMLOCALE=US-EN"
                       + "&hpappid=" + applicationId
                       + "&smredirect=" + escape( smredirect );
  }

  location.href = forgotPasswordHref;
}

/*******************************************************************************
 * HPP Function forgotUserid
 *
 * Redirect to Forgot Userid page then back to the current page when completed.
 */
function forgotUserid()
{
  var forgotUserIdHref;
  var smlocale = getLocale();

  if ( smlocale == "" )
    smlocale = "US-EN";

  if ( languageSupport == 'Y' )
  {
    forgotUserIdHref = regServer + regPath + "/forgotusername.do"
                     + "?SMLOCALE=" + smlocale
                     + "&hpappid=" + applicationId
                     + "&smredirect=" + escape( location.href );
  }
  else
  {
     forgotUserIdHref = regServer + regPath + "/forgotusername.do"
                      + "?SMLOCALE=US-EN"
                      + "&hpappid=" + applicationId
                      + "&smredirect=" + escape( location.href );
  }

  location.href = forgotUserIdHref;
}

/*******************************************************************************
 * HPP Function EditProfile
 *
 * Redirect to the RD edit profile gateway page then back to this page when
 * finished editing profile attributes.
 */
function EditProfile()
{
  var editProfileHref = receptionDeskHref + "/rdp/edit-profile/action/editgateway"
                      + "?appid=" + applicationId
                      + "&edit-profile-return=" + escape( location.href );

  location.href = editProfileHref;
}

/*******************************************************************************
 * HPP Function ChangeContactInformation
 *
 * Redirect to Change Contact Information page then back to the current page
 * when completed.
 */
function ChangeContactInformation()
{
  var changeContactInformationHref;
  var smlocale = getLocale();

  if ( smlocale == "" )
    smlocale = "US-EN";

  smredirect = receptionDeskHref + "/hpp/hpp2rd?mode=edit-profile"
                                + "&dest_url=" + location.href;

  if ( languageSupport == 'Y' )
  {
    changeContactInformationHref = regServer + regPath + "/modify.do"
                                 + "?SMLOCALE=" + smlocale
                                 + "&hpappid=" + applicationId
                                 + "&smredirect=" + escape( smredirect );
  }
  else
  {
    changeContactInformationHref = regServer + regPath + "/modify.do"
                                 + "?SMLOCALE=US-EN"
                                 + "&hpappid=" + applicationId
                                 + "&smredirect=" + escape( smredirect );
  }

  location.href = changeContactInformationHref;
}

/*******************************************************************************
 * HPP Function ChangeUserID
 *
 * Redirect to Change Contact Information page then back to the current page
 * when completed.
 */
function ChangeUserID()
{
  var changeUserIdHref;
  var smlocale = getLocale();

  if ( smlocale == "" )
    smlocale = "US-EN";

  if (languageSupport == 'Y')
  {
    changeUserIdHref = regServer + regPath + "/changeusername.do"
                     + "?SMLOCALE=" + smlocale
                     + "&hpappid=" + applicationId
                     + "&smredirect=" + escape( location.href );
  }
  else
  {
    changeUserIdHref = regServer + regPath + "/changeusername.do"
                     + "?SMLOCALE=US-EN"
                     + "&hpappid=" + applicationId
                     + "&smredirect=" + escape( location.href );
  }

  location.href = changeUserIdHref;
}

/*******************************************************************************
 * HPP Function ChangePassword
 *
 * Redirect to Change Password page then back to the current page when
 * completed.
 */
function ChangePassword()
{
  var changePasswordHref;
  var smlocale = getLocale();

  if ( smlocale == "" )
    smlocale = "US-EN";

  if ( languageSupport == 'Y' )
  {
    changePasswordHref = regServer + regPath + "/changepassword.do"
                       + "?SMLOCALE=" + smlocale
                       + "&hpappid=" + applicationId
                       + "&smredirect=" + escape( location.href );
  }
  else
  {
    changePasswordHref = regServer + regPath + "/changepassword.do"
                       + "?SMLOCALE=US-EN"
                       + "&hpappid=" + applicationId
                       + "&smredirect=" + escape( location.href );
  }

  location.href = changePasswordHref;
}

/*******************************************************************************
 * HPP Function SignOut
 *
 * When user completes a sign out from their current session redirect to the
 * sign out page.
 */
function SignOut()
{
  var signOutHref;

  if ( languageSupport == 'Y' )
  {
     signOutHref = regServer + regPath + "/confirmlogout.do"
                 + "?hpappid=" + applicationId
                 + "&smredirect=" + escape( getDefaultURL() );
  }
  else
  {
     signOutHref = regServer + regPath + "/confirmlogout.do"
                 + "?SMLOCALE=US-EN"
                 + "&hpappid=" + applicationId
                 + "&smredirect=" + escape( getDefaultURL() );
  }

  location.href = signOutHref;
}

/*******************************************************************************
 * HPP Function SignOut
 *
 * When user completes a sign out from their current session redirect to the
 * sign out page. Sign out for channel partner reserved users.
 */
function SignOutReserved()
{
  var signOutHref = regServer + regPath + "/confirmlogout.do"
                    + "?smredirect=" + location.href
                    + "&hpappid=" + applicationId;

  location.href = signOutHref;
}

/*******************************************************************************
 * HPP Utility Function GetUserName
 *
 * Retrieve the current user name associated with this session. This function
 * will attempt to retrieve the username from the HPP cookie.
 */
function GetUserName()
{
  var hpclname = getAttrFromCookie( "hpclname" );

  logDebug( "GetUserName() -> " + hpclname );

  return ( hpclname );
}

/*******************************************************************************
 * HPP Utility Function GetUserID
 *
 * Retrieve the current user ID associated with this session.  This function
 * will attempt to retrieve the username from the HPP cookie.
 */
function GetUserID()
{
  var hpclidnumber = getAttrFromCookie( "hpclidnumber" );

  logDebug( "GetUserID() -> " + hpclidnumber );

  return( hpclidnumber );
}

/*******************************************************************************
 * HPP Utility Function getAttrFromCookie
 *
 * Retrieve the specified attribute value from the HPP cookie.
 */
function getAttrFromCookie( attributeName )
{
  var attributeValue = "";
  var attributeQuery = attributeName + "=";
  var cookieValue = getCookie( hppCookieName );
  var index;

  if ( cookieValue != "" )
  {
    index = cookieValue.indexOf( attributeQuery );

    // increment the index by the length of the attribute value
    // ( taking "=" into consideration )
    index = index + attributeName.length + 1;

    while ( index < cookieValue.length )
    {
      // Check for attribute name=value delimiter
      if ( cookieValue.charAt( index ) == "|" )
        break;

      attributeValue = attributeValue + cookieValue.charAt( index );
      index++;

      if ( index > cookieValue.length )
        break;
    }
  }

  logDebug( "getAttrFromCookie( " + attributeName + " ) -> " + attributeValue );

  return attributeValue;
}

/*******************************************************************************
 * HPP Utility Function decode
 *
 * Decode UTF-8 encoded data.
 */

function decode( encodeIn )
{
  var base64s = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var bits;
  var decodeOut = '';

  for ( i = 0; i < encodeIn.length; i += 4)
  {
    bits = ( base64s.indexOf( encodeIn.charAt( i ) ) & 0xff ) << 18
         | ( base64s.indexOf( encodeIn.charAt( i + 1 ) ) & 0xff ) << 12
         | ( base64s.indexOf( encodeIn.charAt( i + 2 ) ) & 0xff ) << 6
         |   base64s.indexOf( encodeIn.charAt( i + 3 ) ) & 0xff;

    decodeOut += String.fromCharCode( ( bits & 0xff0000 ) >> 16, ( bits & 0xff00 ) >> 8, bits & 0xff );
  }

  if ( encodeIn.charCodeAt( i - 2 ) == 61 )
    return decodeOut.substring( 0, decodeOut.length - 2 );
  else if ( encodeIn.charCodeAt( i - 1 ) == 61 )
    return decodeOut.substring( 0, decodeOut.length - 1 );
  else
    return decodeOut;
}

/*******************************************************************************
 * HPP Utility Function getCookie
 *
 * Generic function to get any cookie.
 *
 * cookieName is the name of the cookie to find.  You can also search
 * for one of a number of cookies by passing the names seperated by
 * vertical bars (i.e. one|two|three would first search for cookie
 * "one", then "two", and so on) returning the value of the first
 * cookie found.  Putting parenthesis around the list of cookies
 * will break the method (don't do this: getCookie("(one|two)"); ).
 *
 * returns the value of the cookie requested, or false if not found
 *
 * Added additional logic to check for UTF-8 encoded cookie. If the prefix
 * "?UTF-8?B?" is found at the start of the cookie then the cookie data is
 * decoded otherwise it is left as is.
 */
function getCookie( cookieName )
{
  var cookieValue = "";
  var allcookies = "; " + document.cookie + ";";
  var cookieBeg = allcookies.indexOf( "; " + cookieName + "=" );
  var cookieEnd;

  if ( cookieBeg >= 0 )
    cookieBeg = allcookies.indexOf( "=", cookieBeg );

  if ( cookieBeg > 0 )
  {
    cookieBeg += 1;

    cookieEnd = allcookies.indexOf( ";", cookieBeg );

    cookieValue = allcookies.substring( cookieBeg, cookieEnd );

    if ( cookieValue.indexOf( "?UTF-8?B?" ) >= 0 )
    {
      // Remove the utf prefix of the cookie
      cookieValue = cookieValue.substring( 9, cookieValue.length - 1 );

      // Decode the cookie.
      cookieValue = unescape( decode(cookieValue ) );
    }

    logDebug( "allcookies = " + allcookies );
    logDebug( "getCookie( " + cookieName + " ) -> " + cookieValue );

    return cookieValue;
  }
  else
  {
    logDebug( "getCookie( " + cookieName + " ) -> (not found)" );

    return "";
  }
}

/*******************************************************************************
 * HPP Utility Function getLocale
 *
 * Determine the language in which the HPP pages must be displayed.
 */
function getLocale()
{
  var allcookies;
  var s_lang_start;
  var c_lang_start;
  var s_lang_end;
  var c_lang_end;
  var s_lang = "";
  var c_lang = "";
  var a_lang = "";
  var language = "";
  var locale = "";

  allcookies = document.cookie;
  s_lang_start = allcookies.indexOf( "s_lang" );

  if ( s_lang_start != - 1 )
  {
    s_lang_start += 7;
    s_lang_end = allcookies.indexOf( ";", s_lang_start );

    if (s_lang_end == - 1)
      s_lang_end = allcookies.length;

    s_lang = allcookies.substring( s_lang_start, s_lang_end );
  }

  c_lang = getAttrFromCookie( "preferredlanguage" );
  a_lang = applicationLanguage;

  if ( s_lang != "" && isLanguageSupported( s_lang ) )
    language = s_lang;

  if ( language == "" && c_lang != "" && isLanguageSupported( c_lang ) )
    language = c_lang;

  if ( language == "" && a_lang != "" && isLanguageSupported( a_lang ) )
    language = a_lang;

  if ( language == "" )
    language = "en";

  locale = "US-" + language.toUpperCase();

  return locale;
}

/*******************************************************************************
 * HPP Utility Function getLocale
 *
 * Determine the language in which the HPP pages must be displayed.
 */
function isLanguageSupported( language )
{
  var supportedLanguages = ",en,fr,de,it,pt,es,";
  var found = false;

  language = "," + language + ",";

  if ( supportedLanguages.search( language ) != - 1 )
    found = true;

  return found;
}

/*******************************************************************************
 * HPP Utility Function LoggedIn
 *
 * Determine whether the user is logged in or not. Checks to see if their is
 * a "SMSESSION" cookie, if the cookie exists and does not have the value of
 * "LOGGEDOFF", then a user will be considered "logged in", otherwise not.
 */
function LoggedIn()
{
  var allcookies = document.cookie;
  var cookieStart = allcookies.indexOf( "SMSESSION" );

  if ( cookieStart != - 1 )
  {
    var cookieEnd = allcookies.indexOf( ";", cookieStart );

    if ( cookieEnd == - 1 )
      cookieEnd = allcookies.length;

    var value = allcookies.substring( cookieStart + 10, cookieEnd );

    if ( value == "LOGGEDOFF" )
    {
      return false;
    }
    else
    {
      return true;
    }
  }
  else
  {
    return false;
  }
}

/*******************************************************************************
 * RD Utility Function assertURL
 *
 * Determine if images should be referenced via http or https.
 */
function assertURL()
{
   if ( location.href.indexOf( "https:" ) == 0 )
   {
      return "https://ssl1.speedera.net/hp-ww";
   }
   else
   {
      return "http://welcome.hp-ww.com";
   }
}

/*******************************************************************************
 * RD Utility Function setQParameter
 *
 * Set query parameter name and value in the given href.
 */
function setQParameter( href, qpName, qpValue )
{
  var qpPrefix = "?";

  // Check if any query params are defined in the current URL
  if ( href.indexOf( "?" ) > 0 )
  {
    qpPrefix = "&";
  }

  var qpPos = href.toLowerCase().indexOf( qpName );
  var qpLen = qpName.length;

  // Check if the query param is already defined in the URL
  if ( qpPos > 0 )
  {
    var pos = href.indexOf( "&", qpPos );

    // Check if there are other QP after this one
    if ( pos > 0 )
    {
      // Insert QP name=value in the middle of the URL
      href = href.substring( 0, qpPos )
           + qpName + "=" + escape( qpValue ) + href.substring( pos );
    }
    else
    {
      // Append QP name=value at the end of the URL
      href = href.substring( 0, qpPos )
           + qpName + "=" + escape( qpValue );
    }
  }
  else // QP not part of current URL so append
  {
    href = href + qpPrefix + qpName + "=" + escape( qpValue );
  }

  return href;
}

/*******************************************************************************
 * RD Utility Function getLanguage
 *
 * Get the current language setting from the lang cookie.
 */
function getLanguage()
{
  var languageCurrent = getCookie(languageCookie);

  if (languageCurrent.length > 1)
  {
    languageCurrent = languageCurrent.substring(0, 2);
  }
  else
  {
    languageCurrent = languageCodeDefault;
  }

  logDebug( "getLanguage() -> " + languageCurrent );

  return languageCurrent;
}

/*******************************************************************************
 * RD Utility Function switchLanguage
 *
 * Set the current language setting in the lang cookie.
 */
function switchLanguage()
{
  var optionIndex = document.countryForm.countrySelect.selectedIndex;

  if (optionIndex == 0)
  {
    createCookie(languageCookie, languageCodeJP, 0);
    createCookie(countryCookie, countryCodeJP, 0);
  }
  else if (optionIndex == 1)
  {
    createCookie(languageCookie, languageCodeUS, 0);
    createCookie(countryCookie, countryCodeUS, 0);
  }

  // Refresh the page with the new language selection
  location.href = location.href;
}

/*******************************************************************************
 * RD Utility Function formatMessage
 *
 * Format the message based on the language code setting.
 */
function formatMessage(languageCode, message)
{
  languageCode = languageCode.toLowerCase();
  if (languageCodeJP == languageCode || languageCodeUS == languageCode)
  {
    return eval(message + "_" + languageCode);
  }
  else
  {
    return eval(message + "_" + languageCodeDefault);
  }
}

/*******************************************************************************
 * RD Utility Function logDebug
 *
 * Simple logging used for debugging. Debug messages will be place on the web
 * page if the query parameter "clhook=debug" is set.
 */
function logDebug(msg)
{
  if (location.href.indexOf("clhook=debug") > 0)
  {
    document.write(msg + "<br/>");
  }
  else if (location.href.indexOf("clhook=alertdebug") > 0)
  {
    alert(msg);
  }
}
