/*
 * Copyright 1999-2004 Antti Koivunen.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 */

/**
 * Simple singleton object for handling cookies. Note that setting the cookies
 * uses the old Netscape syntax, since IE doesn't yet support RFC-2109.
 */
var Cookies = {
    
    // 24 * 60 * 60
    SECS_IN_DAY: 86400,

    // Returns the value of the specified cookie, or null if it's not defined.
    get: function (name) {
        var re = new RegExp(name + "=([^;]*)");
        var a = re.exec(document.cookie);
        return (a != null) ? unescape(a[1]) : null;
    },
    
    // Sets the value of the specified cookie.
    set: function (name, value, maxAgeSecs, domain, path, secure) {
        var c = name + "=" + escape(value);
        if (maxAgeSecs)
            c += "; expires=" + new Date(
                new Date().getTime() + maxAgeSecs * 1000 ).toGMTString();
        if (domain)
            c += "; domain=" + domain;
        if (path)
            c += "; path=" + path;
        if (secure)
            c += "; secure";
        document.cookie = c;
    }
}
