

// === Version Detection ===
iv_isDOM  = (document.getElementById);
iv_isNS4  = (document.layers);
iv_isIE   = (document.all);
iv_isIE4  = (iv_isIE && !iv_isDOM);
iv_isMac  = (navigator.appVersion.indexOf("Mac") != -1);
iv_isIE4M = (iv_isIE4 && iv_isMac);
iv_isIE5M = iv_isDOM && iv_isIE && iv_isMac;
iv_isIE5W = iv_isDOM && iv_isIE && !iv_isMac;
iv_isNS6 =  iv_isDOM && (navigator.vendor == ("Netscape6") || navigator.product == ("Gecko"));
iv_searchIVUrl = "http://search.ivillage.com/search/ivillage";
iv_searchWebUrl = "http://search.ivillage.com/search/web";
iv_verticalID = "iv";
iv_sageHost = "https://subscriber.ivillage.com";
iv_channelHomepageURL = "http://www.ivillage.com";

// === Utilities ===
// iv_queryString - Reads a query string from the URL. Pass in the key name and get back the value. 
// @param keyName Querystring key.
// @return Key value.
function iv_queryString(keyName) { 
    var keyValue = "";
    keyName = keyName.toUpperCase() + "="; 

    if (window.location.href.indexOf("?") != -1) { 
        var queryString = window.location.href.substring(window.location.href.indexOf("?")+1); 
        var searchString = queryString.toUpperCase(); 
        if (searchString.indexOf(keyName) != -1) { 
            var keyValueStart = parseInt(searchString.indexOf(keyName)) + keyName.length; 
            var keyValueEnd = searchString.indexOf("&", keyValueStart); 
            var keyValueEnd = (keyValueEnd != -1) ? keyValueEnd : searchString.length; 
            keyValue = queryString.substring(keyValueStart,keyValueEnd); 
        }

        var plusPos = keyValue.indexOf('+');
        while (plusPos != -1) {
            keyValue = keyValue.substring(0, plusPos) + " " + keyValue.substring(plusPos + 1, keyValue.length);
            plusPos = keyValue.indexOf('+');
        }
    } 

    return unescape(keyValue); 
} 

// iv_changeStatusBar - Window status changer.
// @param text Text to display in status bar.
function iv_changeStatusBar(text) {
	window.status = text;
}

// iv_resetStatusBar - Resets status bar to blank.
function iv_resetStatusBar() {
	window.status = "";
}


// === Cookie functions ===
// iv_getCookie - Gets cookie value.
// Note: B/c this function uses indexOf, false matches are possible, i.e. iv_getCookie("est") will get the value of "test".
// @param Name Cookie key name.
// @return Key value. Returns null if cookie doesn't exist.
function iv_getCookie(Name) {
    var tCookie = document.cookie; if (tCookie.length == 0) { return null; }
    var search = Name + "=";
    offset = tCookie.indexOf(search); if (offset == -1) { return null; }
    offset += search.length;
    end = tCookie.indexOf(";", offset);
    if (end == -1) { end = tCookie.length; }
    return unescape(tCookie.substring(offset, end));
}

function iv_setIntervalCookie (name, value, interval, mode) {
  var now = new Date();
  var aDay = 86400000
  var aHour = 3600000
  var aMinute = 60000
  var aSec = 1000
  
  if (mode == 'days') {
    //this gets the precise seconds to set the cookie, calculating the days (not 24hours)
    now.setTime(now.getTime() + ((interval-1)*aDay)+(24-now.getHours())*aHour+aMinute)
  } else if (mode == 'hours') {
	now.setTime(now.getTime() + interval * aHour)
  }
 
  //now set the cookie
  document.cookie = name+"="+escape(value)+"; expires="+now.toGMTString()+"; path=/";
}

function iv_deleteCookie (name,path,domain) {
  if (iv_getCookie(name)) {
    document.cookie = name + "=" +
      "; path=" + ((path) ? path : "/") +
      ((domain) ? "; domain=" + domain : "") + "; expires=Thu, 01-Jan-1970 00:00:01 GMT";
  }
}

// iv_,, - Sets cookie value.
// @param Name Cookie key name.
// @param value Cookie value.
// @param expires
// @param path
// @param domain
// @return nothing
function iv_setCookie (name,value,expires,path,domain) {
  // expires represents a value in days
  var ckToday = new Date();
  if (expires != null) { var exp = new Date(ckToday.getTime() + expires * 24 * 60 * 60 * 1000); }
  document.cookie = name + "=" + escape(value) +
    ((expires) ? "; expires=" + exp.toGMTString() : "") +
    "; path=" + ((path) ? path : "/") +
    ((domain) ? "; domain=" + domain : "");
}

// === Search ===
// iv_handleGoogleSubmit - Submit handler. Verifies search input. Alters action depending on button pushed.
// @param inputForm Form object to be checked.
// @param frmIDBase Base name of form. Used to identify multiple forms on page.
// @return boolean value if form is valid or not.
function iv_handleGoogleSearch(inputForm, frmIDBase) {
	var skin = inputForm.sk;
    var restrictValue = inputForm.restrict;
    var mt = inputForm.q.value;

    if (mt.length == 0) {
        alert('Your search could not be completed because no search words were entered.');
        inputForm.q.focus();
		inputForm.q.select();
        return false;
    }

    if (document.getElementById) {
        var r1 = document.getElementById(frmIDBase + '_ivradio');

        if (r1.src.indexOf("off.") > -1) {
            inputForm.action = "http://search.ivillage.com/search/web";
            restrictValue.value = "web";
        } else {
            inputForm.action = "http://search.ivillage.com/search/ivillage";
            restrictValue.value = "ivillage";
        }
        return true;
    }
}


// === Send To A Friend OR "Email this page" functionality===
// iv_openS2F - Opens S2F window. Use iv_S2FOverride to override standard page location.
function iv_openS2F() {
 
    iv_S2FUrl = typeof iv_S2FOverride == "undefined" ? window.document.location.href : iv_S2FOverride;
	    

    var w = 505;
    var h = 610;
    var cw = 252;
    var ch = 203;

    if (window.screen) {
        cw = Math.floor((screen.availWidth - w) / 2);
        ch = Math.floor((screen.availHeight - h) / 3);
    }

    var mywin = window.open ('http://www.ivillage.com/s2f/form/0,,k,00.html?s2fURL=' + escape(iv_S2FUrl) + '&s2fTitle=' + escape(window.document.title), 's2f', 'width=505,height=610,top=' + ch + ',left=' + cw + ',scrollbars=yes');
} 


/*
 * FlashObject embed
 * by Geoff Stearns (geoff@deconcept.com, http://www.deconcept.com/)
 *
 * v1.1.0 - 03-31-2005
 *
 * writes the embed code for a flash movie, includes plugin detection
 *
 * Usage:
 *
 *	myFlash = new FlashObject("path/to/swf.swf", "swfid", "width", "height", flashversion, "backgroundcolor");
 *	myFlash.write("objId");
 *
 * for best practices, see:
 *  http://blog.deconcept.com/2005/03/31/proper-flash-embedding-flashobject-best-practices/
 *  
 *  May 5th 2005 - Dennis Pierce
 *  Renamed variables to be iVillage compliant.
 */

var iv_FlashObject = function(swf, id, w, h, ver, c) {
//alert("obj created");
	this.swf = swf;
	this.id = id;
	this.width = w;
	this.height = h;
	this.version = ver;
	this.align = "middle";

	this.params = new Object();
	this.variables = new Object();

	this.redirect = "";
	this.sq = document.location.search.split("?")[1] || "";
	this.bypassTxt = "<p>Already have Macromedia Flash Player? <a href='?detectflash=false&"+ this.sq +"'>Click here if you have Flash Player "+ this.version +" installed</a>.</p>";
	
	if (c) this.color = this.addParam('bgcolor', c);
	this.addParam('quality', 'high'); // default to high
	this.doDetect = iv_getQueryParamValue('detectflash');
}

var iv_FOP = iv_FlashObject.prototype;

iv_FOP.addParam = function(name, value) { this.params[name] = value; }

iv_FOP.getParams = function() { return this.params; }

iv_FOP.getParam = function(name) { return this.params[name]; }

iv_FOP.addVariable = function(name, value) { this.variables[name] = value; }

iv_FOP.getVariable = function(name) { return this.variables[name]; }

iv_FOP.getVariables = function() { return this.variables; }

iv_FOP.getParamTags = function() {
    var paramTags = "";
    for (var param in this.getParams()) {
        paramTags += '<param name="' + param + '" value="' + this.getParam(param) + '" />';
    }
    return (paramTags == "") ? false:paramTags;
}

iv_FOP.getHTML = function() {
    var flashHTML = "";
    if (navigator.plugins && navigator.mimeTypes.length) { // netscape plugin architecture
        flashHTML += '<embed type="application/x-shockwave-flash" src="' + this.swf + '" width="' + this.width + '" height="' + this.height + '" id="' + this.id + '" align="' + this.align + '"';
        for (var param in this.getParams()) {
            flashHTML += ' ' + param + '="' + this.getParam(param) + '"';
        }
        if (this.getVariablePairs()) {
            flashHTML += ' flashVars="' + this.getVariablePairs() + '"';
        }
        flashHTML += '></embed>';
    } else { // PC IE
        flashHTML += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" width="' + this.width + '" height="' + this.height + '" id="' + this.id + '" align="' + this.align + '">';
        flashHTML += '<param name="movie" value="' + this.swf + '" />';
        if (this.getParamTags()) {
            flashHTML += this.getParamTags();
        }
        if (this.getVariablePairs() != null) {
            flashHTML += '<param name="flashVars" value="' + this.getVariablePairs() + '" />';
        }
        flashHTML += '</object>';
    }
    return flashHTML;	
}

iv_FOP.getVariablePairs = function() {
    var variablePairs = new Array();
    for (var name in this.getVariables()) { 
    	variablePairs.push(name + "=" + escape(this.getVariable(name))); 
    }
    return (variablePairs.length > 0) ? variablePairs.join("&"):false;
}

iv_FOP.write = function(elementId) {

	if(iv_detectFlash(this.version) || this.doDetect=='false') {
		if (elementId) {
		//alert(elementId);
			document.getElementById(elementId).innerHTML = this.getHTML();
		} else {
			document.write(this.getHTML());
		}
	} else {
		if (this.redirect != "") {
			document.location.replace(this.redirect);
		} else if (this.altTxt) {
			if (elementId) {
				document.getElementById(elementId).innerHTML = this.altTxt +""+ this.bypassTxt;
			} else {
				document.write(this.altTxt +""+ this.bypassTxt);
			}
		}
	}		
}

/* ---- detection functions ---- */
function iv_getFlashVersion() {
	var flashversion = 0;
	if (navigator.plugins && navigator.mimeTypes.length) {
		var x = navigator.plugins["Shockwave Flash"];
		if(x && x.description) {
			var y = x.description;
   			flashversion = y.charAt(y.indexOf('.')-1);
		}
	} else {
		result = false;
	    for(var i = 15; i >= 3 && result != true; i--){
   			execScript('on error resume next: result = IsObject(CreateObject("ShockwaveFlash.ShockwaveFlash.'+i+'"))','VBScript');
   			flashversion = i;
   		}
	}
	return flashversion;
}

function iv_detectFlash(ver) {	return (iv_getFlashVersion() >= ver) ? true:false; }

// get value of query string param
function iv_getQueryParamValue(param) {
	var q = document.location.search || document.location.href.split("#")[1];
	if (q) {
		var detectIndex = q.indexOf(param +"=");
		var endIndex = (q.indexOf("&", detectIndex) > -1) ? q.indexOf("&", detectIndex) : q.length;
		if (q.length > 1 && detectIndex > -1) {
			return q.substring(q.indexOf("=", detectIndex)+1, endIndex);
		} else {
			return "";
		}
	}
}

/* add Array.push if needed */
if(Array.prototype.push == null){
	Array.prototype.push = function(item) { this[this.length] = item; return this.length; }
}





// === ZAG ===
// iv_SetdccCookie - Sets the ZAG cookie
// @param zip
// @param age - Year of birth 
// @param gender - 'M' or 'F'
// @return  nothing
function iv_SetdccCookie (zip, age, gender) {
  if (zip == null) { zip = ""; } 
  if (age == null) { age = ""; }
  if (gender == null) { gender = ""; }
  iv_dcc= "Z:" + zip + "|A:"  + age + "|G:"  + gender;
  iv_setCookie("iv_dcc", iv_dcc, 3600, "/", ".ivillage.com");
}



// === Fourth column astrology ===
// iv_SetSunSign - Used by fourth column to set ZAG cookie. 
// @param sunSign
// @param year 
// @return  nothing
function iv_SetSunSign (sunSign, year) {
  iv_SetdccCookie("", "", year);
  iv_setCookie("iv_sunsign", sunSign, 3600, "/", ".ivillage.com");
}

// === CIMS form handler ===
// Checks the email field, and sets cid and cid fields. All CIMS forms MUST have 
// these fields.
function processCIMS (theForm,popUp) {
   // See if we have any spaces.
	var space = theForm.email.value.indexOf(" ");
	if (space != -1) { 
	alert("Please check your email address");
	return false; 
	}
	
	var pos1 = theForm.email.value.indexOf("@");
    if (pos1 < 1) { 
	alert("Please check your email address");
	return false; 
	}
    var email = theForm.email.value.substr(pos1 + 1);
    var pos2 = theForm.email.value.indexOf(".");
    if (pos2 < 1 || theForm.email.value.substr(pos2 + 1) == "" || (pos2 - pos1) == 1) { 
	alert("Please check your email address");
	return false; 
	}
	

  if (typeof(cimsCid) != 'undefined') {
    theForm.cid.value=cimsCid;
  }
  
  if (typeof(cimsUid) != 'undefined') {
	theForm.uid.value=cimsUid;
  }
  
  // Append the email address to the rurl.
  //theForm.rurl.value += "?email=" + theForm.email.value;
  
  // If popUp is specified, open CIMS in a new window.
  if (popUp == 'y') {
    cimsWindow = window.open('','cimsWindow',"WIDTH=770,HEIGHT=600,scrollbars=yes,toolbar=yes,resizable=yes,location=yes,menubar=yes,statusbar=yes"); 
    theForm.target = 'cimsWindow';
    return true;
  } else {
    return true;
  }
}

function pollSubmit (myForm) {

  var leftplacement = screen.width / 2 - 152;
  var topplacement = screen.height / 2 - 95;
  var myWin = window.open('', 'pollResultsWindow', 'HEIGHT=190,WIDTH=305,top=' + topplacement + ',left=' + leftplacement);
  myForm.target='pollResultsWindow';
  myForm.submit();
  myWin.focus();
  return true;
}

// === Open Window Wrapper ===
// iv_OpenWin - Used to open link to new window. 
// @param url
// @param params
// @return  nothing
function iv_OpenWin(url, params) {
   window.open(url, 'iv_window', params);
}

// === Open Window JS ===
// iv_OpenWin - Used to open link to new window. 
function iv_pleasedontGo(box) {
  if (box.selectedIndex == -1) { alert('Please select a value first.'); return; }
  val = box.options[box.selectedIndex].value; window.open (val,'_top'); 
}
  

// Joins numerous form values into one string. 
// Delimiters (if any) should be set in the individual form values
// Created for sweeps entry.

function concatEntryData(thisForm) {

	//create temporary string
	tempString = new String();
    // Test if field exists
    if (!thisForm.txtEntryNames) {
        alert("DEVELOPER ERROR: Missing entry data inputs field.");
        return false;
    }

    if (trimSpace(thisForm.txtEntryNames.value) == "") {
        alert("DEVELOPER ERROR: Required entry data inputs field is empty.");
        return false;
    }

    var entryInputs = thisForm.txtEntryNames.value.split(" ");
	
	
	for (var i = 0; i < entryInputs.length; i++) { 
		var formItem = entryInputs[i];
		var concatList = new Array;   // sublist of form fields to validate
		
		if (formItem.indexOf("*") > 0) {
            formItem = formItem.replace(/\*/,"1");  // dynamic node array is based on first element name
            var curObject = eval("thisForm." + formItem);
            // object will not have a name if it is an array (possible if only 1 element in multi)
            if (!curObject.name) {
                for (var j = 0; j < curObject.length; j++) { concatList[formItem + "[" + j + "]"] = 1; }
            } else {
                concatList[formItem] = 1;
            }
        } else {
            concatList[formItem] = 1;
        }
		
		for (formElement in concatList) {
				
            curObject = eval("thisForm." + formElement);
			
            if (!curObject) {
                alert("DEVELOPER ERROR: " + formElement + " is an non-existant form element.");
                return false;
            }
			
			// check text and textareas
            if (curObject.type == "text" || curObject.type == "textarea" || curObject.type == "password" || curObject.type == "hidden") {
                var tempValue = trimSpace(curObject.value);
                tempString += tempValue;
				
						
            } else if (curObject.type == "select-one"  || curObject.type == "select-multiple") {
				tempValueIndex = curObject.selectedIndex;
				tempValue = curObject[tempValueIndex].value;
				tempString += tempValue;
				
				
            } else if (curObject.type == "radio" || curObject.type == "checkbox") {
                tempValue = curObject.checked.value;
                tempString.concat(tempValue);  
				    
            } else if (!curObject.type) {
				var multiValue;
				tempValue = '';
                for (var j = 0; j < curObject.length; j++) {
                    if (curObject[j].checked) {
					multiValue = curObject[j].value;
					tempValue += multiValue;
					}
                }
			tempString += tempValue;
                
            }
		}		
	}
thisForm.entryData.value = tempString;
}	


// isValidEmail - Checks to see if email format is correct.
// @param email Email address to validate.
// @returns boolean depending on success.
function isValidEmail(email) {
    // See if we have any spaces.
	var space = email.indexOf(" ");
	if (space != -1) { return false; }

    // max length of email
    if (email.length > 75) { return false; }

    var re = /^[\w-]+(\.[\w-]+)*@([\w-]+\.)+[a-zA-Z]{2,7}$/;
    if (!email.match(re)) { return false; }
    return true;
}

// @param thisForm Form object to be tested
// @param popUp checks for popUp window
// @return true/false
function doNewsletterSubmit(theForm,popUp) {
    theForm.ip.value = document.location.href;
    theForm.action="https://subscriber.ivillage.com/sagews"    //Get Server Environment
	if (!isValidEmail(theForm.email.value)) {
	  alert("Enter valid email address");
	  return false;
    }	

    if (theForm.r.value == "") { theForm.r.value = "http://www.ivillage.com/ivillage/thankyou/newsletters"; }
	if (popUp == 'y') {
	    sageWindow = window.open('','sageWindow',"WIDTH=500,HEIGHT=500,scrollbars=yes,toolbar=yes,resizable=yes,location=yes,menubar=yes,statusbar=yes"); 
    	theForm.target = 'sageWindow';
		theForm.submit();
    	return false;
  	} else {
		theForm.submit();
    	return false;
  	}
}

// @param thisForm Form object to be tested
// @param popUp checks for popUp window
// @return true/false
function doFunnel4Submit(theForm,popUp) {
    var redirectURL = document.location;
    theForm.action="https://subscriber.ivillage.com/funnels/4?vrt=" + iv_verticalID + "&dd=" + redirectURL;
	if (!isValidEmail(theForm.email.value)) {
	  alert("Enter valid email address");
	  return false;
    }	

    if (popUp == 'y') {
	    sageWindow = window.open('','sageWindow',"WIDTH=720,HEIGHT=500,scrollbars=yes,toolbar=yes,resizable=yes,location=yes,menubar=yes,statusbar=yes"); 
    	theForm.target = 'sageWindow';
		theForm.submit();
    	return false;
  	} else {
	    return true;
  	}
}

// javascript code needed for the Glossary dictionary
// @param index accepts ID for glossary
function iv_showDef(index) { 
    if (index != 'null') { 
        window.open('/glossary/definition/0,,' + index + ',00.html', 'glossary', 'width=350,height=180,scrollbars');
    } 
}

// Select box redirector (opens in same window)
// @param handle of select box
function newpage(box) {
  if (box.options[box.selectedIndex].value == '') { return; }
  document.location.href = box.options[box.selectedIndex].value;
}

//sets pixel for 4th column tracking
function iv_set4thImp() {
    return;			
}
