    

// === Global config parameters ===
var iv_showDelay = 80;
var iv_hideDelay = 80;


// === Bookmark ===
// iv_bookMark - Creates bookmark link to current page location if in IE. If iv_bookMarkOverride is set, will use that value instead.
//               Requires iv_pageTitle to be global since the function call will be invoked from a global level.
function iv_bookMark() {
    iv_bookMarkURL = typeof iv_bookMarkOverride == "undefined" ? window.document.location.href : iv_bookMarkOverride;
    iv_pageTitle = document.title ? document.title : "";  // global variable

    if (!iv_isIE) { return; }

    var link = '<a href="javascript: window.external.AddFavorite(iv_bookMarkURL, iv_pageTitle);" id="bookmark" onmouseover="window.status=\'add bookmark\'; return true;" onmouseout="window.status=\'\'; return true;">Bookmark this page</a>';
    document.write(link);
}


// === Search ===
// iv_toggleSearch - toggle radio button images for search
// @param selectedRadio Radio value to switch to. Can be web|ivillage.
// @param frmIDBase Base name of form. Used to identify multiple forms on page.
function iv_toggleSearch(selectedRadio, frmIDBase) {
    if (document.getElementById) {
        r1 = document.getElementById(frmIDBase + '_ivradio');
        r2 = document.getElementById(frmIDBase + '_webradio');
        
        var current = (r1.src.indexOf("off.") > -1) ? "web" : "ivillage";
        
        if (current != selectedRadio) {
            var src1 = r1.src;
            r1.src = r2.src;
            r2.src = src1;
        }
    }
}


// === News related functions ===
// iv_initNews - Starts up the news ticker. Requires the existance of global newsItems array and nextItem variable.
function iv_initNews() {
    if (typeof newsItems == "undefined") { return; }
    newsBox = document.getElementById('newsticker');
    var newsInt = setInterval(iv_showNextNewsItem, 9000);
    iv_showNextNewsItem();
}

// iv_showNextNewsItem - Displays next news item.
function iv_showNextNewsItem() {
    var totalNews = newsItems.length;
    
    if (totalNews > 0) {
        newsBox.innerHTML = "";
        nextItem++;
        nextItem = (nextItem >= totalNews) ? 0 : nextItem;
        setTimeout('newsBox.innerHTML = \'<a href="'+ newsItems[nextItem][0] +'" target="feedroom">'+ newsItems[nextItem][1] +'</a>\';', 1000);
    }
}


// === Auth related functions ===
// Get the user name (only works on iVillage domain)
// iv_tkt is required to be considered logged in.

var iv_login = iv_getCookie("iv_id");
var iv_loggedin = iv_getCookie("iv_tkt");

// === drawWelcome ===
// Outputs welcome text.
// 3 cases:
//   1. not authed
//   2. authed, no iv_id
//   3. authed, have iv_id

function drawWelcome() {
    if (typeof iv_sageHost == "undefined") {
      iv_sageHost = "https://subscriber.ivillage.com";
    }
    
    if (typeof iv_verticalID == "undefined") {
      iv_verticalID = "iv";
    }
    
    var destURL = escape(document.location);
    
    if (typeof iv_S2FOverride != "undefined") {
      destURL = iv_S2FOverride;
    } else {
        destURL = "http://www.ivillage.com";
    }
    
    var logout = '<a href="' + iv_sageHost + '/login/logout/?url=' + escape(document.location) + '">LOG OUT</a>';

    if (!iv_loggedin || iv_loggedin == "NA") {
        // not authed
        var login = iv_sageHost + "/login/login?s=iv&dt=rurl&dd=" + destURL;
        var join = iv_sageHost + "/funnels/10?vrt=" + iv_verticalID + "&dd=" + destURL;
        document.write('<a href="' + login + '">LOG IN</a> or <a href="' + join + '">JOIN NOW</a>');
        return;
    } else {
        if (!iv_login) {
            var profile = '<a href="' + iv_sageHost + '/profile">YOUR PROFILE</a>';
            document.write('Welcome! ' + profile + ' or '+ logout); return;
        } else {
            var profile = '<a href="' + iv_sageHost + '/profile">' + iv_login + '</a>';
            document.write('Welcome, ' + profile + '! ' + logout);
        }
    }
}


// === Left nav related functions ===
// iv_setupLeftNav - Initializes left nav
function iv_setupLeftNav() {
    if (document.getElementById) {
        navRoot = document.getElementById("lnav");
        if (navRoot) {
            var atags = navRoot.getElementsByTagName("a");
            for (var i = 0; i < atags.length; i++) {
                var arrow = atags[i];
                if (arrow.className.indexOf("lnavarrow") > -1) {
                    arrow.id = "arrow" + i;
                    iv_showHide(arrow.id);
                    arrow.onclick = function() {
                        iv_showHide(this.id);
                        return false;
                    }
                    if (arrow.className.indexOf("active") > -1) { iv_showHide(arrow.id); }
                }
            }
        }
    }

    // also fix hover for ie
    iv_addLeftNavHover();
    
    // also disable link for current category
    iv_disableLink();

}

// iv_disableLink - Disables link in left nav
 function iv_disableLink () {
        if (typeof(iv_secondarytopicID) != 'undefined') { 
                var CurrentTopic = document.getElementsByName(iv_secondarytopicID)
                    if (CurrentTopic[0] == undefined){
                        return;
                    } else {
                        // CurrentTopic[0].href = "javascript:void(false)";
                        CurrentTopic[0].className = "disablelink";
                    }
        
        }
}


// iv_addLeftNavHover - Left nav fix for ie
function iv_addLeftNavHover() {
        var navRoot = document.getElementById("lnav");
        iv_setupNode(navRoot);
        /*look for second list, if there is one (messageboards)*/
        var navRoot2 = document.getElementById("lnav_2");
        iv_setupNode(navRoot2);
}

// iv_setupNode - add hover actions to list
var iv_bleedingSelect = null; 
function iv_setupNode(navRoot){
    if (navRoot) {
        for (var i=0; i<navRoot.childNodes.length; i++) {
            var node = navRoot.childNodes[i];
            if (node.nodeName=="LI") {
                node.hideTimer = null;
                node.id = navRoot.id+"_sub"+i;
                node.onmouseover = iv_showNav;
                node.onmouseout = iv_hideNav;
            }
        }
    }
    //set a select id to "bleedingSelect" if it should be hidden on nav flyouts
    iv_bleedingSelect = document.getElementById("bleedingSelect");
}

// showNav - Display nav
function iv_showNav() {
    if (this.hideTimer) { clearTimeout(this.hideTimer); }
     iv_showNode(this);
    var command = "iv_showNavById('"+this.id+"')";
    this.hideTimer = setTimeout(command, iv_showDelay);
}

// iv_hideNav - Hides nav
function iv_hideNav() {
     iv_hideNode(this);
    var command = "iv_hideNavById('"+this.id+"')";
    this.hideTimer = setTimeout(command, iv_hideDelay);
}

var nodeOffset = -1;
// iv_showNavById - Display nav
function iv_showNavById(navId) {
    var node = document.getElementById(navId);
    node = node.getElementsByTagName("UL")[0];
    if (node == null){
    return true;
    }
    iv_showNode(node);

    /* add top offset from header for IE, best if we could remove this */
    if( nodeOffset == -1 && document.all )
        nodeOffset = document.getElementById("leftcol").offsetTop;
    else if ( nodeOffset == -1 )
        nodeOffset = 0;
    
    /* adjust flyout nodes so memnu always connects to flyout */
    if( node.haveFixedFlyout == null ){
        var nodeBottom=node.offsetTop+node.offsetHeight;
        var navBottom=node.parentNode.offsetTop+node.parentNode.offsetHeight;

        if( navBottom + nodeOffset > nodeBottom){    /*if sits below nav, offset up from bottom of nav*/
            node.style.top = node.offsetTop+nodeOffset+(navBottom-nodeBottom)+"px";    
        }else{    /*else place at top of leftnav*/
            node.style.top = (document.getElementById("leftcol").offsetTop+3)+"px";
        }
        node.haveFixedFlyout = "true";
    }        
}

// iv_hideNavById - Hides nav
function iv_hideNavById(navId) {
    var node = document.getElementById(navId);
    node = node.getElementsByTagName("UL")[0];
    iv_hideNode(node);
}
// iv_showNode - disclose a node in list
function iv_showNode(node){
    if (node != null && node.className.indexOf("over") < 0) {
        if(iv_bleedingSelect != null)
            iv_bleedingSelect.style.visibility="hidden";
        node.className += " over";
    }
}
// iv_hideNode - hide node in list
function iv_hideNode(node){
    if( node != null){
        if(iv_bleedingSelect != null)
            iv_bleedingSelect.style.visibility="visible";
        node.className = node.className.replace(" over", "");
        node.className = node.className.replace("over", "");
    }
}

// iv_showHide - Show/Hide toggle.
// @param elmid Item to toggle.
function iv_showHide(elmid) {
    var elm = document.getElementById(elmid).parentNode.getElementsByTagName("ul")[0];
    var img = document.getElementById(elmid).getElementsByTagName("img")[0];
    if (img && elm) {
        if (img.src.indexOf("_on") < 0) {
            var s = img.src.split(".gif");
            var newSrc = s[0] + "_on.gif";
        } else {
            var newSrc = img.src.replace("_on", "");
        }

        elm.style.display = elm.style.display == "none" ? "block" : "none";
        img.src = newSrc;
    }
}


// === Load event handler ===
window.onload = function() {
    iv_initNews();
    iv_setupLeftNav();
	iv_loadFlashDetection();
}

// ==== Flash tracking function ===
function iv_loadFlashDetection() {
    if (iv_isDOM) {
	  if (document.getElementById("flashcontent_detect") != null) {
	    document.getElementById("flashcontent_detect").innerHTML = iv_flashObj_detect.getHTML();
	  }
	}
}

// === TOUTS
/* Tabbed Touts */
var toutTabsLeftName = "tout_tabs_left_on";
var toutTabsRightName = "tout_tabs_right_on";
function toggleTabs( clickedLink ){

    var switchRight=true;
    //switch the tab background    
        //checkto see if new tab is being clicked
        var tabOwner = clickedLink.parentNode.parentNode.parentNode;
        // Check for the initial click.
          var clickedLeftTab = clickedLink.parentNode == clickedLink.parentNode.parentNode.firstChild;
          //alert("clickedLeftTab"+clickedLeftTab);
        if (clickedLeftTab && tabOwner.className.indexOf(toutTabsLeftName) > -1 ) { 
          return false; 
        } else if (!clickedLeftTab && tabOwner.className.indexOf(toutTabsRightName) > -1 ) { 
          return false; 
        }        
                
        var links = clickedLink.parentNode.parentNode;
        var lChildren = links.getElementsByTagName("LI");
        if( !clickedLeftTab ) {
            // Turning on the right tab and underlining the left. 
            tabOwner.className=toutTabsRightName;
            lChildren[0].className="underline_on";
            lChildren[1].className="underline_off";
        } else {
            tabOwner.className=toutTabsLeftName;
            lChildren[1].className="underline_on";
            lChildren[0].className="underline_off";
        }
        //swap in the proper content
        
        var contentParent = null;
        var sibling = tabOwner;
        while( contentParent == null ){
            sibling = sibling.nextSibling;
            if( sibling.nodeName == "DIV")
                contentParent = sibling;
        }
        //tabOwner.nextSibling;//parentNode.getElementsByTagName("DIV")[1];
        var contentChildren = contentParent.getElementsByTagName("DIV");
        //alert("contentParent="+contentParent.innerHTML);
        var panel1=null;
        var panel2=null;
        for(var i=0;i<contentChildren.length;i++){
            if( contentChildren[i].className=="tout_main"){
                if(panel1 != null)
                    panel2=contentChildren[i];
                else
                    panel1=contentChildren[i];
            }
        }
        
        
        if( !clickedLeftTab ){
            panel1.style.display="none";
            panel2.style.display="";
        }else{
            panel2.style.display="none";
            panel1.style.display="";
        }
    
    return false;
}

/*Touts with Categorized Content*/
var itemOnName="cat_on";
var itemOffName="";
var contentOnName="normalText";
var contentOffName="normalText cat_off";

function switchCategory( clickedLink ){    
    var thisItemNode = clickedLink.parentNode;
    thisItemNode.className=itemOnName;
    var listNode = thisItemNode.parentNode;
    var listItems = listNode.getElementsByTagName("LI");
    var newNumber=0;
    var currentNumber=0;

    for(var i = 0; i < listItems.length; i++) {
        var listItem = listItems[i];
        if( listItem == thisItemNode ) {
            newNumber=i;
        }
        else if ( listItem.className.indexOf(itemOnName ) != -1) {
            listItem.className = itemOffName;
            currentNumber = i;
        }
    }
	
    var textFrameNode= listNode.parentNode;
    var frameHolderNode = textFrameNode.parentNode;
    
    /* toggle tab titles */
    var tabNode = document.getElementById("tabtitle");
    tabSpans = tabNode.getElementsByTagName("SPAN");
    toggleNodeDisplay(tabSpans[currentNumber],false);
    toggleNodeDisplay(tabSpans[newNumber],true);    
    
    /* toggle content */
    var contentNodes=textFrameNode.getElementsByTagName("DIV");
    toggleNodeDisplay(contentNodes[currentNumber],false);
    toggleNodeDisplay(contentNodes[newNumber],true);
    
    /* toggle images */
    if ( frameHolderNode.className == "two_frame" ) {
        var photoFrameNode = frameHolderNode.getElementsByTagName("DIV")[0];
        var photoNodes=photoFrameNode.getElementsByTagName("IMG");
        toggleNodeDisplay(photoNodes[currentNumber],false);
        toggleNodeDisplay(photoNodes[newNumber],true);
    }
    
}
function toggleNodeDisplay( node, turnOn ){
    if( turnOn )
        node.className=node.className.replace("cat_off","");
    else
        node.className=node.className+" cat_off";
}

/* for frontend touts that use a select box to go to a url */
function iv_selectURL(selectId){
    var theSelect = document.getElementById(selectId);
    var theOption = theSelect.options[theSelect.selectedIndex];
    if( theOption != null ){
        location.href = theOption.value;
    }
}