// Customer : The Weather Channel
// Version : Standard Trigger 2.10
// this script implements the survey strategy. After number of pages visited is equal to or
// greater than 'stickFactor' apply the 'samplePercentage' rule to determine if this visitor
// gets the survey.

function cppUrlPatch(s) {
	var translated = "";
	var i; 
	var found = 0;
	for(i = 0; (found = s.indexOf(':', found)) != -1; ) {
		translated += s.substring(i, found) + "|";
		i = found + 1;
		found++;
	}
	translated += s.substring(i, s.length);
	return translated;
}

// ************* configuration variables - change the values, NOT THE NAMES **************
// parameter array which defines the behavior of the trigger - this must be included
// before the trigger script or if on-exit is  being done, must be included before the 
triggerParms = new Array();
triggerParms["trigger_type"] = "ST"; // Type of trigger
triggerParms["meas_id"] = "1PLA2hx0LyHCS/kyUr6pzw=="; // measurement id (only used for OnExit)
triggerParms["mid"] = "iP222w7/lI3TfD4FWF5UmA=="; // model instance id
triggerParms["cid"] = "KQSramEereeZ8BQS8jPwzw=="; // customer id
//triggerParms["lf"] = 3; // loyalty factor
triggerParms["lf"] = 0; // loyalty factor
triggerParms["lfcookie"] = "ForeseeLoyalty_MID_KQSramEere";
triggerParms["ascookie"] = "ForeseeSurveyShown_KQSramEere";
//triggerParms["sp"] = 100; // sample percentage
triggerParms["sp"] = 0.1; // sample percentage
triggerParms["npc"] = 0; // no persistent cookies if 1
triggerParms["use_cpp"] = 0; // value set to 1, if the client wants user url (only used for OnExit)
//triggerParms["cpp_1"] = "userURL:"+ cppUrlPatch (window.location.protocol+"://" + window.location.host + window.location.pathname); // customer parameter 1 - optional.
//triggerParms["cpp_2"] = "Browser:"+ cppUrlPatch (navigator.userAgent); // customer parameter 1 - optional. 
triggerParms["pu"] = 0; // pop-under control
triggerParms["rw"] = 129600; // resample wait (value in minutes)
triggerParms["dt"] = 0; // disable trigger if 1
triggerParms["width"] = 420; // used by version 2 standard trigger to resize the survey
triggerParms["height"] = 500; // used by version 2 standard trigger to resize the survey
triggerParms["domain"] = ".weather.com"; // domain attached to resample wait. Comment out the line if you want to use default domain.
triggerParms["path"] = "/"; // cookie path
//triggerParms["omb"] = "1505-0186"; // omb number
triggerParms["alt_width"] = 580; // used by version 2 standard trigger to resize the ADA Complaint survey
triggerParms["alt_height"] = 500; // used by version 2 standard trigger to resize the ADA Complaint survey
triggerParms["scout_chk"]= "ScoutRunningCheck";//check to see if scout.html is running or not (only used for OnExit)
triggerParms["armTrigger"]= 0;// to supress ForeSee Trigger 


// these values will be set to "normal" values until we have version 2 triggers in production
// at that point, we will reset winOptWidth, winOptHeight, winOptTop, winOptLeft to
// 1, 1, 4000, 4000 respectively.  At that point the width and height above will be passed
// to the survey JSP page which will dynamically generate a JavaScript onLoad handler to 
// resize and translate to visible (for normal survey) or close off-screen (for failover)
triggerParms["winOptWidth"] = 1; // set to 1 for version 2 standard trigger
triggerParms["winOptHeight"] = 1; // set to 1 for version 2 standard trigger
triggerParms["winOptTop"] = 4000; // set to 4000 for version 2 standard trigger
triggerParms["winOptLeft"] = 4000; // set to 4000 for version 2 standard trigger

// if window contains one of these paths in its location while browsing 
// then the survey wont poped up only in Standard Trigger 
var excludeList = new Array();
//excludeList[0] = "/exclude/";//trigger script will not work under this path

//values for Double cookie solution
//triggerParms["ndc"] = 0; //   
//triggerParms["fsexp"] = 13140000;  //{Pre-defined value by ForeSee (in minutes)}; //This will be a value set some time out in the future.
//triggerParms["midexp"] = 5; //{Pre-defined value by ForeSee (in minutes)}; // This will value be used to expire the model instance id that is stored in the ForeSee cookie.  The value should be in minutes, same as in trigger parameter "rw"


// values for watchList added (only for OnExit)
var watchList = new Array();
// test values - include the "home" page and a page from one other subdirectory
// we'll intentionally leave out a second subdirectory for testing
//watchList[1] = "OnExitTesting/pop/popup.html"; // home page must be in the list
