//---------------------------------------------------------------------------
// WebFeat JavaScript interface library
//
// This file contains functions that can be used to generate the Databases
// object in the WebFeat search form
//---------------------------------------------------------------------------
//
// Updated 07/31/2002
//    Brian Schelp
//---------------------------------------------------------------------------

// Open full text in a New Window 1=yes | 0=No
newFullTextWindow = 1;

var ftWinAttributes = 'height=600,width=700,resizable=yes,scrollbars=yes,location=no,status=1,toolbar=yes,personalbar=no,menubar=yes'
var ftwin;

// Submit a fulltext2 request from a scoreboard link
function sbSummaryLink(frm, urlval)
{
	if (frm == '')
	{
		// Call user exit if it exists
		if (typeof(wf2UrlParse) == 'function')
			urlval = wf2UrlParse(urlval);
	
		// Create a form and POST the request if required
	
		var tabLoc = urlval.indexOf("\t");
		
		if (window.ftwin && !window.ftwin.closed)
				window.ftwin.close();
				
		if (tabLoc > 0)
		{
			ftwin = window.open('/WFEmptyPage.htm', 'FullRecord', ftWinAttributes);
			ftwin.focus();
			ftwin.document.open();
			ftwin.document.writeln('<html><head><title>Submit Request</title></head><body>');
			ftwin.document.writeln('<form name="wf" action="' + urlval.substr(0, tabLoc) + '" method=POST>');

			var postParms = urlval.substr(tabLoc + 1);
			var i = 0;
			var postParm;
			var name, value, j;
			while ((i = postParms.indexOf("&")) > 0)
			{
				postParm = postParms.substr(0, i);
				postParms = postParms.substr(i + 1);
				ftwin.document.writeln(formInput(postParm));
			}

			if (postParms != '')
				ftwin.document.writeln(formInput(postParms));
			ftwin.document.writeln("</form>");
			ftwin.document.writeln('</body></html>');
			ftwin.document.write();
			ftwin.document.close();
			ftwin.document.wf.submit();
			return;
		}
		else
			ftwin = window.open(urlval, 'FullRecord', ftWinAttributes);
		ftwin.focus();
		return;
	}
	
	var x, i;
  	if (!(x = document[frm]) && document.all)
		x = document.all[frm];
 
	for (i = 0; !x && i < document.forms.length; i++)
		x = document.forms[i][frm];
		
	fulltext2(x, urlval);		
}

// "Undo" a URL parameter to recreate a form input tag
function formInput(parm)
{
	var i;
	
	// Change '+' characters to space--not handled by "unescape()" function
	while ((i = parm.indexOf('+')) > 0)
		parm = parm.substr(0, i) + ' ' + parm.substr(i + 1);
	
	var j = parm.indexOf("=");
	if (j > 0)
	{
		name = unescape(parm.substr(0, j));
		value = unescape(parm.substr(j + 1));
	}
	else
	{
		name = unescape(parm);
		value = '';
	}
	return '<input type=hidden name="' + name + '" value="' + value + '">';
}

// Open POSTed full-record link in new window
function fulltext2(f, urlval)
{
	if (typeof f == 'undefined' || f == '')
	{
		sbSummaryLink('', urlval);
		return;
	}
	
	// Call user exit if it exists
	if (typeof(wf2UrlParse) == 'function')
		urlval = wf2UrlParse(urlval);
	
	var tempVal;
	var formContent = '';
	
	f.url.value = urlval;
	if (window.ftwin && !window.ftwin.closed)
		window.ftwin.close();	
	ftwin = window.open('/WFEmptyPage.htm', 'FullRecord', ftWinAttributes);
	ftwin.focus();
	ftwin.document.open();
	ftwin.document.writeln('<html><head><title>Submit Request</title></head><body>');
	formContent += '<form name="wf" action="' + f.action + '" method=POST>';
	formContent += '<input type=hidden name="formcontent" value="' + f.formcontent.value + '">';
	formContent += '<input type=hidden name="url" value="' + urlval + '">';
	formContent += "</form>";	
	ftwin.document.write(formContent);
	ftwin.document.writeln('</body></html>');	
	ftwin.document.write();
	ftwin.document.close();
	ftwin.document.wf.submit();
}


//Setting the strDescText default value
if(typeof(strDescText) == 'undefined')
	strDescText = '<font class=\"wfrdblink\">Database Description</font></a>';


// Return value of cookie (or null if it doesn't exist)
function getCookie(cookiename)
{
	var result = null;
	var myCookie = " " + document.cookie + ";";
	var searchName = " " + cookiename + "=";
	var startOfCookie = myCookie.indexOf(searchName);
	var endOfCooke;

	if (startOfCookie != -1)
	{
		startOfCookie += searchName.length;
		endOfCookie = myCookie.indexOf(";", startOfCookie);
		if(endOfCookie == -1) { endOfCookie = myCookielength(); }
		result = unescape(myCookie.substring(startOfCookie, endOfCookie));
		
	}
	return result;
}

// Get a single value from the wfsearch cookie
function getWFSearchCookieValue(cookie, valuename)
{
	var result = null;
	valuename += "=";
	var startOfValue = cookie.indexOf(valuename);
	var endOfValue;

	if (startOfValue != -1)
	{
		startOfValue += valuename.length;
		endOfValue = cookie.indexOf(":", startOfValue);
		result = unescape(cookie.substring(startOfValue, endOfValue));
	}
	return result;
}

// Return the customer assigned database name from the arrays
function getDisplayName(inField, defaultName)
{
	var outName = defaultName;
	if (typeof databases == 'undefined')
		return outName;

	for (j = 0; j < databases.length; j++)
	{
		if (databases[j][0] == inField)
		{
			outName = databases[j][1];
			return outName;
		}
	}

	return outName;
}

//--------------------------------------------------------------------------------
// WebFeat JavaScript Array structure
//--------------------------------------------------------------------------------
//
// category[idx++] = [
//	["Category 1 Name from WAC", "Default Selected", "Show Individual Databases", "Show Database Descriptions"],
//		["Translator 1 wf_value", "Translator 2 wf_value", "Translator 3 wf_value", ...];
//
// databases[] = [
//	["Translator 1 wf_value", "Assigned Name", "Local/Remote Access", "Selected by default", 
//		"Sub-Category", "Help Text", "Native Link", "Short Description"],
//	["Translator 2 wf_value", "Assigned Name", "Local/Remote Access", "Selected by default", 
//		"Sub-Category", "Help Text", "Native Link", "Short Description"],
//	];
//--------------------------------------------------------------------------------


//--------------------------------------------------------------------------------
// global function variables
//--------------------------------------------------------------------------------
g_wfaccess = getCookie("wfaccess");
if (g_wfaccess == null)
	g_wfaccess = 0;

//--------------------------------------------------------------------------------
// This function writes the individual database entires as HTML form checkboxes
//
// Uses Global Variables
//		g_CheckBoxTemplate - This template is used to format each line with the 
//								embedded <input ...checkbox ...> object.
//
// Uses Parameters
//		categoryName - This parameter is used to select the category that is to be 
//						displayed
//		useDesc - This paramater is a true/false that tells the function to display
//					the details link.
//---------------------------------------------------------------------------------
//
// Function Defaults
	CHECKBOX_TEMPLATE_D = '<tr><td width="100%"><<checkbox>><<database name>>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<<description link>></td></tr>';
//
//---------------------------------------------------------------------------------

function showDBsForCatName(categoryName, descriptionText, nCols, omitDatabase)
{
	// Use the default template if g_CheckboxTemplate is not present
	if(typeof(g_CheckboxTemplate) == 'undefined')
		g_CheckboxTemplate = CHECKBOX_TEMPLATE_D;

	if(typeof(g_CheckboxName) == 'undefined')
		g_CheckboxName = 'Databases';

	if (typeof(categoryName) == 'undefined')
		categoryName = category[0][0][0];

	if(typeof(descriptionText) == 'undefined')
		descriptionText = '';

	if(typeof(nCols) == 'undefined')
		nCols = 1;

	if(typeof(omitDatabase) == 'undefined')
		omitDatabase = '';

	for (i=0; i< category.length; i++)
	{
		if (category[i][0][0] == categoryName)
		{
			
			//alert(categoryName);
			var offset = 0;
		
			if (typeof(nCols) != 'undefined')
				offset = Math.ceil(category[i][1].length / nCols);
			if (nCols == 1)
				offset = 0;

			var useIdx = 0;
			var rowNum = 0;
			var colNum = 0;

			for (j=0; j<category[i][1].length; j++)
			{
				if (offset)
				{
					if(colNum == 0)
						document.write('<tr>');
					useIdx = (colNum * offset) + rowNum;
				}
				else
				{
					useIdx = j;
					document.write('<tr>');
				}

				wfname = category[i][1][useIdx];
				//alert(wfname);

				for (k=0; k<databases.length; k++)
					if (databases[k][0] == wfname)
						dbArray = databases[k];

				if ((dbArray[2] != 2 && dbArray[2] != g_wfaccess) || (dbArray[0] == 'wf_iefbr14' )
		  || ( omitDatabase == dbArray[0] ) )
				{
					continue;
				}
				
					sTemplate = g_CheckboxTemplate;
					sCheckbox = '';
					sDBname = '';
					sDescLink = '';			

					wfName = dbArray[0];
					dbName = dbArray[1];
					sDBDesc = dbArray[5];
					sNativeLink = '<a href="' + dbArray[6] + '">';

					sDescLink = '<a href="javascript:showHelp(\'/help.html?wffield=';
					sDescLink += wfName;
					sDescLink += '\');">' + descriptionText + '</a>';
								
					sCheckbox = '<input type="checkbox" name="' + g_CheckboxName + '" value="';
					sCheckbox += wfName + '">';
					sDBname = dbName;
								
			//tkamdar 04/02 to align link only xlators with other xlators
					if (sDBname.indexOf('<!-- link only -->') >= 0)
						sCheckbox = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';			
									
					sTemplate = sTemplate.replace(/<<checkbox>>/g, sCheckbox);
					sTemplate = sTemplate.replace(/<<database name>>/g, sDBname);
					sTemplate = sTemplate.replace(/<<description link>>/g, sDescLink);
					sTemplate = sTemplate.replace(/<<database description>>/g, sDBDesc);
					sTemplate = sTemplate.replace(/<<native link>>/g, sNativeLink);
									
					document.write(sTemplate);

					if (offset)
					{
						if (colNum == (nCols - 1))
						{
							colNum = 0;
							rowNum++;
							document.write('</tr>');
						}
						else
							colNum++;
					}							
					else
						document.write('</tr>');
			}			
			break;
		}
	}		     
}

//--------------------------------------------------------------------------------
// This function will create a select box with all available categories not in the
// sOmit paramter.
//
//
// Uses Parameters
//		selectName - This parameter will specify the name to be given to the HTML
//						select object
//		sOmit - This is a comma delimited value that specifies what categories to 
//					omit from the drop down list.
//---------------------------------------------------------------------------------

function showCategoryBox(selectName, categoryOmit)
{
	if (typeof(selectName) == 'undefined')
		selectName = 'Databases';

	if (typeof(categoryOmit) == 'undefined')
		categoryOmit = '';

	document.write('<select name="' + selectName + '">');

	for (i=0; i< category.length; i++)
	{
		if (categoryOmit.indexOf(category[i][0][0]) >= 0)
			continue;

		sOptionValue = '';
		sOptionText = '';

		sOptionText = category[i][0][0];

		for (j = 0; j < category[i][1].length; j++)
		{
			//if (category[i][j][3] != 2 &&
			//	category[i][j][3] != g_wfaccess)
			//{
			//	continue;
			//}

			sOptionValue += ',' + category[i][1][j];
		}

		sOptionValue = sOptionValue.substr(1);
						
		document.write('<option value="' + sOptionValue + '">');
		document.write(sOptionText + '</option>\n');
	}
	document.write('</select>');     
}

//--------------------------------------------------------------------------------
// This function will create a hidden input field that sets the WebFeat databases
// that are to be searched.
//
//
// Uses Parameters
//		categoryName - This is a comma delimited value to specify the categories that 
//						will be included in the hidden Databases field .
//		databaseAdd - This is a comma delimited value that specifies any additional  
//						databases to add to the Databases field.
//		databaseOmit - This is a comma delimited value that specifies any databases  
//						that are to be omited from the Databases field.
//---------------------------------------------------------------------------------

function addHiddenInput(categoryName, databaseAdd, databaseOmit)
{
	if (typeof(categoryName) == 'undefined')
		categoryName = 'category[0][0][0]';

	if (typeof(databaseAdd) == 'undefined')
		databaseAdd = '';

	if (typeof(databaseOmit) == 'undefined')
		databaseOmit = '';

	hiddenValue = '';
	
	for (i=0; i< category.length; i++)
	{
		if (categoryName.indexOf(category[i][0][0]) >= 0)
		{
			for (j=0; j<category[i][1].length; j++)
			{
				//if ((category[i][j][3] != 2) &&
				//	(category[i][j][3] != g_wfaccess))
				//{
				//	continue;
				//}
				
				if (databaseOmit.indexOf(category[i][1][j]) < 0)
				{
					hiddenValue += ',' + category[i][1][j];
				}
			}
		}
	}

	if (databaseAdd.length > 0)
		hiddenValue += ',' + databaseAdd;
	hiddenValue = hiddenValue.substr(1);

	document.write('<input type="hidden" name="Databases" ');
	document.write('value="' + hiddenValue + '">');
	//alert(hiddenValue);
}


//--------------------------------------------------------------------------------
// showSubjectList( subjectOmit )
//
//	This function will display a list of databases by subject.  It allows for checkboxes 
//		by subject, or by the individual databases
//
// Uses Parameters
//		subjectOmit - This is a comma delimited list of subjects to omit from the list. 
//
//---------------------------------------------------------------------------------
// Function Defaults
	MAIN_SUBJECT_T = '<tr><td width="100%"><<checkbox>><b><<category name>></b></td></tr>';
	SUBJECT_DATABASE_T = '<tr><td width="100%"><<database name>>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<<database description>></td></tr>';
//
//---------------------------------------------------------------------------------
function showSubjectList(subjectOmit, descriptionText, subjectOnly, bShowNumbers)
{
	// Use the default template if g_SubjectTemplate is not set
	if(typeof(g_SubjectTemplate) == 'undefined')
		g_SubjectTemplate = MAIN_SUBJECT_T;

	// Use the default template if g_SubjectDatabaseTemplate is not set
	if(typeof(g_SubjectDatabaseTemplate) == 'undefined')
		g_SubjectDatabaseTemplate = SUBJECT_DATABASE_T;

	// Use the default template if g_SubjectDatabaseTemplate is not set
	if(typeof(subjectOnly) == 'undefined')
		subjectOnly = true;

	if (typeof(subjectOmit) == 'undefined')
		subjectOnly = '';

	if (typeof(descriptionText) == 'undefined')
		descriptionText = '';
	
	//Show total number of databases in a category
	if (typeof(bShowNumbers) == 'undefined')
		bShowNumbers = true;

	//Click  databases belonging to a category (SFPL)
	if (typeof(categoryClick) == 'undefined')
		categoryClick = false;

	var subSelIdx = 0;

	// Loop through the category array to build the page
	for (i=0; i<category.length; i++)
	{
		var subSelBegin = subSelIdx;
		var subSelEnd = subSelIdx;
		if (subjectOmit.indexOf(category[i][0][0]) >= 0)
			continue;
		
		catName = category[i][0][0];

		// bschelp 04/01/2003
		// Why if user is a local user?
		//if ((g_wfaccess == 0) && (bShowNumbers))
		if (bShowNumbers)
		{	
			catName += ' ( ' + category[i][1].length + ' )'
			catName += '<a name="' + category[i][0][0] + '">';
			catLength= category[i][1].length;
		}	
			
		wfSubNames = '';

		// Build the complete subject wf_name list first
		for (j=0; j<category[i][1].length; j++)
		{
			// bschelp 04/01/2003
			// Check to see if the user has the correct access rights
			wfname = category[i][1][j];
					
			for (k=0; k<databases.length; k++)
				if (databases[k][0] == wfname)
					dbArray = databases[k];

			if (dbArray[2] != 2 && dbArray[2] != g_wfaccess)
			{
				continue;
			}

			//tkamdar 10/17/2003
			//check if dbname has <!-- link only, then reduce subSelEnd count by 1
			if (dbArray[1].indexOf('<!-- link only -->') >= 0)
				{ subSelEnd--;}

			wfSubNames += ',' + wfname;
			subSelEnd++;
		}

		// bschelp 04/01/2003
		// If there are no wf_names for this category, don't create the checkbox
		if (wfSubNames.length == 0)
			continue;

		wfSubNames = wfSubNames.substr(1);

		sTemplate = g_SubjectTemplate;
		sCheckbox = '';
		
		if (subjectOnly)
		{		
			sCheckbox = '<input type="checkbox" name="Databases" value="';
			sCheckbox += wfSubNames + '">';
		}
		else
		{
			sCheckbox = '<input type="checkbox" name="CategoryBoxes" value=""';
			sCheckbox += ' onClick="subSel(' + subSelBegin + ',' + subSelEnd;
			sCheckbox += ', this.checked)">';
		}

		// Set the Index for the next group
		subSelIdx = subSelEnd;
								
		sTemplate = sTemplate.replace(/<<checkbox>>/g, sCheckbox);
		sTemplate = sTemplate.replace(/<<category name>>/g, catName);							
		document.write(sTemplate);

		// Now build the individual database entries
		for (j=0; j<category[i][1].length; j++)
		{
			wfname = category[i][1][j];
					
			for (k=0; k<databases.length; k++)
				if (databases[k][0] == wfname)
					dbArray = databases[k];

			// bschelp 04/01/2003
			//if (databases[j][2]  != 2 && dbArray[2] != g_wfaccess)
			if (dbArray[2] != 2 && dbArray[2] != g_wfaccess)
			{
				continue;
			}
			
								
			sTemplate = g_SubjectDatabaseTemplate;
			sCheckbox = '';
			sDBname = '';
			sDescLink = '';			

			wfName = dbArray[0];
			dbName = dbArray[1];
			sDBDesc = dbArray[5];
			sNativeLink = '<a href="' + dbArray[6] + '">';

			sDescLink = '<a href="javascript:showHelp(\'/help.html?wffield=';
			sDescLink += wfName;
			sDescLink += '\');">' + descriptionText + '</a>';
						
			sDBname = dbName;

			//tkamdar 09/24 to align link only xlators and skip checkbox
			if (sDBname.indexOf('<!-- link only -->') >= 0)
				{ sCheckbox = '&nbsp;&nbsp;&nbsp;&nbsp;';	}
			else 
			{
			sCheckbox = '<input type="checkbox" name="Databases" value="';
			sCheckbox += wfName + '">';
			}			
								
			sTemplate = sTemplate.replace(/<<checkbox>>/g, sCheckbox);
			sTemplate = sTemplate.replace(/<<database name>>/g, sDBname);
			sTemplate = sTemplate.replace(/<<description link>>/g, sDescLink);
			sTemplate = sTemplate.replace(/<<database description>>/g, sDBDesc);
			sTemplate = sTemplate.replace(/<<native link>>/g, sNativeLink);
								
			document.write(sTemplate);
		}	
		
	}
}

//--------------------------------------------------------------------------------
// showSubjectTable( numCols, subjectOmit )
//
//	This function will display a list of databases by subject using a table layout with numCols
//		columns.  It allows for checkboxes by subject, or by the individual databases
//
// Uses Parameters
//		numCols - Specifies the number of columns in the table
//		subjectOmit - This is a comma delimited list of subjects to omit from the list. 
//
//---------------------------------------------------------------------------------
// Function Defaults
	MAIN_SUBJECT_T = '<tr><td width="100%"><<checkbox>><b><<category name>></b></td></tr>';
	SUBJECT_DATABASE_T = '<tr><td width="100%"><<database name>>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<<database description>></td></tr>';
//
//---------------------------------------------------------------------------------
function showSubjectTable(numCols, subjectOmit, descriptionText)
{
	// Use the default template if g_HeaderTemplate is not set
	if (typeof(g_TableTemplate) == 'undefined')
		g_TableTemplate = MAIN_TABLE_T;

	if (typeof(numCols) == 'undefined')
		numCols = 2;

	if (typeof(subjectOmit) == 'undefined')
		subjectOmit = '';

	if (typeof(descriptionText) == 'undefined')
		descriptionText = '';

	// Loop through the category array to build the page
	var sTemplate = '';
	var sText = '';
	for (i=0; i<category.length; i++)
	{
		if (subjectOmit.indexOf(category[i][0][0]) >= 0)
			continue;

		sText = '';

		catName = category[i][0][0];
		
		wfSubNames = '';

		// Build the complete subject wf_name list first
		for (j=0; j<category[i][1].length; j++)
			wfSubNames += category[i][1][j] + ',';

		wfSubNames = wfSubNames.substr(1);

		var sTemplate = g_CategoryTemplate;
		sCheckbox = '';
							
		sCheckbox = '<input type="checkbox" name="Databases" value="';
		sCheckbox += wfSubNames + '">';

		// Make all the necessary replacements
		sTemplate = sTemplate.replace(/<<checkbox>>/g, sCheckbox);
		sTemplate = sTemplate.replace(/<<category name>>/g, catName);

		sText += sTemplate;
		
		// Now build the individual database entries
		for (j=0; j<category[i][1].length; j++)
		{
			wfname = category[i][1][j];
					
			for (k=0; k<databases.length; k++)
				if (databases[k][0] == wfname)
					dbArray = databases[k];

			if (databases[j][2] != 3 &&
				dbArray[2] != g_wfaccess)
			{
				continue;
			}

			sTemplate = g_DatabaseTemplate;
			sCheckbox = '';
			sDBname = '';
			sDescLink = '';			

			wfName = dbArray[0];
			dbName = dbArray[1];
			sDBDesc = dbArray[5];
			sNativeLink = '<a href="' + dbArray[6] + '">';

			sDescLink = '<a href="javascript:showHelp(\'/help.html?wffield=';
			sDescLink += wfName;
			sDescLink += '\');">' + descriptionText + '</a>';
							
			sCheckbox = '<input type="checkbox" name="Databases" value="';
			sCheckbox += wfName + '">';
			sDBname = dbName;			
								
			sTemplate = sTemplate.replace(/<<checkbox>>/g, sCheckbox);
			sTemplate = sTemplate.replace(/<<database name>>/g, sDBname);
			sTemplate = sTemplate.replace(/<<description link>>/g, sDescLink);
			sTemplate = sTemplate.replace(/<<database description>>/g, sDBDesc);
			sTemplate = sTemplate.replace(/<<native link>>/g, sNativeLink);

			sText += sTemplate;
		}
		g_TableTemplate = g_TableTemplate.replace(/<<category template>>/, sText);
	}
	document.write(g_TableTemplate);
}

//--------------------------------------------------------------------------------
// This function will set a cookie containing all the search information from a 
// submitted WebFeat search form.
//
// The cookie will have the form:
//		wfsearch=f1:wf_keyword&t1:foo&o2:and&f2:wf_title&t2:bar; path=/;
//
// Uses Parameters
//		oForm - This is the form that the data will be extracted from. 
//
//---------------------------------------------------------------------------------

function setSearchCookie(oForm)
{
	sCookie = '';

	// Loop through the form and set  values
	// f<x>:wf_field<x>&t<x>:wf_term<x>&o<x>:wf_op<x>&f<x+1>:wf_field<x+1> ...
	if(typeof(oForm.wf_field1) != 'undefined')
	{
		sCookie += "f1:" + oForm.wf_field1.value + "&";
		sCookie += "t1:" + oForm.wf_term1.value;
	}

	if(typeof(oForm.wf_field2) != 'undefined')
	{
		sCookie += "&f2:" + oForm.wf_field2.value + "&";
		sCookie += "t2:" + oForm.wf_term2.value + "&";
		sCookie += "o2:" + oForm.wf_op2.value;
	}

	if(typeof(oForm.wf_field3) != 'undefined')
	{
		sCookie += "&f3:" + oForm.wf_field3.value + "&";
		sCookie += "t3:" + oForm.wf_term3.value + "&";
		sCookie += "o3:" + oForm.wf_op3.value;
	}

	document.cookie = "wfsearch=" + sCookie + "; path=/;";
	//alert(sCookie);
}

//--------------------------------------------------------------------------------
// This function will read the cookie, return the value of the associated Tag in 
// predefined format.
//
// When the cookie argument is empty, the default cookie is "wfsearch"
// eg 1) wfsearch = f<x>:wf_field<x>&t<x>:wf_term<x>&o<x>:wf_op<x>&f<x+1>:wf_field<x+1> ...
// eg 2) rslimits = ay:y&fy:2000&ty:2003&ln:english&ft:y
//--------------------------------------------------------------------------------

function getSearchCookie(sTag, cookie)
{
	if(typeof(cookie) == 'undefined')
		sCookie = getCookie('wfsearch');
	else
		sCookie = getCookie(cookie);

	if (sCookie)
	{
		nBegin = sCookie.indexOf(sTag);
		nEnd = sCookie.indexOf("&", nBegin);
		if (nEnd < 0)
			nEnd = sCookie.length;

		if (nBegin>=0 && nEnd>=0)
		{
			nBegin += 3;
			return sCookie.substr(nBegin, nEnd-nBegin);
		}
	}
	return null;
}

//--------------------------------------------------------------------------------
// This function will load the following search data history to the associated 
// element on the search form for Refine Search feature.
// This can be used in the search form at onload. 
//
// set wfrs = 0
// loads db list
// loads search terms
// loads all other search limits
// returns true if loading for refine search, and false otherwise
//---------------------------------------------------------------------------------

function loadRefineSearch(oForm)
{
	var dbidxArry;
	var csArry;

	// is it to load for refine search?
	if (getCookie('wfrs') != '1')
	{
		return false;
	}

	document.cookie = "wfrs=0; path=/;";


	// let's load all the dbs
	var wfrsdb = getCookie("wfrsdb");
	if ((wfrsdb != null) && (wfrsdb != ""))
	{
		dbidxArry = wfrsdb.split(",");
		// alert("dbidxArry: " + dbidxArry);

		for (var loop=0; loop < dbidxArry.length; loop++)
		{
			// document.writeln("DB index: " + dbidxArry[loop] + ".<br>");
			oForm.Databases[parseInt(dbidxArry[loop])].checked = true;
		}
	}


	// let's load all the terms, fields, and operators from wfsearch cookie
	// wfsearch = f<x>:wf_field<x>&t<x>:wf_term<x>&o<x>:wf_op<x>&f<x+1>:wf_field<x+1> ...
	if(typeof(oForm.wf_field1) != 'undefined')
	{
		// alert("getSearchCookie('f1:'): " + getSearchCookie('f1:'));
		// alert("getSearchCookie('t1:'): " + getSearchCookie('t1:'));
		oForm.wf_field1.value = getSearchCookie('f1:');
		oForm.wf_term1.value = getSearchCookie('t1:');
	}

	if(typeof(oForm.wf_field2) != 'undefined')
	{
		oForm.wf_field2.value = getSearchCookie('f2:');
		oForm.wf_term2.value = getSearchCookie('t2:');
		oForm.wf_op2.value = getSearchCookie('o2:');
	}

	if(typeof(oForm.wf_field3) != 'undefined')
	{
		oForm.wf_field3.value = getSearchCookie('f3:');
		oForm.wf_term3.value = getSearchCookie('t3:');
		oForm.wf_op3.value = getSearchCookie('o3:');
	}


	// let's load all the search limits from rslimits cookie
	// rslimits = ay:y&fy:2000&ty:2003&ln:english&ft:y&sd:y&cs:1,3,5

	// year
	if ( (typeof(oForm.wf_from_year) != 'undefined') &&
		(typeof(oForm.wf_to_year) != 'undefined') )
	{
		// alert("getSearchCookie('ay:'): " + getSearchCookie('ay:', 'rslimits'));
		// alert("getSearchCookie('fy:'): " + getSearchCookie('fy:', 'rslimits'));
		// alert("getSearchCookie('ty:'): " + getSearchCookie('ty:', 'rslimits'));
		var wf_all_years = getSearchCookie('ay:', 'rslimits');

		if (wf_all_years != "y")
		{
			var checkedYear;
			for (var i=0; i<oForm.wf_all_years.length; i++)
			{
				if (!oForm.wf_all_years[i].checked) 
					checkedYear = i;
			}

			// alert("checkedYear: " + checkedYear);

			oForm.wf_from_year.value = getSearchCookie('fy:', 'rslimits');
			oForm.wf_to_year.value = getSearchCookie('ty:', 'rslimits');
			oForm.wf_all_years[checkedYear].checked = true;
		}
	}

	// language
	if(typeof(oForm.wf_language) != 'undefined')
	{
		// alert("getSearchCookie('ln:'): " + getSearchCookie('ln:', 'rslimits'));
		oForm.wf_language.value = getSearchCookie('ln:', 'rslimits');
	}

	// ftonly
	if(typeof(oForm.wf_ftonly) != 'undefined')
	{
		// alert("getSearchCookie('ft:'): " + getSearchCookie('ft:', 'rslimits'));
		var wf_ftonly = getSearchCookie('ft:', 'rslimits');

		if (wf_ftonly == "y")
		{
			oForm.wf_ftonly.checked = true;
		}
	}

	// image only
	if(typeof(oForm.wf_imgonly) != 'undefined')
	{
		// alert("getSearchCookie('im:'): " + getSearchCookie('im:', 'rslimits'));
		var wf_imgonly = getSearchCookie('im:', 'rslimits');

		if (wf_imgonly == "y")
		{
			oForm.wf_imgonly.checked = true;
		}
	}

	// select/deselect all
	if(typeof(oForm.select) != 'undefined')
	{
		// alert("getSearchCookie('sd:'): " + getSearchCookie('sd:', 'rslimits'));
		var selectall = getSearchCookie('sd:', 'rslimits');

		if (selectall == "y")
		{
			oForm.select.checked = true;
		}
	}

	// catsel/subsel
	var wfrscs = getSearchCookie('cs:', 'rslimits');
	if ((wfrscs != null) && (wfrscs != ""))
	{
		csArry = wfrscs.split(",");
		// alert("csArry: " + csArry);

		for (var loop=0; loop < csArry.length; loop++)
		{
			// document.writeln("DB index: " + csArry[loop] + ".<br>");
			oForm.catsel[parseInt(csArry[loop])].checked = true;
		}
	}

	return true;
}

//--------------------------------------------------------------------------------
// This function will set and store the following search data to the associated 
// cookie for Refine Search feature.
// This can be used in the search form at submit. 
//
// set db list
// set this url
// set search terms
// other search limits:  year, language, ftonly, select all, catsel
//---------------------------------------------------------------------------------

function setRefineSearch(oForm)
{
	var dbidx = "";
	var limits = "";

	document.cookie = "wfrsdb=; path=/;";
	document.cookie = "wfrsurl=; path=/;";
	document.cookie = "rslimits=; path=/;";
	document.cookie = "wfsearch=; path=/;";

	for (var loop=0; loop < oForm.Databases.length; loop++)
	{
		if (oForm.Databases[loop].checked == true)
		{
			if (dbidx == "")
				dbidx = loop + "";
			else
				dbidx += "," + loop;
		}
	}


	// year, language, ftonly
	// rslimits = ay:y&fy:2000&ty:2003&ln:english&ft:y&sd:y&cs:1,3,5

	// year
	if ( (typeof(oForm.wf_from_year) != 'undefined') &&
		(typeof(oForm.wf_to_year) != 'undefined') )
	{

		var checkedYear;
		for (var i=0; i<oForm.wf_all_years.length; i++)
		{
			if(oForm.wf_all_years[i].checked) 
			{
				checkedYear = oForm.wf_all_years[i].value;
			}
		}

		// alert("checkedYear: " + checkedYear);

		if (checkedYear == 'yes')
		{
			limits += "ay:y&";
		}
		else
		{
			limits += "fy:" + oForm.wf_from_year.value + "&";
			limits += "ty:" + oForm.wf_to_year.value + "&";
		}
	}

	// language
	if(typeof(oForm.wf_language) != 'undefined')
	{
		limits += "ln:" + oForm.wf_language.value + "&";
	}

	// ftonly
	if(typeof(oForm.wf_ftonly) != 'undefined')
	{
		if (oForm.wf_ftonly.checked == true)
		{
			limits += "ft:y&";
		}
	}

	// image only
	if(typeof(oForm.wf_imgonly) != 'undefined')
	{
		if (oForm.wf_imgonly.checked == true)
		{
			limits += "im:y&";
		}
	}

	// select/deselect all
	// alert("typeof(oForm.select): " + typeof(oForm.select));
	if(typeof(oForm.select) != 'undefined')
	{
		if (oForm.select.checked == true)
		{
			limits += "sd:y&";
		}
	}

	// catsel/subsel
	var catsel = "";
	// alert("typeof(oForm.catsel)" + typeof(oForm.catsel));
	if(typeof(oForm.catsel) != 'undefined')
	{
		for (var loop=0; loop < oForm.catsel.length; loop++)
		{
			if (oForm.catsel[loop].checked == true)
			{
				if (catsel == "")
					catsel = loop + "";
				else
					catsel += "," + loop;
			}
		}
	}

	if (catsel != "")
	{
		limits += "cs:" + catsel + "&";
	}

	if (limits != "")
	{
		limits = limits.substring(0, limits.length - 1);
	}

	// alert("dbidx: " + dbidx);
	// alert("limits: " + limits);
	document.cookie = "wfrsdb=" + dbidx + "; path=/;";
	document.cookie = "wfrsurl=" + escape(document.location.href) + "; path=/;";
	document.cookie = "rslimits=" + limits + "; path=/;";

	// wfsearch = f<x>:wf_field<x>&t<x>:wf_term<x>&o<x>:wf_op<x>&f<x+1>:wf_field<x+1> ...
	setSearchCookie(oForm);
}

//--------------------------------------------------------------------------------
// This function will call the history search url from the cookie and set the wfrs 
// cookie to 1 so that the search page will know it is for Refine Search feature.
// This can be used in result template. 
//
// set wfrs = 1
// set location
//---------------------------------------------------------------------------------

function goRefineSearch()
{
	var url;
	var path;
	var sdata;

	document.cookie = "wfrs=1; path=/;";

	url = getCookie('wfrsurl');

	if (url)
	{
		// alert(url);
		document.location = url;
	}
}


function showDateRange(startYear)
{	
	var today = new Date();
	currentYear = today.getYear();
	if (currentYear < 1900)
		currentYear += 1900;	
	
	//wf_from_year 
	document.write('From: ');
	document.write('<select name="wf_from_year" size="1">');
	document.write('<option value="' + startYear + '" selected>' + startYear + '</option>');
	for (i=startYear +  1; i <= currentYear ; i++)
	{
		document.write('<option value="' + i + '">' + i + '</option>');
	}
	document.write('</select>&nbsp;&nbsp;&nbsp;&nbsp;To: ');

	//wf_to_year 
	document.write('<select name="wf_to_year" size="1">');
	document.write('<option value="' + currentYear + '" selected>' + currentYear + '</option>');
	for (i=currentYear - 1; i >= startYear ; i--)
	{
		document.write('<option value="' + i + '">' + i + '</option>');
	}
	document.write('</select>');
}