function addParameter(url, param) {
    if(url.indexOf("?") == -1) {
        url += "?" + param;
    } else {
        url += "&" + param;
    }
    return url;
}

function getTs() {
 // avoid browser caching by mutating the URL
 // 981954000000 is Date("February 13, 2001").getTime(), the date when the fix was introduced.
 dateObj = new Date();
 return dateObj.getTime()-981954000000;
}

function getTsParamNone() {
 // avoid browser caching by mutating the URL
 // 981954000000 is Date("February 13, 2001").getTime(), the date when the fix was introduced.
 dateObj = new Date();
 return "_ts="+(dateObj.getTime()-981954000000);
}

function getTsParamFirst() {
 // avoid browser caching by mutating the URL
 // 981954000000 is Date("February 13, 2001").getTime(), the date when the fix was introduced.
 dateObj = new Date();
 return "?" + "_ts="+(dateObj.getTime()-981954000000);
}

function getTsParamMid() {
 // avoid browser caching by mutating the URL
 // 981954000000 is Date("February 13, 2001").getTime(), the date when the fix was introduced.
 dateObj = new Date();
 return "&" + "_ts="+(dateObj.getTime()-981954000000);
}

function replaceTSParam(url) {
    var regexp = /_ts=(\d)*/
    var ts = getTsParamNone();
    url = url.replace(regexp, ts);

    return url;
}

function addExtraParams(url, addtimestampbool) {
    // addtimestampbool is a boolean - send in true or false (without any quotes)
    if(addtimestampbool) {
        if(url.indexOf("_ts") == -1) {
            if(url.indexOf("?") == -1) {
                return url + getTsParamFirst();
            } else {
                return url + getTsParamMid();
            }
        } else {
            return replaceTSParam(url);
        }
    }
    return url;
}

///////////////////////////////////////////////////////////////////////////////
// You should not assign to document.location. You should assign to 
// window.location. So, this exists for backwards compatibility, and you 
// should use the javascript method: 
// getAFFWindowLocation(winLocation, addtimestampbool)
///////////////////////////////////////////////////////////////////////////////
function getAFFDocumentLocation(docLocation, addtimestampbool) {
    return addExtraParams(docLocation, addtimestampbool);
}

///////////////////////////////////////////////////////////////////////////////
// Use this if you set the window.location in javascript
// e.g. document.location = getAFFWindowLocation(window.location, true)
///////////////////////////////////////////////////////////////////////////////
function getAFFWindowLocation(winLocation, addtimestampbool) {
    return addExtraParams(winLocation, addtimestampbool);
}

// Use this if you do formX.submit() in javascript
// e.g. form.action = getAFFFormAction(form.action, true)
function getAFFFormAction(formAction, addtimestampbool) {
    return addExtraParams(formAction, addtimestampbool);
}

// Use this as an attribute in your html FORM tag 
// e.g. onSubmit=onAFFFormSubmit(this, true) 
// onSubmit will only call this if you press a submit button (as opposed to 
// doing a formX.submit in javascript)
function onAFFFormSubmit(form, addtimestampbool) {
    form.action = getAFFFormAction(form.action, addtimestampbool);
    return true;
}

// Use this if you call a servlet in an html HREF tag.
function goServletHref(servlet, urlParams, addtimestampbool) {
    // ts is a boolean - send in true or false (without any quotes)
    var newLink = servlet + urlParams;
    newLink = addExtraParams(newLink, addtimestampbool);
    location.href = newLink;
}
