// string_util.js 
// utility functions for strings 

// new (more general functions for trimming)
// note: update old functions when time allows to call these 
// (slightly) more general functions; they have not been updated at
// this time since it is a risk [pd].
// these functions have been given different names to differentiate them
// from the previous ones (stringAllTrim, stringLeftTrim, stringRightTrim). 

// trim a string from both sides
function trimStringBothSides(strParm, chars)
{
  return trimStringLeft(trimStringRight(strParm, chars), chars);
}

// trim a string from right; i.e., return a string in which any characters
// at the end of the original string are skipped if they are
// in the set of 'chars'.
function trimStringRight(strParm, chars)
{
 if ((strParm == null ) || (strParm == "" ))
   return strParm;
 var retStr = "";
 for ( var i = strParm.length; i > 0; i--)
 {
   if ( chars.indexOf(strParm.charAt(i-1)) < 0 )
     break;
 }
 retStr = strParm.substr( 0 , i );
 return retStr;
}

// trim a string from left; i.e., return a string in which any characters
// at the beginning of the original string are skipped if they are
// in the set of 'chars'.
function trimStringLeft(strParm, chars)
{
 if ((strParm == null ) || (strParm == "" ))
   return strParm;
 var retStr = "";
 for ( var i = 0; i < strParm.length; i++)
 {
   if ( chars.indexOf(strParm.charAt(i)) < 0 )
     break;
 }
 retStr = strParm.substr( i, strParm.length );
 return retStr;
}

// old trim function; see above note for updates.
function stringAllTrim(strParm)
{
  return stringLeftTrim(stringRightTrim(strParm));
}
function stringRightTrim(strParm)
{
 if ((strParm == null ) || (strParm == "" ))
   return strParm;
 var retStr = "";
 for ( var i = strParm.length; i > 0; i--)
 {
   if ( strParm.charAt(i-1) != ' ' )
     break;
 }
 retStr = strParm.substr( 0 , i );
 return retStr;
}
function stringLeftTrim(strParm)
{
 if ((strParm == null ) || (strParm == "" ))
   return strParm;
 var retStr = "";
 for ( var i = 0; i < strParm.length; i++)
 {
   if ( strParm.charAt(i) != ' ' )
     break;
 }
 for ( var j = i; j < strParm.length; j++)
 {
   retStr += strParm.charAt(j);
 }
 return retStr;
}
function stringIsNumber(strParm)
{
 var tokens = "-.0123456789"
 // trim it up in case it contains blanks
 var strParmTrimmed = stringAllTrim(strParm);
 if ((strParmTrimmed == null ) || (strParmTrimmed == "" ))
   return false;
 for ( var i = 0; i < strParmTrimmed.length; i++)
 {
   if ( tokens.indexOf(strParmTrimmed.charAt(i)) == -1 )
     return false;
 }
 return true;
}
function stringEmpty(strParm)
{
 if ((strParm == null ) || (strParm == "" ))
    return true;
  for (var i=0; i < strParm.length ; i++)
  {
    if ( strParm.charAt(i) != ' ' )
      return false;
  }
  return true;
}
function stringReplace(originalString,findText,replaceText)
{
   var pos = 0;
   var len = findText.length;
   pos = originalString.indexOf(findText);
   while (pos != -1)
   {
      preString = originalString.substring(0,pos);
      postString = originalString.substring(pos+len,originalString.length)
      originalString = preString + replaceText + postString;
      pos = originalString.indexOf(findText);
   }
   return originalString;
}
// split() is not supported under IE 3 
function stringSplit(s,delimChar)
{
  var retArray = new Array();
  var buf = "";
  for ( var i = 0; i < s.length; i++ )
  {
    var letter = s.substring ( i, i+1 );
    if ( letter == delimChar )
    {
      retArray[retArray.length] = buf;
      buf = "" ;
    }
    else
      buf = buf + letter ;
  }
  retArray[retArray.length] = buf;
  return retArray;
}
function urlEncode(origString) {
  var newString = new String("");
  var oldString = new String(origString);
  if (!stringEmpty(oldString)) {
    for(var i=0; i < oldString.length; i++) {
      var tmpChar = oldString.charAt(i);
      if (tmpChar==' ') {
        newString += "+";
      } else {
        newString += escape(tmpChar);
      }
    }
  }
  return newString;
}
function urlDecode(origString) {
  var newString = new String("");
  var oldString = new String(origString);
  if (!stringEmpty(oldString)) {
    for(var i=0; i < oldString.length; i++) {
      var tmpChar = oldString.charAt(i);
      if (tmpChar=='+') {
        newString += " ";
      } else {
        newString += tmpChar;
      }
    }
    newString = unescape(newString);
  }
  return newString;
}
