// file: /javascript/common/breadcrumb.js
// dependencies: /javascript/timestamp.js - getTs()

var FILLED_BELOW = "_FILLED_BELOW_";

function gotoBreadcrumb(url) {
	document.breadcrumbHref.action = url;
	document.breadcrumbHref._ts.value = getTs();
	document.breadcrumbHref.submit();
}

function gotoBreadcrumbMain() {
	if (document.breadcrumbHref._lang.value == "es") {
		document.breadcrumbHref.action = '/servlet/BasicFactsServlet';
	}
	else {
		document.breadcrumbHref.action = '/home/saff/main.html';
	}
	document.breadcrumbHref._ts.value = "";
	document.breadcrumbHref.submit();
}

function gotoBreadcrumbDataSets(datasetId, programId) {
	document.breadcrumbDataSetsHref.action = 'DatasetMainPageServlet';
	if (datasetId != FILLED_BELOW) {
		document.breadcrumbDataSetsHref._ds_name.value = datasetId;
	}
	if (programId != FILLED_BELOW) {
		document.breadcrumbDataSetsHref._program.value = programId;
	}
	document.breadcrumbDataSetsHref._ts.value = getTs();
	document.breadcrumbDataSetsHref.submit();
}