//
//  javascript functions for Advanced Search by Keyword/Placename, etc
//  for jumping to a product, dataset, table, etc.
//


// construct the URL for the jump call for one product
//function jumpToProduct(jumpServlet, backServlet, backParams, prod_name, prod_id, langparamnone) {
// signature changed on 07/22/02 for defect number 9268
function jumpToProduct(jumpServlet, backServlet, prod_name, prod_id, langparamnone) {
    // the back link uses only the servlet name since the other args are saved in the session.
    location.href = jumpServlet+"?id="+prod_id+"&product="+escape(prod_name.replace(/###/g,/'/))+"&"+langparamnone;
}

// construct the URL for the jump call for one dataset
function jumpToDataset(jumpServlet, idValue, langparamnone) {
    location.href = jumpServlet+"?_ds_name"+"="+idValue + "&" + langparamnone;
}

// construct the URL for the jump call for one economic dataset
function jumpToEconDataset(jumpServlet, idValue, langparamnone) {
    location.href = jumpServlet+"?ds_name"+"="+idValue + "&geo_id=D&" + langparamnone;
}

// construct the URL for the jump call for one table
function jumpToTable(jumpServlet, ds_id, geo_id, idName, idValue, msg, langparamnone) {
    location.href = jumpServlet+"?ds_name="+ds_id+"&geo_id="+geo_id+"&"+idName+"="+idValue+msg+ "&" + langparamnone;
}

// construct the URL for the jump call for MYPs
function jumpToMYP(jumpServlet, ds_id, geo_id, idName, idValue, idName2, idValue2, langparamnone) {
    location.href = jumpServlet+"?ds_name="+ds_id+"&geo_id="+geo_id+"&"+idName+"="+idValue+ "&"+idName2+"="+idValue2+ "&" + langparamnone;
}

// construct the URL for the jump call for one thematic map
function jumpToThemMap(dataset, tree_id, geo_id, idValue, langparamnone) {
	var eqPos=langparamnone.indexOf('=');
	displayLoadingWindowAdvSearch("/home/"+langparamnone.substring(eqPos+1)+"/loading.html");
    parent.location.href = "ThematicMapFramesetServlet?ds_name="+dataset+"&geo_id="+geo_id+"&tree_id="+tree_id+"&tm_name="+idValue + "&" + langparamnone;
}

// construct the URL for the jump call for one reference map
function jumpToRefMap(idValue, treeId, bucketLabel,langparamnone) {
	var eqPos=langparamnone.indexOf('=');
	displayLoadingWindowAdvSearch("/home/"+langparamnone.substring(eqPos+1)+"/loading.html");
    parent.location.href = "ReferenceMapFramesetServlet?geo_id="+idValue + "&tree_id="+treeId+"&_yp="+escape(bucketLabel)+"&"+langparamnone;
}

// Quick fix for defect 12982, will be fixed in the next release (AFF9.3 or AFF9.2.1)
// construct the URL for the jump call for one geo quick report
function jumpToGeoQuickReport(idValue, langparamnone,tableName,dsName) {
    location.href = "GQRTable?geo_id="+idValue + "&" + "ds_name=" +dsName + "&" + langparamnone + "&qr_name=" + tableName;
}

// construct the URL for the jump call for one geo quick report
function jumpToIndustryQuickReport(idValue, langparamnone, dsName, ibType) {
    location.href = "IQRTable?"+ibType+"="+idValue + "&" + "ds_name="+dsName + "&" + langparamnone;
}

// construct the URL for the jump call for one geo quick report
function jumpToProductQuickReport(ib_type,langparamnone,ib_code,ds_name,sector_code,vt_name) {
	if (sector_code==null) {
        location.href = "PIQRTable?"+ib_type+"="+ib_code+"&ds_name="+ds_name+"&"+langparamnone+"&qr_name="+vt_name;
    } else {
        location.href = "PQRTable?"+ib_type+"="+ib_code+"&ds_name="+ds_name+"&"+langparamnone+"&qr_name="+vt_name+"&ib_code="+sector_code;
    }
}

// construct the URL for the jump call for one result
function jumpHREF(jumpServlet, idName, idValue, langparamnone) {
    location.href = jumpServlet+"?"+"ds_name=D&geo_id=D"+"&"+idName+"="+idValue + "&" + langparamnone;
}
