//
//  javascript functions for Advanced Search by Placename
//

// check a keyword for wildcard;
// original email depicting the functionality!!
// So, for search by placename and for advanced search where the 'search for' is set to 'All', search terms must have at least 2 alpha characters (examples: ra  or ra* )
// Error message would be:  "Search terms must contain at least 2 alphabetic characters."
//
// For advanced geo search by placename where 'search for' is set to something other than 'All', search terms must have at least 2 alphanumeric characters (examples: ra  or ra* or 12 or 12*  )
// Error message would be:  "Search terms must contain at least 2 alphanumeric characters."

var separator = "|";

function checkKeyword(keyword, geoAreaType) {
	var trimmedKeyword = trimStringBothSides(keyword, "* ");
	if (trimmedKeyword.length >= 2) {
		return 0;
	}

	var pos = keyword.indexOf("*");
	if (pos > 2 || pos < 0) {
		// wildcard does not appear or is at least the third char; OK
		return 0;
	}

	if (geoAreaType == "ALL" || geoAreaType == "") {
		// check for the case when no geoAreaType selected
		if (pos == 0 || pos == 1) {
			return 1;
		} else {
			var c1 = keyword.charAt(0).toUpperCase();
			var c2 = keyword.charAt(1).toUpperCase();
			if (!(c1 >= "A" && c1 <= "Z" && c2 >= "A" && c2 <= "Z")) {
				return 1;
			}			
		}
	} else {
		if (pos == 0 || pos == 1) {
			return 2;
		} else {
			var c1 = keyword.charAt(0).toUpperCase();
			var c2 = keyword.charAt(1).toUpperCase();
			if (!((c1 >= "A" && c1 <= "Z") || (c1 >= "0" && c1 <= "9")) && ((c2 >= "A" && c2 <= "Z") || (c2 >= "0" && c2 <= "9"))) {
				return 2;
			}			
		}
	}

	return 0;
}

function submitKeyword(langparamnone, errMsgSelectGeo2, errMsgPlacenameNull, errMsgPlacenameAny, errMsgPlacenameMin2AlphaChars, errMsgPlacenameMin2AlphanumChars) {
	// set the keyword
	keyword=document.form1.keyword.value;

	// invalid placename -- do nothing
	if (geoBucketId == "?undefined?") {
		return;
	}

	if (programYear == "" && document.form1.chosenProgramYear.value != "") {
		programYear=document.form1.chosenProgramYear.value;
	}
	if (geoAreaType == "" && document.form1.chosenGeoAreaType.value != "") {
		geoAreaType=document.form1.chosenGeoAreaType.value;
	}
	if (treeId == "" && document.form1.chosenTreeId.value != "") {
		treeId=document.form1.chosenTreeId.value;
	}
	if (geoIds == "" && document.form1.chosenGeoIdsHierarchy.value != "") {
		geoIds=document.form1.chosenGeoIdsHierarchy.value;
	}
	if (currGeoAreaType == "" && document.form1.chosenCurrentGeoAreaType.value != "") {
		currGeoAreaType=document.form1.chosenCurrentGeoAreaType.value;
	}
	if (placename == "" && document.form1.chosenPlacename.value != "") {
		placename=document.form1.chosenPlacename.value;
	}
	if (geos == "" && document.form1.chosenGeos.value != "") {
		geos=document.form1.chosenGeos.value;
	}

	if ((geos == "" || geos == "select") && geoIds != "") {
		alert(errMsgSelectGeo2);
		document.form1.keyword.focus();
		return;
	}
	if (keyword == "") {
		alert(errMsgPlacenameNull);
		document.form1.keyword.focus();
	} else if (keyword == "*") {
		alert(errMsgPlacenameAny);
		document.form1.keyword.focus();
	} else {
		var ok = checkKeyword(keyword, geoAreaType);

		if (ok == 1) {
			alert(errMsgPlacenameMin2AlphaChars);
			document.form1.keyword.focus();
		} else if (ok == 2) {
			alert(errMsgPlacenameMin2AlphanumChars);
			document.form1.keyword.focus();
		} else {
			location.href = "AdvGeoSearchByPlacenameServlet?_command=getPlaces&_keyword="+escape(keyword)+"&_programYear="+programYear+"&_geoAreaType="+geoAreaType+"&_treeId="+treeId+"&_currentGeoAreaType="+currGeoAreaType+"&_geoIdsHierarchy="+geoIds+"&_geos="+geos+"&_placename="+placename.replace(/ /g,"+")+"&_geoBucketId="+geoBucketId+"&"+langparamnone;
		}
	}
}

// make a pair
var divide_char="|";
function makePair(first, second) {
	return first+divide_char+second;
}

// get the first part of a pair
function firstOfPair(pair) {
	var index = pair.indexOf(divide_char);
	return pair.substr(0, index);
}

// get the second part of a pair
function secondOfPair(pair) {
	var index = pair.indexOf(divide_char);
	return pair.substr(index + 1);
}

// set the year and program from the drop down
var programYear="";
function selectYearProgram(t, langparamnone) {
	programYear = firstOfPair(t.options[t.selectedIndex].value);
	treeId = secondOfPair(t.options[t.selectedIndex].value);

	// re-paint page (get new geo area types) for new program year.
	location.href = "AdvGeoSearchByPlacenameServlet?_command=getPlacenames&_programYear="+programYear+"&_geoAreaType=ALL&_treeId="+treeId+"&_geoIdsHierarchy=&_currentGeoAreaType="+"&"+langparamnone;
}

// select the geo area type
var geoAreaType="";
var treeId = "";
function selectGeoAreaType(t, langparamnone) {
	geoAreaType = firstOfPair(t.options[t.selectedIndex].value);

	var tmpTreeId = secondOfPair(t.options[t.selectedIndex].value);
	if (tmpTreeId != "select") {
		treeId = tmpTreeId;
	}
	if ((treeId == "" || treeId == "select") && document.form1.chosenTreeId.value != "") {
		treeId=document.form1.chosenTreeId.value;
	}

	if (programYear == "" && document.form1.chosenProgramYear.value != "") {
		programYear=document.form1.chosenProgramYear.value;
	}

	// re-paint page (get new geo Ids) for new geo area type
	location.href = "AdvGeoSearchByPlacenameServlet?_command=getPlacenames&_programYear="+programYear+"&_geoAreaType="+geoAreaType+"&_treeId="+treeId+"&_geoIdsHierarchy=&_currentGeoAreaType="+"&"+langparamnone;
}

// select the geo id
var currGeoAreaType = "";
var geoIds = "";
var geos = "";


function setupGetPlaces(t, action, langparamnone)
{
	if (programYear == "" && document.form1.chosenProgramYear.value != null && document.form1.chosenProgramYear.value != "") {
		programYear=document.form1.chosenProgramYear.value;
	}
	if (geoAreaType == "" && document.form1.chosenGeoAreaType.value != null && document.form1.chosenGeoAreaType.value != "") {
		geoAreaType=document.form1.chosenGeoAreaType.value;
	}
	if (treeId == "" && document.form1.chosenTreeId.value != null && document.form1.chosenTreeId.value != "") {
		treeId=document.form1.chosenTreeId.value;
	}
//	if (geos == "" && document.form1.chosenGeos.value != null && document.form1.chosenGeos.value != "") {
//		geos=document.form1.chosenGeos.value;
//	}

	if (action == "getPlacenames") {
		location.href = "AdvGeoSearchByPlacenameServlet?_command=getPlacenames&_programYear="+programYear+"&_geoAreaType="+geoAreaType+"&_treeId="+treeId+"&_currentGeoAreaType="+currGeoAreaType+"&_geoIdsHierarchy="+geoIds+"&_geos="+geos+"&"+langparamnone;
	} else {
		if (action == "getResults") {
			var str = t.options[t.selectedIndex].value;
   			arrayOfStrings = str.split(separator,3)

			showMap = arrayOfStrings[2];
			geoBucketId = arrayOfStrings[1];
			placename = arrayOfStrings[0];
		}
	}
	// otherwise, nothing to do
}

function selectGeoId(t, action, geoIdsHierarchy, currentGeoAreaType, langparamnone) {
	var treenodeId = secondOfPair(t.options[t.selectedIndex].value);
//	var tmp = secondOfPair(t.options[t.selectedIndex].value);
//	var treenodeId = firstOfPair(tmp);
//	if (action == "getPlacenames" || action == "getPlaces") {
//		geos = secondOfPair(tmp);
//	}

	// check the selection
	if (treenodeId == "select") {
		alert(errMsgSelectGeo2);
		document.form1.keyword.focus();
	}

	currGeoAreaType = currentGeoAreaType;
	if (action == "getPlacenames") {
		if (geoIdsHierarchy == "") {
			geoIds = treenodeId;
		} else {
			geoIds = geoIdsHierarchy + "|" + treenodeId;
		}
	}

	setupGetPlaces(t, action, langparamnone);
}

function selectGeoId2(t, action, geoIdsHierarchy, currentGeoAreaType, langparamnone) {
//	var treenodeId = secondOfPair(t.options[t.selectedIndex].value);
//	var tmp = secondOfPair(t.options[t.selectedIndex].value);
//	var treenodeId = firstOfPair(tmp);
//	if (action == "getPlacenames" || action == "getPlaces") {
//		geos = secondOfPair(tmp);
//	}
       
	var str = t.options[t.selectedIndex].value;
        if (str == "?undefined?") {
                geoBucketId = "?undefined?"
		document.form1.keyword.focus();
                return;
        }
   	arrayOfStrings = str.split(separator,3)

	var showMap = arrayOfStrings[2];
	var treenodeId = arrayOfStrings[1]

	// check the selection
	if (treenodeId == "select") {
//		alert(errMsgSelectGeo);
		document.form1.keyword.focus();
	}

	currGeoAreaType = currentGeoAreaType;
	if (action == "getPlacenames") {
		if (geoIdsHierarchy == "") {
			geoIds = treenodeId;
		} else {
			geoIds = geoIdsHierarchy + "|" + treenodeId;
		}
	}

	setupGetPlaces(t, action, langparamnone);
}

function selectGeos(t, action, geoIdsHierarchy, currentGeoAreaType, langparamnone) {
//	geos = secondOfPair(t.options[t.selectedIndex].value);

	var tmp = secondOfPair(t.options[t.selectedIndex].value);
	var treenodeId = firstOfPair(tmp);
	geos = secondOfPair(tmp);
 
	if (treenodeId != "" && treenodeId != "select") {
		if (geoIdsHierarchy == "") {
			geoIds = treenodeId;
		} else {
			geoIds = geoIdsHierarchy + "|" + treenodeId;
		}
	} else {
		geoIds = "select";
		geoIdsHierarchy = "select";
		geos ="select";
	}
}

// set the typed-in geo entity
var keyword="";
function setKeyword(t) {
	keyword = document.form1.keyword.value;
}

// select the geo entity for searching reference maps, tables, etc.
var placename="";
var geoBucketId="";
var showMap="Y"
function selectPlacename() {
	// get the selected places; assume only one!!
	for (var i = 0; i < document.form1.places.length; i++) {
		if (document.form1.places.options[i].selected) {
		//	placename = firstOfPair(document.form1.places.options[i].value);
		//	geoBucketId = secondOfPair(document.form1.places.options[i].value);
			var str = t.options[t.selectedIndex].value;
   			arrayOfStrings = str.split(separator,3)

			showMap = arrayOfStrings[2];
			geoBucketId = arrayOfStrings[1];
			placename = arrayOfStrings[0];
			break;
		}
	}
}

// construct the URL for the call.
var servlet="AdvGeoSearchByPlacenameServlet";
function makeHREF(action, langparamnone, errMsgSelectGeo, errMsgPlacenameNull, errMsgPlacenameAny, errMsgPlacenameMin2AlphaChars, errMsgPlacenameMin2AlphanumChars) {

    
	// if no new selection, use the old selection
	if (keyword == "" && document.form1.chosenKeyword.value != "") {
		keyword=document.form1.chosenKeyword.value;
	}
	if (programYear == "" && document.form1.chosenProgramYear.value != "") {
		programYear=document.form1.chosenProgramYear.value;
	}
	if (geoAreaType == "" && document.form1.chosenGeoAreaType.value != "") {
		geoAreaType=document.form1.chosenGeoAreaType.value;
	}
	if (treeId == "" && document.form1.chosenTreeId.value != "") {
		treeId=document.form1.chosenTreeId.value;
	}
	if (geoIds == "" && document.form1.chosenGeoIdsHierarchy.value != "") {
		geoIds=document.form1.chosenGeoIdsHierarchy.value;
	}
	if (currGeoAreaType == "" && document.form1.chosenCurrentGeoAreaType.value != "") {
		currGeoAreaType=document.form1.chosenCurrentGeoAreaType.value;
	}
	if (placename == "" && document.form1.chosenPlacename.value != "") {
		placename=document.form1.chosenPlacename.value;
	}
	if (geos == "" && document.form1.chosenGeos.value != "") {
		geos=document.form1.chosenGeos.value;
	}

	if (geoBucketId == "" && document.form1.chosenGeoBucketId.value != "")
	{
		geoBucketId=document.form1.chosenGeoBucketId.value;
        }

	if (geos == "select" ) {
		geos=" ";
	}

	if (geoIds == "select" ) {
		geoIds ="";
	}
	
       // invalid placename -- do nothing
//	if ( typeof geoBucketId != "undefined") {
//            if (geoBucketId.indexOf("undefined") != -1  ) {
//                if (action == "getResults")  {
//                    alert(errMsgSelectGeo);
//                    document.form1.keyword.focus();
//                    return;
//                }
//            }
//        } else {
//                    alert(errMsgSelectGeo);
//                    document.form1.keyword.focus();
//                    return;
//        }

//	if ((geos == "" || geos == "select") && geoIds != "") {
//		alert(errMsgSelectGeo);
//		document.form1.keyword.focus();
//		return;
//	}

	if (keyword == "") {
		alert(errMsgPlacenameNull);
		document.form1.keyword.focus();
	} else if (keyword == "*") {
		alert(errMsgPlacenameAny);
		document.form1.keyword.focus();
	} else {
		var ok = checkKeyword(keyword, geoAreaType);
		if (ok == 1) {
			alert(errMsgPlacenameMin2AlphaChars);
			document.form1.keyword.focus();
		} else if (ok == 2) {
			alert(errMsgPlacenameMin2AlphanumChars);
			document.form1.keyword.focus();
		} else if (action == "getResults" && placename == "") {
			alert(errMsgSelectGeo);
			document.form1.keyword.focus();
		} else {

			// put the rotating image only when getting the results
			if (action == "getResults") {
				var eqPos=langparamnone.indexOf('=');
				displayLoadingWindowAdvSearch("/home/"+langparamnone.substring(eqPos+1)+"/loading.html");
			}

			location.href = "AdvGeoSearchByPlacenameServlet?_command="+action+"&_keyword="+escape(keyword)+"&_programYear="+programYear+"&_geoAreaType="+geoAreaType+"&_treeId="+treeId+"&_currentGeoAreaType="+currGeoAreaType+"&_geoIdsHierarchy="+geoIds+"&_geos="+geos+"&_placename="+placename.replace(/ /g,"+")+"&_geoBucketId="+geoBucketId+"&"+langparamnone;
		}
	}
}

// construct the URL for the call for more results.
var category="";
function makeHREFMore(action, category, langparamnone) {
	// invalid placename -- do nothing
	if (geoBucketId == "?undefined?") {
		return;
	}

	// ignore any new settings and use the original chosen settings
	keyword=document.form1.chosenKeyword.value;
	programYear=document.form1.chosenProgramYear.value;
	geoAreaType=document.form1.chosenGeoAreaType.value;
	treeId=document.form1.chosenTreeId.value;
	geoIds=document.form1.chosenGeoIdsHierarchy.value;
	currGeoAreaType=document.form1.chosenCurrentGeoAreaType.value;
	placename=document.form1.chosenPlacename.value;
	geoBucketId=document.form1.chosenGeoBucketId.value;
	geos=document.form1.chosenGeos.value;
	// no need for the rest

	// put the rotating image
	var eqPos=langparamnone.indexOf('=');
	displayLoadingWindowAdvSearch("/home/"+langparamnone.substring(eqPos+1)+"/loading.html");

	location.href = "AdvGeoSearchByPlacenameServlet?_command="+action+"&_programYear="+programYear+"&_keyword="+escape(keyword)+"&_placename="+placename.replace(/ /g,"+")+"&_geoAreaType="+geoAreaType+"&_treeId="+treeId+"&_currentGeoAreaType="+currGeoAreaType+"&_geoIdsHierarchy="+geoIds+"&_geoBucketId="+geoBucketId+"&_geos="+geos+"&_category="+escape(category)+"&"+langparamnone;
}

// construct the URL for the call for more results for detail/quick tables given a subcategory
var subcategory="";
function makeHREFMoreTables(action, category, subcategory, langparamnone) {
	// invalid placename -- do nothing
	if (geoBucketId == "?undefined?") {
		return;
	}

	// ignore any new settings and use the original chosen settings
	keyword=document.form1.chosenKeyword.value;
	programYear=document.form1.chosenProgramYear.value;
	geoAreaType=document.form1.chosenGeoAreaType.value;
	treeId=document.form1.chosenTreeId.value;
	geoIds=document.form1.chosenGeoIdsHierarchy.value;
	currGeoAreaType=document.form1.chosenCurrentGeoAreaType.value;
	placename=document.form1.chosenPlacename.value;
	geoBucketId=document.form1.chosenGeoBucketId.value;
	geos=document.form1.chosenGeos.value;

	// put the rotating image
	var eqPos=langparamnone.indexOf('=');
	displayLoadingWindowAdvSearch("/home/"+langparamnone.substring(eqPos+1)+"/loading.html");

	location.href = "AdvGeoSearchByPlacenameServlet?_command="+action+"&_programYear="+programYear+"&_keyword="+escape(keyword)+"&_placename="+placename.replace(/ /g,"+")+"&_geoAreaType="+geoAreaType+"&_treeId="+treeId+"&_currentGeoAreaType="+currGeoAreaType+"&_geoIdsHierarchy="+geoIds+"&_geoBucketId="+geoBucketId+"&_geos="+geos+"&_category="+escape(category)+"&_subcategory="+escape(subcategory)+"&"+langparamnone;
}
