/**
$Id: pint_commonDEBUG.js,v 1.19 2004/01/14 18:14:37 cducker Exp $

Description:
	PINT Commonly used JavaScript functions and constants.

Dependencies:
	Inward:
		pint_initcleanup.js
	
	Outward:
		none	
	
Usage:
	n/a		
*/

/* ******** Constants *********************************** */
windowStatus = "";
/* ******** Common Window Settings ********************** */
defaultStatus = "";

/**
 * PINT_GetEventSource()
 * Takes as an argument the first argument to an event handler, and 
 * returns a reference to the object that generated the event
 *
 * @param e - first argument to an event handler
 *
 * @return reference to object that triggered event
 */
function PINT_GetEventSource(e)
{
	return ( //figure out where in the dom events come in on this browser
		(e && e.target) || 
		(window && window.event && window.event.srcElement)
	);	
}

/**
 * PINT_GetElementById()
 * Tries to find an element in the document 
 * by its id or name
 *
 * @param idname - id of element to locate
 */
function PINT_GetElementById(idname)
{
	var handle;

	if (document.getElementById) {
		handle = document.getElementById(idname);
		if (handle) return handle;
	}

	if (document.getElementByName) {
		handle = document.getElementByName(idname)[0];
		if (handle) return handle;
	}

	handle = document[idname];
	if (handle) return handle;

	if (document.all) {
		handle = document.all[idname];
		if (handle) return handle;
	}
	
	if (document.anchors) {
		handle = document.anchors[idname];
		if (handle) return handle;
	}
	
	if (document.links) {
		handle = document.links[idname];
		if (handle) return handle;
	}
	
	if (document.images) {
		handle = document.images[idname];
		if (handle) return handle;
	}
	
	if (document.embeds) {
		handle = document.embeds[idname];
		if (handle) return handle;
	}

	return handle;
}

/**
 * PINT_GetIdByElement()
 * Inverse of PINT_GetElementById, returns the id, 
 * or name, of a given element
 *
 * @param element - object whose id to retrieve
 */
function PINT_GetIdByElement(element)
	{
	if (!(element)) return undefined;
	if (element.id) return element.id;
	if (element.name) return element.name;
	return undefined;
	}

/**
 * PINT_ChangePageTitle()
 * Change title of current page. Use when initial title
 * tag value is optimized for Search Engines, but you 
 * want the title to be more descriptive for the visitor.
 *
 * @param   pageTitle  - new page title
 */	
function PINT_ChangePageTitle( pageTitle )
	{
	if(document.title.readOnly == true) document.title = pageTitle;
	} 	
	
/**
 * PINT_GetCurrentFileName()
 * Get name of current file from path name
 */
function PINT_GetCurrentFileName()
	{
	var URL = unescape( window.location.pathname );
	var start = URL.lastIndexOf( "/" ) + 1;
	var end = ( URL.indexOf( "?" ) > 0 ) ? URL.indexOf( "?" ) : URL.length;
	return( URL.substring( start, end ) );
	}	
/**
 * PINT_GetCurrentFilePath()
 * Get path to current file from path name
 */
function PINT_GetCurrentFilePath()
	{
	var URL = unescape( window.location.pathname );
	var start = URL.lastIndexOf( "/" );
	return( URL.substring( 0, start ) );
	}

/**
 * PINT_GetCurrentDirectory()
 * Get name of current directory from path name
 */			
function PINT_GetCurrentDirectory()
	{
	var filePath = PINT_GetCurrentFilePath();
	var directories = filePath.split("/");
	return directories.length && directories[ directories.length-1 ] != "" ? directories[ directories.length-1 ] : "";
	}
	
/**
 * PINT_IsRootDirectory()
 * Determine if specified directory matches root directory
 *
 * @param directory - directory to check
 */
function PINT_IsRootDirectory( directory )
	{
	return directory.toLowerCase() == PINT_GetRootDirectory().toLowerCase() ? true : false;
	}

/**
 * PINT_IsDefaultFile()
 * Determine if file name is an index file
 *
 * @param fileName - file name to check
 */
function PINT_IsDefaultFile()
	{
	var fileName = typeof(PINT_IsDefaultFile.arguments[0]) != 'undefined' ? PINT_IsDefaultFile.arguments[0] : PINT_GetCurrentFileName();
	return fileName == "" || fileName == PINT_GetDefaultFile() ? true : false;
	}	

/**
 * PINT_GetDefaultFile()
 * Gets DefaultFile global variable if defined.
 * 
 * @return		default file name.
 *
 */	
function PINT_GetDefaultFile()
	{
	if( typeof( defaultFile ) == 'undefined' )	
		return "";
	else
		return defaultFile;
	}	
	
/**
 * PINT_FirstFocus()
 * Set cursor focus to first available form field
 * 
 * @param field - optional: reference to form input, otherwise defaults to the first element of the first form on the page
 */				
/**
 * PINT_FirstFocus()
 * Set cursor focus to first available form field
 * 
 * @param field - optional: reference to form input, otherwise defaults to the first element of the first form on the page
 */				
function PINT_FirstFocus()	
	{
	var elementref;
	var i=0;
	if (!(elementref = PINT_FirstFocus.arguments[0]))
		{
		if (!(document.forms[0])) return false;
		while ((elementref = document.forms[0].elements[i++]) && (elementref.type == 'hidden')) {};
		}
	else
		{
		var formIndex;
		var formElementIndex;
		var formElementName = PINT_FirstFocus.arguments[0];
		elementref = null;
		
		for (formIndex = 0; formIndex < document.forms.length; formIndex++)
			{
			for (formElementIndex = 0; formElementIndex < document.forms[formIndex].elements.length; formElementIndex++)
				{
				if (document.forms[formIndex].elements[formElementIndex].name == formElementName)
					{
					elementref = document.forms[formIndex].elements[formElementIndex];
					break;
					}
				}
				if (elementref)
					{
					break;
					}
			}
		}

	if (!(elementref)) return false;
	elementref.focus();
	return true;
	}

/**
 * PINT_OnMouseOverHandler()
 * Handler for all onmouseover events. Must be explicitly set as 
 * the function handler.
 * 
 * @param e		event
 * @return		True.
 *
 */
function PINT_OnMouseOverHandler(e) 
	{
	e = (e) ? e : ((window.event) ? window.event : "")
	if (e) 
		{
		var eventsource = PINT_GetEventSource(e);
		if( eval( 'typeof(PINT_MenuTriggers)' ) != 'undefined' && 
		    eval( 'typeof(PINT_MenuTriggers[eventsource.id])' ) != 'undefined' )
			PINT_MenuPopUp(e);
		else if( eval( 'typeof(PINT_ROtriggers)' ) != 'undefined' &&  
		    eval( 'typeof(PINT_ROtriggers[eventsource.id])' ) != 'undefined' )
			PINT_RORollover(e);
			
		PINT_SetWindowStatus();	
		}
	return true;	
	}

/**
 * PINT_OnMouseOutHandler()
 * Handler for all onmouseout events. Must be explicitly set as 
 * the function handler.
 * 
 * @param e		event
 * @return		True.
 *
 */	
function PINT_OnMouseOutHandler(e) 
	{
	e = (e) ? e : ((window.event) ? window.event : "")
	if (e) 
		{
		var eventsource = PINT_GetEventSource(e);
		if( eval( 'typeof(PINT_MenuTriggers)' ) != 'undefined' && 
		    eval( 'typeof(PINT_MenuTriggers[eventsource.id])' ) != 'undefined' )
			PINT_MenuPopDown(e);	
		else if( eval( 'typeof(PINT_ROtriggers)' ) != 'undefined' &&  
			eval( 'typeof(PINT_ROtriggers[eventsource.id])' ) != 'undefined' )
			PINT_RORollout(e);
		}
	return true;
	}

/**
 * PINT_SetWindowStatus()
 * Set status bar message from parameter or global variable.
 * 
 * @param e		event
 * @return		True.
 *
 */	
function PINT_SetWindowStatus()
	{
	// if no arguments are passed, look for global windowStatus varible
	if( PINT_SetWindowStatus.arguments.length == 0 )
		{
		if( typeof(windowStatus) != 'undefined' && windowStatus != "" )
			{
			window.status = windowStatus;
			windowStatus = "";
			}
		}	
	else
		window.status = PINT_SetWindowStatus.arguments[0];
	return true;
	}	
	

/**
 * PINT_GetRootDirectory()
 * Gets rootDirectory global variable if defined.
 * 
 * @return		root directory path.
 *
 */	
function PINT_GetRootDirectory()
	{
	if( typeof( rootDirectory ) == 'undefined' )	
		return "";
	else
		return rootDirectory;
	}
	
	
/**
 * PINT_getElementsByClass(name)
 * Gets all elements that belong to a specific class
 * 
 * @param name	string containing name of class
 * @return		array of objects
 *
 */	
function PINT_getElementsByClass(name) 
	{
	var all = document.all ? document.all : document.getElementsByTagName('*');
	var elements = new Array();
	for (var e = 0; e < all.length; e++)
		{
		if((name != '') && (all[e].className.indexOf(name) >= 0)) elements[elements.length] = all[e];
		}
	return elements;
	}
	

/**
 * PINT_getURLParam(name, defaultVal)
 * Gets a parameter's value from the url query string if it exists, 
 * otherwise returns a default value
 *
 * @param name  name of url param
 * @param defaultVal value if the url param does not exist
 * @return string  value of url param
 *
 */	
function PINT_getURLParam(name, defaultVal)
	{
	// default the param's value to the default value
	var paramVal = defaultVal;
	// make a regex for the specific param name
	var regex = new RegExp("\&" + name + "\=([^$\&]+)", "i");
	// check if there are any params in the url
	if(document.URL.indexOf('?') != -1) 
		{
		// extract just the query string (prepend an & so the regex can find the first param)
		var qString = '&' + document.URL.substring((document.URL.indexOf('?') + 1), document.URL.length);
		// match the regex to the query string
		var urlMatches = qString.match(regex);
		// if it found a match, the second array element returned will be the value
		if((urlMatches != null) && (urlMatches.length == 2)) paramVal = urlMatches[1];
		}
	return paramVal;
	}
	
	

/*
$Id: pint_printcssDEBUG.js,v 1.3 2003/08/11 20:38:55 cducker Exp $

Creator: C. Ducker

Description:
	Display different style sheets depending upon client browser capabilities.

Dependencies:
	pint_common.js
	
Usage:	
	<head>
	<script src="/javascript/pint_printcss.js" language="JavaScript" type="text/javascript"></script>
	</head>
*/
function PINT_PrintCSS()
	{
	var NS4, IE, DOMstandard, CSScapable;
	NS4 = (document.layers) ? 1 : 0;
	IE = (document.all) ? 1 : 0;
	DOMstandard = (document.getElementById) ? 1 : 0;
	CSScapable = (NS4 || IE || DOMstandard) ? 1 : 0;
	
	if(CSScapable) 
		{
		if(NS4) 
			document.write("<link rel=\"stylesheet\" href=\"" + PINT_GetRootDirectory() + "/css/netscape.css\" type=\"text/css\" media=\"screen\" />");
		else
			document.write("<link rel=\"stylesheet\" href=\"" + PINT_GetRootDirectory() + "/css/dom.css\" type=\"text/css\" media=\"screen\" />");
		}
	}	
	
/*
$Id: pint_rolloverDEBUG.js,v 1.5 2003/07/03 17:01:44 cducker Exp $

Creator: J. Brock

Description:
	This rollover code is supposed to be 
		1. flexible, to accomodate all possible rollover activity
		2. compatible, should work on anything better than IE4, Netscape 4
		3. easy, so that all the rollover information can be inserted into the img tag in a simple way
		4. robust, so that errors, typos, bad DOM support make it degrade gracefully

Dependancies:
	pint_initcleanup.js

Usage:
	In pint_initcleanup.js:
	function init()
		{
		PINT_RORolloverInit('img1', 'img1', 'img1on.png');
		PINT_RORolloverInit('img2', 'img2', 'img2on.png', 'img1', 'img1on.png');
		};
	
	function cleanup()
		{};
	
	In page.htm:
	<head>
	<script src="\script\PINTRolloverDEBUG.js" language="JavaScript" type="text/javascript"></script>
	<script src="\script\PINTInitCleanup.js" language="JavaScript" type="text/javascript"></script>
	</head>

	<!-- rolling over img1 turns img1 on, rolling over img2 turns img1 and img2 on. -->
	<img name="img1" src="img1off.png">
	<img name="img2" src="img2off.png">
*/

/*************** PRIVATE DATA STRUCTURES ****************/

var PINT_ROcapableFlag = true;			// assume this browser is rollover capable, unless it proves otherwise.
var PINT_ROtriggers = new Array();
var PINT_ROtargets = new Array();
var PINT_ROtargetRollovers = new Array();
if ((typeof PINT_ROtriggers) != 'object') PINT_ROcapableFlag = false;


/************** PUBLIC METHODS **********************/

/* PINT_RolloverInit
   Wrapper for PINT_RORolloverImgInit
*/ 
function PINT_RolloverImgInit( rolloverId, windowStatus )
	{
	PINT_RORolloverInit( rolloverId+"img", windowStatus, (PINT_IsDefaultFile() && PINT_GetCurrentDirectory() == rolloverId ? false : true), rolloverId+"img", PINT_GetRootDirectory() + "/images/HNR_"+rolloverId+".gif", true);
	}

// CURRENT: trigger, target, target image, window status, set trigger
// NEW: trigger, window status, set trigger, target, target image, revert, target, target image, revert, target, target image, revert, target, target image, revert, target, target image,

/*	PINT_RORolloverInit()
	Initializes an html entity for image rollover triggering. This function should only be called after the body of the document has finished loading.
	Arguments: (there must be an odd number of arguments)
		1. the name attribute of the entity (usually an <a> or an <img>) which triggers the rollover
		2. the name attribute of the <img> which will be changed
		3. the source url that the image named by arg 2 will rollover to
		4. same as 2...
		5. same as 3...
		...
	Returns: true on success, false on failure
*/

function PINT_RORolloverInit()
	{
	if (!(PINT_ROcapableFlag)) return false;			// if the browser is not rollover capable, fail
	if (!(document.images)) return PINT_ROcapableFlag = false;
	if (PINT_RORolloverInit.arguments.length < 1 ) return true;		//if no arguments
	if (PINT_RORolloverInit.arguments.length < 6 || (PINT_RORolloverInit.arguments.length % 3) != 0) return false;	// There must be at least six arguments and a multiple of three

	if( document.getElementById )
		{
		var setTrigger = typeof(PINT_RORolloverInit.arguments[2]) != 'undefined' ? PINT_RORolloverInit.arguments[2] : true;
		var trigger = document.getElementById( PINT_RORolloverInit.arguments[0] );

		if( setTrigger && trigger )
			{
			if (!(PINT_ROtriggers[trigger.id])) PINT_ROtriggers[trigger.id] = new Array(); // init the target array
			
			var targetIndex, targetImageIndex, revertIndex, target, revert;
			
			for (targetIndex = 3; targetIndex < PINT_RORolloverInit.arguments.length; targetIndex = targetIndex + 3)
				{
				targetImageIndex = targetIndex + 1;
				revertIndex = targetIndex + 2;

				// loop through all targets
				target = document.getElementById( PINT_RORolloverInit.arguments[targetIndex] );
				targetrollover = PINT_RORolloverInit.arguments[targetImageIndex];
				revert = PINT_RORolloverInit.arguments[revertIndex];
		
				if (!(target.src)) return false;		// if target is not an image
		
				if(revert) PINT_ROtargets[target.id] = target.src;     // load up the target rollover sources
				PINT_ROtargetRollovers[targetrollover] = new Image();
				PINT_ROtargetRollovers[targetrollover].src = targetrollover; // cache rollover images in associative array
				//PINT_ROtriggers[trigger.name][target.name] = PINT_ROtargetRollovers[targetrollover]; // reference to the cached image
				PINT_ROtriggers[trigger.id][target.id] = PINT_ROtargetRollovers[targetrollover]; // reference to the cached image
				}
			if( typeof(PINT_RORolloverInit.arguments[1]) != 'undefined' )
				PINT_ROtriggers[trigger.id]["window.status"] = PINT_RORolloverInit.arguments[1];
				
			trigger.onmouseover = PINT_OnMouseOverHandler;
			trigger.onmouseout = PINT_OnMouseOutHandler;
			}
		}
	return true;
	}


/********* PRIVATE METHODS ************/
function PINT_RORollover(e)
{
	if (!PINT_ROcapableFlag) return false;
	var eventsource = PINT_GetEventSource(e);	//figure out where the events come in on this browser
	if (!eventsource) return (PINT_ROcapableFlag = false); // if there's no events, can't do rollovers
	PINT_RORolloverById(eventsource.id);
	return true;
}

function PINT_RORollout(e)
{
	if (!PINT_ROcapableFlag) return false;
	var eventsource = PINT_GetEventSource(e);	//figure out where the events come in on this browser
	if (!eventsource) return (PINT_ROcapableFlag = false); // if there's no events, can't do rollovers
	PINT_RORolloutById(eventsource.id);
	return true;
}	
	
	
function PINT_RORolloverById(elementId)
	{
	if(!PINT_ROcapableFlag)return false;
	if(eval('typeof(PINT_ROtriggers[elementId])')!='undefined')
		{
		for (target in PINT_ROtriggers[elementId]) //for this trigger, rollover each of it's targets
			{
			if( typeof( document[target] ) == 'object' )
				document[target].src = PINT_ROtriggers[elementId][target].src;
	
			if( target == "window.status" )
				windowStatus = PINT_ROtriggers[elementId][target];
			}
		}
	return true;
	}

function PINT_RORolloutById(elementId)
	{
	if(!PINT_ROcapableFlag)return false;
	if(eval('typeof(PINT_ROtriggers[elementId])')!='undefined')
		{
		for (target in PINT_ROtriggers[elementId]) //for this trigger, reset the src for each of it's targets
			{
			if( typeof( document[target] ) == 'object' && eval('typeof(PINT_ROtargets[target])')!='undefined')// && PINT_ROtargets[target]["revert"] == 1)
				document[target].src = PINT_ROtargets[target];
			}
		}
	return true;
	}	
function confirmDelete( message )
	{
	return confirm( message );
	}	
	
function display_flash()
		{
		document.writeln( "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0\" width=\"760\" height=\"240\" id=\"\" align=\"middle\">");
		document.writeln( "<param name=\"allowScriptAccess\" value=\"sameDomain\" />");
		document.writeln( "<param name=\"movie\" value=\"flash/home.swf\" />");
		document.writeln( "<param name=\"quality\" value=\"high\" />");
		document.writeln( "<param name=\"bgcolor\" value=\"#ffffff\" />");
		document.writeln( "<embed src=\"flash/home.swf\" quality=\"high\" bgcolor=\"#ffffff\" width=\"758\" height=\"239\" name=\"main\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />");
		document.writeln( "</object>");
		}

function display_image()
		{		
		document.writeln ( "<img src=\"images/H_collage.jpg\" width=\"760\" height=\"240\" alt=\"Preparation for College and Beyond...\" title=\"Preparation for College and Beyond...\" border=\"0\" usemap=\"#schoollocator\" />" );
		}


