/*
* blockquotesNS.js
*
* Simon Willison, 6th May 2003
* Changes: Uses document.createElementNS for XHTML compliance
* 
* Updated 14th June 2003
* Changes: added createElement function to support IE6
*
* Explanation: 
*   http://simon.incutio.com/archive/2002/12/20/#blockquoteCitations
* Inspired by Adrian Holovaty: 
*   http://www.holovaty.com/blog/archive/2002/12/20/0454
* Alternative implementation of the same idea by Paul Hammond: 
*   http://www.paranoidfish.org/boxes/2002/12/20/
*/

function createElement(element) {
  if (typeof document.createElementNS != 'undefined') {
    return document.createElementNS('http://www.w3.org/1999/xhtml', element);
  }
  if (typeof document.createElement != 'undefined') {
    return document.createElement(element);
  }
  return false;
}

function extractBlockquoteCitations() {
  quotes = document.getElementsByTagName('blockquote');
  for (i = 0; i < quotes.length; i++) {
    cite = quotes[i].getAttribute('cite');
    if (typeof cite == 'string') {
      newlink = createElement('a');
      newlink.setAttribute('href', cite);
      newlink.setAttribute('title', cite);
      newlink.appendChild(document.createTextNode('Source'));
      newdiv = createElement('div');
      newdiv.className = 'blockquotesource';
      newdiv.appendChild(newlink);
      quotes[i].appendChild(newdiv);
    }
  }
}

window.onload = extractBlockquoteCitations;