/***********************************************************************************
	Name:		validateAll
	Comments:	Validates all search criteria input by the user in form "inputForm".
				If the search criteria is not valid, it returns; otherwise it builds
				a url for the search results page and locates the current window to this url. 
	Parameters:	None
	Returns:	true/false
**********************************************************************************/
function validateAll() {
	var doc = document.inputForm;
	var qs = document.submitForm;
	var msg = "";

	// validate step 1 - "What type of lawyer ..." 
	var perAop = "";
	var perTerm = "";
	var busAop = "";
	var busTerm = "";
	


	if (tabTrigger) { // test the contents of the foreground tab only, ignore the other tab
		perAop = doc.personalaop.options[doc.personalaop.selectedIndex].value;
		perTerm = doc.personalterm.value;
		if ((perAop == "") && (perTerm == "")) {
			msg = "Type of Law is a required field. Please either select a Personal Type of Law or enter another type.\n"
		}
		else
		{
			doc.businessaop.selectedIndex=0;
			doc.businessterm.value="";
		}
	} else {
		busAop = doc.businessaop.options[doc.businessaop.selectedIndex].value;
		busTerm = doc.businessterm.value;
		if ((busAop == "") && (busTerm == "")) {
			msg = "Type of Law is a required field. Please either select a Business Type of Law or enter another type.\n"
		}
		else
		{
			doc.personalaop.selectedIndex=0;
			doc.personalterm.value="";
		}
	}

	// validate step 2 - "Where are you looking ..."
	var city = "";
	var county = "";
	var state = "";
	var province = "";	
	var country = doc.country.options[doc.country.selectedIndex].value; 
	if (country == 1) {
		county = doc.county.value;
		state = doc.state.options[doc.state.selectedIndex].value;
		if (state == "") {
			msg += "State is a required field.  Please select a state.\n";
		}
	} else if (country == 2) {
		state = doc.province.options[doc.province.selectedIndex].value;
		if (state == "") {
			msg += "Province is a required field.  Please select a province.\n";
		}
		else
		{
			doc.state.options[doc.state.selectedIndex].value=state;
			doc.county.value="";
		}
	}
	else
	{
				doc.county.value="";
				doc.state.options[doc.state.selectedIndex].value="";
				doc.province.options[doc.province.selectedIndex].value="";	
				if(country=="")
					doc.city.value="";
							
	}

	
	// If errors detected
	if (msg != "") {
		alert(msg);
		return false;
	}
}
