/*********************************************
 *
 * Adtags.js file - United Online 2004
 * All javascript functions used for adtags
 *
 *********************************************
 */
 
// Global Variables -----
 var TARGET_SERVER			= 'target';
 var TARGET_SERVER_PORT 	= '80';
 var REQUEST_TRANSACTION 	= 'ATAG';
 var CLICK_TRANSACTION 		= 'CLCK';
 var GEN_ADTAG_PRODUCT_TYPE	= '27';
 var TI_ADTAG_PRODUCT_TYPE	= '30';
 var PLAYLIST_REQUEST		= '2';
 var LAYER_ATTRIBUTES		= ' visibility=visible left=0 top=0 ';
 var IFRAME_ATTRIBUTES		= ' align=top frameborder=0 resize=0 marginheight=0 marginwidth=0 scrolling=no ';
 var NETSCAPE_LEGACY_URL	= 'http://nztv.untd.com/webads/999999/';
 var DOMAIN_COOKIE			= 'IS_ADTAG_BD';
 
 // Currently Available Targets
 var FIXED_TARGET 			= new Array();
     FIXED_TARGET[0] 		= 'Site';
     FIXED_TARGET[1] 		= 'Loc';
     FIXED_TARGET[2] 		= 'Size';
     FIXED_TARGET[3]  		= 'W';
     FIXED_TARGET[4]  		= 'H';
     
	// Allowed cookie values
	// Free, Platinum, Accelerator, MegaMail
	var PAY_OPTIONS = new Array('F','P','A','M');
 
// ------------------------------------------------------------------------------

// Main function/entry point for all general adtags
function getTag(site,location,dimension,width,height) {
	var ifm;
	var args;
	
	args = arguments;

	// Set brand cookie in UNTD domain from branded url
	document.write(setAdtagDomainCookie(getAdtagBrandDomain()));
	
	// Check to see if browser supports iframes	
	if (adtagBrowserSupportsIFrame()) {
	
		// IFrames Supported
		ifm =	'<IFRAME src=\'' + 
				getAdtagTargetRequest() + 
				getAdtagRequestQueryString(args) + '&p=' + GEN_ADTAG_PRODUCT_TYPE + '\' ' +
		  		getAdtagWidthAndHeight(width,height) + 
		  		getAdtagFrameAttributes() + '>' + 
		  		'</IFRAME>';
	
	} else {
		
		// IFrames not supported - Just show a static gif			
		ifm = getAdtagNetscapeCreative(width,height);
	}
	
	document.write(ifm);
	
}

// ------------------------------------------------------------------------------

// Main function/entry point for text/icon adtags - used on webmail exclusively - 09/23/2004
function getTextIconBoxTag(site,location,dimension,width,height) {

	var ifm;
    var args;

    args = arguments;
    
	// Set brand cookie in UNTD domain from branded url    
    document.write(setAdtagDomainCookie(getAdtagBrandDomain()));
    
 // Check to see if browser supports iframes   
    if (adtagBrowserSupportsIFrame()) {

		// IFrames Supported
    	ifm = '<IFRAME src=\'' +
        	  getAdtagTargetRequest() +
          	  getAdtagRequestQueryString(args) + 
          	  '&pl=' + PLAYLIST_REQUEST + '&p=' + TI_ADTAG_PRODUCT_TYPE + '\' ' +
          	  ' height=' + getTextIconBoxHeight() + ' width=120' +
          	  getAdtagFrameAttributes() + '>' +
          	  '</IFRAME>';

    } else {
    // Do not show anything for a netscape placement
    // Set it to empty string so it will not diplay undefined keyword
		ifm = '';
    }

    document.write(ifm);


}

// ------------------------------------------------------------------------------

function getTextIconBoxHeight() {
  
  if (navigator.userAgent.indexOf('Mac') != -1) { 
	return '115'; 
  } else { 
  	return '110'; 
  }
  
}


// ------------------------------------------------------------------------------


function getAdtagNetscapeCreative(w,h) {
	
	var n_url = 'http://www.rmhc.com';
	var n_img; 
    if (w == '120' && h == '600') {
    	n_img = 'skyscraper.gif';
    } else if (w == '120' && h == '240') {
    	n_img = 'verticalbanner.gif';
    } else if (w == '150' && h == '70') {
    	n_img = 'rectangletile.gif';
    } else if (w == '300' && h == '250') {
    	n_img = 'mediumrectangle.gif';
    } else if (w == '728' && h == '90') {
    	n_img = 'leaderboard.gif';
    	n_url = 'http://www.ispgift.com';
    } else if (w == '232' && h == '60') {
    	n_img = 'placementbanner.gif';
    	n_url = 'http://www.ispgift.com';
    } else if (w == '120' && h == '60') {
    	n_img = 'buttontwo.gif';
    	n_url = 'http://www.ispgift.com';
    } else {
    	return '';
    }
    
    return 	'<a href=' + getAdtagClickTransaction() + '?s=999999&u=' + n_url + ' target=top><img src=' + NETSCAPE_LEGACY_URL + n_img + ' width=' + w + ' height=' + h + ' border=0></a>';

}

// ------------------------------------------------------------------------------


function getAdtagBrandDomain() {
	var url = self.window.location.href;
	
	var domain;
	var brand;
	
	if (url.indexOf('juno.com') != -1) {
		return 'JU';
	} else if (url.indexOf('mybluelight.com') != -1) {
		return 'BL';
    } else if (url.indexOf('mysite.com') != -1) {
    	return 'MS';
	} else if ((url.indexOf('netzero.net') != -1) || (url.indexOf('netzero.com') != -1)) {
		return 'NZ';
	} else {
		return 'NZ';
	}
}


// ------------------------------------------------------------------------------

function getAdtagServerDomain() {

	var url = self.window.location.href;
	
	if (url.indexOf('juno.com') != -1) {
		return 'juno.com';
	} else if (url.indexOf('mybluelight.com') != -1) {
		return 'mybluelight.com';
    } else if (url.indexOf('mysite.com') != -1) {
    	return 'mysite.com';
	} else if ((url.indexOf('netzero.net') != -1) || (url.indexOf('netzero.com') != -1)) {
		return 'netzero.net';
	} else {
		return 'untd.com';
	}
}

// ------------------------------------------------------------------------------

function setAdtagDomainCookie2() {

	var value = 'TRUE';
	quartDay = 6 * 60 * 60 * 1000;
	expDate = new Date();
	expDate.setTime(expDate.getTime() + quartDay);
	document.cookie = DOMAIN_COOKIE + '=' + value + ';path=/;expires=' + expDate.toGMTString() + ';domain=.' + getAdtagServerDomain();
}
	
// ------------------------------------------------------------------------------



function setAdtagDomainCookie(brand) {
	if (getAdtagCookieValueFromKey(DOMAIN_COOKIE) == null) {
		setAdtagDomainCookie2();
		return '<iframe src=http://nztv.untd.com/webads/js/cookie.html?name=BRAND&value=' + brand + ' width=0 height=0 align=top frameborder=0 resize=0 marginheight=0 marginwidth=0 scrolling=no></iframe>';
	} else {
		return '<iframe src=http://nztv.untd.com/webads/js/cookie.html?name=BRAND&value=' + brand + ' width=0 height=0 align=top frameborder=0 resize=0 marginheight=0 marginwidth=0 scrolling=no></iframe>';
	}	

}

// ------------------------------------------------------------------------------

 
function getAdtagBrand() {
	
	return getAdtagCookieValue('BRAND');
	
}

// ------------------------------------------------------------------------------

function getAdtagCookieValue(key) {

    var url = window.location.search.toUpperCase();
	var value;
	var ukey = key;
	ukey = ukey.toUpperCase();	

        var b_string = ukey + '=';

	if (url.indexOf(ukey) != -1) {
          var start_position = url.indexOf(b_string) + b_string.length;
          var end_position = start_position + 2;
          value = url.substring(start_position, end_position);

	} else {

	   value = getAdtagCookieValueFromKey(key.toUpperCase());

	}
        
        return value;
        
}

// ------------------------------------------------------------------------------

function getAdtagCookieValueFromKey(cookieName) {
  	var allCookies=document.cookie;
  	var pos=allCookies.indexOf(cookieName);
  
  	if(pos == -1) return null;
  
  	var start=pos+cookieName.length;
  	var end=allCookies.indexOf(";",start);
  
  	if(end == -1) end=allCookies.length;
  
  	var value=allCookies.substring(start,end);
  
  	if(value.charAt(0) == '=') value=value.substring(1,value.length);
  
  	return value;
}
// ------------------------------------------------------------------------------

function getAdtagFrameAttributes() {

	if (document.layers) {
		return LAYER_ATTRIBUTES;
	} else {
		return IFRAME_ATTRIBUTES;
	}

}
// ------------------------------------------------------------------------------
 
function adtagBrowserSupportsIFrame() {
	// Return true if it likes IFRAME, else return false
	if (document.layers) {
		return false;
	} else {
		return true;
	}	
}

// ------------------------------------------------------------------------------

function getAdtagTargetServer() {
	return 'http://' + TARGET_SERVER + '.' + getAdtagServerDomain();
}

// ------------------------------------------------------------------------------

function getAdtagTargetRequest() {
	return getAdtagTargetServer() + ":" + TARGET_SERVER_PORT + "/" + REQUEST_TRANSACTION;
}

// ------------------------------------------------------------------------------

function getAdtagClickTransaction() {
	return getAdtagTargetServer() + ":" + TARGET_SERVER_PORT + "/" + CLICK_TRANSACTION;
}

// ------------------------------------------------------------------------------

function getAdtagMemberPayStatus() {

	var mpv_cok = 'MPV=';
	
	// Get cookie value string from MPS cookie
	var mem_pay	= getAdtagCookieValueFromKey('MPS');
	
	// If MPS cookie does not exist or equals 'F', return
	// the user as a Free user
	if (mem_pay == null || mem_pay == PAY_OPTIONS[0]) {
		return mpv_cok + PAY_OPTIONS[0];
	
	// Cookie is set - Loop through all allowed cookie values
	} else {
		var i = 0;
		while (PAY_OPTIONS.length > i) {
			if (mem_pay.indexOf(PAY_OPTIONS[i]) != -1) {
				mpv_cok += PAY_OPTIONS[i];
			}
			i++;
		}
		
		return mpv_cok;		
	}
}

// ------------------------------------------------------------------------------

function getAdtagBrandStatus() {
	return 'brand=' + getAdtagBrandDomain();
}

// ------------------------------------------------------------------------------

function getAdtagCobrandStatus() {
	// Get cookie value string from cobrand cookie
	var cobrand_cookie	= getAdtagCookieValueFromKey('cobrand');
	
	// If cobrand cookie does not exist or equals '', return empty string so it
	// does not do a undefined in the cobrand status
	if (cobrand_cookie == null || cobrand_cookie == '') {
		return '';
	// Return a pipe delimited cobrand value (brand|cobrand)	
	} else {
	
		// Change JN cobrand to JU if necessary
		if (cobrand_cookie == 'JN') {
			cobrand_cookie = 'JU';
		}
			
		return '|' + cobrand_cookie;
	}
}		


// ------------------------------------------------------------------------------

/*
Return some sort of number as the member number
	- Condition 1: The number is a valid number - return right away
	- Condition 2: The number is not valid - clean number
						- if good - return number with error flag
						- if bad still - return a 1 with error flag
	- Condition 3: The number cannot be resolved - return a 0 with error flag					
*/
function isAdtagValueANumber(num_value) {
   
   var ERR = '&ERROR=T';
   var cok_val = getAdtagCookieValueFromKey(num_value);
   if (!isNaN(cok_val)) {
        return cok_val;
   } else if (isNaN(cok_val)) {
   		
   		var t_val = cleanAdtagMemberNumber(cok_val);
        if (!isNaN(t_val)) {
        	return t_val + ERR;
        } else {
          	return '1' + ERR;
        }
        
   } else {
        return '0' + ERR;
   }
}

// ------------------------------------------------------------------------------

function cleanAdtagMemberNumber(mem_num) {
	mem_num = unescape(mem_num);
	return mem_num.substring(1,mem_num.indexOf('|'));
}

// ------------------------------------------------------------------------------

function getAdtagMemberNumber() {
	return 'MNUM=' + isAdtagValueANumber('MNUM');
}

// ------------------------------------------------------------------------------
function getAdtagRequestQueryString(args) {
	var qs = '?';
	
	for (i = 0; i < parseInt(args.length); i++) {
		qs += FIXED_TARGET[i] + '=' + args[i] + '&';
	}
	
	return qs + getAdtagBrandStatus() + getAdtagCobrandStatus() + '&' + 
				getAdtagMemberPayStatus() 	+ '&' +
				getAdtagMemberNumber() 		+ '&' +
	   'rnd=' + getAdtagRandomNumber();
	
}

// ------------------------------------------------------------------------------
function getAdtagWidthAndHeight(width,height) {
	
	return 'width=' + width + ' height=' + height;
}

// ------------------------------------------------------------------------------
function getAdtagClickQueryString() {

	var qs = window.location.search;
	qs = qs.substring(1,qs.length);
	
	// Add Testing Name/Value pair when not in production
	// Look for a step id in the click request URL
	
	if (qs.indexOf('s=') == -1 && adtagBrowserSupportsIFrame()) {
		qs = 'Op=TEST';
    }
	
	return qs;
}

// ------------------------------------------------------------------------------
function getAdtagRandomNumber() {
	return Math.random().toString().substring(2);
}

// ------------------------------------------------------------------------------
function getAdtagContentForClick(adtag_url,adtag_image,adtag_width,adtag_height) {
	return '<a href=' + getAdtagClickTransaction() + '?' + getAdtagClickQueryString() + 
			'&u=' + escape(adtag_url) + ' target=top>' +
			'<img src=' + adtag_image + ' border=0 ' +
			'width=' + adtag_width + ' height=' + adtag_height + '></a>';
}
