function setToggleCookie(name, value, path, domain, secure) 
{
    var expires = new Date();
    var base = new Date(0);
    var skew = base.getTime();
    if ( skew > 0 )
        expires.setTime(expires.getTime()-skew);
    expires.setTime(expires.getTime() + 365 * 24 * 60 * 60 * 1000);
    var curCookie = name + "=" + escape(value) +
      ((expires) ? "; expires=" + expires.toGMTString() : "") +
      ((path) ? "; path=" + path : "") +
      ((domain) ? "; domain=" + domain : "") +
      ((secure) ? "; secure" : "");
    document.cookie = curCookie;
}

function getToggleCookie(name) 
{
    var dc = document.cookie;
    var prefix = name + "=";
    var begin = dc.indexOf("; " + prefix);
    if (begin == -1) 
    {
        begin = dc.indexOf(prefix);
        if (begin != 0) return null;
    } 
    else
        begin += 2;
    var end = document.cookie.indexOf(";", begin);
    if (end == -1)
        end = dc.length;
    return unescape(dc.substring(begin + prefix.length, end));
}

function displayWindow(url,name,width,height){
var x = 300, y = 30; // default values
  x = window.screenX + 100;
  y = window.screenY + 100;
var Win = window.open(url, "name", "width=" + width + ",height=" + height + ",left=" + x + ",top=" + y + ",resizable=yes,scrollbars=no,menubar=no,status=yes,toolbar=no");
}

function displayRefs(url){
var x = 300, y = 30; // default values
  x = window.screenX + 5;
  y = window.screenY + 5;
var Win = window.open(url, "Referrers", "width=" + 640 + ",height=" + 480 + ",left=" + x + ",top=" + y + ",resizable=1,scrollbars=yes,menubar=no,status=1,toolbar=no");
}

function displayPoll(url){
var x = 300, y = 30; // default values
  x = window.screenX + 100;
  y = window.screenY + 100;
	var popupWin = window.open(url, "pollpopup", "width=" + 360 + ",height=" + 420 + ",left=" + x + ",top=" + y + ",resizable=1,scrollbars=nos,menubar=no,status=0,toolbar=no");
	popupWin.opener.top.name = "opener";
	popupWin.focus();
}

function toggleMeta(object)
{
	if (document.getElementById && document.getElementById(object) != null)
	{
		if ( document.getElementById(object).style.visibility == 'visible' )
		{
			document.getElementById(object).style.visibility='hidden';
			document.getElementById(object).style.display='none';
		}
		else
		{
			document.getElementById(object).style.visibility='visible';
			document.getElementById(object).style.display='block';
		}
	}
	else if (document.layers && document.layers[object] != null)
	{
		if ( document.getElementById(object).style.visibility == 'visible' )
		{
			document.layers[object].visibility = 'hidden';
		}
		else
		{
			document.layers[object].visibility = 'visible';
		}
	}
	else if (document.all)
	{
		if ( document.getElementById(object).style.visibility == 'visible' )
		{
			document.all[object].style.visibility = 'hidden';
		}
		else
		{
			document.all[object].style.zIndex = 100;
			document.all[object].style.visibility = 'visible';
		}
	}
}


function expandAll(count)
{
    for ( i = 1; i <= count; i++ )
    {
    	showMeta('cloak_id' + i);
    }
}

function showMeta(object)
{
	if (document.getElementById && document.getElementById(object) != null)
	{
		document.getElementById(object).style.visibility='visible';
		document.getElementById(object).style.display='block';
	}
	else if (document.layers && document.layers[object] != null)
	{
		document.layers[object].visibility = 'visible';
	}
	else if (document.all)
	{
		document.all[object].style.zIndex = 100;
		document.all[object].style.visibility = 'visible';
	}
}

function collapseAll(count)
{
    for ( i = 1; i <= count; i++ )
    {
    	hideMeta('cloak_id' + i);
    }
}

function hideMeta(object)
{
	if (document.getElementById && document.getElementById(object) != null)
	{
		document.getElementById(object).style.visibility='hidden';
		document.getElementById(object).style.display='none';
	}
	else if (document.layers && document.layers[object] != null)
	{
		document.layers[object].visibility = 'hidden';
	}
	else if (document.all)
	{
		document.all[object].style.visibility = 'hidden';
	}
}

function toggleBlogMeta(object)
{
    var visi = 0;
    var iconId = 't' + object;
    var icon = '&#9655;';
	if (document.getElementById && document.getElementById(object) != null)
	{
		if ( document.getElementById(object).style.visibility == 'visible' )
		{
			document.getElementById(object).style.visibility='hidden';
			document.getElementById(object).style.display='none';
		}
		else
		{
			document.getElementById(object).style.visibility='visible';
			document.getElementById(object).style.display='block';
			visi = 1;
			icon = '&#9661;';
		}
	}
	else if (document.layers && document.layers[object] != null)
	{
		if ( document.getElementById(object).style.visibility == 'visible' )
		{
			document.layers[object].visibility = 'hidden';
		}
		else
		{
			document.layers[object].visibility = 'visible';
			visi = 1;
			icon = '&#9661;';
		}
	}
	else if (document.all)
	{
		if ( document.getElementById(object).style.visibility == 'visible' )
		{
			document.all[object].style.visibility = 'hidden';
		}
		else
		{
			document.all[object].style.zIndex = 100;
			document.all[object].style.visibility = 'visible';
			visi = 1;
			icon = '&#9661;';
		}
	}
	setToggleCookie(object,visi);
	document.getElementById(iconId).innerHTML=icon;
}

function loadBlogAll(count)
{
    for ( i = 1; i <= count; i++ )
    {
        var cId = 'cloak_id' + i;
        var exp = getToggleCookie(cId);
        if ( exp == 1 )
    	   showBlogMeta(cId);
    }
}


function expandBlogAll(count)
{
    for ( i = 1; i <= count; i++ )
    {
    	showBlogMeta('cloak_id' + i);
    }
}

function showBlogMeta(object)
{
    var icon = '&#9661;';
    var iconId = 't' + object;
	if (document.getElementById && document.getElementById(object) != null)
	{
		document.getElementById(object).style.visibility='visible';
		document.getElementById(object).style.display='block';
	}
	else if (document.layers && document.layers[object] != null)
	{
		document.layers[object].visibility = 'visible';
	}
	else if (document.all)
	{
		document.all[object].style.zIndex = 100;
		document.all[object].style.visibility = 'visible';
	}
	document.getElementById(iconId).innerHTML=icon;
}

function collapseBlogAll(count)
{
    for ( i = 1; i <= count; i++ )
    {
    	hideBlogMeta('cloak_id' + i);
    }
}

function hideBlogMeta(object)
{
    var icon = '&#9655;';
    var iconId = 't' + object;
	if (document.getElementById && document.getElementById(object) != null)
	{
		document.getElementById(object).style.visibility='hidden';
		document.getElementById(object).style.display='none';
	}
	else if (document.layers && document.layers[object] != null)
	{
		document.layers[object].visibility = 'hidden';
	}
	else if (document.all)
	{
		document.all[object].style.visibility = 'hidden';
	}
	document.getElementById(iconId).innerHTML=icon;
}
