// Validate address and card
// mostly written by CKC Oct 2004
// with highlighting code adapted from 
// http://javascript.internet.com/forms/val-no-alert.html
// and other free sources

var goterrors = 0;
var message = "PLEASE FILL IN:\n";
// Functions to highlight fields
dom = (document.getElementById) ? 1 : 0;

function highlightfield(what,errors){
	if (dom){
		what.style.backgroundColor='yellow';
		what.style.color='black';
		}
	if (!goterrors && errors) {
		goterrors = errors;
	} 
}
function unhighlightfield(what){
	if (dom){
		what.style.backgroundColor='';
		what.style.color='';}
}

// Validation functions
function validateAddress(f){
	goterrors = 0;
	if (f.firstname.value.length < 2) {highlightfield(f.firstname,true);message += "first name\n"} else {unhighlightfield(f.firstname)};
	if (f.lastname.value.length < 2) {highlightfield(f.lastname,true);message += "last name\n"}else{unhighlightfield(f.lastname)};
	if (f.address1.value.length < 5) {highlightfield(f.address1,true);message += "billing address line 1\n"}else{unhighlightfield(f.address1)};
	if (f.city.value.length < 3) {highlightfield(f.city,true);message += "billing city\n"}else{unhighlightfield(f.city)};
	if (f.state.value.length < 2 && f.province.value.length < 2) {highlightfield(f.state,true);message += "billing state\n"}else{unhighlightfield(f.state)};
	if (f.zip.value.length < 5) {highlightfield(f.zip,true);message += "billing zip code\n"}else{unhighlightfield(f.zip)};
	if (f.day_phone.value.length < 10) {highlightfield(f.day_phone,true);message += "valid daytime phone number (for billing or shipping questions)\n"}else{unhighlightfield(f.day_phone)};
	if (f.sh_address1.value.length < 5) {highlightfield(f.sh_address1,true);message += "shipping address line 1\n"}else{unhighlightfield(f.sh_address1)};
	if (f.sh_city.value.length < 3) {highlightfield(f.sh_city,true);message += "shipping city\n"}else{unhighlightfield(f.sh_city)};
	if (f.sh_state.value.length < 2 && f.sh_province.value.length <2) {highlightfield(f.sh_state,true);message += "shipping state\n"}else{unhighlightfield(f.sh_state)};
	if (f.sh_zip.value.length < 5) {highlightfield(f.sh_zip,true);message += "shipping zip code\n"}else{unhighlightfield(f.sh_zip)};
	if(goterrors)alert(message);
	message = "PLEASE FILL IN:\n";
	return (!goterrors);
	}

function validateCard(f){
	goterrors = 0;
	if (f.cctype.value != "MasterCard" && f.cctype.value != "Visa" && f.cctype.value != "Discover" && f.cctype.value != "American Express") {highlightfield(f.cctype,true);message += "MasterCard, Visa, Discover, or American Express for card type\n"}else{unhighlightfield(f.cctype)};
	if (f.ccnum.value.length < 16) {highlightfield(f.ccnum,true);message += "valid credit card number\n"}else{unhighlightfield(f.ccnum)};
	if (f.ccmonth.value < 1) {highlightfield(f.ccmonth,true);message += "expiration month\n"}else{unhighlightfield(f.ccmonth)};
	if (f.ccyear.value < 5) {highlightfield(f.ccyear,true);message += "expiration year\n"}else{unhighlightfield(f.ccyear)};
	if(goterrors) {alert(message)};
	message = "PLEASE FILL IN:\n";
	return(!goterrors);
}
