// Customer : SSA FAQs
// Version : OnExit 3.2
// ************ don't modify below this line *************
// implements the standard survey strategy triggered on load or on unload of the page or
// an image

// *********** These typically will not need to be parameterized from the including page ********

// this is the base URL to the survey engine
var popUpURL = "http://www.foreseeresults.com/survey/display";

// the name of the pop up window
var popUpWinName = "survey";

// the name of the persistent or session cookie to prevent multi-surveying in a given time period
var ckAlreadyShown = triggerParms["ascookie"];

// the name of the cookie that counts the minimum pages viewed with the trigger code in them
var ckLoyaltyCount = triggerParms["lfcookie"];

// the name of the cookie that implements the surveying 'sample-percentage' algorithm
var ckSamplePercentage = "foreseeSamplePerc";

// set persistent cookie expiration if we are using it, otherwise it is a session cookie
var persistentExpires = new Date();
persistentExpires.setTime(persistentExpires.getTime() + (triggerParms["rw"]*60*1000));

function ForeCStdGetCookie (name) {
	var arg = name + "=";
	var alen = arg.length;
	var clen = document.cookie.length;
	var i = 0;
	while (i < clen) {
		var j = i + alen;
		if (document.cookie.substring(i, j) == arg) {
			return ForeCStdGetCookieVal (j);
		}
		i = document.cookie.indexOf(" ", i) + 1;
		if (i == 0) {
			break;
		}
	}
	return null;
}

function ForeCStdSetCookie (name, value) {
	var argv = ForeCStdSetCookie.arguments;
	var argc = ForeCStdSetCookie.arguments.length;
	var expires = (argc > 2) ? argv[2] : null;
	var path = (argc > 3) ? argv[3] : null;
	var domain = (argc > 4) ? argv[4] : null;
	var secure = (argc > 5) ? argv[5] : false;
	document.cookie = name + "=" + escape (value) +
	((expires == null) ? "" : ("; expires=" + expires.toGMTString())) +
	((path == null) ? "" : ("; path=" + path)) +
	((domain == null) ? "" : ("; domain=" + domain)) +
	((secure == true) ? "; secure" : "");
}

function ForeCStdDeleteCookie (name) {
	var exp = new Date();
	exp.setTime (exp.getTime() - 1);
	var cval = ForeCStdGetCookie (name);
	document.cookie = name + "=" + cval + "; expires=" + exp.toGMTString();
}

function ForeCStdGetCookieVal(offset) {
	var endstr = document.cookie.indexOf (";", offset);
	if (endstr == -1) {
		endstr = document.cookie.length;
	}
	return unescape(document.cookie.substring(offset, endstr));
}

// check whether or not this browser supports focus() on windows
function supportsFocus() {
	// get user agent string
	var userAgent = navigator.userAgent;
	var strBrowserPlatform = navigator.platform;
	// find IE version label in user agent string if it exists
	var realMSVersionAt = userAgent.indexOf("MSIE");
	if (strBrowserPlatform.indexOf("Win32") >= 0) {
		if (realMSVersionAt == -1) {
			// must be netscape
			return true;
		} else {
			// IE browser, see which one
			var nameAndVersion = userAgent.substring(realMSVersionAt, realMSVersionAt + 6);
			var realMSVersion = nameAndVersion.charAt(5);
			if(realMSVersion >= 5) {
				return true;
			} else {
				return false;
			}
		}
	} else {
		return false;
	}
}

function specialEscape(str) {
	var encoded = "";
	for(var i = 0; i < str.length; i++) {
	encoded += encodeURLChar(str.charAt(i));
	}
	return encoded ;
}

function encodeURLChar(c) {
	var lookupTable = new Array();
	lookupTable[" "] = "%20";
	lookupTable["!"] = "%21";
	lookupTable["\""] = "%22";
	lookupTable["#"] = "%23";
	lookupTable["$"] = "%24";
	lookupTable["%"] = "%25";
	lookupTable["@"] = "%40";
	lookupTable["&"] = "%26";
	lookupTable["'"] = "%27";
	lookupTable["("] = "%28";
	lookupTable[")"] = "%29";
	lookupTable["*"] = "%2A";
	lookupTable["+"] = "%2B";
	lookupTable[","] = "%2C";
	lookupTable["-"] = "%2D";
	lookupTable["."] = "%2E";
	lookupTable["/"] = "%2F";
	lookupTable[":"] = "%3A";
	lookupTable[";"] = "%3B";
	lookupTable["<"] = "%3C";
	lookupTable["="] = "%3D";
	lookupTable[">"] = "%3E";
	lookupTable["?"] = "%3F";
	lookupTable["["] = "%5B";
	lookupTable["\\"] = "%5C";
	lookupTable["]"] = "%5D";
	lookupTable["^"] = "%5E";
	lookupTable["_"] = "%5F";
	lookupTable["`"] = "%60";
	lookupTable["{"] = "%7B";
	lookupTable["|"] = "%7C";
	lookupTable["}"] = "%7D";
	lookupTable["~"] = "%7E";
	lookupTable["0"] = "0";
	lookupTable["1"] = "1";
	lookupTable["2"] = "2";
	lookupTable["3"] = "3";
	lookupTable["4"] = "4";
	lookupTable["5"] = "5";
	lookupTable["6"] = "6";
	lookupTable["7"] = "7";
	lookupTable["8"] = "8";
	lookupTable["9"] = "9";
	lookupTable["a"] = "a";
	lookupTable["b"] = "b";
	lookupTable["c"] = "c";
	lookupTable["d"] = "d";
	lookupTable["e"] = "e";
	lookupTable["f"] = "f";
	lookupTable["g"] = "g";
	lookupTable["h"] = "h";
	lookupTable["i"] = "i";
	lookupTable["j"] = "j";
	lookupTable["k"] = "k";
	lookupTable["l"] = "l";
	lookupTable["m"] = "m";
	lookupTable["n"] = "n";
	lookupTable["o"] = "o";
	lookupTable["p"] = "p";
	lookupTable["q"] = "q";
	lookupTable["r"] = "r";
	lookupTable["s"] = "s";
	lookupTable["t"] = "t";
	lookupTable["u"] = "u";
	lookupTable["v"] = "v";
	lookupTable["w"] = "w";
	lookupTable["x"] = "x";
	lookupTable["y"] = "y";
	lookupTable["z"] = "z";
	lookupTable["A"] = "A";
	lookupTable["B"] = "B";
	lookupTable["C"] = "C";
	lookupTable["D"] = "D";
	lookupTable["E"] = "E";
	lookupTable["F"] = "F";
	lookupTable["G"] = "G";
	lookupTable["H"] = "H";
	lookupTable["I"] = "I";
	lookupTable["J"] = "J";
	lookupTable["K"] = "K";
	lookupTable["L"] = "L";
	lookupTable["M"] = "M";
	lookupTable["N"] = "N";
	lookupTable["O"] = "O";
	lookupTable["P"] = "P";
	lookupTable["Q"] = "Q";
	lookupTable["R"] = "R";
	lookupTable["S"] = "S";
	lookupTable["T"] = "T";
	lookupTable["U"] = "U";
	lookupTable["V"] = "V";
	lookupTable["W"] = "W";
	lookupTable["X"] = "X";
	lookupTable["Y"] = "Y";
	lookupTable["Z"] = "Z";
	return lookupTable[c];
}
// this function checks to see if we are in path included in the excluded list. 
function currentLocationExcluded() {	
	if (triggerParms["trigger_type"] == "OE" ) {
		return false;	
	} else {
		var parentURLPath = window.location.pathname;//location path
		for(key in excludeList) {
			if(parentURLPath.indexOf(excludeList[key]) != -1) {
				return true;
			}
		}
		return false;
	}
}

// this function toggles whether to supress the ForeSee survey
function disarmTrigger(){
	triggerParms["armTrigger"] = 1;
}

// this function has been adapted from the Poll() function in our standard launcher. Since
// we are calling this function directly rather than through a load event, we don't increment
// loyalty factor, we only interrogate it to see if the loyalty has been met.
function Poll() { 
	if(triggerParms["dt"] == 1) {
		return;
	}
	//checks if we are in path included in the excluded list.
	if(currentLocationExcluded()) {
	    	return;
	}	
	var stickyCounter = ForeCStdGetCookie(ckLoyaltyCount); // check counter cookie
	var alreadyShown = ForeCStdGetCookie(ckAlreadyShown); // check if we already have shown survey
	var pageCount;
	var randNum = Math.random();
	randNum *= 100;
	ForeCStdSetCookie(ckSamplePercentage, randNum); // only for diagnostics
	if (stickyCounter == null) {
		// this will only create the loyalty factor cookie if we don't 
		// already have one
		pageCount = 1;
		ForeCStdSetCookie(ckLoyaltyCount, pageCount, null,'/',triggerParms["domain"]);		
		stickyCounter = ForeCStdGetCookie(ckLoyaltyCount);
	}
	if (stickyCounter != null) {
		// already a loyalty cookie - see if we have reached the pages viewed requirement
		pageCount = stickyCounter;
		if(pageCount >= triggerParms["lf"]) {
			// apply the samplingPercentage algorithm
			if(alreadyShown == null) {
				// only if we haven't already served them a survey
		                if(randNum <= triggerParms["sp"]) {
					// we'll open it offscreen. If the survey loads it will resize and translate
					// onscreen, otherwise the failover page will close the offscreen window
					var winOptions = "width=" + triggerParms["winOptWidth"] + 
					",height=" + triggerParms["winOptHeight"] +
					",top=" + triggerParms["winOptTop"] +
					",left=" + triggerParms["winOptLeft"] 
					+ ",resizable=yes,scrollbars=yes";
					var fullURL = popUpURL + "?" + "width=" + triggerParms["width"] +
					"&height=" + triggerParms["height"] +
					"&cid=" + specialEscape(triggerParms["cid"]) + "&mid=" + specialEscape(triggerParms["mid"]);
					if ((triggerParms["alt_width"] )!=null) {
						fullURL += "&alt_width=" + triggerParms["alt_width"];
					}
					if ((triggerParms["alt_height"] )!=null) {
						fullURL += "&alt_height=" + triggerParms["alt_height"];
					}
					if ((triggerParms["omb"] )!=null) {
						fullURL += "&omb=" + specialEscape(triggerParms["omb"]);
					}
					//Coremetrics support
					if ((triggerParms["cmetrics"] ) != null) {
						fullURL += "&cmetrics=" + escape(triggerParms["cmetrics"]);
					}
					// added for pop control after window is loaded
					if (triggerParms["olpu"] == 1) {
						fullURL += "&olpu=1";
					}
					// added for double cookie
					if ((triggerParms["ndc"] )!=null) {
						fullURL += "&ndc=" + triggerParms["ndc"] + "&fsexp=" + triggerParms["fsexp"] +
							   "&midexp=" + triggerParms["midexp"];
					}
					//extract customer passed parameters for OnExit
					var counter=3;
					for(paramKey in triggerParms) {
						if(paramKey.substring(0,5) == "oecpp"){
							var value = triggerParms[paramKey];
							var session = ForeCStdGetCookie(value);
							if (session != null) {
								triggerParms["cpp_"+ counter] = value.substring(8,value.length) + ":" + cppUrlPatch (session);
								counter++;	
							}
						}
					}
					// extract customer passed parameters if any
					var customerParams = "";
					for(paramKey in triggerParms) {
						if(paramKey.substring(0,3) == "cpp"){
							// append it to full
							fullURL += "&" + paramKey + "=" + specialEscape(triggerParms[paramKey]);
						}
					}
					if(triggerParms["armTrigger"] == 1){
						return;
					}else {
						// insure that we only pop up once during the lifetime of the cookie
						if(triggerParms["npc"] == 1) {
							ForeCStdSetCookie(ckAlreadyShown, 'true',null,triggerParms["path"],triggerParms["domain"]);
						} else {
							ForeCStdSetCookie(ckAlreadyShown, 'true', persistentExpires,triggerParms["path"],triggerParms["domain"]);
						}
						var myPopUp = window.open(fullURL, popUpWinName,winOptions);
						if(supportsFocus()){						
							switch (triggerParms["pu"]){
								case 0:
									myPopUp.focus();								
								break;
								case 1:
									self.focus();								
								break;
								default:
								break;
							}
						}
					}
				}
			}
		}	
		// increment it and set the new cookie value
		pageCount++;
		ForeCStdSetCookie(ckLoyaltyCount, pageCount, null,'/',triggerParms["domain"]);		
	}
}