// ----------------------------------------------------------------------------
//       File Name: enduser.js
//       Subsystem: enduser
//   Document Type: Javascript include file
//         Purpose: contains all non-page specific enduser page Javascript
// ----------------------------------------------------------------------------

function utf8_len(str)
{
    var i, sz, len = 0;

    for (i = 0, sz = str.length; i < sz; i++) 
        if (str.charCodeAt(i) < 0x0080)
            len += 1;
        else if (str.charCodeAt(i) < 0x0800)
            len += 2;
        else
            len += 3;

    return(len);
}

// ----------------------------------------------------------------------------

function utf8_excess_chars(str, maxlen)
{
    var i, sz, len = 0; excess = 0;

    for (i = 0, sz = str.length; i < sz; i++)
    {
        if (str.charCodeAt(i) < 0x0080)
            len += 1;
        else if (str.charCodeAt(i) < 0x0800)
            len += 2;
        else
            len += 3;

        if (len > maxlen)
            excess += 1;
    }

    return(excess);
}

// ----------------------------------------------------------------------------

function is_furigana_string(str)
{
    var i, sz, c;

    for (i = 0, sz = str.length; i < sz; i++)
    {
        c = str.charCodeAt(i);

        if ((c >= 0x3041  &&  c <= 0x309E) || // hiragana
            (c >= 0x30A1  &&  c <= 0x30FE) || // full-width katakana
            (c == 0x2212) || (c == 0x2025) || // full-width hyphens
            (c == 0xFF0E) || (c == 0x0020) || // nakaguro, ' '
            (c >= 0x0030  &&  c <= 0x0039) || // '0' - '9'
            (c >= 0x0041  &&  c <= 0x005A) || // 'A' - 'Z'
            (c >= 0x0061  &&  c <= 0x007A) || // 'a' - 'z'
            (c == 0x0028) || (c == 0x0029) || // '('   ')'
            (c == 0x002C) || (c == 0x002E) || // ','   '.'
            (c == 0x0026) || (c == 0x002D) || // '&'   '-'
            (c == 0xFF0D) || (c == 0xFF06) || // full-width hypen and ampersand
            (c == 0xFF08) || (c == 0xFF09) || // full-width parenthesis
            (c == 0x3000))                    // full-width space
            continue;

        return(false);
    }

    return(true);
}

// ----------------------------------------------------------------------------

function submenu(code, items)
{
    this.code  = code;
    this.items = items;
}

// ----------------------------------------------------------------------------

function subitem(code, name)
{
    this.code = code;
    this.name = name;
}

// ----------------------------------------------------------------------------

function field_data(int_msg, reqd_msg, not_complete_msg, oversz_msg,
                    ascii_msg, email_msg, furigana_msg,
                    mon_lbl, day_lbl, yr_lbl, hr_lbl, min_lbl,
                    email_expr, date_order, no_html_msg, pos_int_msg)
{
    this.int_msg          = int_msg;
    this.reqd_msg         = reqd_msg;
    this.not_complete_msg = not_complete_msg;
    this.oversz_msg       = oversz_msg;
    this.ascii_msg        = ascii_msg;
    this.email_msg        = email_msg;
    this.furigana_msg     = furigana_msg;
    this.no_html_msg      = no_html_msg;    
    this.pos_int_msg      = pos_int_msg;
    
    // can't do a cfg_get in javascript, so store it in a javascript variable
    switch (date_order) 
    {
    case 0: // American
        this.dt_lbl     = new Array(mon_lbl, day_lbl, yr_lbl, hr_lbl, min_lbl);
        this.dt_sfx     = new Array('_mon', '_day', '_yr');
        break;
    case 1: // Japanese
        this.dt_lbl     = new Array(yr_lbl, mon_lbl, day_lbl, hr_lbl, min_lbl);
        this.dt_sfx     = new Array('_yr', '_mon', '_day');
        break;
    case 2: // European
        this.dt_lbl     = new Array(day_lbl, mon_lbl, yr_lbl, hr_lbl, min_lbl);
        this.dt_sfx     = new Array('_day', '_mon', '_yr');
        break;
    }

	email_expr = email_expr.replace(/^\s+|\s$/g,''); // trim any return characters or whitespace
    this.email_expr = new RegExp(email_expr ? email_expr : '.*');
}

// ----------------------------------------------------------------------------

function field(name, label, type, maxlen, flags)
{
    this.name   = name;
    this.label  = label;
    this.type   = type;
    this.maxlen = maxlen;

    // flags is a bitmask:
    //  0x0001  required
    //  0x0002  ascii only
    //  0x0004  must match email pattern
    //  0x0008  cannot contain HTML
    //  0x0010  valid furigana characters only
    //  0x0020  cannot contain < >
    //  0x0040  int must be greater than 0
    //  0x0080  field is a checkbox (unselected value doesn't show in post params)
    this.flags  = flags;
}

// ----------------------------------------------------------------------------

function _upd_submenu(menu, submenu, submenu_data, all_str)
{
    var i, j = 1, sz;

    submenu.length = 0;

    submenu.options[0]       = new Option();
    submenu.options[0].text  = all_str;
    submenu.options[0].value = '';

    for (i = 0, sz = submenu_data.length; i < sz; i++)
        if (submenu_data[i].code == menu.options[menu.selectedIndex].value)
        {
            for ( ; j <= submenu_data[i].items.length; j++)
            {
                submenu.options[j]       = new Option();
                submenu.options[j].text  = submenu_data[i].items[j-1].name;
                submenu.options[j].value = submenu_data[i].items[j-1].code;
            }

            break;
        }

    submenu.length        = j;
    submenu.selectedIndex = 0;
}

// ----------------------------------------------------------------------------

function _alp_onload(page, gridsort)
{
    if (document.grid)
    {
        if (document.grid.p_page)
            document.grid.p_page.selectedIndex = page - 1;
        if (document.grid.p_gridsort)
            document.grid.p_gridsort.value = gridsort;
    }
}

// ----------------------------------------------------------------------------

function _adp_print(url)
{
    window.open(url, 'print_answer', 'resizable,menubar,toolbar,scrollbars');
}

// ----------------------------------------------------------------------------

function _adp_email(url)
{
    window.open(url, 'email_answer', 'resizable,width=700,height=392');
}

// ----------------------------------------------------------------------------
// CDT_DATE and CDT_DATETIME components are processed as individual CDT_MENU
// fields

function _check_fields(form_name, fld_data, fields)
{
    var fld, i, j, numSet, str;
    var ws_exp      = new RegExp("(^\\s+|\\s*$)", "g");
    var strtok_exp  = new RegExp("%s");
    var numtok_exp  = new RegExp("%d");
    var valid_ascii = new RegExp("^[\x20-\x7e]+$");
    var no_html     = new RegExp("[<>]");
    
    with (fld_data) for (i = 0; (i < fields.length) && fields[i].type; i++)
    {
        if ((fields[i].type != 4) && (fields[i].type != 7))
            fld = eval('document.'+form_name+'.'+fields[i].name);

        switch (fields[i].type)
        {
            case 1: // CDT_MENU
                if ((fields[i].flags & 1) &&
                    (fld.length > 1) && (fld.selectedIndex < 1))
                {
                    alert('\''+fields[i].label+'\' '+reqd_msg);
                    fld.focus();
                    return(false);
                }
                break;

            case 2: // CDT_BOOL
            case 8: // CDT_OPT_IN
                if ((fields[i].flags & 1) &&
                    !fld[0].checked && !fld[1].checked)
                {
                    alert('\''+fields[i].label+'\' '+reqd_msg);
                    fld[0].focus();
                    return(false);
                }
                break;

            case 3: // CDT_INT
                fld.value = fld.value.replace(ws_exp, '');
                if (fld.value.length && isNaN(fld.value))
                {
                    alert('\''+fields[i].label+'\' '+int_msg);
                    fld.focus();
                    return(false);
                }
                if (fields[i].flags & 0x40 && fld.value < 0)
                {
                    alert('\''+fields[i].label+'\' '+pos_int_msg);
                    fld.focus();
                    return(false);                     
                }

                // deliberate drop through

            case 5: // CDT_VARCHAR
            case 6: // CDT_MEMO
                if (fields[i].maxlen && (fields[i].maxlen < fld.value.length))
                {
                    str = oversz_msg.replace(strtok_exp, fields[i].label);
                    str = str.replace(numtok_exp, fields[i].maxlen);
                    str = str.replace(numtok_exp,
                                      fld.value.length - fields[i].maxlen);

                    alert(str);
                    fld.focus();
                    return(false);
                }

                if (fields[i].type != 3)
                    fld.value = fld.value.replace(ws_exp, '');

                if ((fields[i].flags & 1) && (fld.value.length == 0))
                {
                    alert('\''+fields[i].label+'\' '+reqd_msg);
                    fld.focus();
                    return(false);
                }

                // if not required and not set, don't do checks
                if ((fld.value.length == 0))
                    break;

                if ((fields[i].flags & 2) && !valid_ascii.test(fld.value))
                {
                    alert('\''+fields[i].label+'\' '+ascii_msg);
                    fld.focus();
                    return(false);
                }

                if ((fields[i].flags & 4) && !email_expr.test(fld.value))
                {
                    alert('\''+fields[i].label+'\' '+email_msg);
                    fld.focus();
                    return(false);
                }

                if ((fields[i].flags & 0x10) && !is_furigana_string(fld.value))
                {
                    alert('\''+fields[i].label+'\' '+furigana_msg);
                    fld.focus();
                    return(false);
                }
                
                if (fields[i].flags & 0x20 && no_html.test(fld.value))
                {
                    alert('\''+fields[i].label+'\' '+ no_html_msg);
                    fld.focus();
                    return(false);
                }
                
                break;


            case 4: // CDT_DATETIME
            case 7: // CDT_DATE
                fld = new Array();

                fld[0] = eval('document.'+form_name+'.'+fields[i].name+dt_sfx[0]);
                fld[1] = eval('document.'+form_name+'.'+fields[i].name+dt_sfx[1]);
                fld[2] = eval('document.'+form_name+'.'+fields[i].name+dt_sfx[2]);

                if (fields[i].type == 4)
                {
                    fld[3] = eval('document.'+form_name+'.'+fields[i].name+'_hr');
                    fld[4] = eval('document.'+form_name+'.'+fields[i].name+'_min');
                }

                if (!(fields[i].flags & 1))  // not required
                {
                    for (j = numSet = 0; j < fld.length; j++)
                        numSet += (fld[j].selectedIndex > 0) ? 1 : 0;

                    if ((numSet > 0) && (numSet != fld.length))
                    {
                        // field is only partially filled out
                        alert('\''+fields[i].label+'\' '+not_complete_msg);
                        fld[0].focus();
                        return(false);
                    }

                    break;
                }

                for (j = 0; j < fld.length; j++)
                    if ((fld[j].selectedIndex < 1))
                    {
                        alert('\''+fields[i].label+' ('+dt_lbl[j]+')\' '+reqd_msg);
                        fld[j].focus();
                        return(false);
                    }

                break;
        }
    }

    return(true);
}

// ----------------------------------------------------------------------------

function _validate_acctinfo(userid, passwd1, passwd2, min_passwd_len, msgs)
{
    var msg = -1, fld;

    if (userid.value.indexOf(' ') != -1)
         msg = 0, fld = userid;

    if (userid.value.indexOf('\"') != -1)
         msg = 1, fld = userid;

    if (passwd1 && (passwd1.value != passwd2.value))
         msg = 2, fld = passwd1;

    if (passwd1 && (passwd1.value.length < min_passwd_len))
        msg = 3, fld = passwd1;

    if (msg != -1)
    {
        alert(msgs[msg]);
        fld.focus();
        fld.select();
        return(false);
    }

    return(true);
}

// ----------------------------------------------------------------------------

var cursor_set = false;

function _set_cursor()
{
    var i, j;

    if (cursor_set)
        return;

    cursor_set = true;

    if (document.location.href.indexOf('#') > -1)
        return;

    for (i = 0; i < document.forms.length; i++)
        for (j = 0; j < document.forms[i].length; j++)
           with (document.forms[i])
               if (elements[j].type && ((elements[j].type == 'text') || (elements[j].type == 'textarea')))
               {
                   elements[j].focus();
                   if (elements[j].value.length)
                       elements[j].select();
                   return;
               }
}

// ----------------------------------------------------------------------------
 
function check_mask(mask_fld)
{
    var i, ln, js_msg = '';
    var val = '', code = '', echar = '', fchar = '';
 
    if (mask_fld.value == eval(mask_fld.name+'_dmask'))
        return;

    if (eval(mask_fld.name + '_emask.length') < mask_fld.value.length)
        js_msg = "Field contains too many characters";
    else        
        for (i = 0, ln = eval(mask_fld.name + '_emask.length'); i < ln; i++)
        {

            val = mask_fld.value.charAt(i);
            code = mask_fld.value.charCodeAt(i);
            echar = eval(mask_fld.name + '_emask.charAt(i)');
            fchar = eval(mask_fld.name + '_fstr.charAt(i)');

            if (fchar == 'F' && val != echar)
            {
                if (val == ' ')
                    js_msg = 'Must contain a valid format character.';
                else
                    js_msg = val + ' is not a valid format character.';
                break;
            }    
            else if ((echar == '#') &&
                (!((code >= 48) && (code <= 57))))
            {
                if (val == '')
                    js_msg = 'Must contain a valid number.';
                else
                    js_msg = val + ' is not a valid number.';
                break;
            }
            else if ((echar == 'A') &&
                    (!(((code >= 48) && (code <= 57)) || 
                      ((code >= 65) && (code <= 90)) ||
                      ((code >= 97) && (code <= 122)))))
            {
                if (val == '')
                    js_msg = 'Must contain a valid alpha-numeric.';
                else            
                    js_msg = val + ' is not a valid alpha-numeric.';
                break;
            }
            else if ((echar == 'L') &&
                    (!(((code >= 65) && (code <= 90)) || 
                      ((code >= 97) && (code <= 122)))))
            {
                if (val == '')
                    js_msg = 'Must contain a valid letter.';
                else
                    js_msg = val + ' is not a valid letter.';
                break;
            }
            else if ((echar == 'C') &&
                    (!(((code >= 32) && (code <= 126)) || 
                     ((code >= 128) && (code <= 255)))))
            {
                if (val == '')
                    js_msg = 'Must contain a valid character.';
                else
                    js_msg = val + ' is not a valid character.';
                break;
            }
        }
    
    if (js_msg)
    {
        alert(js_msg+'\n\nThe correct format is '+eval(mask_fld.name+'_dmask')+ '.');
        mask_fld.focus();
        return(false);
    }
    return(true);
}

// ----------------------------------------------------------------------------

function put_mask(mask_fld, val, formelm, nn)
{
    var mtmp = '', ftmp = '', dtmp = '';
    var i, sl;   

    for (i = 0, sl = val.length; i < sl; i++)
    {
        ftmp += val.charAt(i);

        if (val.charAt(i) == 'F')
            dtmp += val.charAt(i+1);
        else
            dtmp += (val.charAt(i+1) == '#') ? '#' : '@';

        mtmp += val.charAt(++i);

    }
    if (!nn)  
        eval("document.getElementById('"+mask_fld+"_mask').innerHTML='"+dtmp+"'");

    eval(mask_fld + '_fstr = ftmp');
    eval(mask_fld + '_emask = mtmp');
    eval(mask_fld + '_dmask = dtmp');

}

// ----------------------------------------------------------------------------

function answer_window_preview(ansid, created)
{
    var agt=navigator.userAgent.toLowerCase();
	var is_major = parseInt(navigator.appVersion);
	var is_nav  = ((agt.indexOf('mozilla')!=-1) && (agt.indexOf('spoofer')==-1)
        && (agt.indexOf('compatible') == -1) && (agt.indexOf('opera')==-1)
        && (agt.indexOf('webtv')==-1) && (agt.indexOf('hotjava')==-1));
    var query_str = location.search.substring(1);
    var pairs = query_str.split('&');
    var args = new Object( );
    var pos = 0;
    var argname = '';
    var value = '';
    var i = 0;

    for (i = 0; i < pairs.length; i++)
    {
        pos = pairs[i].indexOf('=');
        if (pos == -1)
            continue;
        argname = pairs[i].substring(0, pos);
        value = pairs[i].substring(pos + 1);
        args[argname] = unescape( value );
    } // end for i loop

	// Check browser version numbers.
	// Netscape version 6+ uses is_major == 5, previous versions < 5
	if(is_nav && (is_major < 5))
    {
		h_size = top.innerWidth;
		v_size = top.innerHeight;
	}
	// Netscape version	6+
	else if(is_nav && (is_major < 7))
	{
		h_size = document.body.offsetWidth;
		v_size = document.body.offsetHeight;
	}
	// All others (including IE)
	else
	{
		h_size = document.body.clientWidth;
		v_size = document.body.clientHeight;
	}

    h_size -= 20;
    v_size = Math.floor(v_size * 0.8);

    if (v_size < 200)
        v_size = 200;

    window.open('popup_adp.php?p_sid=' + args.p_sid + '&p_lva=' + args.p_lva +
                '&p_li=' + args.p_li + '&p_faqid=' + ansid + '&p_created=' +
                created + '&p_sp=' + args.p_sp, 'suggested_answer',
                'scrollbars,resizable,toolbar,menubar,width=' + h_size +
                ',height=' + v_size);
}

// ----------------------------------------------------------------------------
function check_valid_ascii(fld, valid_ascii_msg)
{
    var valid_ascii = new RegExp("^[\x0a\x0d\x20-\x7e]+$");
    if (fld.value.length > 0 && valid_ascii.test(fld.value) == false)
    {
        alert(valid_ascii_msg);
        fld.focus();
    }
}
