/*
   The purpose of below JavaScript code is to provide a drop-down menu functionality
   that is supposed to replace two text boxes. It will provide all IRS.gov site and
   Forms & Pubs collections. In addition, some IRS.goc collections are inlucded in a
   menu, such as Individulas or Buisnesses.
   Name: Mikhail Podolski
   Date: 10/14/2004
*/
  //These arrays provide correspondance betweev IRS.gov collections and menu option names.
  var selectedValues = new Array ("0","1","2","3","4","5","6","7","8","9");
  var advancedChoices = new Array ("Individuals","Businesses","\"Charities & Non-Profits\"","\"Government Entities\"","\"Tax Professionals\"",
  "\"Internal Revenue Manual\"","\"Frequently Asked Questions\"","\"Tax Stats\"","\"e-file\"");

  // Function unsetAll manages to reset values of all HTML seek1 form fields
  function unsetAll()
  {
    formLen=document.seek1.elements.length;
    for (index=0;index<formLen;index++)
    {
      formKey = document.seek1.elements[index].name;
      formValue = document.seek1.elements[index].value;

      if (formKey=="criterias" || formKey=="qt" || formKey=="Go") continue;
      if ( isNaN(formValue) != true )
      {
        document.seek1.elements[index].value="0";
        continue;
      }
      document.seek1.elements[index].value="";
    }

  }

  //Function setDefault manages to set HTML seek1 form fields for IRS.gov or Forms & Pubs general collections
  function setDefault()
  {
    document.seek1.elements["charset"].value="utf-8";
    document.seek1.elements["ht"].value="0";
    document.seek1.elements["qp"].value="";
    document.seek1.elements["qs"].value="";
    document.seek1.elements["qc"].value="";
    document.seek1.elements["pw"].value="100%";
    document.seek1.elements["ws"].value="0";
    document.seek1.elements["la"].value="en";
    document.seek1.elements["qm"].value="0";
    document.seek1.elements["st"].value="1";
    document.seek1.elements["nh"].value="10";
    document.seek1.elements["lk"].value="1";
    document.seek1.elements["rf"].value="0";
    document.seek1.elements["oq"].value="";
    document.seek1.elements["rq"].value="0";
    document.seek1.elements["si"].value="0";
  }

  //Function setDefault manages to set HTML seek1 form fields for IRS.gov advanced collections
  function setAdvanced()
  {
    document.seek1.elements["nh"].value="10";
    document.seek1.elements["qc"].value="";
    document.seek1.elements["pw"].value="100%";
    document.seek1.elements["st"].value="1";
    document.seek1.elements["charset"].value="utf-8";
    document.seek1.elements["la"].value="en";

 }


  /* chooseCollections is the main function
     1. Resets al values
     2. Sets method to to get so that the query string would be visible
     3. Sets action string for IRS.gov if the menu value is IRS.gov
     4. Sets action string for Forms & Pubs if the menu value is Forms & Pubs
     5. Sets action string for IRS.gov advanced collections if the menu value anything other than IRS.gov and Forms & Pubs
  */
  function chooseCollection()
  {
     
     unsetAll();
     document.seek1.method="GET";

     if ( document.seek1.criterias.value == "1a" )
     {
          setDefault();
          document.getElementById('Col1').value="irsweb";
          document.seek1.elements["qp"].value='collection:irsweb, -Wct:"Internal Revenue Manual"';
          document.seek1.action='http://search.irs.gov/web/query.html';
     }

     else if ( document.seek1.criterias.value == "1b" )
     {

          setDefault();
          document.getElementById('Col1').value="catfoin";
          document.getElementById('Col2').value="catpub";
          document.getElementById('Col3').value="catnote";
          document.seek1.action='http://search.irs.gov/pub/query.html';

     }
     else
     {

        /*
         selected = document.seek1.criterias.value;
         arValue = selectedValues[ parseInt( selected) ];
         setAdvanced();
         document.seek1.elements["chkbox"+arValue].value="1";
         document.getElementById('Col1').value="irsweb";
         document.seek1.elements["qp"].value='Wct:'+advancedChoices[ parseInt( selected) ];
         document.seek1.action='http://search.irs.gov/web/query.html';
        */
     }
  }



