

//============================================================================
// Constants = Values that are dependent on other settings
var TRUE = 0;
var FALSE = 1;

var MENUBAR_ID = "MENUBAR";
var MENUBARITEM_ID = "MENUBARITEM";
var MENUBAR_GRAPHIC = "MENUBARGRAPHIC";

//============================================================================
// Global variables and their defaults
var g_strMenuBarGraphicsDir = "";
var g_fPageLoad = TRUE;

//============================================================================
// Functions to be called during the program

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
window.onresize = reloadPage;
window.onload = loadPage;

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function reloadPage()
{
	// Only in NS
	if( !document.all  )
	{
		// Only in version 4.1 and less; dont reload after a load
		if( (g_fPageLoad == FALSE) && ( (parseFloat( navigator.appVersion )) < 4.1 ) )
			location.reload();
		if( (parseFloat( navigator.appVersion ) >= 4.1) )
			location.reload();
		
		// Reset flag
		g_fPageLoad = FALSE;
	}
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function loadPage()
{
	// Needed for 4.1 and less browsers to stop reload after load but permit load after reload
	g_fPageLoad = TRUE;
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function createMenuBar()
{
	// Setup the menu container
	if( !this.MenuBarContainer )
		this.MenuBarContainer = new createMenuBarObject();
	return this.MenuBarContainer;
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function initMenuBarGraphics( a_strMenuBarGraphicsDir )
{
	g_strMenuBarGraphicsDir = a_strGraphicsDir;
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function createMenuBarObject()
{
	this.menuBarItems = new Array();		// List of menu bar items
	this.addMenuBarItem = addMenuBarItem;   // Add a menuitem to this object function	
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function createMenuBarItem( a_strText, a_strAction )
{
	this.PopMenu;							 // Pop menu associated with this menubar
	this.Text = a_strText;					 // Text for this menu item
	this.Action = a_strAction;
	this.ImageOn = new Image();				 // Image when item is active
	this.ImageOff = new Image();			 // Image when item is inactive
	this.ItemImage = null;					
	this.ItemIndex = 0;
	
	this.setImageOn = setImageOn;			 // Function to turn on image
	this.setImageOff = setImageOff;			 // Function to turn off image
	this.setPopMenu = setPopMenu;			 // Function to set the associated pop up menu
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function addMenuBarItem( a_strText, a_strAction )
{
	this.menuBarItems[ this.menuBarItems.length ] = new createMenuBarItem( a_strText, a_strAction );
	return this.menuBarItems[ this.menuBarItems.length - 1];
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function setImageOn( a_strGraphicSrc )
{
   this.ImageOn.src = a_strGraphicSrc;
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function setImageOff( a_strGraphicSrc )
{
	this.ImageOff.src = a_strGraphicSrc;
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function setPopMenu( a_PopMenu )
{
	this.PopMenu = a_PopMenu;
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function initMenuBar()
{
	writeMenuBarHTML();
	posMenuBarItems();
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function writeMenuBarHTML()
{
	// Create the menu bars in the list
	var strOutput = "";

	// Get the menu to be created
	var menuBarCurrent = this.MenuBarContainer;
		
	// Loop through the menu items
	for( var nItemIndex = 0; nItemIndex < menuBarCurrent.menuBarItems.length; nItemIndex++ )
	{
		// Get the menubar item being worked on
		var menuBarItem = menuBarCurrent.menuBarItems[ nItemIndex ];
			
		// Check if an image or label is used
		strOutput += '<A HREF="' + menuBarItem.Action + '" onMouseOver="menuBarItemMouseOver( window.MenuBarContainer.menuBarItems[' + nItemIndex + '] )" onMouseOut="menuBarItemMouseOut( window.MenuBarContainer.menuBarItems[' + nItemIndex + '] )"><IMG NAME="' + MENUBAR_GRAPHIC + nItemIndex + '" ALT="" BORDER="0" SRC="' + menuBarItem.ImageOff.src + '"></A>';
	}
				
	// Output the menubar
	document.write( strOutput );
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function posMenuBarItems()
{
	// Get the menu 
	var menuBarCurrent = this.MenuBarContainer;

	// Loop through the menu items
	for( var nItemIndex = 0; nItemIndex < menuBarCurrent.menuBarItems.length; nItemIndex++ )
	{
		// Get the menu item
		var menuBarImg;
		if( document.all )
			menuBarImg = this.document.images[ MENUBAR_GRAPHIC + nItemIndex ];
		else
			menuBarImg = document.images[ MENUBAR_GRAPHIC + nItemIndex ];
			
		// Hook into the menu system
		menuBarCurrent.menuBarItems[ nItemIndex ].ItemImage = menuBarImg;
		menuBarCurrent.menuBarItems[ nItemIndex ].ItemIndex = nItemIndex;
	}
}


/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function menuBarItemMouseOver( a_MenuItem )
{
	a_MenuItem.ItemImage.src = a_MenuItem.ImageOn.src;
	if( document.all )
	{
		var nLeft = 0;
		var nTop = 0;
		var fParentExists = true;
		var CurrentObject = a_MenuItem.ItemImage;
		while( fParentExists )
		{
			nLeft += CurrentObject.offsetLeft;
			nTop += CurrentObject.offsetTop;
			if( CurrentObject.offsetParent.tagName != "BODY" )
				CurrentObject = CurrentObject.offsetParent;
			else
				fParentExists = false;
		}
		showPopMenu( a_MenuItem.PopMenu, nLeft, nTop + a_MenuItem.ItemImage.height );
	}
	else
		showPopMenu( a_MenuItem.PopMenu, a_MenuItem.ItemImage.x, a_MenuItem.ItemImage.y + a_MenuItem.ItemImage.height );
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function menuBarItemMouseOut( a_MenuItem )
{
	a_MenuItem.PopMenu.closeWindow = TRUE;	
	setTimeout( 'deactivateImage( window.MenuBarContainer.menuBarItems[' + a_MenuItem.ItemIndex + '] )', 50 );
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function deactivateImage( a_MenuItem )
{
	if( a_MenuItem.PopMenu.closeWindow == TRUE )
	{
		a_MenuItem.ItemImage.src = a_MenuItem.ImageOff.src;
		hidePopMenu( a_MenuItem.PopMenu );
	}
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
function hidePopMenuCallBack( a_popMenu )
{
	// Loop through the menu items
	for( var nItemIndex = 0; nItemIndex < this.MenuBarContainer.menuBarItems.length; nItemIndex++ )
	{
		// Hook into the menu system
		if( this.MenuBarContainer.menuBarItems[ nItemIndex ].PopMenu.Text == a_popMenu.Text )
			this.MenuBarContainer.menuBarItems[ nItemIndex ].ItemImage.src = this.MenuBarContainer.menuBarItems[ nItemIndex ].ImageOff.src;
	}
}

