addEvent( window, 'load', load );
var popupDelayID;
var timerID;

function load() {
	inMenu = false;
	body = document.getElementsByTagName( "body" )[0];
	lastMenuItem = null;

	//just a quick test to see if the menu IDs are set or not.. testing only using one of them.
	//intermediate jump pages in the forums will return as menus are not present ;)
	if( getNode( "home" ) == null ) return;

	var xhome     = new MenuItemsParent( getNode( "home" ));
	var customize = new MenuItemsParent( getNode( "customize" ));
	var forums    = new MenuItemsParent( getNode( "forums" ));
	var journals  = new MenuItemsParent( getNode( "journals" ));
	var fans      = new MenuItemsParent( getNode( "fans" ));
	var openweb   = new MenuItemsParent( getNode( "openweb" ));
	var dev       = new MenuItemsParent( getNode( "dev" ));
	//var comics    = new MenuItemsParent( getNode( "comics" ));
	//var portal    = new MenuItemsParent( getNode( "portal" ));
	
	xhome.addMenuItem( new MenuItem( "Sign up", "/community/signup/" ) );
	xhome.addMenuItem( new MenuItem( "My Account", "/community/account/" ) );
	xhome.addMenuItem( new MenuItem( "My Journal", "/community/journals/edit.pl?action=viewJournal" ) );
	xhome.addMenuItem( new MenuItem( "Upload files", "/community/upload/" ) );
	xhome.addMenuItem( new MenuItem( "Log out", "/community/login/index.pl?logout=true" ) );
	xhome.createMenu();

	customize.addMenuItem( new MenuItem( "Tips &amp; Tricks", "/community/tips/" ) );
	//customize.addMenuItem( new MenuItem( "&nbsp;&bull;&nbsp;Opera Mail Filters", "/community/tips/filterguide/" ) );
	
	customize.addMenuItem( new MenuItem( "Language files", "/community/customize/langs/" ) );
	customize.addMenuItem( new MenuItem( "Panels", "/community/customize/panel/" ) );
	customize.addMenuItem( new MenuItem( "Skins:" ) );
	customize.addMenuItem( new MenuItem( "Editor's picks", "/community/customize/skins/index.pl?show=rec" ) );
	customize.addMenuItem( new MenuItem( "Most popular", "/community/customize/skins/index.pl?show=pop" ) );
	customize.addMenuItem( new MenuItem( "Newest skins", "/community/customize/skins/index.pl?show=new" ) );
	customize.addMenuItem( new MenuItem( "Setups:" ) );
	customize.addMenuItem( new MenuItem( "Toolbars", "/community/customize/setups/index.pl?show=toolbars" ) );
	customize.addMenuItem( new MenuItem( "Menus", "/community/customize/setups/index.pl?show=menus" ) );
	customize.addMenuItem( new MenuItem( "Mouse gestures", "/community/customize/setups/index.pl?show=mouse" ) );
	customize.addMenuItem( new MenuItem( "Keyboard shortcuts", "/community/customize/setups/index.pl?show=keyboard" ) );
	customize.addMenuItem( new MenuItem( "Themes:" ) );
	customize.addMenuItem( new MenuItem( "Nokia 6600/7610", "/community/customize/skins/?appAndVersion=Nokia+6600%2F7610" ) );
	customize.addMenuItem( new MenuItem( "SE P900", "/community/customize/skins/?appAndVersion=SE+P900" ) );
	customize.createMenu();
	
	
	forums.addMenuItem( new MenuItem( "Opera Information", "/forums/forumdisplay.php?forumid=39" ) );
	forums.addMenuItem( new MenuItem( "Opera Topics", "/forums/forumdisplay.php?forumid=25" ) );
	forums.addMenuItem( new MenuItem( "Opera Platforms", "/forums/forumdisplay.php?forumid=1" ) );
	forums.addMenuItem( new MenuItem( "Off-topic", "/forums/forumdisplay.php?forumid=33" ) );
	forums.addMenuItem( new MenuItem( "Smartphones/PDA", "/forums/forumdisplay.php?forumid=73" ) );
	forums.addMenuItem( new MenuItem( "Opera languages", "/forums/forumdisplay.php?forumid=59" ) );
	forums.addMenuItem( new MenuItem( "Shortcuts:" ) );
	forums.addMenuItem( new MenuItem( "New posts", "/forums/search.php?&action=getnew" ) );
	forums.addMenuItem( new MenuItem( "Today's posts", "/forums/search.php?&action=getdaily" ) );
	forums.addMenuItem( new MenuItem( "Search", "/forums/search.php" ) );
	forums.addMenuItem( new MenuItem( "Private messages", "/forums/private.php" ) );
	forums.addMenuItem( new MenuItem( "Control panel", "/forums/usercp.php" ) );
	forums.addMenuItem( new MenuItem( "<acronym>FAQ</acronym>", "/forums/faq/" ) );
	forums.createMenu();

	journals.addMenuItem( new MenuItem( "Latest posts", "/community/journals/" ) );
	journals.addMenuItem( new MenuItem( "All journals", "/community/journals/edit.pl?action=all" ) );
	journals.addMenuItem( new MenuItem( "My journal:" ) );
	journals.addMenuItem( new MenuItem( "View", "/community/journals/edit.pl?action=viewJournal" ) );
	journals.addMenuItem( new MenuItem( "Add a post", "/community/journals/edit.pl?action=addPost" ) );
	journals.addMenuItem( new MenuItem( "Edit/delete posts", "/community/journals/edit.pl?action=managePosts" ) );
	journals.addMenuItem( new MenuItem( "Journal settings", "/community/journals/edit.pl?action=editSettings" ) );
	journals.addMenuItem( new MenuItem( "<acronym>FAQ</acronym>", "/community/journals/faq/" ) );
	journals.createMenu( );

	fans.addMenuItem( new MenuItem( "Fan photos", "/community/photos/" ) );
	fans.addMenuItem( new MenuItem( "Fan sites", "/community/fans/links/" ) );
	fans.addMenuItem( new MenuItem( "Newsletter", "/community/newsletter/" ) );
	fans.addMenuItem( new MenuItem( "Accessories store", "/community/operastore/" ) );
	fans.addMenuItem( new MenuItem( "Opera graphics:" ) );
	fans.addMenuItem( new MenuItem( "Banners & buttons", "/community/gfx/banners/" ) );
	fans.addMenuItem( new MenuItem( "Opera Show", "/community/gfx/operashow/" ) );
	fans.addMenuItem( new MenuItem( "Wallpapers", "/community/gfx/wallpapers/" ) );
	fans.addMenuItem( new MenuItem( "Opera in:" ) );
/* 	fans.addMenuItem( new MenuItem( "Your School", "/community/school/" ) ); */
	fans.addMenuItem( new MenuItem( "Websites", "/community/linkexchange/" ) );
	fans.addMenuItem( new MenuItem( "Magazines", "/community/magazines/" ) );
	fans.addMenuItem( new MenuItem( "Internet Caf&#233;s", "/community/cafe/" ) );
	fans.createMenu( );
	
	openweb.addMenuItem( new MenuItem( "Help Opera", "/community/openweb/" ) );
	openweb.addMenuItem( new MenuItem( "Why open the Web?", "/community/openweb/info/" ) );
	openweb.addMenuItem( new MenuItem( "Forum", "/forums/forumdisplay.php?forumid=29" ) );
	openweb.createMenu();
	
	dev.addMenuItem( new MenuItem( "Designing for Mobile", "/community/dev/device/" ) );
	dev.addMenuItem( new MenuItem( "&nbsp;&bull;&nbsp;Netmeeting", "/community/netmeetings/designmobile/" ) );
	dev.addMenuItem( new MenuItem( "Opera Show Center", "/community/dev/operashow/" ) );
	dev.addMenuItem( new MenuItem( "Netmeetings", "/community/netmeetings/" ) );
	dev.addMenuItem( new MenuItem( "How to make a skin", "/community/dev/skin/" ) );
	dev.addMenuItem( new MenuItem( "Articles by users", "/community/articles/" ) );
	dev.addMenuItem( new MenuItem( "Much More...", "/community/dev/" ) );
	dev.createMenu( );
}


function MenuItemsParent ( node ) {
	this.node = node;
	this.menuItems = new Array();
	
	MenuItemsParent.prototype.addMenuItem = function( menuItem ) {
		this.menuItems[ this.menuItems.length ] = menuItem;	
	}
	
	MenuItemsParent.prototype.createMenu = function( ) {
		var divNode = document.createElement( "div" );
		
		divNode.className = "jsMenu";

		var str = "_" + this.node.id;
		divNode.setAttribute( "id", str );
		//must initialize values once so they don't display extra whitespace at the bottom of screen.
		var w = this.node.offsetWidth;
		divNode.style.width = w > 135 ? w+"px" : "135px";
		divNode.style.top = ( this.node.offsetTop + this.node.offsetHeight ) + "px";
		divNode.style.left = this.node.offsetLeft + "px";

		addEvent( this.node, "mouseover", function() { showMenuInTime(str, 250) } );
		addEvent( this.node, "mouseout", function() { setInMenu(false) } );

		divNode.setAttribute( "parentItemID", this.node.id );
		addEvent( divNode, "mouseover", function() { setInMenu(true) } );
		addEvent( divNode, "mouseout", function() { setInMenu(false) } );

		var html = "<ul>";
		for( var i=0; i<this.menuItems.length; i++ ) {
			html += this.menuItems[i].getLinkHTML();
		}
		divNode.innerHTML = html + "</ul>";
		
		body.appendChild( divNode );

				
		//need to place arrow due to popular demand ;)
		var imgNode = document.createElement( "img" );
		imgNode.setAttribute( "alt", "" );
		imgNode.className = "arrow";

		//add img to this.node, NOT to its hyperlink (firstChild) as other browsers have problems with that. :(
		this.node.appendChild( imgNode );
		
		/*the above would've been really easy like this.. but current html markup prevents that :(
		this.node.className = "arrow";
		*/

	}

}

function MenuItem( value, href ) {
	this.value = ( value == null ) ? "" : value;
	this.href = ( href == null ) ? "" : href;

	if( this.href!="" && this.href.indexOf( "http://" ) < 0 ) {
		if( window.location.href.indexOf( "http://my.opera.com" ) != 0 && window.location.href.indexOf("is.oslo")<0 ) 
			this.href = "http://my.opera.com" + this.href;
	}

	MenuItem.prototype.getLinkHTML = function () {

		//if its a complete URL
		if( this.value != "" && this.href != "" ) {
			return "<li><a onclick=\"setInMenu(false); hideMenu(); return true;\" href=\"" + this.href + "\">" + this.value + "</a></li>";
		}
		
		//if its a sub header, no link
		else if( this.value != "" && this.href == "" ) {
			return "<li class='heading'>" + this.value + "</li>";
		}
		
		//if its a separator, no value, no href
		else {
			return "<li class='separator'>&nbsp;</li>";
		}
		
	}
}

function showMenuInTime( node, time ) {
	popupDelayID = setTimeout( "showMenu('" + node + "')", time );
}

function showMenu( node ) {
	clearTimeout( popupDelayID );
	if( typeof node == "string" )
		node = getNode( node );

	if( lastMenuItem != null && lastMenuItem != node ) {
		hideMenu( lastMenuItem );
	} else if( lastMenuItem == node ) {
		setInMenu( true );
		return;
	}

	node.style.display = "block";
	
	//Need to set this values dynamically when the menu is displayed!!
	var parentItem = getNode( node.getAttribute( "parentItemID" ) );
	
	var w = parentItem.offsetWidth;
	node.style.width = w > 135 ? w+"px" : "135px";
	node.style.top = ( parentItem.offsetTop + parentItem.offsetHeight ) + "px";
	node.style.left = parentItem.offsetLeft + "px";
	
	setClassName( parentItem.firstChild, "jsHover" );
	
	setInMenu( true );
	lastMenuItem = node;
	timerID = setTimeout( "hideMenu( lastMenuItem )", 500 );
}

function hideMenu( node ) {
	//node is null when called by menu item hyperlink onclick event
	if( node == null ) {
		setInMenu( false );
		hideMenu( lastMenuItem );
		return;
	}
	
	if( typeof node == "string" )
		node = getNode( node );

	if( !inMenu ) {
		node.style.display = "none";
		var parentItem = getNode( node.getAttribute( "parentItemID" ) );
		removeClassName( parentItem.firstChild, "jsHover" );
		lastMenuItem = null;
		clearTimeout( timerID );
	} else {
		timerID = setTimeout( "hideMenu( lastMenuItem )", 500 );	
	}
}

function setInMenu( value ) {
	inMenu = value;	
	if( !value ) clearTimeout( popupDelayID );
}


function addEvent( node, evtType, func ) {
	if( node.addEventListener ) {
		node.addEventListener( evtType, func, false );
		return true;
	} else if( node.attachEvent ) {
		return node.attachEvent( "on" + evtType, func );
	} else {
		return false;
	}
}


function getNode( nodeId ) {
	if( document.getElementById ) {
		return document.getElementById( nodeId );
	}
	else if( document.all && document.all( nodeId ) ) {
		return document.all( nodeId );
	}
	else if( document.layers && document.layers[ nodeId ] ) {
		return document.layers[ nodeId ];
	}
	else {
		return false;
	}
}


function setClassName( node, value ) {
	if( node == null ) return;
	if( " " + node.className + " " . indexOf( value ) >= 0 ) return;
	
	node.className += ( node.className.length==0 ? "" : " " ) + value;
}

function removeClassName( node, value ) {
	if( node == null ) return;
	//RegExp doesn't work well in IE :(
	//node.className =  node.className.replace( new RegExp( /^\s?jsHover\s?$/ ), "" );
	node.className =  node.className.replace( value, "" );
}