var hasChanged = 0;
var hostName = '.typepad.com';

function setCookie (name, value, expires) {
    document.cookie = name + '=' + escape(value) + '; expires=' + expires.toGMTString() + '; domain=' + hostName + '; path=/';
}

function getCookie (name) {
    var key = name + '=';
    var c = document.cookie;
    var i = c.indexOf(key);
    if (i < 0) return '';
    var j = c.indexOf(';', i + key.length);
    if (j < 0) j = c.length;
    return unescape(c.substring(i + key.length, j));
}

function deleteCookie (name) {
    if (getCookie(name))
        setCookie(name, '', new Date(70, 0, 1, 0, 0, 1));
}

function rememberMe (f) {
    var now = new Date();
    now.setTime(now.getTime() + 365 * 24 * 60 * 60 * 1000);
    setCookie('typepadauthor', f.author.value, now);
    setCookie('typepademail', f.email.value, now);
    setCookie('typepadurl', f.url.value, now);
}

function forgetMe () {
    deleteCookie('typepadauthor');
    deleteCookie('typepademail');
    deleteCookie('typepadurl');
}

function setFormValues (f) {
    var val = getCookie("typepadauthor");
    if(!f.author.value && val) f.author.value = val;
    val = getCookie("typepademail");
    if(!f.email.value && val) f.email.value = val;
    val = getCookie("typepadurl");
    if(!f.url.value && val) f.url.value = val;
}

function unsetFormValues (f) {
    f.author.value = '';
    f.email.value = '';
    f.url.value = '';
}

function handleSubmit (f) {
    if (f.bakecookie.checked)
        rememberMe(f);
    else
        forgetMe();
}

function handleCheck (e) {
    if (hasChanged) return;
    if (e.checked)
        setFormValues(e.form);
    else
        unsetFormValues(e.form);
}

function handleChange (e) {
    hasChanged = 1;
}

function doLoaded () {
    if (!document.comments_form) return;
    setFormValues(document.comments_form);
    if (document.comments_form.bakecookie && document.comments_form.author.value)
        document.comments_form.bakecookie.checked = 1;
}
onload = doLoaded;

var theForm;
var requestSubmitted = false;
function disableButton (e) {
    if (!requestSubmitted) {
        e.disabled = true;
        theForm = e.form;
        requestSubmitted = true;
        setTimeout('submitIt()', 250);
    } else {
        return false;
    }
}

function submitIt () {
    // make sure we're posting
    if(theForm.bakecookie) handleSubmit(theForm);
    theForm.submit();
    return false;
}
