// =====================================================================
//
// NetScooter (R)
//
// (C) 2004 - Bonus.com	
//
// =====================================================================


// ---------------------------------------------------------------------
// Property - Value parokat tartalamzo asszociativ tombot kezelo osztaly
// ---------------------------------------------------------------------
function Property()
{
    this._attrs = new Array();

    this.get = function(aname)
    {
        return this._attrs[aname];
    }

    this.set = function(aname, avalue)
    {
        this._attrs[aname] = avalue;
    }

    this.clear = function()
    {
		//this._attrs = new Array();
    }

}

// ---------------------------------------------------------------------
// URL-t osszereko osztaly
// ---------------------------------------------------------------------
function URL(aprog)
{
    this._query = "";
    this._delimiter = "?";
    this._prog = aprog;

    this.addNameValue = function(aname, avalue)
    {
        if (avalue)
        {
        	this._query += this._delimiter + aname + "=" + escape(avalue);
        	this._delimiter = "&";
        }
    }

    this.toString = function()
    {
        return this._prog + this._query;
    }

    this.clear = function()
    {
		this._query = "";
		this._delimiter = "?";
    }	
}
// ---------------------------------------------------------------------
// A reklamok ososztalya
// ---------------------------------------------------------------------
function BaseMedia()
{
    // Az AD demontol lekerendo url.
    
    this._url = new URL("/bonus_ad");

    this.setProp = function(aprop)
    {
        this._prop = aprop;
    }

    // Az AD demon url query resze.
    
    this.query = function()
    {
		this._url.clear();

		this._url.addNameValue("bonus2004",	"true");
        this._url.addNameValue("media",		this.media);
        this._url.addNameValue("index",		this._prop.get("index"));
		this._url.addNameValue("pos",		this._prop.get("id"));
        this._url.addNameValue("id",		ID);
        this._url.addNameValue("code",		CODE);
        this._url.addNameValue("type",		registerType);
        this._url.addNameValue("from",		referrer);
        this._url.addNameValue("entry",		entry);
        this._url.addNameValue("reason",	reason);
	if(adOrder && adOrder!='') this._url.addNameValue("order", adOrder);
    }

    // Melyik az a  "document" objektum melyet valtoztatni kell?
    
    this.register = function(adocument)
    {
        this._doc = adocument;
    }

    // Osszerakjuk a queryt es lecsereljuk a documentumot
    
    this.rotate = function()
    {
		this.query();
        this.replace(this._url.toString());
    }  
    
    this.replace = function(aurl)
    {
    	// Win2000 + IE5.0 hack
    	if ("!"+this._doc+"!" != "!!")
    	{
    		this._doc.location.replace(aurl);
    	}
    } 
    
    // Itt van a helye az egyebb logolasnak
    // hiszen ide akkor jutunk ha a reklam mar ott vagyon
    // a cliens browseren
    
    this.impression = function(aretobj)
    {
        this._prop.set("index", aretobj.index);
    }
}

// ---------------------------------------------------------------------
// A szuperbanner amely a BaseMedia-bol szarmazik
// ---------------------------------------------------------------------
function SuperBanner(aprop)
{
    this.media = "superbanner";
    this.setProp(aprop);
}
SuperBanner.prototype = new BaseMedia;

// ---------------------------------------------------------------------
// A Skyscraper amely a BaseMedia-bol szramazik
// ---------------------------------------------------------------------
function Skyscraper(aprop)
{
    this.media = "trimedal";
    this.setProp(aprop);
}
Skyscraper.prototype = new BaseMedia;

// ---------------------------------------------------------------------
// A Cover amely a BaseMedia-bol szramazik
// ---------------------------------------------------------------------
function Cover(aprop)
{
    this.media = "cover";
    this.setProp(aprop);
}
Cover.prototype = new BaseMedia;

// ---------------------------------------------------------------------
// Reklamkiszolgalas
// registerMedia(aid, adocument)
//	az IFRAME-be betoltott lap igy regisztralja magat egy reklamra
//	aid - string "superbanner" | "skyscraper" | "cover"
//	adocument - az IFRAME-be betoltott lap documentja (ennek locationja cserelodik)
//
// impression(aid, aretobj)
//	AD Demon igy szol vissza
// ---------------------------------------------------------------------
function BaseNetScooter()
{
    this._sessiondata = new Property();
    this._pagedata = new Property();

    this._createMedia = function(aid)
    {
    	if (!this._sessiondata.get(aid))
        {
            this._sessiondata.set(aid, new Property());
        }
        
        // minden media property objektumaban szerepel a 
        // netscooter property objektum - global dolgok, uzenet kuldes
        
        this._sessiondata.get(aid).set("session", this._sessiondata);
        
        // a media megkapja az id-t is
        
        this._sessiondata.get(aid).set("id", aid);
        if (aid == "superbanner")
        {
            this._pagedata.set(aid, new SuperBanner(this._sessiondata.get(aid)));
        }
        else if (aid == "cover")
        {
            this._pagedata.set(aid, new Cover(this._sessiondata.get(aid)));
        }
        else 
        {
        	if (aid == "skyscraperwest" || aid == "skyscrapereast")
        	{
            	this._pagedata.set(aid, new Skyscraper(this._sessiondata.get(aid)));
        	}
        }
    }
    
    this._register = function(aid, adocument)
    {
    	if (this._pagedata.get(aid))
    	{
    		this._pagedata.get(aid).register(adocument);
    	}
    }
    
    this._rotate = function(aid)
    {
    	if (this._pagedata.get(aid))
    	{
    		this._pagedata.get(aid).rotate();
    	}
    }
    
    // Publikus eljarasok

    this.registerMedia = function(aid, adocument)
    {
        
        this._createMedia(aid);
        this._register(aid, adocument);
        this._rotate(aid);
    }
    
    this.replace = function(aid, aurl)
    {
    	if (this._pagedata.get(aid))
    	{
    		this._pagedata.get(aid).replace(aurl);
    	}
    }

    this.impressionMedia = function(aid, aretobj)
    {
		if (this._pagedata.get(aid))
        {
        	this._pagedata.get(aid).impression(aretobj);
		}
    }

    this.initPage = function()
    {
        this._pagedata.clear();
    }
    
    this.getMedia = function(aid)
    {
		return this._pagedata.get(aid);
    }
}

// ---------------------------------------------------------------------
// Singleton - csak egy peldany legyen a NetScooter-bol 
// Constructort nem hivunk!!!
// ---------------------------------------------------------------------
function NetScooter()
{
}
NetScooter.prototype = new BaseNetScooter;
NetScooter._instance = new NetScooter();

NetScooter.getInstance = function()
{
    return new NetScooterDecorator(NetScooter._instance);
}
NetScooter.getInstanceWithURL = function(asuperbannerURL, askyscraperwestURL, acoverURL, askyscrapereastURL)
{
	this.nsrb = new NetScooterRoadBlock(NetScooter._instance);

	this.nsrb._firstURL.set("superbanner",    asuperbannerURL);	
	this.nsrb._firstURL.set("skyscraperwest", askyscraperwestURL);	
	this.nsrb._firstURL.set("cover", acoverURL);	
	this.nsrb._firstURL.set("skyscrapereast", askyscrapereastURL);	

	return this.nsrb;
}

// ---------------------------------------------------------------------
// Specialis igenyekhez Decorator
// ---------------------------------------------------------------------
function NetScooterDecorator(arealNetScooter)
{
	this._netscooter = arealNetScooter;
    
    // A NetScooter publikus eljarasait "diszitjuk"
    
    this.registerMedia = function(aid, adocument)
    {
    	this._netscooter.registerMedia(aid, adocument);
    }
    this.replace = function(aid, adocument)
    {
    	this._netscooter.replace(aid, adocument);
    }
    this.impressionMedia = function(aid, aretobj)
    {
        this._netscooter.impressionMedia(aid, aretobj);
    }
    this.initPage = function()
    {
    	this._netscooter.initPage();
    }
    this.getMedia = function(aid)
    {
    	return this._netscooter.getMedia(aid);
    }
}

// ---------------------------------------------------------------------
// Road Block NetScooter amely a NetScooterDecorator osztalybol szarmazik
// ---------------------------------------------------------------------
function NetScooterRoadBlock(arealNetScooter)
{
	this._netscooter = arealNetScooter;
    this._firstURL = new Property();
    
    this.registerMedia = function(aid, adocument)
    {
    	this._netscooter._createMedia(aid);
        this._netscooter._register(aid, adocument);
        
        // Ha van indulo URL akkor azzal kezdunk
        // ha nincs akkor hivjuk a megszokott rotate eljarast.
        
        if (this._firstURL.get(aid) != "")
        {
        	this._netscooter.getMedia(aid).replace(this._firstURL.get(aid));
        }
        else
        {
        	this._netscooter.getMedia(aid).rotate();
        }	
    }

}
NetScooterRoadBlock.prototype = new NetScooterDecorator;
