<!--
/*******************
* 1998-2003 (mt) Media Temple, Inc. All Rights Reserved.
* 
* All code in this library was custom rolled in house.
*
* Author: David Bartle
*/
//-->

function RowHighlighter( tableIdName, highlightedClassName, eventList) {


	// initialize class variables
	this.containerId            = tableIdName;
	this.tableElement           = document.getElementById(tableIdName);
	this.highlightedClassName   = highlightedClassName;
	this.selectedRow;
	this.selectedRowOriginalClass;
	
	if( this.tableElement == null ) {
		return false;
	}
		
	// Note about copying this.
	// For some reason, browsers complain about using "this" from an anonymous function like
	// the one below.  I think it has something to do with a scoping change when
	// inside of an anonymous function. Thus you have to copt the "this" for use.
	var copyOfThis = this;	
	var action 	= 	function( e ) {
						if( e == null ) {
							e = this.tableElement.ownerDocument.parentWindow.event;
						}
						copyOfThis.mouseover(e);
					}
	
	// add a listener for onmouseover W3C compatable
	if (this.tableElement.addEventListener) {
		for( i=0; i< eventList.length; i++ ) {
			this.tableElement.addEventListener(eventList[i], action, false);
		}
	}
	// add a listener for onmouseover Microsoft IE compatable
	else if (this.tableElement.attachEvent) {
	    for( i=0; i< eventList.length; i++ ) {
			eventName = "on" + eventList[i];
			this.tableElement.attachEvent(eventName, action);
		}
	}
	
	return;
	
}

RowHighlighter.prototype.mouseover = function( e ) {
	
	// what node are we over?
	var el;
	if( e.target != null ) {
		el = e.target;
	}
	else {
		el = e.srcElement;
	}
	
	// Move up the tree to the first TAG type node that is not the TABLE parent
	while ( el != null && el.nodeType!=1 && el.parentNode!=this.tableElement ) {
		el = el.parentNode;
	}
	
	if(el == this.tableElement) {
		return false;
	}
	
	//alert("t");
	
	// get the row we are over
	rowEl = this.getCurrentRow(el);
	
	
	if( rowEl == null ) {
		return false;
	}
	
	// we're in the same row, do nothing
	if( rowEl == this.selectedRow ) {
		return false;
	}
	
	// return the currently highlighted row to its original form
	if( this.selectedRow ) {
		this.selectedRow.className = this.selectedRowOriginalClass;
	}
	
	// store the selected row element and its original class
	this.selectedRow              = rowEl;
	// store the selected row class
	this.selectedRowOriginalClass = rowEl.className;
	
	// highlight the current row
	rowEl.className = this.highlightedClassName;
	return;
	
}

RowHighlighter.prototype.getCurrentRow = function(el) {
	// cruise up to the TR tag
	//names = el.nodeName + " " + el.id + "\n";
	while ( el != null && el.parentNode.parentNode.id!=this.containerId && el.parentNode != null) {
		el = el.parentNode;
		//names = names + el.nodeName + " " + el.id + "\n";
	}	
	//alert(el.nodeName);
	
	return el;
}


