// ------------------------------------------------------------------------------------------------
// SPAC.JS (Generic Client) - Copyright (c) 2000-2001 Engage, Inc. All Rights Reserved.
//
// $Id: spac.js,v 1.11 2001/02/06 09:59:28 srehman Exp $
// ------------------------------------------------------------------------------------------------

var spac_adServer = "http://ads.whi.co.nz";
var spac_autoPageID = false;
var spac_pageID = spac_getUniqueValue();

// outputs adcall HTML tags
function spac_writeAd( aTargetParams )
{
    document.write( spac_getAdHTML( aTargetParams ) );
}

// returns adcall HTML tags as a String
function spac_getAdHTML( aTargetParams )
{
// ## testing
//    return ( "<a href='http://www.nzherald.co.nz' target='_new'><img src='http://203.99.65.60/defaults/invisible-ae0.gif' border='0'></a>" );
    var targetParams, adServer, method, frameWidth, frameHeight, frameTarget, i;

    targetParams = aTargetParams.toUpperCase();

    // make sure we have a leading slash
    if ( targetParams.charAt( 0 ) != "/" )
    {
    	targetParams = "/" + targetParams;
    }

    // determine adserver URL to use
    if ( ( adServer = ( ( spac_getParamValue( "ADSERVER", targetParams ) ) ) ) == "" )
    {
        adServer = spac_adServer;
    }

    // determine the method to use to make this adcall
    if ( ( method = spac_getParamValue( "METHOD", targetParams ) ) == "" )
    {
        method = "AUTO";
    }

    if ( method == "AUTO" )
    {
        method = spac_getMethod();
    }

    // determine frame target to use
    if ( ( frameTarget = spac_getParamValue( "FRAMETARGET", targetParams ) ) == "" )
    {
        frameTarget = "_new";
    }
    else
    {
    	frameTarget = frameTarget.toLowerCase();
    }

    // default frameSize is 468x60
    var frameWidth = "468";
    var frameHeight = "60";

    // determine frameSize to use. if frameSize not specified directly, use the value specified
    // in the AAMSZ= tag
    if ( ( frameSize  = ( ( spac_getParamValue( "FRAMESIZE", targetParams ) ) ) ) == "" )
    {
        frameSize = "AUTO";
    }
    if ( frameSize == "AUTO" )
    {
        frameSize = spac_getParamValue( "AAMSZ", targetParams );
    }

    // extract the width and height components from frameSize string
    if ( frameSize != "" )
    {
        var i = frameSize.indexOf( "X" );
        if ( i >= 0 )
        {
            frameWidth = frameSize.substring( 0, i );
            frameHeight = frameSize.substring( i + 1 );
        }
    }

    // compute random value for cache busting this call
    var uniqueValue = spac_getUniqueValue();

    // auto include /PAGEID tag if necessary
    if ( true == spac_autoPageID )
    {
        var autoPageID = spac_getParamValue( "AUTOPAGEID", targetParams );
        if ( "" == autoPageID || "TRUE" == autoPageID )
        {
            targetParams = targetParams + "/PAGEID=" + spac_pageID;
        }
    }

    // add /ACC_RANDOM tag for cache busting this adcall
    targetParams = targetParams + "/ACC_RANDOM=" + uniqueValue;

    // build appropriate adcall URL based on the method required
    if ( method == "IFRAME" || method == "JSCRIPT" )
    {
        if ( method == "IFRAME" )
        {
            return ( "<iframe src=\"" + adServer + "/hserver" + targetParams + "?\" width=\"" + frameWidth + "\" height=\"" + frameHeight + "\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>" );
        }
        else if ( method == "JSCRIPT" )
        {
            return ( "<script src=\"" + adServer + "/jserver" + targetParams + "?\"></script>" );
        }
    }
    else if ( method == "STREAM" )
    {
        return ( "<a href=\"" + adServer + "/xtserver" + targetParams + "?\"></a>" );
    }
    else if ( method == "POPUP" )
    {
        var windowName = aTargetParams;
        len = windowName.length;
        for ( i = 0; i < len; i++ )
        {
            ch = windowName.charAt( i )
            if ( ch == "/" || ch == "=" || ch == "." || ch == "_" || ch == "-" )
            {
                windowName = windowName.substring( 0, i ) + "_" + windowName.substring( i + 1 );
            }
        }
        var features = "width=" + frameWidth + ",height=" + frameHeight;
        var winPos;
        if ( ( winPos = ( ( spac_getParamValue( "POPUPPOS", targetParams ) ) ) ) != "" )
        {
            i = winPos.indexOf( "X" );
            if ( i >= 0 )
            {
            	j = winPos.indexOf( "Y", i + 1 );
            	if ( j < 0 )
            	{
            	    j = winPos.length;
            	}
                features += ",left=" + winPos.substring( i + 1, j );
            }
            i = winPos.indexOf( "Y" );
            if ( i >= 0 )
            {
            	j = winPos.indexOf( "X", i + 1 );
            	if ( j < 0 )
            	{
            	    j = winPos.length;
            	}
                features += ",top=" + winPos.substring( i + 1, j );
            }
        }

    	var adwin = window.open( adServer + "/hserver" + targetParams + "?", windowName, features );
    	adwin.focus();
    	return ( "" );
    }
    else
    {
        if ( frameTarget != "" )
        {
            frameTarget = " target=\"" + frameTarget + "\"";
        }
        return ( "<a href=\"" + adServer + "/adclick" + targetParams + "?\" " + frameTarget + ">" +
                 "<img src=\"" + adServer + "/adserver" + targetParams + "?\" border=\"0\" width=\"" + frameWidth + "\" height=\"" + frameHeight + "\"></a>" );
    }
}

// returns the best method that can be used to display banner ads
function spac_getMethod()
{
    var agt = navigator.userAgent;
    var ver = parseInt( navigator.appVersion );
    var isMoz = ( ( ( agt.indexOf( "Mozilla" ) != -1 ) &&
                    ( agt.indexOf( "spoofer" ) == -1 ) &&
                    ( agt.indexOf( "compatible" ) == -1 ) &&
                    ( agt.indexOf( "opera" ) == -1 ) &&
                    ( agt.indexOf( "webtv" ) == -1 ) ) )
    var isIE3Up = ( ( agt.indexOf( "MSIE" ) != -1 ) && ( ver >= 3 ) );
    if ( isIE3Up || ( isMoz && ver >= 5 ) )
    {
        return ( "IFRAME" );
    }
    else if ( isMoz && ver >= 3 )
    {
    	return ( "JSCRIPT" );
    }
    else
    {
        return ( "IMG" );
    }
}

// parses pathinfo string and returns the value of a named parameter
function spac_getParamValue( aName, aParam )
{
    var retVal = "";
    var p = aParam.indexOf( aName );
    if ( p != -1 )
    {
        p = aParam.indexOf( "=", p );
        if ( p != -1 )
        {
            p++;
            while ( p < aParam.length && aParam.charAt( p ) == " " )
            {
                p++;
            }
            var p2 = aParam.indexOf( ";", p );
            if ( p2 != -1 )
            {
                retVal = ( aParam.substring( p, p2 ) );
            }
            else
            {
                p2 = aParam.indexOf( "/", p );
                if ( p2 != -1 )
                {
                    retVal = ( aParam.substring( p, p2 ) );
                }
                else
                {
                    retVal = ( aParam.substring( p , aParam.length ) );
                }
            }
            p = retVal.length - 1;
            while ( p > 0 && retVal.charAt( p ) == " " )
            {
                p--;
            }
            if ( p > 0 )
            {
                retVal = retVal.substring( 0, p + 1 );
            }
        }
    }
    return ( retVal );
}


// computes and returns a random number
function spac_getUniqueValue()
{
    return ( Math.floor( Math.random() * 1000000000 ) );
}

// returns current version info
function spac_getVersion()
{
    return ( "$Id: spac.js,v 1.11 2001/02/06 09:59:28 srehman Exp $" );
}

