/**************************************
**
** FILE: main.js
** 
** AUTHOR: svargas
**
** SYNOPSIS: init() functions for 
** browsers
** 
** 
**************************************/

function isIE ()
{
	return (navigator.appName.indexOf("Microsoft") != -1);
}

function initialize() 
{  
	// called at body.onload move variables above into this function
	var myScreen;	
	
	myScreen = new screenObject();
	
	userInit(); // creates UI based on user events
	
	//window.onresize = windowResize;
}

function saneEvent(eventObj)
{
	// merge conflicting event models of moz and IE.
	return (eventObj) ? eventObj : ((event) ? event : null);
}
function saneEventTarget(eventObj)
{
	// same deal for the originating element of events.
	return (eventObj.target) ? eventObj.target : ((eventObj.srcElement) ? eventObj.srcElement : null);
}

/**************************************
**
** FILE: events.js
** 
** AUTHOR: svargas
**
** SYNOPSIS: Functions for common window
** objects
** 
** 
**************************************/

var mouseX = mouseY =0;

function screenObject()
{
	this.bottom = function()
	{
		if (document.body.scrollHeight) return document.body.scrollHeight;
	};
	
	this.height = function() 
	{
		if (document.body.offsetHeight) return document.body.offsetHeight;
	};
	
	this.visHeight = function() 
	{
		if (window.innerHeight) return window.innerHeight;
		if (document.body.clientHeight) return document.body.clientHeight;
	};
	
	this.width = function() 
	{
		if (document.body.offsetWidth) return document.body.offsetWidth;
	};
	
	this.scrollTop = function() 
	{
		if(document.body.scrollTop) return document.body.scrollTop
		if (window.pageYOffset) return window.pageYOffset;
		else return 0;
	};	
}

function mousePosition(e)	
{
	if (e) event = e;   //for Netscape
	mouseX = event.clientX;
	mouseY = event.clientY;
}

function windowResize() 
{
	displayFix;
}

/**************************************
**
** FILE: user.js
** 
** AUTHOR: svargas
**
** SYNOPSIS: Functions for user event-
** driven actions, and page elements
** 
** 
**************************************/


// Check concatenation in showMenu function for more details.
var menus = new Array("Topics", "History", "Saved", "Account", "RecentSrch");

var menuShowing = null;
var tagMenu;
var navShowing;
var tagNav;
var idxShowing;

function hideThis(oldNav, oldIdx, oldMenu) 
{
	tagMenu = document.getElementById(oldMenu);
	eval('tagMenu.style.visibility="hidden"');	
}

function showThis(showNav, idx, showMenu) 
{
	if (menuShowing != null) 
	{
		hideMenu();	
	}
	
	if (!document.getElementById(showMenu))
	{
		showMenu = "seM" + showMenu.substr(1);
	}
	tagMenu = document.getElementById(showMenu);
	eval('tagMenu.style.visibility="visible"');
	menuShowing = showMenu;
	navShowing = showNav;
	idxShowing = idx;
}
	
function hideMenu() 
{
	document.onclick = null;
	if (menuShowing != null) 
	{
		obj = document.getElementById(menuShowing);
		obj.style.visibility = "hidden";
	}
}


var allEvents = new Array();
var activeMenu = null; //defines which menu is currently open

var activeSection = "Default";


function menuOver() 
{ // Prevents stickiness to UI menus.
	document.onclick = null;
}

function menuOut() 
{ // Prevents stickiness to UI menus.
	document.onclick = hideMenu;
}

function userInit() 
{ // Responds to user events
	for (i=0; i < menus.length; i++) 
	{		
		obj = document.getElementById("menu"+menus[i]);
		obj.onmouseover = menuOver;
		obj.onmouseout = menuOut;
	}
	objSe = document.getElementById("seMenuHistory")
	if (objSe)
	{
		objSe.onmouseover = menuOver;
		objSe.onmouseout = menuOut;
	}
	objSe = document.getElementById("seMenuSaved")
	if (objSe)
	{
		objSe.onmouseover = menuOver;
		objSe.onmouseout = menuOut;
	}
}
	
function cwAnnotate(strURL) 
{
  //opener.window.location.href = "/" + strURL;
//eval("parent.main.location.reload(true)");
//opener.window.location.reload(true);
}

function jumpMenu(selObj)
{
  eval("window.location='"+selObj.options[selObj.selectedIndex].value+"'");
}

function openWin(winURL,winName,winAttrs) 
{
	var newWin = window.open(winURL,winName,winAttrs);
	newWin.focus();
}

function imagePopup(itemID, seqNum) 
{
	var imgPopup = window.open('/ImagePopup.do?itemID='+itemID+'&seqNum='+seqNum, 'img', 'toolbar=no,status=no,scrollbars=yes,resizable=yes,width=630,height=750');
	imgPopup.focus();
} 

function chooseCard(baseURL, cardList)
{
   var cardURL = "/" + baseURL + "&cbi_id=" + cardList.options[cardList.selectedIndex].value;
   window.location.href = cardURL;
}

function ckSearch(str) 
{
	if (str.criteria.value == "") 
	{
		alert("If you want to start a keyword search, please type in some search words.");
		str.criteria.focus;
		return false;
	}
}

var firstFlip = 1;
function flipVis(buttonId,menuId,typeFlag)
{
	if(typeof document.getElementById(menuId) != "undefined")
	{
		var flipper = document.getElementById(buttonId);
		flipper.src = 
			(flipper.src.indexOf("down") != -1)
			?
				"/common/images/nav_arrow_in.gif"
			:
				"/common/images/nav_arrow_down.gif"
		;
		
		var elm = document.getElementById(menuId);
		var hat = document.getElementById("tophat");
		if (hat.className == "default_closed" && firstFlip)
		{
			// init to reduce freakiness on first click
			hat.style.display = "none";
			elm.style.display = "none";
			firstFlip = 0;
		}
		
		hat.style.display = (hat.style.display == "none") ? "block" : "none";
		
		// now directly show what we want
		elm.style.display = 
			(elm.style.display == "none")
			?
				"block"
			:
				"none"
		;
	}
}

function hintEnlargeables()
{
	// create our hint element
	var hintObj = document.createElement("div");
	hintObj.className = "mag";
	var theText = document.createTextNode("Click image to magnify");
	hintObj.appendChild(theText);

	var allIm = document.getElementById("realcontent").getElementsByTagName("img");
	for (var r = 0; r < allIm.length; r++)
	{
		if (allIm[r].className.indexOf("magnify") == -1) continue;
		
		var theHint = hintObj.cloneNode(true);
		
		// add the element after the imageObj
		var theAdded = allIm[r].parentNode.insertBefore(theHint, allIm[r].nextSibling);
		
		// enforce minimum width when image hasn't loaded (moz)
		var theWidth = (allIm[r].width == 24 ? 120 : allIm[r].width);
		theAdded.style.width = theWidth;
		
		var theFloat = (isIE() ? allIm[r].currentStyle.styleFloat : allIm[r].style.cssFloat);
		if (theFloat != "" && theFloat != "undefined")
		{
			// set the float of the hint element to match
			theAdded.className += (theFloat == "left" ? " mag_l" : " mag_r");
		}
	}
}