
var modules = new Array("fantasy","insider","scores");

function getElement(id)
{
	return document.all ? document.all[id] : document.getElementById(id);

}

function changeMain(url)
{
	window.parent.location = url;
}

function toggleModule(moduleid) {
	if(moduleid!=null) {
		showDiv = getElement(moduleid);
		hideDiv = getElement(moduleid+"_hidden");
		
		showDivHTML = showDiv.innerHTML;
		hideDivHTML = hideDiv.innerHTML;
		
		showDiv.innerHTML = hideDivHTML;	
		hideDiv.innerHTML = showDivHTML;
		
		htblkey = moduleid + "_hidden_table"; 
		id = moduleid.substring(0,moduleid.length-7);
		if(showDiv.firstChild.id==null || showDiv.firstChild.id==htblkey)
			setPref("mstate_"+id,"c");
		else
			setPref("mstate_"+id,"o");
	}
}

function selectSportDiv(sport,key) {
	sports = new Array("nba","nfl","mlb","nhl");
	for(i=0; i<sports.length; i++)
	{
		if(sports[i] != sport)
		{
			offdiv = getElement(key+"_"+sports[i]);
			if(offdiv!=null)
				offdiv.style.display = 'none';
		}
	}
	ondiv = getElement(key+"_"+sport);
	if(ondiv!=null)
		ondiv.style.display = 'block';
}

function hideAllModules(link)
{
	for(i=0;i<modules.length;i++)
	{		
		divkey = modules[i]+"_module";
		vtblkey = divkey + "_visible_table"; 

		div = getElement(divkey);
		if(div!=null)
		{	
			if(div.firstChild.id==vtblkey)
				toggleModule(modules[i]+"_module");
		}
	}
	link.blur();
}

function showAllModules(link)
{
	for(i=0;i<modules.length;i++)
	{	
		divkey = modules[i]+"_module";
		htblkey = divkey + "_hidden_table"; 

		div = getElement(divkey);
		if(div!=null)
		{	
			if(div.firstChild.id==htblkey)
				toggleModule(modules[i]+"_module");
		}
	}
	link.blur();
}

function addToModuleList(newmoduleid)
{
	modules[modules.length] = newmoduleid;
}

function switchDivs(moveDiv,aboveDiv)
{
	d1HTML = moveDiv.innerHTML;
	d2HTML = aboveDiv.innerHTML;
	d1Id   = moveDiv.id;
	d2Id   = aboveDiv.id;
	dummyId = moveDiv.id + "dummy";

	moveDiv.innerHTML = d2HTML;
	aboveDiv.innerHTML = d1HTML;
	moveDiv.id = dummyId;
	aboveDiv.id = d1Id;
	getElement(dummyId).id = d2Id;
	
	setModuleOrder();
}

var divs = document.getElementsByTagName("DIV");
function showorder()
{
	for (var i = 0; i < divs.length; i++) {
		tempid = divs[i].id;
	   	if(tempid!="")
	   		alert(tempid);
	}
}

function getModuleOrder()
{
	mord = "";

	for(var i=0; i<divs.length; i++) {
		tmpval = divs[i].id;

		if(tmpval.indexOf("module")>-1 && tmpval.indexOf("hidden")<0 && tmpval.indexOf("deleted")<0)
		{
			tmpval = tmpval.substring(0,tmpval.length-7);
			mord = mord + tmpval + ","; 
		}

	}
	return mord;
}

function setModuleOrder()
{
	tmpmord = getModuleOrder();
	setPref("module_order",tmpmord);
}

function getPreviousDiv(curid)
{
	retval = null;
	moveDivIndex = 0;
	for(var i=0; i<divs.length; i++) {
		if(divs[i].id==curid)
		{
			if(i>-1)
			{
				for(var j=i-1; j>-1;j--)
				{
					tmpval = divs[j].id;
					if(tmpval.indexOf("module")>-1 && tmpval.indexOf("hidden")<0 && tmpval.indexOf("deleted")<0)
					{
						retval = tmpval;
						break;
					}
				}	
			}
			break;
		}
	}
	return retval;
}

function getNextDiv(curid)
{
	retval = null;
	for (var i = 0; i < divs.length; i++) {
		if(divs[i].id==curid)
		{
			if(i<divs.length)
			{
				for(var j=i+1; j<divs.length;j++)
				{
					tmpval = divs[j].id;
					if(tmpval.indexOf("module")>-1 && tmpval.indexOf("hidden")<0 && tmpval.indexOf("deleted")<0)
					{
						retval = tmpval;
						break;
					}
				}		
			}
			break;
		}
	}
	return retval;
}

function up(link)
{

	//LINK/TD/TR/TBODY/TABLE/DIV
	//link.parentElement.parentElement.parentElement.parentElement.parentElement.id;	
	moveDivId = link;
	moveDiv = getElement(moveDivId);
	aboveDivId = getPreviousDiv(moveDivId);
	if(aboveDivId!="" && aboveDivId!=null)
	{
		aboveDiv = getElement(aboveDivId);
		if(aboveDiv)
		{
			switchDivs(moveDiv,aboveDiv);
		}
	}

}

function down(link)
{
	//LINK/TD/TR/TBODY/TABLE/DIV
	//link.parentElement.parentElement.parentElement.parentElement.parentElement.id;	
	moveDivId = link;	
	moveDiv = getElement(moveDivId);
	belowDivId = getNextDiv(moveDivId);
	if(belowDivId!="" && belowDivId!=null)
	{
		belowDiv = getElement(belowDivId);
		if(belowDiv)
		{
			switchDivs(moveDiv,belowDiv);
		}
	}
}

function remove(link)
{
	//LINK/TD/TR/TBODY/TABLE/DIV
	//link.parentElement.parentElement.parentElement.parentElement.parentElement.id;	
	removeDivId = link;	
	removeDiv = getElement(removeDivId);
	removeDiv.style.display = 'none';
	removeDiv.id = removeDivId + "_deleted";
	
	setModuleOrder();
}

var last_obj = '';
function mover(obj) {
	if ( obj != last_obj) {
    	obj.className="over";
	}
}

function moff(obj) {
	if ( obj != last_obj) {
		obj.className="off";
	}
}
		
function toggle(obj) {
	if ( obj != last_obj) {
		last_obj.className="off"
	}
}

function setPref(cname,cvalue) {
	setCookie(cname,cvalue,null);
}

var cookies = document.cookie.split("; ");

function getCookie(name) {
	for (var i=0; i < cookies.length; i++) {
	  cookie = cookies[i].split("=");
	  if (cookie[0] == name)
		return cookie[1];
	}
	return null;
}

function setCookie(name, value, time) {
	if(time==null) { time = 720*60*60*1000; }
	var today = new Date();
	var expiration = new Date(today.getTime() + time);
	if (value != null && value != "")
	  document.cookie=name + "=" + value + ";path=/;domain=go.com;expires=" + expiration.toGMTString();
	cookies = document.cookie.split("; ");
}


function resizeIframe(f,h) {
	ife = getElement(f);
	ife.style.height=h;
}

function selectGameTypeDiv(team) {
	//toggle images
	lastImg = getElement("lastImg_"+team);
	nextImg = getElement("nextImg_"+team);
	lastImgSrc = lastImg.src;
	nextImgSrc = nextImg.src;
	lastImg.src = nextImgSrc;
	nextImg.src = lastImgSrc;
	
	//toggle game tables
	lastGame = getElement("lastGame_"+team);
	nextGame = getElement("nextGame_"+team);
	if(lastGame.style!=null && nextGame.style!=null) {
		if(lastGame.style.display == "none") {
			nextGame.style.display = "none";
			lastGame.style.display = "block";
		} else {
			nextGame.style.display = "block";
			lastGame.style.display = "none";
		}
	}
}
