function validateAmount(source, arguments){
	if (!numericCheck(arguments.Value, 2, "Please enter a numeric amount.")) arguments.IsValid = false;
}
function jsDV_strTrim(str){
	var i = 0;
	var j = str.length - 1;

	trimstr = "";
	if (j < 0) return trimstr;

	flagbegin = true;
	flagend = true;

	while (flagbegin == true){
		if (str.charAt(i) == ' ') i++;
		else flagbegin = false;
	}
	while (flagend == true){
		if (str.charAt(j) == ' ') j--;
		else flagend = false;
	}

	if (j < i) return trimstr;
	else trimstr = str.substring(i, j + 1);

	return trimstr;
}
function specialCharCheck(val, msg){
	var nrl = val;
	var flag = 0;
	var alphaErrorMsg = msg;

	if(val == "") return false;
	if(alphaErrorMsg == null){
		alphaErrorMsg = "This entry accepts only letters, periods, commas and hyphens.";
	}
	for (var i=0; i<nrl.length;i++){
		cmp = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()+?:.,-";
		cmp += " ";
		tst = nrl.substring(i,i+1);
		if (cmp.indexOf(tst)<0) flag++;
	}
	if (flag != 0){
		if(alphaErrorMsg != "nomsg") alert(alphaErrorMsg);
		return false;
	}
	return true;
}
function alphaCheck(val, msg){
	var nrl = val;
	var flag = 0;
	var alphaErrorMsg = msg;

	if(val == "") return false;
	if(alphaErrorMsg == null) alphaErrorMsg = "This entry accepts only letters, periods, commas, hyphens and spaces.";

	for (var i=0; i<nrl.length;i++){
		cmp = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.,-";
		cmp += " ";
		tst = nrl.substring(i,i+1);
		if (cmp.indexOf(tst)<0) flag++;
	}
	if (flag != 0){
		if(alphaErrorMsg != "nomsg") alert(alphaErrorMsg);
		return false;
	}
	return true;
}
// Alphacheck that has options to check alpha only or AlphaNumeric with out special Characters
function validAlpha(val,typeCheck,msg){
	var tempVal = val;
	var Errormsg = msg;
	var flag = 0;
	switch(typeCheck){
		case 1:  //alpha + , . -, for names ect.
			cmp="ABCDEFGHIJKLMNOPQRSTUVWXYZ -abcdefghijklmnopqrstuvwxyz,.'";
			break;
		case 2: //alpha, numeric, + ,.-# , for addresses
			cmp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ -abcdefghijklmnopqrstuvwxyz0123456789.,#'";
			break;
		case 3: //alpha, numeric, + ,.-# , for username and password, no " or '
			cmp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ -abcdefghijklmnopqrstuvwxyz0123456789.$#%*=+()@";
			break;
		case 4: //I am not sure when this was added but it is not correct for username or passwords -svp
			cmp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ -abcdefghijklmnopqrstuvwxyz0123456789.$#%*/=+()@\\\"_";
			break;
		case 6: //alpha, numeric 
			cmp = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
			break;
		case 7: //alpha, numeric, + ,.-#
			cmp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ-abcdefghijklmnopqrstuvwxyz0123456789.$#%*=+()@_";
			break;
		default:
			cmp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ -abcdefghijklmnopqrstuvwxyz,.'";
			break;
	}
	if (Errormsg == null) Errormsg = "You have entered an invalid character in this field.";

	for(var i= 0; i < tempVal.length; i++){
		test = tempVal.substring(i,i + 1);
		if(cmp.indexOf(test)< 0) flag = -1;
	}
	if(flag != 0){
		if(Errormsg != "nomsg") alert(Errormsg);
		return false;
	}
	return true;
}
function numericCheck(val, type, msg){
	var nr1 = val;
	var typeCheck = type;
	var flag = 0;
	var numberErrorMsg = msg;

	if(val == "") return false;
	if (numberErrorMsg == null) numberErrorMsg = "This entry must be a number.  Please remove all letters, special characters, and spaces.";

	switch(typeCheck){
		case 0: //int
			cmp = "0123456789";
			break;
		case 1: //int + commas
			cmp="0123456789,";
			break;
		case 2: //float
			cmp = "0123456789.,";
			break;
		case 3: //currency
			cmp = "0123456789.,$-";
			break;
		case 4: //int + point
			cmp = "0123456789.";
			break;
		case 5: //for zip codes  
			cmp = "0123456789-";
			break;
		default:
			cmp = "0123456789";
			break;
	}

	for (var i=0; i<nr1.length; i++){
		tst = nr1.substring(i,i+1);
		if ((cmp.indexOf(tst)<0) || (cmp.indexOf(" ") != -1)) flag++;
	}
	if (flag != 0){
		if(numberErrorMsg != "nomsg") alert(numberErrorMsg);
		return false;
	}
	return true;
}
function daysInFebruary (year){
	return (  ((year % 4 == 0) && ( (!(year % 100 == 0)) || (year % 400 == 0) ) ) ? 29 : 28 );
}
function isDate (year, month, day){
	var daysInMonth = new Array(12);
	daysInMonth[1] = 31;
	daysInMonth[2] = 29;
	daysInMonth[3] = 31;
	daysInMonth[4] = 30;
	daysInMonth[5] = 31;
	daysInMonth[6] = 30;
	daysInMonth[7] = 31;
	daysInMonth[8] = 31;
	daysInMonth[9] = 30;
	daysInMonth[10] = 31;
	daysInMonth[11] = 30;
	daysInMonth[12] = 31;

	if (month <1 || month > 12) return false;
	if (day <1 || day > 31) return false;
	var intYear = parseInt(year, 10);
	var intMonth = parseInt(month, 10);
	var intDay = parseInt(day, 10);
	if (intDay > daysInMonth[intMonth]) return false; 
	if ((intMonth == 2) && (intDay > daysInFebruary(intYear))) return false;
	return true;
}
function validDate(val, textBox, msg, msg2){
	var dateErrorMsg = msg;
	var spaceErrorMsg = msg2;
	var indate = val;
	var flag = 0;

	if (indate == "") return false;
	if (dateErrorMsg == null) dateErrorMsg = "You have entered an invalid date or date format.  Please use the MM/DD/YYYY format without spaces.";
	if (spaceErrorMsg == null) spaceErrorMsg = "Please use the MM/DD/YYYY format without spaces.";

	if (indate.indexOf(" ")!=-1){
		if(dateErrorMsg != "nomsg") alert(spaceErrorMsg);
		return false;
	}
	if (indate.indexOf("-")!=-1){
		var delimeter = "-";
	}
	else if (indate.indexOf("/")!=-1){
		var delimeter = "/";
	}
	else if (indate.indexOf(".")!=-1){
		var delimeter = ".";
	}
	else {
		flag++;
	}
	var dateArray = indate.split(delimeter);
	if((dateArray.length != 3) || ((dateArray[2].length != 2) && (dateArray[2].length != 4)) ||
		(dateArray[0].length < 1) || (dateArray[0].length > 2) || (dateArray[1].length < 1) ||
		(dateArray[1].length > 2)){
			flag++;
	}
	else if ((numericCheck(dateArray[0], 0, dateErrorMsg)==false) || (numericCheck(dateArray[1], 0, dateErrorMsg)==false) || (numericCheck(dateArray[2], 0, dateErrorMsg)==false)){
		return false;
	}
	var intYear = parseInt(dateArray[2], 10);
	if ((intYear >= 0) & (intYear <= 29)){
		dateArray[2] = 2000 + intYear;
	}
	else if ((intYear >= 30) & (intYear <= 99)){
		dateArray[2] = 1900 + intYear;
	}
	if (isDate(dateArray[2], dateArray[0], dateArray[1])==false){
		flag++;
	}
	if(flag != 0){
		if(dateErrorMsg != "nomsg") alert(dateErrorMsg);
		return false;
	}
	if ((dateArray[2] > 99) & (dateArray[2] < 1753)){
		if(dateErrorMsg != "nomsg") alert("We do not support dates before 1753.  Please choose a later year and try again.");
		return false;
	}
	indate = dateArray[0] + "/" + dateArray[1] + "/" + dateArray[2];
	textBox.value = indate;  // Set the date in the form to the modified date.
	return true;
}
// Check for valid Area Code in separate input box.
function validAreaCode(val,msg){
	var tempVal = val;
	var Errormsg = msg;
	var flag = 0;
	var tempComp = "0123456789";

	if(val == "") return false;
	if(Errormsg == null) Errormsg = "You have entered an invalid 'Area Code',Please try again.";

	for(var i=0; i < tempVal.length; i++){
		tempTest = tempVal.substring(i,i+1);
		if(tempComp.indexOf(tempTest)<0 || tempComp.indexOf(" ") != -1) flag = -1;
	}
	if(tempVal.length < 3){
		flag = -1;
	}
	else{
		for(var i=0; i < tempVal.length; i++){
			tempTest = tempVal.substring(i,i+1);
			if(tempComp.indexOf(tempTest)<0 || tempComp.indexOf(" ") != -1) flag = -1;
		}
	}
	if(flag != 0){
		if(Errormsg != "nomsg") alert(Errormsg);
		return false;
	}
	return true;
}
//Check for valid phone number if phone is separate input from area code and extension.
function validPhoneNum(val,msg){
	while(val.search(" ") != -1) val = val.replace(" ", "");

	var tempVal = val;
	var Errormsg = msg;
	var flag = 0;
	var tempComp = "0123456789-";
	//var isNum = numericCheck(tempVal,3)

	if(val == "") return false;
	if(Errormsg == null) Errormsg = "You have entered an invalid 'Phone Number', Please try again.";

	for(var i; i < tempVal.length; i++){
		tempTest = tempVal.substring(i,i+1);
		if(tempComp.indexOf(tempTest)<0 || tempComp.indexOf(" ") != -1) flag = -1;
	}
	if(tempVal.indexOf("-") != -1){
		if(tempVal.length != 8){
			flag = -1;
		}
		else{
			for(var j=0; j < tempVal.length; j++){
				tempTest = tempVal.substring(j,j+1);
				if(tempComp.indexOf(tempTest)<0 || tempComp.indexOf(" ") != -1) flag = -1;
			}
		}
	}
	else if(tempVal.length != 7){
		flag = -1;
	}
	else{
		for(var j=0; j < tempVal.length; j++){
			tempTest = tempVal.substring(j,j+1);
			if(tempComp.indexOf(tempTest)<0 || tempComp.indexOf(" ") != -1) flag = -1;
		}
	}
	if(flag != 0){
		if(Errormsg != "nomsg") alert(Errormsg);
		return false;
	}
	return true;
}
function validPhone(val, msg){
	while(val.search(" ") != -1) val = val.replace(" ", "");

	val = val.replace("", "")

	var phone = val;
	var flag = 0;
	var phoneErrorMsg = msg;
	if(phone == "") return false;
	if (phoneErrorMsg == null) phoneErrorMsg = "You have entered an invalid phone #.  Please re-enter your # in the form xxx-xxx-xxxx.";
	if(phone.indexOf(" ") != -1){
		alert("Please re-enter your phone # without using spaces.");
		return false;
	}
	if(phone.length < 10){
		flag++;
	}
	else {
		for (var i=0; i<phone.length; i++){
			var cmp="0123456789()-.";
			tst=phone.substring(i,i+1);
			if (cmp.indexOf(tst)<0){
				flag++;
				break;
			}
		}
	}
	if(flag > 0){
		if(phoneErrorMsg != "nomsg") alert(phoneErrorMsg);
		return false;
	}
	return true;
}
//new function to format the phone number. kintera standard
function phoneCheck(val){
	var phonestr,formatphone;
	strphone = val;
	formatphone = "";
	var intcount=0; charcount=0;
	strint = "0123456789";
	strchar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	for (var i=0; i<strphone.length; i++){
		tst = strphone.substring(i,i+1);
		if (!((strchar.indexOf(tst)<0)||(strchar.indexOf(" ") != -1)))
			charcount++;
		if (!((strint.indexOf(tst)<0)||(strint.indexOf(" ") != -1))){
			if (intcount == 0) formatphone = formatphone + "(";
			if (intcount == 3) formatphone = formatphone + ") ";
			if (intcount == 6) formatphone = formatphone + "-";
			formatphone = formatphone + tst;
			intcount++;
		}
	}
	return (intcount==10 && charcount==10) ? formatphone : strphone;
}
function validEmailOld(val, msg){
	var email = val;
	var flag = 0;
	var emailErrorMsg = msg;

	if (email == "") return false;
	if(emailErrorMsg == null) emailErrorMsg = "You have entered an invalid email address.";
	if(email.indexOf('@', 0) == -1){
		flag++;
	}
	else if(email.indexOf('.', 0) == -1){
		flag++;
	}
	if(flag > 0){
		if(emailErrorMsg != "nomsg") alert(emailErrorMsg);
		return false;
	}
	return true;
}
function validEmail(str, msg){
	var emailErrorMsg = msg;
	
	if(emailErrorMsg == null) emailErrorMsg = "Please enter a valid email address. Email addresses must include the\n@ sign and at least one period. (e.g. friendname@abc.com)";

	if (!isValidEmail(str)){
		if(emailErrorMsg != "nomsg") alert(emailErrorMsg);
		return false;
	}
	return true;
}
function isValidEmail(str){
	var at;
	var i = 0;
	var j = str.length - 1;
	var count = 0;

	at = str.indexOf("@", 0);
	if (at <= 0 || at == j) return false;

	while (i < at){
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
			(str.charAt(i) >= 'a' && str.charAt(i) <= 'z') ||
			(str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') ||
			str.charAt(i) == '.' || str.charAt(i) == '&' || 
			str.charAt(i) == '?' || str.charAt(i) == '#' || 
			str.charAt(i) == '$' || str.charAt(i) == '*' || 
			str.charAt(i) == '+' || str.charAt(i) == '!' || 
			str.charAt(i) == '%' || str.charAt(i) == '\'' || 
			str.charAt(i) == '^' || str.charAt(i) == '/' || 
			str.charAt(i) == '_' || str.charAt(i) == '-')
				i++;
		else return false;
	}

	i = at + 1;
	if (str.charAt(i) == '.' || str.charAt(j) == '.') return false;
	while (i <= j){
		if (str.charAt(i) == '.'){
			count++;
			if (str.charAt(i + 1) == '.') return false;
			else i++;
		}

		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) >= 'a' && str.charAt(i) <= 'z') ||
			(str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') || str.charAt(i) == '_' || str.charAt(i) == '-')
			i++;
		else return false;
	}
	return (count == 0) ? false : true;
}

function validateSphereEmailAddress(str, msg){
	var regex;
	
	regex = /^[\w]\w*([-+.&?#$*!%]\w+)*@[a-zA-Z0-9]\w*([.-]\w+)*\.[a-zA-Z]{2,4}$/;
	if (regex.test(str) == true)
		return true;
	else {
		alert(msg);
		return false;
	}
		
}

function validYear(val, msg){
	var year = val;
	var yearErrorMsg = msg;
	var flag=0;
	var checkYear = parseInt(year);
	if (year == "") return false;
	if (yearErrorMsg == null) yearErrorMsg = "Please enter the year in YYYY format.  ex 1990";
	if (year.length > 0){
		if (year.length < 4) flag++;
	}
	if (year.length > 4) flag++;
	if(numericCheck(year, 0, "nomsg") == false) flag++;
	if(flag != 0){
		if(yearErrorMsg != "nomsg") alert(yearErrorMsg);
		return false;
	}
	if (checkYear < 1753){
		if(yearErrorMsg != "nomsg") alert("Please enter a year later than 1752.");
		return false;
	}
	return true;
}
function isFieldBlank(theField){
	var count = 0;
	if(theField == "") return true; 
	for(i=0;i<theField.length;i++){
		if(theField.indexOf(" ", i) == i) count++;
	}
	return (count == theField.length) ? true : false;
}
function minLength(textBox, min, msg){
	var min_length = min;
	var data = textBox.value;
	var minLengthErrorMsg = msg;
	if (min == null) return false;
	if (data == "") return false;
	if (minLengthErrorMsg == null) minLengthErrorMsg = "The "+textBox.name+" field requires at least "+min+" characters or more.";
	if(textBox.value.length < min){
		if(minLengthErrorMsg != "nomsg") alert(minLengthErrorMsg);
		return false;
	}
	return true;
}
//check a string for a specific character. getVal - string, findChar - char to find, charLimit - number of times char can exist
function checkMatchingChars(getVal,findChar,charLimit){
	var i=0, t=0;
	for(i=0 ; i <= getVal.length;i++){
		if(getVal.indexOf(findChar,i) == i) t++;
	}
	return (t > charLimit) ? false : true;
}

//-----------------------------------------------------------------------------
// Newer functions: Some are redundant in functionality to the functions above
// but are being kept for backwards compatibility
//-----------------------------------------------------------------------------
function checknumber(object_value){
	//Returns true if value is a number or is NULL
	//otherwise returns false	

	if (object_value.length == 0) return true;

	//Returns true if value is a number defined as
	//   having an optional leading + or -.
	//   having at most 1 decimal point.
	//   otherwise containing only the characters 0-9.
	//var start_format = " .+-0123456789";
	var start_format = " .0123456789";
	var number_format = " .0123456789";
	var check_char;
	var decimal = false;
	var trailing_blank = false;
	var digits = false;

	//The first character can be + - .  blank or a digit.
	check_char = start_format.indexOf(object_value.charAt(0))
	//Was it a decimal?
	if (check_char == 1) decimal = true;
	else if (check_char < 1) return false;

	//Remaining characters can be only . or a digit, but only one decimal.
	for (var i = 1; i < object_value.length; i++){
		check_char = number_format.indexOf(object_value.charAt(i))
		if (check_char < 0)
			return false;
		else if (check_char == 1){
			if (decimal)		// Second decimal.
				return false;
			else
				decimal = true;
		}
		else if (check_char == 0){
			if (decimal || digits) trailing_blank = true;
			// ignore leading blanks
		}
		else if (trailing_blank) return false;
		else digits = true;
	}
	return true;
}
function checkinteger(object_value)
{
	//Returns true if value is a number or is NULL
	//otherwise returns false	

	if (object_value.length == 0) return true;

	//Returns true if value is an integer defined as
	//   having an optional leading + or -.
	//   otherwise containing only the characters 0-9.
	var decimal_format = ".";
	var check_char;

	//The first character can be + -  blank or a digit.
	check_char = object_value.indexOf(decimal_format)
	//Was it a decimal?
	return (check_char < 1) ? checknumber(object_value) : false;
}
function getphone(strphone){
	var object_phone,i=0,counter=0,formatphone="",notusa_num=0;
	object_phone = strphone;
	str24char = "+?:.,abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&*";
	for (i = 0; i < object_phone.length; i ++){
		var inchar,indx;
		indx = 0
		inchar = object_phone.charAt(i);
		if (checkinteger(inchar) == true){
			if (counter == 0)
				formatphone = "(" + inchar;
			else{
				if (counter == 3) formatphone += ") ";
				if (counter == 6) formatphone += "-";
				formatphone = formatphone.concat(inchar);
			}
			counter++;
		}
		else{
			indx = str24char.indexOf(inchar);
			if (indx > 0) notusa_num = 1;
		}
	}
	return (counter == 10 & notusa_num == 0) ? formatphone : object_phone;
}
function jsDV_isValidMoney(strMoney){
	// str must not be empty string
	var pointPos;
	var pointCount = 0;
	var zeroFlag = 1;
	var str = strMoney;
	if (str.length < 1) return "0"; //empty input

	//start with '.'
	if (str.charAt(0) == '.'){
		if (str.length == 1) return "-1";
		else str = "0" + str;
	}

	if (str.charAt(str.length - 1) == '.') return "-1"; //end with '.'

	//check the character set
	for (i = 0; i < str.length; i++){
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.')){
			if (str.charAt(i) != '0' && str.charAt(i) != '.') zeroFlag = 0;
			if (str.charAt(i) == '.') pointCount++;
			if (pointCount > 1) return "-1";
			continue;
		}
		else return "-1";
	}
	pointPos = str.indexOf(".", 0);
	if (pointPos >= 0){
		//e.g. 09.89
		if (pointPos > 1 && str.charAt(0) == '0') return "-1";
		//cut the long decimal part
		if (str.length - pointPos -1 > 2) str = str.substring(0, pointPos + 3);
	}
	else {
		if (str.length > 1 && zeroFlag == 0){
			//e.g. 0898
			if (str.charAt(0) == '0') return "-1";
		}
	}
	//multiple valid '0', just return single '0'
	return (zeroFlag) ? "0" : str;
}
function isValid5DigitsZIP(str) {
	var regex = /^[0-9]{5}$/;
	return regex.test(str);
}
