// StaticNav Javascript
// Come up with a one-level deep nav for static news pages, based on the first 'word' of the URL following wp-dyn
// To update the deep links array, execute the following SQL query:
// SELECT ''''||id||','||replace(actualname,'''','\''')||''',' result FROM sitetree WHERE id LIKE '%/%' AND id NOT LIKE '%/%/%' AND (menudisplay IS null OR UPPER(menudisplay) = 'Y') AND actualname is not NULL ORDER BY nodeorder,id;
function getDeepLinks(ancestor)
{
var deep_links ;
if (ancestor == 'sports/')
{
  deep_links = new Array(
  'sports,Sports',
  'sports/scoreboard,Scoreboard',
  'sports/redskins,Redskins',
  'sports/washingtoncapitals,Capitals',
  'sports/washingtonwizards,Wizards',
  'sports/baltimoreorioles,Orioles',
  'sports/dcunited,DC United',
  'sports/washingtonmystics,Mystics',
  'sports/baltimoreravens,Ravens',
  'sports/areaproteams,Area Pro Teams',
  'sports/highschools,High Schools',
  'sports/colleges,Colleges',
  'sports/leaguesandsports,Leagues and Sports',
  'sports/columns,Columnists',
  'sports/features,Features',
  'sports/index,Index'
  ) ;
}
else
{
deep_links = new Array(
'admin/archives,Archives',
'entertainment/outdoors,Test page',
'photo/dayinphotos,The Day in Photos',
'photo/weekinreview,The Week in Review',
'artsandleisure/barsandclubs,Bars and Clubs',
'artsandliving/barsandclubs,Bars and Clubs',
'artsandliving/comics,Comics',
'food/columns,Columns',
'health/alternativecare,Alternative Care',
'home/buildit,Build It/Fix It',
'print/a1,Front Page',
'sports/scoreboard,Scoreboard',
'style/books,Book World',
'travel/webtravel,Web Travel',
'world/africa,Africa',
'artsandleisure/books,Books',
'artsandliving/books,Books',
'health/childrenyouth,Children & Youth',
'home/furnishings,Furnishings/Design',
'print/image,Front Page Image',
'sports/redskins,Redskins',
'travel/international,International',
'travel/unitedstates,United States',
'world/americas,Americas',
'artsandleisure/columns,Columns',
'artsandliving/columns,Columns',
'health/chronicdiseases,Chronic Diseases',
'health/fitness,Fitness',
'home/garden,Garden & Patio',
'home/guides,Guides',
'print/asection,Inside the A Section',
'travel/escapes,Mid-Atlantic',
'world/asia,Asia/Pacific',
'artsandleisure/comics,Comics',
'health/healthcare,Health Care Issues',
'home/homelife,Home Life',
'print/nationpolitics,Nation and Politics',
'style/postmagazine,Post Magazine',
'travel/visitorsguide,DC Visitors Guide',
'world/europe,Europe',
'artsandleisure/crosswords,Crosswords',
'artsandliving/crosswords,Crosswords',
'health/men,Men',
'home/neighborhoods,Neighborhoods',
'opinion/editorials,Editorials',
'print/editorials,Editorial Pages',
'style/sundayarts,Sunday Arts',
'artsandleisure/entertainmentguide,Entertainment Guide',
'artsandliving/entertainmentguide,Entertainment Guide',
'health/mentalhealth,Mental Health',
'home/roombyroom,Room by Room',
'print/world,World',
'style/sundaysource,Sunday Source',
'travel/seasonal,Beach Guide',
'world/mideast,Middle East',
'artsandleisure/entertainmentnews,Entertainment News',
'artsandliving/entertainmentnews,Entertainment News',
'health/nutrition,Nutrition',
'home/columns,Columnists',
'print/business,Business',
'style/weekend,Weekend',
'travel/travelbytopic,Travel by Topic',
'world/columns,Columnists',
'artsandleisure/fashionandbeauty,Fashion and Beauty',
'artsandliving/fashionandbeauty,Fashion and Beauty',
'health/seniors,Seniors',
'home/photogalleries,Photo Galleries',
'opinion/opeds,Op-Eds',
'print/metro,Metro',
'sports/specialevent,U.S. Open',
'style/columns,Columns',
'travel/liveonline,Live Discussions',
'world/search,Search the World',
'artsandleisure/foodanddining,Food and Dining',
'artsandliving/foodanddining,Food and Dining',
'health/women,Women',
'home/liveonline,Live Discussions',
'print/sports,Sports',
'travel/photogalleries,Photo Galleries',
'world/issues,Special Reports',
'health/columns,Columns',
'home/index,Index',
'opinion/columns,Columnists',
'print/style,Style',
'style/news,Entertainment News',
'travel/columns,Columns',
'travel/heritage,Heritage Travel',
'world/photogalleries,Photo Galleries',
'artsandleisure/horoscope,Today\'s Horoscope',
'artsandleisure/horoscopes,Today\'s Horoscope',
'artsandliving/horoscope,Today\'s Horoscope',
'artsandliving/horoscopes,Today\'s Horoscope',
'education/columns,Columns',
'health/specials,Special Reports',
'metro/specials,Special Reports',
'print/archive,Previous Editions',
'world/live,Live Discussions',
'artsandleisure/movies,Movies',
'artsandliving/movies,Movies',
'health/liveonline,Live Discussions',
'print/sunday,Sunday Sections',
'world/index,World Index',
'artsandleisure/museums,Museums and Galleries',
'artsandliving/museums,Museums and Galleries',
'health/photogalleries,Photo Galleries',
'print/community,The Extras',
'style/photogalleries,Photo Galleries',
'artsandleisure/music,Music',
'artsandliving/music,Music',
'health/index,Health Index',
'print/weekly,Weekly Sections',
'style/liveonline,Live Discussions',
'artsandleisure/sportsandrec,Sports & Recreation',
'artsandliving/sportsandrec,Sports & Recreation',
'sports/baltimoreorioles,Orioles',
'style/index,Index',
'artsandleisure/television,Television',
'artsandleisure/theater,Theater',
'artsandliving/theater,Theater',
'print/subscription,Subscription Form',
'opinion/letterstotheeditor,Letters to the Editor',
'photo/topstory,Top Story',
'sports/dcunited,United',
'opinion/tolestom,Tom Toles',
'liveonline/messageboards,Message Boards',
'opinion/outlook,Sunday Outlook',
'photo/newsvideo,News Video/Audio',
'sports/washingtonwizards,Wizards',
'liveonline/schedule,Weekly Schedule',
'sports/washingtonmystics,Mystics',
'sports/baltimoreravens,Ravens',
'sports/areaproteams,Area Pro Teams',
'liveonline/candidates,Candidates Forum',
'liveonline/politics,Politics',
'sports/highschools,High Schools',
'liveonline/nation,Nation',
'sports/colleges,Colleges',
'liveonline/world,World',
'sports/leaguesandsports,Leagues and Sports',
'education/dc,District',
'liveonline/metro,Metro',
'photo/onassignment,On Assignment',
'photo/studentwork,Emerging Voices',
'realestate/buy,BUY',
'sports/columns,Columnists',
'sports/features,Features',
'photo/aqphotovoyage,AQ Photo Voyages',
'liveonline/sports,Sports',
'photo/bestofthepost,Post Photographers',
'liveonline/business,Business',
'sports/index,Index',
'liveonline/tech,Technology',
'liveonline/style,Style',
'liveonline/entertainment,Entertainment',
'liveonline/opinion,Opinion',
'liveonline/travel,Travel',
'liveonline/health,Health',
'liveonline/homeandgarden,Home & Garden',
'education/md,Maryland',
'liveonline/food,Food',
'photo/politics,Politics',
'realestate/sell,SELL',
'liveonline/education,Education',
'photo/nation,Nation',
'photo/world,World',
'liveonline/postmagazine,Post Magazine',
'photo/business,Business',
'photo/metro,Metro',
'liveonline/realestate,Real Estate',
'photo/sports,Sports',
'photo/style,Style',
'photo/visitorsguide,Visitor\'s Guide',
'liveonline/jobs,Jobs',
'photo/travel,Travel',
'photo/education,Education',
'photo/homeandgarden,Home & Garden',
'photo/health,Health',
'education/va,Virginia',
'photo/liveonline,Live Discussions',
'realestate/rent,RENT',
'education/adulteducation,Adult Education',
'realestate/own,OWN',
'photo/faq,FAQs',
'photo/toolsandresources,Tools &#38; Resources',
'photo/contactus,Contact Us',
'photo/relatedlinks,Related Links',
'education/highereducation,Higher Education',
'education/teachers,Teachers',
'metro/schools,Schools',
'nation/nationalsecurity,National Security',
'politics/fedpage,Federal Page',
'education/parenting,Parenting',
'metro/crime,Crime',
'nation/science,Science',
'politics/elections,Elections',
'metro/government,Government',
'nation/courts,Courts',
'politics/administration,Bush Administration',
'metro/traffic,Traffic',
'politics/congress,In Congress',
'business/markets,Market News',
'education/preschool,Preschool',
'metro/lottery,Lottery',
'nation/states,Search the States',
'politics/polls,Polls',
'technology/washtech,Washtech',
'business/portfolio,Portfolio',
'business/companyresearch,Company Research',
'business/economy,Economy',
'education/kto12,K to 12',
'metro/obituaries,Obituaries',
'nation/specials,Special Reports',
'education/schoolguide,School Guide',
'metro/religion,Religion',
'nation/photogalleries,Photo Galleries',
'politics/liveonline,Live Discussions',
'education/kidspost,KidsPost',
'metro/columns,Columnists',
'nation/liveonline,Live Discussions',
'politics/specials,Special Reports',
'metro/dc,The District',
'nation/index,Nation Index',
'education/specials,Special Reports',
'education/liveonline,Live Discussions',
'metro/md,Maryland',
'education/photogalleries,Photo Galleries',
'education/index,Education Index',
'metro/va,Virginia',
'business/government,Policy',
'business/localbusiness,Metro Business',
'metro/photogalleries,Photo Galleries',
'metro/liveonline,Live Discussions',
'technology/techpolicy,Tech Policy',
'business/industries,Industries',
'metro/index,Metro Index',
'business/personalfinance,Personal Finance',
'technology/govtit,Gov\'t IT',
'business/mutuals,Mutual Funds',
'technology/markets,Markets',
'business/specials,Special Reports',
'technology/columns,Columnists',
'business/columns,Columnists',
'technology/personaltech,Personal Tech',
'technology/specials,Special Reports',
'business/liveonline,Live Discussions',
'business/index,Business Index',
'technology/jobs,Jobs',
'admin/classifieds,Classifieds',
'admin/help,Help/Feedback',
'admin/newsindex,News Index',
'entertainment/review,Profile',
'entertainment/search,Search Results',
'kids/features,Features',
'kids/newsflash,Newsflash',
'kids/photo,Shutterbug',
'kids/poll,Polling Booth',
'technology/finance,Finance',
'travel/archive,Travel Index'
);
}
return deep_links ;
}

levelAHardNews = new Array(
  'wp-dyn/nation,Nation',
  'wp-dyn/politics,Politics',
  'wp-dyn/world,World',
  'wp-dyn/metro,Metro',
  'wp-dyn/print/style,Style',
  'wp-dyn/business,Business',
  'wp-dyn/technology,Technology',
  'wp-dyn/health,Health',
  'wp-dyn/education,Education',
  'wp-dyn/kidspost,KidsPost',
  'wp-dyn/realestate,Real Estate',
  'wp-dyn/metro/obituaries,Obituaries',
  'wp-dyn/print/corrections,Corrections',
  'wp-adv/archives,Archives'
) ;

levelAOpinion = new Array(
  'wp-dyn/opinion/editorials,Editorials',
  'wp-dyn/opinion/opeds,Op-Eds',
  'wp-dyn/opinion/columns,Columnists',
  'wp-dyn/opinion/letterstotheeditor,Letters to the Editor',
  'wp-dyn/opinion/tolestom,Tom Toles',
  'wp-dyn/opinion/outlook,Outlook',
  'wp-dyn/opinion,More...'
) ;

// levalAOpinion = new Array() ;
levelAShortOpinion = levelAOpinion ;

levelASports = new Array(
  'wp-dyn/sports/scoreboard,Latest Scores',
  'wp-dyn/sports/redskins,Redskins',
  'wp-dyn/sports/washingtoncapitals,Capitals',
  'wp-dyn/sports/leaguesandsports/nba/19992000/washingtonwizards,Wizards',
  'wp-dyn/sports/baltimoreorioles,Orioles',
  'wp-dyn/sports/areaproteams,Pro Sports',
  'wp-dyn/sports/colleges,College Sports',
  'wp-dyn/sports/highschools,High School Sports',
  'wp-dyn/sports,More...'
) ;

levelASoftNews = new Array(
	'wp-dyn/artsandliving/barsandclubs, Bars &amp; Clubs',
	'wp-dyn/artsandliving/books, Books',
	'wp-dyn/artsandliving/columns, Columns &amp; Advice',
	'wp-dyn/artsandliving/comics, Comics',
	'wp-dyn/artsandliving/crosswords, Crosswords',
	'wp-dyn/dating, Dating',
	'wp-dyn/artsandliving/entertainmentguide, Entertainment Guide',
	'wp-dyn/artsandliving/entertainmentnews, Entertainment News',
	'wp-dyn/artsandliving/fashionandbeauty, Fashion &amp; Beauty',
	'wp-dyn/artsandliving/foodanddining, Food &amp; Dining',
	'wp-dyn/home, Home &amp; Garden',
	'wp-dyn/artsandliving/horoscopes, Horoscopes',
	'wp-dyn/artsandliving/movies, Movies',
	'wp-dyn/artsandliving/museums, Museums',
	'wp-dyn/artsandliving/music, Music',
	'wp-dyn/artsandliving/sportsandrec, Sports &amp; Recreation',
	'wp-dyn/artsandliving/television, Television',
	'wp-dyn/artsandliving/theater, Theater &amp; Dance',
	'wp-dyn/travel, Travel'
) ;

levelAShortDiscussions = new Array(
  'wp-dyn/liveonline/regularhosts,Regular Hosts',
  'wp-dyn/liveonline/messageboards,Message Boards',
  'wp-dyn/liveonline/schedule,Weekly Schedule'
  // 'wp-dyn/liveonline/specialevents,Special Events'
) ;

levelADiscussions = new Array(
  'wp-dyn/liveonline/regularhosts,Regular Hosts',
  'wp-dyn/liveonline/messageboards,Message Boards',
  'wp-dyn/liveonline/schedule,Weekly Schedule',
  'wp-dyn/liveonline/candidates,Candidates Forum',
  'wp-dyn/liveonline/politics,Politics',
  'wp-dyn/liveonline/nation,Nation',
  'wp-dyn/liveonline/world,World',
  'wp-dyn/liveonline/metro,Metro',
  'wp-dyn/liveonline/sports,Sports',
  'wp-dyn/liveonline/business,Business',
  'wp-dyn/liveonline/tech,Technology',
  'wp-dyn/liveonline/style,Style',
  'wp-dyn/liveonline/entertainment,Entertainment',
  'wp-dyn/liveonline/opinion,Opinion',
  'wp-dyn/liveonline/travel,Travel',
  'wp-dyn/liveonline/health,Health',
  'wp-dyn/liveonline/homeandgarden,Home &amp; Garden',
  'wp-dyn/liveonline/food,Food',
  'wp-dyn/liveonline/education,Education',
  'wp-dyn/liveonline/postmagazine,Post Magazine',
  'wp-dyn/liveonline/realestate,Real Estate',
  'wp-dyn/liveonline/jobs,Jobs'
) ;

function getTopLink( node )
{
  if ( isInArray( levelADiscussions,"wp-dyn/"+node ) || node.indexOf("liveonline") == 0 )
    return "DISCUSSIONS,wp-dyn/liveonline" ;
  else if ( isInArray( levelAOpinion,"wp-dyn/"+node ) || node.indexOf("opinion") == 0 )
    return "OPINION,wp-dyn/opinion" ;
  else if ( isInArray( levelASports,"wp-dyn/"+node ) || node.indexOf("sports") == 0 )
    return "SPORTS,wp-dyn/sports" ;
  else if ( isInArray( levelASoftNews,"wp-dyn/"+node ) || node.indexOf("artsandliving") == 0 || node.indexOf("artsandleisure") == 0 )
    return "ARTS &amp; LIVING,wp-dyn/artsandliving" ;
  else if ( isInArray( levelAShortDiscussions,"wp-dyn/"+node ) || node.indexOf("discussions") == 0 )
    return "DISCUSSIONS,wp-dyn/liveonline" ;
  else if ( isInArray( levelAShortOpinion,"wp-dyn/"+node ) || node.indexOf("shortopinion") == 0 )
    return "OPINION,wp-dyn/opinion" ;
  else
    return "NEWS," ;
}

function getLevelA( node )
{
  if ( isInArray( levelADiscussions,"wp-dyn/"+node ) || node.indexOf("liveonline") == 0 )
    return levelADiscussions ;
  else if ( isInArray( levelAOpinion,"wp-dyn/"+node ) || node.indexOf("opinion") == 0 )
    return levelAOpinion ;
  else if ( isInArray( levelASports,"wp-dyn/"+node ) || node.indexOf("sports") == 0 )
    return levelASports ;
  else if ( isInArray( levelASoftNews,"wp-dyn/"+node ) || node.indexOf("artsandliving") == 0 )
    return levelASoftNews ;
  else if ( isInArray( levelASoftNews,"wp-dyn/"+node ) || node.indexOf("artsandleisure") == 0 )
    return levelASoftNews ;
  else if ( isInArray( levelAShortDiscussions,"wp-dyn/"+node ) || node.indexOf("discussions") == 0 )
    return levelAShortDiscussions ;
  else if ( isInArray( levelAShortOpinion,"wp-dyn/"+node ) || node.indexOf("shortopinion") == 0 )
    return levelAShortOpinion ;
  else
    return levelAHardNews ;
}

function isBlowOut(node,top_text)
{
  if ( top_text == "NEWS" && node != "style" )
    return true ;
  else
    return false ;
}

function isHighlighted( blowout,nodeIsInAry,section,node,name,url )
{
  if ( name == "More..." )
    return false ;
  else if ( !blowout && url == "wp-dyn/"+node )
    return true ;
  else if ( blowout && url == "wp-dyn/"+section )
    return true ;
  else if ( node == "style" && url == "wp-dyn/print/style" )
    return true ;
  else
    return false ;
}

function isGiffed( blowout,nodeIsInAry,section,node,name,url )
{
  if ( name == "More..." )
    return false ;
  else if ( !blowout && url == "wp-dyn/"+node )
    return true ;
  else if ( ( blowout && url == "wp-dyn/"+section && !nodeIsInAry ) )
    return true ;
  else if ( node == "style" && url == "wp-dyn/print/style" )
    return true ;
  else
    return false ;
}

blowOutArray = new Array() ;

/*
var temp = window.location.pathname;
var section = 'nation';
if (temp.indexOf("wp-srv") != -1){
  var start = temp.indexOf("wp-srv") + 7;
  var end = (temp.indexOf("/",start) != -1) ? temp.indexOf("/",start) : temp.length;
  section = temp.substring(start, end);
}
*/

var bgColorLevelA = '#OD3159';
var bgColorLevelB = '#5b87b8';
var bgColorLevelC = '#345c89';
var fgColorLevelA = '#FFFFFF';
var fgColorLevelB = '#FFFFFF';
var fgColorLevelC = '#FFFFFF';

var dotLevelA = '&nbsp;' ;
var dotLevelB = '&nbsp;<img src="http://media.washingtonpost.com/wp-srv/images/arrow.gif" width="6" height="8" border="0">&nbsp;' ;
var dotLevelC = '&nbsp;&nbsp;&nbsp;&nbsp;'

function placeMenuNav(node)
{
  node = trimNode( node ) ;
  var start = 0;
  var end = (node.indexOf("/", start) != -1) ? node.indexOf("/",start) : node.length;
  var section = node.substring(start, end);

  var style_sheet = '' ;
  style_sheet += '<link rel=stylesheet href="http://www.washingtonpost.com/wp-srv/css/sectionfronts/leftNavNS4_SF.css">\n' ; 
  style_sheet += '<style>\n' ;
  style_sheet += '<!--\n' ;
  style_sheet += '@import url("http://www.washingtonpost.com/wp-srv/css/sectionfronts/leftNavIE_SF.css");\n' ;
  style_sheet += '-->\n' ;
  style_sheet += '</style>\n' ;
  document.write( style_sheet ) ;

  document.writeln('<table width="100%" cellpadding="0" cellspacing="0" border="0">');
  
  var levelA = getLevelA(node) ;
  var oTopLink = getTopLink(node) ;
  var top_text = oTopLink.split(",")[0] ;
  var top_link = oTopLink.split(",")[1] ;
  var blowout = isBlowOut( node,top_text ) ;
  
  blowOutArray = getBlowOutArray(section+"/") ;
  var nodeIsInAry = isInArray(blowOutArray,node) ;

  document.writeln('<TR><TD BGCOLOR="#FFFFFF" HEIGHT="1"><spacer type="block" height="1"></TD></TR>') ;
  document.writeln('<TR><TD BGCOLOR="'+bgColorLevelA+'" HEIGHT="5"><spacer type="block" height="5"></TD></TR>');
  document.writeln('<TR><TD BGCOLOR="'+bgColorLevelA+'"><a href="http://www.washingtonpost.com/'+top_link+'"><font class="leftNav" color="#FFFFFF"><b>'+dotLevelA+top_text+'<b></font></a></TD></TR>');

  var topLevelHighlightInPlace = false ;
  var topLevelDotInPlace = false ;
  for (var count = 0; count < levelA.length; count++)
  {
    var url = levelA[count].substring(0, levelA[count].indexOf(","));
    var name = levelA[count].substring(levelA[count].indexOf(",") + 1, levelA[count].length);

	var highlighted = isHighlighted( blowout,nodeIsInAry,section,node,name,url ) ;
	var giffed      = isGiffed( blowout,nodeIsInAry,section,node,name,url )
 
    var useFgColor = ( useBgColor == bgColorLevelB ) ? fgColorLevelB : fgColorLevelA ;

    var oBold = '' ; var cBold = '' ;
    if ( highlighted )
    {
       if ( !topLevelHighlightInPlace )
       {
	     var useBgColor = bgColorLevelB ;
         oBold = '<b>' ;
         cBold = '</b>' ;
         topLevelHighlightInPlace = true ;
       }
	   else
         var useBgColor = bgColorLevelA ;      
    }
    else
       var useBgColor = bgColorLevelA ;      

    if ( giffed )
    {
       if ( !topLevelDotInPlace )
	   {
         var useDot = dotLevelB ;
         topLevelDotInPlace = true ;
       }
	   else
         var useDot = dotLevelA ;
    }
    else
      var useDot = dotLevelA ;
	  
	if ( highlighted && !giffed )
	{
	  useDot = dotLevelC ;
	  name = name.toUpperCase() ;
	}
  
    document.writeln('<TR><TD BGCOLOR="'+useBgColor+'"><a href="http://www.washingtonpost.com/'+url+'"><font class="leftNav" color="'+useFgColor+'">'+useDot+oBold+name+cBold+'</font></a></TD></TR>');
    
	if ( highlighted )
	  blowOutNav(section,node,blowout);
  }

  if ( top_text == "DISCUSSIONS")
  {
    document.writeln('<TR><TD BGCOLOR="'+bgColorLevelA+'" HEIGHT="5"><spacer type="block" height="5"></TD></TR>') ;
    document.writeln('<TR><TD BGCOLOR="'+bgColorLevelA+'" HEIGHT="5"><a href="http://www.washingtonpost.com/wp-srv/liveonline/viewpoint.htm"><font class="leftNav" color="#FFFFFF">&nbsp;PAID PROGRAMMING</font></a></TD></TR>') ;
    document.writeln('<TR><TD BGCOLOR="'+bgColorLevelA+'" HEIGHT="5"><a href="http://www.washingtonpost.com/wp-srv/liveonline/viewpoint.htm"><font class="leftNav" color="#FFFFFF">&nbsp;Viewpoint</font></a></TD></TR>') ;
  }

  document.writeln('<TR><TD BGCOLOR="'+bgColorLevelA+'" HEIGHT="5"><spacer type="block" height="5"></TD></TR>') ;
  // document.writeln('<TR><TD BGCOLOR="#FFFFFF" HEIGHT="1"><spacer type="block" height="1"></TD></TR>') ;
  document.writeln('</TABLE>');

  if ( top_text == "OPINION" && node != "shortopinion" )
    placeMenuNav('discussions') ;
  else if ( node.indexOf('liveonline') != -1 )
    placeMenuNav('shortopinion') ;
}

function blowOutNav(section,node,blowout)
{
  if ( blowout )
  {
    useBgColor = bgColorLevelC;
    useFgColor = fgColorLevelC;
    useDot     = dotLevelC ;
    for (var count = 0; count < blowOutArray.length; count++)
    {
      var url = blowOutArray[count].substring(0,blowOutArray[count].indexOf(","));
      var name = blowOutArray[count].substring(blowOutArray[count].indexOf(",") + 1, blowOutArray[count].length);

      if ( url.indexOf(section) == 0 )
      {
        if ( url == node )
          document.writeln('<TR><TD BGCOLOR="'+bgColorLevelB+'"><font class="leftNav">'+dotLevelB+'<a href="http://www.washingtonpost.com/wp-dyn/'+url+'" class="leftNav"><font color="'+fgColorLevelC+'">'+name+'</font></a></font></TD></TR>');
        else
          document.writeln('<TR><TD BGCOLOR="'+useBgColor+'"><font class="leftNav">'+useDot+'<a href="http://www.washingtonpost.com/wp-dyn/'+url+'"><font color="'+useFgColor+'" class="leftNav">'+name+'</font></a></font></TD></TR>');
      }
    }
  }
}

function makeArray()
{
  for(var count = 0; count < makeArray.arguments.length; count++)
    this[count] = makeArray.arguments[count];
  this.length = count;
}

function trimNode( node )
{
  if ( node.indexOf("/") != -1 )
  {
    var n = new Array() ;
	n = node.split("/") ;
	node = n[0] + "/" + n[1] ;
  }
  return node ;
}

function getBlowOutArray(section)
{
  var deepLinks = getDeepLinks(section) ;
  var boAry = new Array() ;
  var i = 0 ;
  for (var count=0; count<deepLinks.length; count++)
  {
    if ( deepLinks[count].indexOf(section) == 0 )
  {
    boAry[i] = deepLinks[count] ;
    i++ ;
    }
  }
  return boAry ;
}

function isInArray(ary,item)
{
  for (var count=0; count<ary.length; count++)
  {
    if ( ary[count].indexOf(item+",") == 0 )
    return true ;
  }
  return false ;
}

// this is for the "navigate to sections" dropdowns on the new article template
function placeDropDownNav(loc)
{
        var formName = "topSections";
        if (loc==null)
        {       loc = "top";    }
        if (loc=="bottom")
        {       var formName = "bottomSections";         }
        
        var agt=navigator.userAgent.toLowerCase()
        
        // for MAC browsers only
        if ( document.getElementById && agt.indexOf("mac")!=-1 )
        {
                //alert("true");
                document.write('<form name="'+formName+'" style="display: inline;">');
                document.write('<table cellpadding="0" cellspacing="0" border="0">');
        }
        else
        {
                //alert("false");
                document.write('<form name="'+formName+'">');
                document.write('<table cellpadding="0" cellspacing="0" border="0" align="top">');
        }
        
        //document.write('<form name="'+formName+'">');
        //document.write('<table cellpadding="0" cellspacing="0" border="0">');
        document.write('<tr><td width="5" height="5"><SPACER TYPE="BLOCK" WIDTH="5" HEIGHT="5"></td></tr>');
        document.write('<tr><td valign="top" align="middle"><select name="sections">');
        document.write('<option value="nope">Navigate to News Sections');
        
        // add jobs, cars and realestate first:
/* Removed 12/23 per Compton
        document.writeln('<option value=http://www.washingtonpost.com/wl/jobs/home>Jobs');
        document.writeln('<option value=http://www.washingtonpost.com/wp-dyn/cars/>Cars');
        document.writeln('<option value=http://www.washingtonpost.com/wp-dyn/realestate/>Real Estate');
        document.writeln('<option>--------------------');
*/        
        levelA = levelAHardNews ;
        for (var count = 0; count < levelA.length; count++)
  {
                var url = levelA[count].substring(0, levelA[count].indexOf(","));
    var name = levelA[count].substring(levelA[count].indexOf(",") + 1, levelA[count].length);
                document.writeln('<option value=http://www.washingtonpost.com/'+url+'>'+name);
        }

        // add jobs, cars and realestate first:
/* Removed 12/23 per Compton
        document.writeln('<option>--------------------');
        document.writeln('<option value=http://www.washingtonpost.com/wp-adv/archives/>Archives');
        document.writeln('<option value=http://www.washingtonpost.com/wp-srv/contents/>Site Index');
        document.writeln('<option value=http://www.washingtonpost.com/wp-dyn/admin/help/>Help/Feedback');
*/
        document.write('</select>');
        document.write('&nbsp;&nbsp;<A href="javascript:leapto(\''+formName+'\');"><img src="http://media.washingtonpost.com/wp-srv/images/go_front.gif" border="0" width="29" height="17" align="absMiddle"></a>');
        document.write('</td></tr>');
        document.write('<tr><td width="5" height="5"><SPACER TYPE="BLOCK" WIDTH="5" HEIGHT="5"></td></tr><span></form></span>');
  document.write('</table>');
}
if (typeof articleUrl == 'undefined') articleUrl = document.location.href;
if (articleUrl.indexOf('A5109-2004Jun25') != -1) adTemplate = templateConfigs[ OBIT ]