if (typeof thisNode == 'undefined') thisNode = 'news';

var adTemplate = 255;

// Define all possible ad positions
var BANNER_TOP    = 1 << 0;
var BANNER_BOTTOM = 1 << 1;
var TOWER_LEFT    = 1 << 2;
var TOWER_RIGHT   = 1 << 3;
var BIGBOX        = 1 << 4;
var BIGBOX_LEFT = 1 << 5;
var SUPER_BANNER  = 1 << 6;
var SUPER_BANNER_BOTTOM = 1 << 7;
var GOOGLE_LINKS	= 1 << 8;
var HALFPAGE_LEFT = 1 << 9;
var TOWER_LEFT_160 = 1 << 10 ;
var FOURTH_COLUMN_160 = 1 << 11 ;

// Define all possible ad templates
var NEWS_TOWER     = 0;
var NEWS_BIGBOX    = 1;
var BIGFIVE_TOWER  = 2;
var BIGFIVE_BIGBOX = 3;
var OBIT           = 4;
var NEWS_SUPER_BANNER = 5;
var BANNER_ONLY = 6;
var BOX_ONLY = 7;
var LIVEONLINE_BIGBOX = 8;
var NEWS_SUPER_BANNER_NOGOOGLE = 9;
var BOX_ONLY_NOGOOGLE = 10; 
var HALFPAGE_ONLY = 11;
var TECH          = 12;
var TECH_SUPER_BANNER = 13;
var BANNER_BIGBOX = 14;
var POLITICS_BOX_ONLY = 15;
var BIGFIVE_TOWER_NO  = 16;
var BIGFIVE_BIGBOX_NO = 17;
var ENLARGE_PHOTO = 18;
var PRINTER_FRIENDLY = 19;
var NEWS_TOWER_NO     = 20;
var LIVEONLINE_BIGBOX_NO = 21;
var HALFPAGE_ONLY_NOGOOGLE = 22;
var NEWS_SUPER_BANNER_FOURTH = 23;
var BOX_ONLY_FOURTH = 24;
var NEWS_BIGBOX_FOURTH = 25;
var NEWS_SUPER_BANNER_FOURTH_NOGOOGLE = 26;
var NEWS_BIGBOX_FOURTH_NOGOOGLE = 27;
var ADMIN_TOWER = 28; 
var ADMIN_BIGBOX = 29;
var ELECTIONS_2004 = 30;

var DEFAULT_TEMPLATE = NEWS_TOWER;

// Allow for IE User to get google links
document.layers?GOOGLE=null:GOOGLE=GOOGLE_LINKS;

if (typeof commercialNode == 'undefined') {
commercialNode = '';
}
// Makes fourth column equal to true if commercial node is equal to technology
if ( (commercialNode.indexOf("technology") != -1) && (thisNode.indexOf("technology") == -1) ) {
BIGBOX = BIGBOX_LEFT;
TOWER_LEFT_160 = null;
}


// Check screen width to see if user is eligible for fourth column skyscraper (must have a resolution higher than 860 wide, and not use Netscape
if ((screen.width<=860) || (document.layers))
	{FOURTH_COLUMN=null;}
else{FOURTH_COLUMN=FOURTH_COLUMN_160;}

// Removes google links for individual nodes.  
if (thisNode == "artsandliving/dating") GOOGLE=null; //dating exclusion to be kept forever
else if (thisNode == "opinion/columns/willgeorge") GOOGLE=null; // George Solomon Exception 2/5/04
else if (thisNode == "sports/features/crime") GOOGLE=null; // BALCO exception 02/13/2004
//else if (thisNode == "sports/latestap") GOOGLE=null; Steroid AP articles 2/17/04 - taken out 6.24.04
//else if (thisNode == "print/sports/inside") GOOGLE=null; Steroid articles 2/27/04 - taken out 6.24.04
else if (thisNode == "metro/va/homes") GOOGLE=null; //Nursing home articles 5/21/04
else if (thisNode == "metro/obituaries") GOOGLE=null; // Remove google links from obituaries.


// Removes google links for individual articles.  
articleUrl = document.location.href;
if (articleUrl.indexOf('A37827-2004Feb12') != -1) GOOGLE=null; // Feb. 13, 2004
else if (articleUrl.indexOf('A39274-2004Feb13') != -1) GOOGLE=null; // Feb. 13, 2004
else if (articleUrl.indexOf('A38191-2004Feb12') != -1) GOOGLE=null; // Feb. 13, 2004
else if (articleUrl.indexOf('A37551-2004Feb12') != -1) GOOGLE=null; // Feb. 13, 2004
else if (articleUrl.indexOf('A36962-2004Feb12') != -1) GOOGLE=null; // Feb. 13, 2004
else if (articleUrl.indexOf('A10915-2004Feb26') != -1) GOOGLE=null; // Feb. 26, 2004
else if (articleUrl.indexOf('A18014-2004Feb29') != -1) GOOGLE=null; // Mar. 1, 2004
else if (articleUrl.indexOf('A41783-2004Mar8') != -1) GOOGLE=null; // Mar. 8, 2004
else if (articleUrl.indexOf('A41780-2004Mar8') != -1) GOOGLE=null; // Mar. 8, 2004
else if (articleUrl.indexOf('A18845-2004May11') != -1) GOOGLE=null; // May 12, 2004
else if (articleUrl.indexOf('A43785-2004May20') != -1) GOOGLE=null; // May 12, 2004
else if (articleUrl.indexOf('A54028-2004Jun19') != -1) GOOGLE=null; // June 19, throwback jerseys

// Define contents of ad templates
var templateConfigs = new Array();

templateConfigs[ NEWS_TOWER ]     = SUPER_BANNER + TOWER_LEFT_160 + GOOGLE;
templateConfigs[ NEWS_BIGBOX ]    = SUPER_BANNER + SUPER_BANNER_BOTTOM + BIGBOX_LEFT + GOOGLE;
templateConfigs[ BIGFIVE_TOWER ]  = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM + GOOGLE;
templateConfigs[ BIGFIVE_BIGBOX ] = SUPER_BANNER + SUPER_BANNER_BOTTOM + BIGBOX_LEFT + GOOGLE;
templateConfigs[ BIGFIVE_TOWER_NO ]  = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM;
templateConfigs[ BIGFIVE_BIGBOX_NO ] = SUPER_BANNER + SUPER_BANNER_BOTTOM + BIGBOX_LEFT;
templateConfigs[ OBIT ]           = 0;
templateConfigs[ NEWS_SUPER_BANNER ] = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM + GOOGLE;
templateConfigs[ BANNER_ONLY ]   = SUPER_BANNER_BOTTOM + GOOGLE;
templateConfigs[ BOX_ONLY ]   = BIGBOX_LEFT + GOOGLE;
templateConfigs[ LIVEONLINE_BIGBOX ]   = SUPER_BANNER + BIGBOX_LEFT + GOOGLE;
templateConfigs[ NEWS_SUPER_BANNER_NOGOOGLE ] = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM;
templateConfigs[ BOX_ONLY_NOGOOGLE ]   = BIGBOX_LEFT ;
templateConfigs[ HALFPAGE_ONLY ] = HALFPAGE_LEFT + GOOGLE ;
templateConfigs[ HALFPAGE_ONLY_NOGOOGLE ] = HALFPAGE_LEFT;
templateConfigs[ TECH ]   = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM + BIGBOX + GOOGLE;
templateConfigs[ TECH_SUPER_BANNER ] = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM + BIGBOX + GOOGLE;
templateConfigs[ BANNER_BIGBOX ] = SUPER_BANNER + BIGBOX + GOOGLE;
templateConfigs[ POLITICS_BOX_ONLY ]   = BIGBOX_LEFT + BANNER_BOTTOM + GOOGLE;
templateConfigs[ ENLARGE_PHOTO ] = TOWER_LEFT_160;
templateConfigs[ PRINTER_FRIENDLY ] = TOWER_LEFT_160 + GOOGLE;
templateConfigs[ NEWS_TOWER_NO ]     = SUPER_BANNER + TOWER_LEFT_160;
templateConfigs[ LIVEONLINE_BIGBOX_NO ]   = SUPER_BANNER + BIGBOX_LEFT;
templateConfigs[ NEWS_SUPER_BANNER_FOURTH ] = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM + GOOGLE + FOURTH_COLUMN;
templateConfigs[ BOX_ONLY_FOURTH ]   = BIGBOX_LEFT + FOURTH_COLUMN + GOOGLE;
templateConfigs[ NEWS_BIGBOX_FOURTH ]    = SUPER_BANNER + SUPER_BANNER_BOTTOM + BIGBOX_LEFT + FOURTH_COLUMN + GOOGLE;
templateConfigs[ NEWS_SUPER_BANNER_FOURTH_NOGOOGLE ] = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM + FOURTH_COLUMN;
templateConfigs[ NEWS_BIGBOX_FOURTH_NOGOOGLE ]    = SUPER_BANNER + SUPER_BANNER_BOTTOM + BIGBOX_LEFT + FOURTH_COLUMN;
templateConfigs[ ADMIN_TOWER ]  = SUPER_BANNER + SUPER_BANNER_BOTTOM + TOWER_LEFT_160 + GOOGLE;
templateConfigs[ ADMIN_BIGBOX ]  = SUPER_BANNER + SUPER_BANNER_BOTTOM + BIGBOX_LEFT + GOOGLE;
templateConfigs[ ELECTIONS_2004 ]  = SUPER_BANNER + SUPER_BANNER_BOTTOM + GOOGLE;



// Make node-to-template assignments

// 120x600 Tower Ads
var nodeConfigs = new AdConfigurations();


nodeConfigs.addConfiguration('nation/nationalsecurity/abroad/iraq')
.addTemplateAssignment(new TemplateAssignment(BANNER_ONLY,1))
nodeConfigs.addConfiguration('metro/obituaries')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.3))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.7))
nodeConfigs.addConfiguration('nation')
.addTemplateAssignment(new TemplateAssignment(HALFPAGE_ONLY,.05))
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.25))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.70))
nodeConfigs.addConfiguration('jobs')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.5))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.5))
nodeConfigs.addConfiguration('world')
.addTemplateAssignment(new TemplateAssignment(HALFPAGE_ONLY,.1))
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.20))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.70))
nodeConfigs.addConfiguration('metro')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.2))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.8))
nodeConfigs.addConfiguration('sports')
.addTemplateAssignment(new TemplateAssignment(HALFPAGE_ONLY,.15))
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.3))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.55))
nodeConfigs.addConfiguration('business')
.addTemplateAssignment(new TemplateAssignment(HALFPAGE_ONLY,.1))
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.35))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.55))
nodeConfigs.addConfiguration('food')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.2))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.8))
nodeConfigs.addConfiguration('style')
.addTemplateAssignment(new TemplateAssignment(HALFPAGE_ONLY,.02))
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.3))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.68))
nodeConfigs.addConfiguration('travel')
.addTemplateAssignment(new TemplateAssignment(BIGFIVE_TOWER_NO,.6))
.addTemplateAssignment(new TemplateAssignment(BIGFIVE_BIGBOX,.4))
nodeConfigs.addConfiguration('health')
.addTemplateAssignment(new TemplateAssignment(BIGFIVE_TOWER,.3))
.addTemplateAssignment(new TemplateAssignment(BIGFIVE_BIGBOX,.7))
nodeConfigs.addConfiguration('home')
.addTemplateAssignment(new TemplateAssignment(BIGFIVE_TOWER,.45))
.addTemplateAssignment(new TemplateAssignment(BIGFIVE_BIGBOX,.55))
nodeConfigs.addConfiguration('education')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.65))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.35))
nodeConfigs.addConfiguration('world/columns/sanchezmarcela')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER_NOGOOGLE,.4))
.addTemplateAssignment(new TemplateAssignment(BOX_ONLY_NOGOOGLE,.6))
nodeConfigs.addConfiguration('liveonline')
.addTemplateAssignment(new TemplateAssignment(NEWS_TOWER,.5))
.addTemplateAssignment(new TemplateAssignment(LIVEONLINE_BIGBOX,.5))
nodeConfigs.addConfiguration('realestate')
.addTemplateAssignment(new TemplateAssignment(NEWS_TOWER,1))
nodeConfigs.addConfiguration('technology')
.addTemplateAssignment(new TemplateAssignment(TECH_SUPER_BANNER,1))
nodeConfigs.addConfiguration('politics')
.addTemplateAssignment(new TemplateAssignment(HALFPAGE_ONLY,.15))
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.20))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.65))
nodeConfigs.addConfiguration('weather')
.addTemplateAssignment(new TemplateAssignment(NEWS_TOWER,.6))
.addTemplateAssignment(new TemplateAssignment(LIVEONLINE_BIGBOX,.4))
nodeConfigs.addConfiguration('entertainment')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.15))
.addTemplateAssignment(new TemplateAssignment(NEWS_TOWER,.35))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.5))
nodeConfigs.addConfiguration('artsandliving')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.1))
.addTemplateAssignment(new TemplateAssignment(NEWS_TOWER,.35))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.55))
nodeConfigs.addConfiguration('opinion')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.3))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.7))
nodeConfigs.addConfiguration('mostemailed')
.addTemplateAssignment(new TemplateAssignment(NEWS_SUPER_BANNER,.5))
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,.5))
nodeConfigs.addConfiguration('admin/keycontent')
.addTemplateAssignment(new TemplateAssignment(ADMIN_BIGBOX,1))
nodeConfigs.addConfiguration('visitorsguide')
.addTemplateAssignment(new TemplateAssignment(NEWS_TOWER,1))
nodeConfigs.addConfiguration('search/newssearch')
.addTemplateAssignment(new TemplateAssignment(NEWS_BIGBOX,1))
nodeConfigs.addConfiguration('politics/elections2003')
.addTemplateAssignment(new TemplateAssignment(ELECTIONS_2004,1))
nodeConfigs.addConfiguration('politics/elections2004')
.addTemplateAssignment(new TemplateAssignment(ELECTIONS_2004,1))



// For this node, select a template
if ( (typeof commercialNode != 'undefined') && (commercialNode != "") ) {
if (thisNode.indexOf("technology") != -1) {
adTemplate = nodeConfigs.getTemplate( thisNode )
}
else {
adTemplate = nodeConfigs.getTemplate( commercialNode );
}
}

else {
adTemplate = nodeConfigs.getTemplate( thisNode );
}

if (document.location.href.indexOf("debugAdCode") != -1) document.writeln("Ad Template: " + adTemplate);

// Define objects
// TemplateAssignment associates a template with a frequency ( 0 <= frq <= 1 )
function TemplateAssignment( tmpl, frq )
{
  this.template = tmpl;
  this.frequency = ( ( frq >= 0 ) && ( frq <= 1 ) ) ? frq : 0 ;
}

// NodeTemplateAssignment collects TemplateAssignment objects for a specific node
function NodeTemplateAssignment ( node )
{
  this.node = node;
  this.templates = new Array();
  this.templateCount = 0;
  
  this.addTemplateAssignment = _addAdTemplateAssignment;
  this.selectTemplate = _adSelectTemplate;
}

// AdConfigurations collects NodeTemplateAssignments for the site
function AdConfigurations ()
{
  this.configs = new Array();
  this.length = 0;
  
  this.addConfiguration = _addAdConfiguration;
  this.getTemplate = _adGetTemplate;
}

function _adSelectTemplate()
{
  var base = 0;
  var rNum = Math.random();
  var rTemplate = NEWS_TOWER;
  
  for (var count = 0; count < this.templates.length; count++)
  {
    if ( rNum < this.templates[count].frequency + base ) 
    {
      rTemplate = this.templates[count].template;
      break;
      //return this.templates[count].template;
    }
    else
    {
      base += this.templates[count].frequency;
    }
  }
  return rTemplate;
}

function _adGetTemplate ( node )
{
  adTemplate = DEFAULT_TEMPLATE;
  var base = 0;
  var bestMatch = 0;
  for ( var count = 0; count < this.length; count++ )
  {
    if ( this.configs[count].node == node )
    {
      adTemplate = this.configs[count].selectTemplate();
      break;
    }
    else if (( node.indexOf(this.configs[count].node) == 0 ) && ( this.configs[count].node.length > bestMatch ))
    {
      adTemplate = this.configs[count].selectTemplate();
      bestMatch = this.configs[count].node.length;
    }
  }
  return templateConfigs[adTemplate];
}

function _addAdTemplateAssignment( templateAssignment )
{
  this.templates[this.templateCount++] = templateAssignment;
  return this;
}

function _addAdConfiguration ( n )
{
  this.configs[this.length++] = new NodeTemplateAssignment (n);
  return this.configs[this.length - 1];
}