

/*
	function: playVideo
	
	inputs:
			iVideoID: y! music videoID (required)
			sRD: yahoo redirect URL (optional)
			sSkinID: video player skinID
			
	notes:
		- adding support for older implementations (specifically yahooligans)
*/
	function playMyVideos() { playLAUNCHVideo('', '', '', 'p/m.xml'); }
	function playVideo( iVideoID, sRD ) { playVideos(iVideoID, '', '', '', '', '', '', sRD); }
	
	function playLAUNCHVideo( videoID, bandwidth, vo, showPath, playerSkin, forceSplash, clientID, sPopupCheckerURL ) {
		if(isNaN(videoID)) return false;
		sPopupCheckerURL	= ( typeof(sPopupCheckerURL) == undefined )? '':sPopupCheckerURL;
		showPath			= ( typeof(showPath) == undefined )? '':showPath;
		playerSkin			= ( typeof(playerSkin) == undefined )? '':playerSkin;
		forceSplash			= ( typeof(forceSplash) == undefined )? '':forceSplash;
		bandwidth			= ( typeof(bandwidth) == undefined )? '':bandwidth;
		vo					= ( typeof(vo) == undefined )? '':vo;
		
		playVideos( videoID, sPopupCheckerURL, showPath, playerSkin, forceSplash, bandwidth, vo );
	}
	
	function playVideos( iVideoID, sPopupCheckerURL, sVideoShow, iSkinID, bForceSplash, iBandwidth, sVO, sRD ) {

		var targetWindow = ( common_playvideos_isBlank(self.name) ) ? common_playvideos_targetWindow : self.name;
		self.name = targetWindow;
	
	// filtering
		if ( !isNaN( iVideoID ) ) common_playvideos_videoID = iVideoID;
		if ( !common_playvideos_isBlank( sVideoShow ) ) common_playvideos_show = sVideoShow;
		if ( !isNaN( iSkinID ) ) common_playvideos_skinID = iSkinID;
		if ( !isNaN( bForceSplash ) ) common_playvideos_forceSplash = bForceSplash;
		if ( isNaN( iBandwidth ) ) iBandwidth = '';
		if ( common_playvideos_isBlank( sVO ) ) sVO = '';
		if ( common_playvideos_isBlank( sPopupCheckerURL ) ) sPopupCheckerURL = common_playvideos_default_redirect_path;
				
	// build param list
		var params = 'cid=' + common_playvideos_clientID + '&vid=' + common_playvideos_videoID + '&sx=' + common_playvideos_show + '&ps=' + common_playvideos_skinID + '&bw=' + iBandwidth + '&fs=' + common_playvideos_forceSplash + '&tw=' + targetWindow + '&vo=' + sVO;
		//sPopupCheckerURL is the redirect - really need to pass this in
		params += "&redirectURL=" + escape(sPopupCheckerURL);
		
		var sPlayerURL = ( ( !common_playvideos_isBlank( sRD ) ) ? sRD : '') + common_playvideos_player_path + '?' + params;
	//open player	
		var videoWin = window.open( sPlayerURL , 'videoPlayerWindow', 'WIDTH=690,HEIGHT=520');
		common_popup_checkForNewWindow(videoWin, sPopupCheckerURL, common_playvideos_getPopupErrorUrl() + params);
	}
	
	function common_playvideos_isBlank( what )		{ return (typeof what == 'undefined' || what == null || what == 'undefined' || what == ''); }
	function common_playvideos_getPopupErrorUrl()	{ return common_playvideos_popup_error_path + '?showtext=Y&'; };