/*
 * CommonWindowOpener.js
 * This file defines a common_class_openwindow class to manage opening windows, especially with popup blocking
 */
 
// Constructor
function CommonWindowOpener()
{
}

// global variables

CommonWindowOpener.windowArray = new Array();

// static
CommonWindowOpener.openWindow = CommonWindowOpener_openWindow;
CommonWindowOpener.checkForNewWindow = CommonWindowOpener_checkForNewWindow;
CommonWindowOpener.redirectWindow = CommonWindowOpener_redirectWindow;
CommonWindowOpener.clearWindowCheck = CommonWindowOpener_clearWindowCheck;

function CommonWindowOpener_openWindow( url, windowName, windowFeatures, fail, pass )
{
	// set window name
	if (windowName == null || typeof(windowName) == "undefined" || windowName == "")
	{
		windowName = "cwo" + CommonWindowOpener.windowArray.length;
	}
	
	// try to open the window
	var openCommand = "window.open('" + url + "', '" + windowName + "'" + (typeof(windowFeatures) != "undefined" ? ", '" + windowFeatures + "'" : "") + ")";
	var targetWindow = eval(openCommand);
	
	// set timeout
	if (targetWindow)
	{
		var redirectURL = "";
		if ((pass != '') && (pass != null) && (pass != 'undefined') && (pass != new String(window.location)))
		{
			redirectURL = pass;
		}
		var timeoutID = setTimeout("CommonWindowOpener.checkForNewWindow('" + windowName + "','" + fail + "','" + redirectURL + "')", 3000);
		CommonWindowOpener.windowArray[CommonWindowOpener.windowArray.length] = new Array(windowName, timeoutID, targetWindow);
	}
	else
	{
		CommonWindowOpener.redirectWindow(fail);
	}
}

function CommonWindowOpener_checkForNewWindow( windowName, fail, pass )
{
	for (i = 0; i < CommonWindowOpener.windowArray.length; i++)
	{
		if (CommonWindowOpener.windowArray[i][0] == windowName)
		{
			var targetWindow = CommonWindowOpener.windowArray[i][2];
			if (targetWindow.closed)
			{
				CommonWindowOpener.redirectWindow(fail);
			}
			else
			{
				if (pass != "")
				{
					CommonWindowOpener.redirectWindow(pass);
				}
			}
			break;
		}
	}
}

function CommonWindowOpener_redirectWindow( url )
{
	window.top.location.replace(url);
}

function CommonWindowOpener_clearWindowCheck( windowName )
{
	for (i = 0; i < CommonWindowOpener.windowArray.length; i++)
	{
		if (CommonWindowOpener.windowArray[i][0] == windowName)
		{
			clearTimeout(CommonWindowOpener.windowArray[i][1]);
			break;
		}
	}
}