var adTemplate = 255 ;
document.layers?overture=null:overture='OVERTURE_LINKS';

// Define all possible ad positions
var BANNER_TOP    = 1 << 0;
var BANNER_BOTTOM = 1 << 1;
var TOWER_LEFT    = 1 << 2;
var TOWER_RIGHT   = 1 << 3;
var BIGBOX        = 1 << 4;
var SUPER_BANNER  = 1 << 5;
var SUPER_BANNER_BOTTOM = 1 << 6;
var TILE_ONE      = 1 << 7;
var TILE_TWO      = 1 << 8;
var TOWER_RIGHT_160=1 << 9;
var OVERTURE_LINKS   =1 << 10;
var HALFPAGE_RIGHT =1 << 11;
var HALFPAGE_LEFT =1 << 12;
var GOOGLE_LINKS = 1 << 11;

// Define all possible ad templates
var CARS_BANNER      = 0;
var CARS_LEADERBOARD = 1;
var TRAVEL           = 2;
var OBIT             = 3;
var SKYONLY          = 4;
var SUPER_OVERTURE	 = 5;
var ENTERTAINMENT_SUPER	 = 6;
var COMICS          = 7;
var DEFAULT_TEMPLATE = SUPER_OVERTURE;
var ARTS_LIVING_BIGBOX = 8;
var ARTS_LIVING_HALF   = 9;
var ARTS_LIVING_TOWER  = 10;
var REAL_ESTATE = 11;
var ARTS_LIVING_TOWER_120 = 12;
var TRAFFIC_FRONT = 13;
var TRAFFIC_SUBSECTION_BIGBOX = 14;
var TRAFFIC_SUBSECTION_TOWER = 15;
var TRAFFIC_FRONT_BIGBOX = 16;
var TRAFFIC_FRONT_TOWER = 17;
var NO_ADS = 18;
var WEATHER_TOWER = 19;
var WEATHER_BIGBOX = 20;
var BESTBETS_TOWER  = 21;
var BESTBETS_BIGBOX = 22;
var FEDWORK_ONLY = 23;
var TECH_BANNER = 24;
var REAL_ESTATE_BIGBOX = 25;
var KEY = 26;
var	JOBS_BIGBOX = 27;
var	JOBS_TOWER = 28;
// Allow for IE User to get google links
OVERTURE=OVERTURE_LINKS;

if (typeof thisNode == 'undefined') thisNode = 'news';
//if (thisNode != 'travel') TILE_ONE = null;

// Define contents of ad templates
var templateConfigs = new Array();
templateConfigs[ CARS_BANNER ]      = SUPER_BANNER + TOWER_RIGHT_160 +SUPER_BANNER_BOTTOM;
templateConfigs[ TECH_BANNER ]      = SUPER_BANNER + TOWER_RIGHT_160 +SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ CARS_LEADERBOARD ] = SUPER_BANNER + TOWER_RIGHT_160 + TILE_ONE + TILE_TWO + SUPER_BANNER_BOTTOM;
templateConfigs[ TRAVEL ] = SUPER_BANNER + TOWER_RIGHT_160 + TILE_ONE + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ OBIT        ] = 0;
templateConfigs[ SKYONLY     ] = TOWER_RIGHT_160 + OVERTURE;
templateConfigs[ SUPER_OVERTURE ] = SUPER_BANNER + TOWER_RIGHT_160 + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ ENTERTAINMENT_SUPER ] = SUPER_BANNER + TOWER_RIGHT_160 + SUPER_BANNER_BOTTOM + OVERTURE ;
templateConfigs[ COMICS ] = SUPER_BANNER + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ ARTS_LIVING_BIGBOX ] = SUPER_BANNER + BIGBOX + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ ARTS_LIVING_HALF ] = SUPER_BANNER + HALFPAGE_RIGHT + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ KEY ] = SUPER_BANNER + HALFPAGE_LEFT + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ ARTS_LIVING_TOWER ] = SUPER_BANNER + TOWER_RIGHT_160 + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ ARTS_LIVING_TOWER_120 ] = SUPER_BANNER + TOWER_RIGHT + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ REAL_ESTATE_BIGBOX ] = SUPER_BANNER + BIGBOX + SUPER_BANNER_BOTTOM;
templateConfigs[ REAL_ESTATE ] = SUPER_BANNER + TOWER_RIGHT_160 + SUPER_BANNER_BOTTOM;
templateConfigs[ TRAFFIC_FRONT_BIGBOX ] = SUPER_BANNER + BIGBOX + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ TRAFFIC_FRONT_TOWER ] = SUPER_BANNER + SUPER_BANNER_BOTTOM + TOWER_RIGHT_160 + OVERTURE;
templateConfigs[ TRAFFIC_SUBSECTION_BIGBOX ] = SUPER_BANNER + SUPER_BANNER_BOTTOM + BIGBOX + OVERTURE;
templateConfigs[ TRAFFIC_SUBSECTION_TOWER ] = SUPER_BANNER + SUPER_BANNER_BOTTOM + TOWER_RIGHT_160 + OVERTURE;
templateConfigs[ WEATHER_TOWER ] = SUPER_BANNER + TOWER_RIGHT + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ WEATHER_BIGBOX ] = SUPER_BANNER + BIGBOX + SUPER_BANNER_BOTTOM + OVERTURE;
templateConfigs[ NO_ADS ] = null;
templateConfigs[ BESTBETS_BIGBOX ]   = SUPER_BANNER + BIGBOX + OVERTURE;
templateConfigs[ BESTBETS_TOWER ]    = SUPER_BANNER + TOWER_RIGHT_160 + OVERTURE;
templateConfigs[ JOBS_BIGBOX ] = SUPER_BANNER + BIGBOX + SUPER_BANNER_BOTTOM;
templateConfigs[ JOBS_TOWER ] = SUPER_BANNER + TOWER_RIGHT_160 + SUPER_BANNER_BOTTOM;


// Make node-to-template assignments
var nodeConfigs = new AdConfigurations();
nodeConfigs.addConfiguration( 'travel' )
           	.addTemplateAssignment ( new TemplateAssignment( TRAVEL, 1) );
nodeConfigs.addConfiguration( 'travel/' )
           	.addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE, 1) );
nodeConfigs.addConfiguration( 'cars' )
           	.addTemplateAssignment ( new TemplateAssignment( CARS_BANNER, 1) );
nodeConfigs.addConfiguration( 'entertainment/search' )
           	.addTemplateAssignment ( new TemplateAssignment( ARTS_LIVING_BIGBOX,  .5) )
           	.addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE,   .5) );
nodeConfigs.addConfiguration( 'entertainment/profile' )
           	.addTemplateAssignment ( new TemplateAssignment( ARTS_LIVING_BIGBOX,  .5) )
           	.addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE,   .5) );
nodeConfigs.addConfiguration( 'entertianment/review' )
           	.addTemplateAssignment ( new TemplateAssignment( ARTS_LIVING_BIGBOX,  .5) )
           	.addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE,   .5) );
nodeConfigs.addConfiguration( 'admin/keycontent' )
			.addTemplateAssignment ( new TemplateAssignment( ARTS_LIVING_BIGBOX,  .5) )
			.addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE,   .5) );
nodeConfigs.addConfiguration( 'politics/fedpage/workers' )
			.addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE,   1) );
nodeConfigs.addConfiguration( 'realestate' )
			.addTemplateAssignment ( new TemplateAssignment( REAL_ESTATE,   1) );
nodeConfigs.addConfiguration( 'rentals' )
			.addTemplateAssignment ( new TemplateAssignment( REAL_ESTATE_BIGBOX, .5) )
			.addTemplateAssignment ( new TemplateAssignment( REAL_ESTATE,   .5) );
nodeConfigs.addConfiguration( 'traffic' )
			.addTemplateAssignment ( new TemplateAssignment( TRAFFIC_FRONT_TOWER,   1) );
nodeConfigs.addConfiguration( 'traffic/drgridlock' )
			.addTemplateAssignment ( new TemplateAssignment( TRAFFIC_SUBSECTION_TOWER,   1) );
nodeConfigs.addConfiguration( 'traffic/metrorail' )
			.addTemplateAssignment ( new TemplateAssignment( TRAFFIC_SUBSECTION_TOWER,   1) );		
nodeConfigs.addConfiguration( 'admin/testing/other' )
			.addTemplateAssignment ( new TemplateAssignment( TRAFFIC_FRONT_BIGBOX,   .5) )
			.addTemplateAssignment ( new TemplateAssignment( TRAFFIC_FRONT_TOWER,   .5) );
nodeConfigs.addConfiguration( 'admin/testing/travel' )
			.addTemplateAssignment ( new TemplateAssignment( TRAFFIC_SUBSECTION_BIGBOX,   .5) )
			.addTemplateAssignment ( new TemplateAssignment( TRAFFIC_SUBSECTION_TOWER,   .5) );
nodeConfigs.addConfiguration( 'technology' )
			.addTemplateAssignment ( new TemplateAssignment( TECH_BANNER,   1) );
nodeConfigs.addConfiguration( 'weather' )
			.addTemplateAssignment ( new TemplateAssignment( WEATHER_BIGBOX, 1) )
nodeConfigs.addConfiguration( 'artsandliving/entertainmentguide/bestbets' )
			.addTemplateAssignment ( new TemplateAssignment( BESTBETS_TOWER,   .7) )
			.addTemplateAssignment ( new TemplateAssignment( BESTBETS_BIGBOX,   .3) );
nodeConfigs.addConfiguration( 'cars/specials/warrenbrown' )
			.addTemplateAssignment ( new TemplateAssignment( REAL_ESTATE, 1) );
nodeConfigs.addConfiguration( 'visitorsguide' )
          .addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE,   1) );
nodeConfigs.addConfiguration( 'jobs/' )
				.addTemplateAssignment ( new TemplateAssignment( JOBS_BIGBOX, .5) )
			.addTemplateAssignment ( new TemplateAssignment( JOBS_TOWER,   .5) );
nodeConfigs.addConfiguration( 'print' )
			.addTemplateAssignment ( new TemplateAssignment( SUPER_OVERTURE, 1 ) );
nodeConfigs.addConfiguration( 'admin/classifieds')
			.addTemplateAssignment ( new TemplateAssignment( ARTS_LIVING_BIGBOX,1 ) );


// For this node, select a template
adTemplate = nodeConfigs.getTemplate( thisNode );
if (document.location.href.indexOf("debugAdCode") != -1) document.writeln("Ad Template: " + adTemplate);

// Define objects
// TemplateAssignment associates a template with a frequency ( 0 <= frq <= 1 )
function TemplateAssignment( tmpl, frq )
{
  this.template = tmpl;
  this.frequency = ( ( frq >= 0 ) && ( frq <= 1 ) ) ? frq : 0 ;
}

// NodeTemplateAssignment collects TemplateAssignment objects for a specific node
function NodeTemplateAssignment ( node )
{
  this.node = node;
  this.templates = new Array();
  this.templateCount = 0;
  
  this.addTemplateAssignment = _addAdTemplateAssignment;
  this.selectTemplate = _adSelectTemplate;
}

// AdConfigurations collects NodeTemplateAssignments for the site
function AdConfigurations ()
{
  this.configs = new Array();
  this.length = 0;
  
  this.addConfiguration = _addAdConfiguration;
  this.getTemplate = _adGetTemplate;
}

function _adSelectTemplate()
{
  var base = 0;
  var rNum = Math.random();
  var rTemplate = 0;
  
  for (var count = 0; count < this.templates.length; count++)
  {
    if ( rNum < this.templates[count].frequency + base ) 
    {
      rTemplate = this.templates[count].template;
      break;
      //return this.templates[count].template;
    }
    else
    {
      base += this.templates[count].frequency;
    }
  }
  return rTemplate;
}

function _adGetTemplate ( node )
{
  adTemplate = DEFAULT_TEMPLATE;
  var base = 0;
  var bestMatch = 0;
  for ( var count = 0; count < this.length; count++ )
  {
    if ( this.configs[count].node == node )
    {
      adTemplate = this.configs[count].selectTemplate();
      break;
    }
    else if (( node.indexOf(this.configs[count].node) == 0 ) && ( this.configs[count].node.length > bestMatch ))
    {
      adTemplate = this.configs[count].selectTemplate();
      bestMatch = this.configs[count].node.length;
    }
  }
  return templateConfigs[adTemplate];
}

function _addAdTemplateAssignment( templateAssignment )
{
  this.templates[this.templateCount++] = templateAssignment;
  return this;
}

function _addAdConfiguration ( n )
{
  this.configs[this.length++] = new NodeTemplateAssignment (n);
  return this.configs[this.length - 1];
}
