/**
This file contains all the functions related to the cookie
and how it functions.  Most of the things in here are 
functions but there are some function calls and global variables
that are set and the order of the execution is very important.
*/

// creates a cookie with the given parameters
function createCookie(name,value,days){
	if (days){
		var date = new Date();
		date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
		var expires = "; expires=" + date.toGMTString();
	} else {
		var expires = "";
	}
	document.cookie = name + "=" + value + expires + "; path=/";
}

// locates and reads the value of a cookie with a specified name
function readCookie(name){
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++)	{
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

// deletes a cookie with a specified name
function eraseCookie(name){
	createCookie(name,"",-1);
}

// parses the value of the cookie
// returns an array of the different values
function parseCookie(cookievalues){
	if (cookieValues.length > 0){
		var cookieValuesArray = new Array(3);
		var CookiesArray = cookievalues.split("&");
		for (var i = 0; i < CookiesArray.length; i++){
			var v = CookiesArray[i].split(":");
			cookieValuesArray[i] = v[1];
		}
		return cookieValuesArray;
	} else {
		return null;
	}
}

// cookieValues is a global variable that is an array of the different
// cookie values.  Check first if the cookie exists, if not then create 
// a cookie with the default values.
var cookieValues = new Array(3);
var cv = readCookie("ihtuserdata");
if (cv){
	cookieValues = parseCookie(cv);
// else, there is no cookie so try to create one
} else {
	createCookie("ihtuserdata","columnMode:3&fontSize:12&clippings:",7);
	cv = readCookie("ihtuserdata");
	if (cv){
		// the cookie was created, parse the values
		cookieValues = parseCookie(cv);
	} else {
		// the cookie was not created, use default values,
		// i.e. cookies may be blocked
		cookieValues[0] = "3"; // column mode
		cookieValues[1] = "12"; // font size
		cookieValues[2] = ""; // clippings (leave it empty)
	}
}
