/*
This file contains all of the functions for the clippings.
This is all functions so the order is not important.
*/

// adds a clipping to the cookie, prevents the addition of duplicates
function addClipping(url,headline,obj){
	if (headline.indexOf("|039|") != -1) {
		headline = headline.replace(/\|039\|/g, "&#039;");
	}
	var cv1 = readCookie("ihtuserdata");
	cookieValues = parseCookie(cv1);
	var newclippingstring = cookieValues[2];
	var clippings = cookieValues[2].split("~");
	for (var i = 0; i < (clippings.length - 1); i++){
		var clippingsVals = clippings[i].split("^");
		if (clippingsVals[0] == url){
			return;
		}
	}		
	var newclipping = url + "^" + escape(headline) + "^" + "0~";
	newclippingstring = newclippingstring + newclipping;
	var cv = "columnMode:" + cookieValues[0] + "&fontSize:" + cookieValues[1] + "&clippings:" + newclippingstring;
	createCookie("ihtuserdata",cv,7);
	obj.style.visibility = "hidden";
	countClippings();
}

// displays the clippings from the cookie
var activeClippingsMenu = false;
function displayClippings(){
	var cv1 = readCookie("ihtuserdata");
	cookieValues = parseCookie(cv1);
	var clippings = cookieValues[2].split("~");
	var clippingsarea = document.getElementById("clippingsarea");
	var clippingsmenu = document.getElementById("clippingsmenu");
	activeClippingsMenu = true;
	clippingsmenu.style.display = "block";
	clippingsmenu.style.visibility = "visible";
	var html = "";
	for (var i = 0; i < (clippings.length - 1); i++){
		var clippingsVals = clippings[i].split("^");
		if (clippingsVals[2] == 1){
			//html = html + '<a href="' + clippingsVals[0] + '" onmousedown="javascript:markAsRead(' + "'" + clippingsVals[0] + "'" + ');">' + clippingsVals[1] + '</a><br>';
			html = html + '<a href="' + clippingsVals[0] + '" onmousedown="javascript:markAsRead(' + "'" + clippingsVals[0] + "'" + ');"><span style="color: #ffcf31">' + unescape(clippingsVals[1]) + '</span></a>';
		} else {
			html = html + '<a href="' + clippingsVals[0] + '" onmousedown="javascript:markAsRead(' + "'" + clippingsVals[0] + "'" + ');">' + unescape(clippingsVals[1]) + '</a>';
		}
	}
	clippingsarea.innerHTML = html;
}

// marks a clipping as "read"
function markAsRead(url){
	var newclippingstring = "";
	var cv1 = readCookie("ihtuserdata");
	cookieValues = parseCookie(cv1);
	var clippings = cookieValues[2].split("~");
	for (var i = 0; i < (clippings.length - 1); i++){
		var clippingsVals = clippings[i].split("^");
		var newclipping = "";
		if (url == clippingsVals[0]){
			newclipping = clippingsVals[0] + "^" + clippingsVals[1] + "^" + "1~";
		} else {
			newclipping = clippingsVals[0] + "^" + clippingsVals[1] + "^" + "0~";
		}
		newclippingstring = newclippingstring + newclipping;
	}
	var cv = "columnMode:" + cookieValues[0] + "&fontSize:" + cookieValues[1] + "&clippings:" + newclippingstring;
	createCookie("ihtuserdata",cv,7);
}

// removes all clippings from the cookie
function removeAllClippings(){
	// unhide all clippings
	var cv1 = readCookie("ihtuserdata");
	cookieValues = parseCookie(cv1);
	var clippings = cookieValues[2].split("~");
	for (var i = 0; i < (clippings.length - 1); i++){
		var clippingsVals = clippings[i].split("^");
		if (document.getElementById(clippingsVals[0]) != null){
			document.getElementById(clippingsVals[0]).style.visibility = "visible";
		}
	}
	// put empty clippings into the cookie
	var cv = "columnMode:" + cookieValues[0] + "&fontSize:" + cookieValues[1] + "&clippings:";
	createCookie("ihtuserdata",cv,7);
	countClippings();
	displayClippings();
}

// removes clippings that are marked as "read"
function removeAllReadClippings(){
	var newclippingstring = "";
	var cv1 = readCookie("ihtuserdata");
	cookieValues = parseCookie(cv1);
	var clippings = cookieValues[2].split("~");
	for (var i = 0; i < (clippings.length - 1); i++){
		var clippingsVals = clippings[i].split("^");
		var newclipping = "";
		if (clippingsVals[2] == 0){
			newclipping = clippingsVals[0] + "^" + clippingsVals[1] + "^" + "0~";
		} else {
			if (document.getElementById(clippingsVals[0]) != null){
				document.getElementById(clippingsVals[0]).style.visibility = "visible";
			}
		}
		newclippingstring = newclippingstring + newclipping;
	}
	var cv = "columnMode:" + cookieValues[0] + "&fontSize:" + cookieValues[1] + "&clippings:" + newclippingstring;
	createCookie("ihtuserdata",cv,7);
	countClippings();
	displayClippings();
}

// checks the clippings in the cookie and compares that
// to the clippings on the page. If they match it hides 
// the clippings icon from the user.
function hideClippedStories(){
	var clippings = cookieValues[2].split("~");
	for (var i = 0; i < clippings.length; i++){
		var clippingsVals = clippings[i].split("^");
		for (var j = 0; j < availableClippings.length; j++){
			var obj = document.getElementById(availableClippings[j]);
			if (clippingsVals[0] == availableClippings[j]){
				obj.style.visibility = "hidden";
			}
		}
	}
}

// counts the total number of clippings
function countClippings(){
	var cv1 = readCookie("ihtuserdata");
	cookieValues = parseCookie(cv1);
	var totalclippings = 0;
	if (cookieValues[2] == ""){
		totalclippings = 0;
	} else {
		var clippings = cookieValues[2].split("~");
		clippings.pop(); // split seems to return an extra element here so pop it off the array
		var totalclippings = clippings.length;
	}
	document.getElementById("numOfClippings").innerHTML = totalclippings;
}

// functions to hide the clippings menu when screen is clicked
// This uses the 3 functions: menuOut(), eventHideMenu(), initClippingsMenu()
// convoluted, yes, but it works...
function menuOut(){
	document.onclick = eventHideMenu;
	if (document.all){
		event.cancelBubble = true;
	}
}

// hides the clippings menu
function eventHideMenu(){
	document.onclick = null;
	if (activeClippingsMenu == true){
		//alert("activeClippingsMenu is set to true");
		var obj = document.getElementById("clippingsmenu");
		obj.style.visibility = "hidden";
		obj.style.display = "none";
	}
}

// initializes the clippings menu
function initClippingsMenu(){
	var menuobj = document.getElementById("clippingsmenu");
	menuobj.onmouseout = menuOut;
}
