/*
This file contains all other user interaction functions:
switching to the 3 column layout, switching to the 1 column
layout, increasing and decreasing the font, setting the 
window resize, etc.
*/

var classFix;
if (document.all){
	classFix = "className";
} else {
	classFix = "class";
}

// these values come from the cookie
var columnMode = cookieValues[0];

// set some defaults values
var originalHeight;
var lineHeight = 16;
var currentPos = 0;

// use these values to manipulate the width of the text columns
// col3Width is used in the 3 column layout and col1Width is 
// used in the 1 column layout.
var col3Width = 210;
var col1Width = 400;
var colWidth = 0;

// use this number to manipulate the height of the article text box
// it is counter intuitive: smaller is taller, bigger is shorter
var heightOfColumns = 250;

var articlePhoto = null;

// returns the height of the current window
function getHeight(obj){
	if (obj == "window"){
		if (window.innerHeight){
			return window.innerHeight;
		} else {
			return document.getElementById("bodyNode").offsetHeight;
		}
	} else {
		obj = document.getElementById(obj);
		if (obj.offsetHeight){
			return obj.offsetHeight;
		}
	}
}
	
// makes the columns and copies the text node into the newly
// created columns ac is the div holding the cloned node - at
function articleSetup(){
	// get the fontSize value from the cookie
	var cv1 = readCookie("ihtuserdata");
	if (cv1){
		cookieValues = parseCookie(cv1);
	} else {
		cookieValues[1] = "12";	
	}
	var fontSize = parseInt(cookieValues[1]);
	var parentDiv = document.getElementById("articleParent");
	var currentPos = 0;
	for (var i = 0; i < 3; i++){
		var col = document.createElement("div");
		col.setAttribute("id", "ac" + i);
		//col.setAttribute("class", "artCol");
		col.setAttribute(classFix, "artCol");
		parentDiv.appendChild(col);
		var obj = document.getElementById("articleBody");
		var artText = obj.cloneNode(true);
		artText.setAttribute("id", "at" + i);
		artText.style.display = "block";
		artText.style.top = "0px";
		artText.style.fontSize = fontSize + "px";
		artText.style.lineHeight = lineHeight + "px";
		col.appendChild(artText);		
	}
	/*if (document.getElementById("articlePhoto")){
		articlePhoto = document.getElementById("articlePhoto");
	}*/
}

// moves the columns into position, but adjust the top
function layoutArticles(){	
	var parentHeight = getHeight("articleParent");
	for (var i = 0; i < columnMode; i++){
		var obj = document.getElementById("at" + i);
		//make sure at least 2 rows of article text are available 
		if (parentHeight > (2 * lineHeight)){
			obj.style.top = -1 * (parentHeight * (i + currentPos));
		}
	}
	/*if (articlePhoto != null){
		layoutPhoto();
	}*/
	articlePages();
}

// resets the article to the first "page"
function resetArticle(){
	currentPos = 0;
	layoutArticles();
}

// returns the snap to align article; this adjusts the height of the 
// article window with a number divisible by line height. the minium 
// number of rows is 10
function setSnap(mod){
	if (mod == null){
		mod = 0;
	}
	var snap = lineHeight * Math.round((getHeight("window") - mod) / lineHeight);
	if (snap < (lineHeight * 10)){
		snap = lineHeight * 10;
		if (window.scrollTo){
			window.scrollTo(0, 75);
		}
	} else if (window.scrollTo){
		window.scrollTo(0, 0);
	}
	return snap;
}

// clips the parent layer to the defined visible area
// if space allows include bottom, otherwise clip out most of bottom
function setArticleHeight(){
	if (columnMode > 1){
		if (document.getElementById("articleBody") != null){
			document.getElementById("articleParent").style.height = setSnap(heightOfColumns);
			var tHeight = getHeight("at1");
			parentHeight = getHeight("articleParent");
			//check to make sure page is still visible
			while ((parentHeight * (currentPos + (columnMode - 1))) > tHeight && currentPos > 0){
				currentPos = currentPos - 1;
			}
			//layoutArticles();
		}
	}
}

// returns the number of screens an article spans, ie the number of pages
function articlePages(){
	var parentHeight = getHeight("articleParent");
	var tHeight = getHeight("at1");
	var totalColumns = tHeight / parentHeight;
	var totalPages = Math.ceil(totalColumns);
	var tPos = (currentPos + columnMode) / columnMode;
	var pagesTotal = Math.ceil(totalPages / columnMode);
	var pagesCurrent = Math.round(tPos);
	var obj = document.getElementById("pagenumbers");
	obj.innerHTML = "PAGE " + pagesCurrent + " : " + pagesTotal;
}

// displays next page icon when mousing over column
function nextPageOver(){
	var tHeight = getHeight("at1");
	var parentHeight = getHeight("articleParent");
	if ((parentHeight * (currentPos + columnMode)) < tHeight){	
		changeImage('next','http://www.iht.com/images/icon/nextHot.gif');
	}
}

// displays next page icon when mousing over column
function prevPageOver(){
	if (currentPos > 0){	
		changeImage('prev','http://www.iht.com/images/icon/prevHot.gif');
	}
}

// hides mouse icon when leaving the columns
function hidePrevPageOver(){
	changeImage('prev','http://www.iht.com/images/icon/prevCool.gif');
}

function hideNextPageOver(){
	changeImage('next','http://www.iht.com/images/icon/nextCool.gif');
}

// adjusts the article to display the next page
function nextPage(){
	tHeight = getHeight("at1")
	var parentHeight = getHeight("articleParent");
	// check to make sure page is still visible 
	if ((parentHeight * (currentPos + columnMode)) < tHeight){
		currentPos = currentPos + columnMode;
	}
	layoutArticles();
}

// adjusts the article to display the previous page
function prevPage(){
	currentPos = currentPos - columnMode;
	if (currentPos < 0){
		currentPos = 0;
	}
	layoutArticles();
}

// user event to trigger the one column change
function eventOneColumn(){
	currentPos = 0;
	columnMode = 1;
	colWidth = col1Width;
	
	// save columnMode value in the cookie
	var cv = "columnMode:" + columnMode + "&fontSize:" + cookieValues[1] + "&clippings:" + cookieValues[2];
	createCookie("ihtuserdata",cv,7);
	
	obj = document.getElementById("at0");
	obj.style.width = colWidth;
	obj.style.left = 70;
	
	obj = document.getElementById("articleParent");
	obj.style.height = getHeight("at0");
	
	obj = document.getElementById("at1");
	obj.style.display = "none";
	
	obj = document.getElementById("at2");
	obj.style.display = "none";

	parentHeight = getHeight("articleParent");

	for (var i = 0; i < columnMode; i++){
		obj = document.getElementById("at" + i);
		obj.style.top = -1 * (parentHeight * (i + currentPos));
	}
	articlePages();

	document.getElementById("next").style.display = "none";
	document.getElementById("prev").style.display = "none";
	document.getElementById("pagenumbers").style.display = "none";
}

// user event to trigger the three column change
function eventThreeColumn(){
	if (window.scrollTo){
		window.scrollTo(0,0);
	}
	// save columnMode value in the cookie
	var cv = "columnMode:3&fontSize:" + cookieValues[1] + "&clippings:" + cookieValues[2];
	createCookie("ihtuserdata",cv,7);

	threeColumn();
	setArticleHeight();
	layoutArticles();
	articlePages();
}

// switches to three Column mode
function threeColumn(){

	// get the fontSize value from the cookie
	var cv1 = readCookie("ihtuserdata");
	if (cv1){
		cookieValues = parseCookie(cv1);
	} else {
		cookieValues[1] = "12";
	}
	var fontSize = parseInt(cookieValues[1]);
	
	currentPos = 0;
	columnMode = 3;
	colWidth = col3Width;

	if (fontSize > 18){
		fontSize = 18;
	}
	var obj1 = document.getElementById("at0");
	//obj1.style.cursor = "pointer";
	obj1.style.cursor = "hand";
	obj1.style.zIndex = 5;
	obj1.style.display = "block";
	obj1.style.width = colWidth;
	obj1.style.left = 0;
	obj1.onmousemove = prevPageOver;
	obj1.onmouseout = hidePrevPageOver;
	obj1.onmousedown = prevPage;
	obj1.onmouseup = hidePrevPageOver;
	
	var obj2 = document.getElementById("at1");
	//obj2.style.cursor = "default";
	obj2.style.cursor = "default";
	obj2.style.zIndex = 5;
	obj2.style.display = "block";
	obj2.style.width = colWidth;
	obj2.style.left = colWidth + 16;
	obj2.onmousemove = null;
	obj2.onmouseout = null;
	obj2.onclick = null;
	obj2.onmouseup = null;

	var obj3 = document.getElementById("at2");
	//obj3.style.cursor = "pointer";
	obj3.style.cursor = "hand";
	obj3.style.zIndex = 5;
	obj3.style.display = "block";
	obj3.style.width = colWidth;
	obj3.style.left = 2 * (colWidth + 16);
	obj3.onmousemove = nextPageOver;
	obj3.onmouseout = hideNextPageOver;
	obj3.onclick = nextPage;
	obj3.onmouseup = hideNextPageOver;			

	document.getElementById("next").style.display = "block";
	document.getElementById("prev").style.display = "block";
	document.getElementById("pagenumbers").style.display = "block";
}

function initArticle(){
	if (document.getElementById("articleBody") != null){
		articleSetup();
		setArticleHeight();
		if (columnMode == 1){
			eventOneColumn();
		} else if (columnMode == 3){
			threeColumn();
		} else {
			alert("columnMode does not exist");
		}
		//setFaceSize();
		layoutArticles();
	
		//attempt to get article to NOT scroll when space bar is pressed in IE
		//obj = document.getElementById("articleParent");
		//obj.onkeyup = eventArticleFocus;
		//obj.onscroll = testArticle;
	} else {
		alert("Can not find articleBody node");
	}
}

// increases the font and adjusts the article layout
function increaseFont(){
	// get the current value from the cookie
	var cv1 = readCookie("ihtuserdata");
	if (cv1){
		cookieValues = parseCookie(cv1);
	} else {
		cookieValues[1] = "12";
	}
	var currentFontSize = parseInt(cookieValues[1]);
	var newFontSize = currentFontSize + 2;
	if (newFontSize > 18){
		newFontSize = 18;
	}
	// save new value in the cookie
	var cv = "columnMode:" + cookieValues[0] + "&fontSize:" + newFontSize + "&clippings:" + cookieValues[2];
	createCookie("ihtuserdata",cv,7);
	
	// re-draw article
	lineHeight = newFontSize + Math.round(.3 * newFontSize);
	for (var i = 0; i < 3; i++){
		obj = document.getElementById("at" + i);
		obj.style.fontSize = newFontSize + "px";
		obj.style.lineHeight = lineHeight + "px";
	}			
	setArticleHeight();
	layoutArticles();
}

// increases the font and adjusts the article layout
function decreaseFont(){
	// get the current value from the cookie
	var cv1 = readCookie("ihtuserdata");
	if (cv1){
		cookieValues = parseCookie(cv1);
	} else {
		cookieValues[1] = "12";
	}
	var currentFontSize = parseInt(cookieValues[1]);
	var newFontSize = currentFontSize - 2;
	if (newFontSize < 12){
		newFontSize = 12;
	}
	// save new value in the cookie
	var cv = "columnMode:" + cookieValues[0] + "&fontSize:" + newFontSize + "&clippings:" + cookieValues[2];
	createCookie("ihtuserdata",cv,7);
	// re-draw article
	lineHeight = newFontSize + Math.round(.3 * newFontSize);
	for (var i = 0; i < 3; i++){
		obj = document.getElementById("at" + i);
		obj.style.fontSize = newFontSize + "px";
		obj.style.lineHeight = lineHeight + "px";
	}			
	setArticleHeight();
	layoutArticles();
}

// adjust article layout when the window is resized
function windowResize(){
	setArticleHeight();
	layoutArticles();
}

window.onresize = windowResize;

// this toggles the format between one and three column layouts
// checks the current value from the cookie and does that opposite
function toggleFormat(){
	var format = columnMode;
	if (format == 1){
		eventThreeColumn();
	} else if (format == 3){
		eventOneColumn();
	} else {
		// do nothing
	}
}

// this might be used, should offset the image if there is one
function layoutPhoto(){
	//find if the last column is visible
	if (columnMode != 1){
		var obj = document.getElementById("at" + (columnMode - 1));
		if ((parseInt(obj.style.top) + obj.offsetHeight) < (parentHeight)){
			colHeight = getHeight("at0");
			graphicOffset = (columnMode - 1) * parentHeight;
			articlePhoto.style.marginTop = lineHeight;
			articlePhoto.style.top = colHeight - ((parentHeight * currentPos) + graphicOffset);
			if (parseInt(articlePhoto.style.top) < 0){
				articlePhoto.style.marginTop = 0;
				articlePhoto.style.top = 0;
			}
			if (columnMode == 2){
				articlePhoto.style.left = (1) * colWidth + 20 + "px";
			}
			if (columnMode == 3){
				articlePhoto.style.left = (2) * colWidth + 36 + "px";
			}
			articlePhoto.style.visibility = "visible";
		} else {
			articlePhoto.style.visibility = "hidden";
			//put the graphic below the first column which
		}
	}
}
