// Flash Detect & Renderer

var VBS_Result = false;

function CNN_FlashDetect() { }

CNN_FlashDetect.prototype.maxVersionToDetect = 8;
CNN_FlashDetect.prototype.minVersionToDetect = 3;

CNN_FlashDetect.prototype.hasPlugin = Boolean( Boolean(navigator.mimeTypes) &&
		navigator.mimeTypes.length &&
		Boolean(navigator.mimeTypes["application/x-shockwave-flash"]) &&
		navigator.mimeTypes["application/x-shockwave-flash"].enabledPlugin );

CNN_FlashDetect.prototype.hasActiveX = Boolean( Boolean(window.ActiveXObject) &&
		typeof ActiveXObject != "undefined" );

CNN_FlashDetect.prototype.hasWinIE = Boolean( Boolean(navigator.userAgent) &&
		( navigator.userAgent.indexOf( "MSIE" ) != -1 ) &&
		Boolean(navigator.appVersion) &&
		( navigator.appVersion.indexOf( "Win" ) != -1 ) );

CNN_FlashDetect.prototype.getVersion = function () {
	var versionNum = 0;
	var i = 0;

	if ( this.hasPlugin ) {
		if ( Boolean(navigator.plugins) && navigator.plugins.length && Boolean(navigator.plugins["Shockwave Flash"]) ) {
			var words = navigator.plugins["Shockwave Flash"].description.split( " " );
			for ( i = 0; i < words.length; ++i ) {
				if ( isNaN( parseInt( words[i] ) ) )
					continue;
				versionNum = words[i];
			}
		}
	} else if ( this.hasActiveX ) {
		var activeXObject = false;
		for ( i = this.maxVersionToDetect; i >= this.minVersionToDetect && !activeXObject; versionNum = ( activeXObject ? i : versionNum ), i-- ) {
			try {
				activeXObject = new ActiveXObject( "ShockwaveFlash.ShockwaveFlash." + i );
			} catch( e ) {
				// do nothing
			}
		}
	} else if ( this.hasWinIE ) {
		VBS_Result = false;
		for ( i = this.maxVersionToDetect; i >= this.minVersionToDetect && !VBS_Result; versionNum = ( VBS_Result ? i : versionNum ), i-- ) {
			execScript( 'on error resume next: VBS_Result = IsObject( CreateObject( "ShockwaveFlash.ShockwaveFlash.' + i + '" ) )', 'VBScript' );
		}
	}

	return ( versionNum );
}

CNN_FlashDetect.prototype.detectVersion = function ( num ) {
	var isVersionSupported = false;

	if ( ! isNaN( num ) ) {
		isVersionSupported = ( this.getVersion() >= parseInt( num ) );
	}

	return ( isVersionSupported );
}


function CNN_FlashObject( p_name, p_src, p_width, p_height, p_parameters, p_flashVars ) {
	this.m_name			= p_name;
	this.m_src			= p_src;
	this.m_width		= p_width;
	this.m_height		= p_height;
	this.m_flashVars	= p_flashVars;

// constructor
	if ( Boolean(p_parameters) )
	{
		this.setParams( p_parameters );
	}
}

// Declare member properties
CNN_FlashObject.prototype.m_name = '';
CNN_FlashObject.prototype.m_src = '';
CNN_FlashObject.prototype.m_width = '100%';
CNN_FlashObject.prototype.m_height = '100%';
CNN_FlashObject.prototype.m_flashVars = '';

CNN_FlashObject.prototype.m_params = {
	menu:		"false",
	quality:	"high",
	wmode:		"transparent"
};

CNN_FlashObject.prototype.setParam = function ( p_name, p_value ) {
	this.m_params[ p_name.toLowerCase() ] = p_value;
}

CNN_FlashObject.prototype.setParams = function ( p_paramHash ) {
	if ( typeof p_paramHash == "object" ) {
		for ( var param in p_paramHash ) {
			if ( p_paramHash[param] ) {
				this.setParam( param, p_paramHash[param] );
			}
		}
	}
}

CNN_FlashObject.prototype.getParam = function ( p_name ) {
	return ( this.m_params[ p_name.toLowerCase() ] );
}

CNN_FlashObject.prototype.getParams = function () {
	return ( this.m_params );
}

CNN_FlashObject.prototype.getFlashVarsString = function () {
	var flashVarsString = '';

	if ( typeof this.m_flashVars == "string" ) {
		flashVarsString = this.m_flashVars;
	} else if ( typeof this.m_flashVars == "object" ) {
		for ( var flashVar in this.m_flashVars ) {
			if ( flashVarsString != '' ) {
				flashVarsString += "&amp;";
			}
			flashVarsString += flashVar + "=" + escape( this.m_flashVars[flashVar] );
		}
	}

	return ( flashVarsString );
}

CNN_FlashObject.prototype.getAttributeString = function ( p_attr, p_value ) {
	return ( Boolean(p_value) ? ' ' + p_attr + '="' + p_value + '"' : '' );
}

CNN_FlashObject.prototype.getParamTag = function ( p_name, p_value ) {
	return ( Boolean(p_value) ? '<param name="' + p_name + '" value="' + p_value + '">' : '' );
}

CNN_FlashObject.prototype.getHtml = function () {
	var htmlString = '';
	var eachParam = '';
	var flashUrl = 'http://www.macromedia.com/go/getflashplayer';

// open object
	htmlString += '<object type="application/x-shockwave-flash" \
					classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"';
	htmlString += this.getAttributeString( 'pluginspage', flashUrl );
	htmlString += this.getAttributeString( 'id', this.m_name );
	htmlString += this.getAttributeString( 'data', this.m_src );
	htmlString += this.getAttributeString( 'width', this.m_width );
	htmlString += this.getAttributeString( 'height', this.m_height );
	htmlString += this.getAttributeString( 'flashVars', this.getFlashVarsString() );
	htmlString += '>';
	htmlString += this.getParamTag( 'movie', this.m_src );
	for ( eachParam in this.getParams() ) {
		htmlString += this.getParamTag( eachParam, this.getParam( eachParam ) );
	}
	htmlString += this.getParamTag( 'flashVars', this.getFlashVarsString() );

// open embed
	htmlString += '<embed type="application/x-shockwave-flash"';
	htmlString += this.getAttributeString( 'pluginspage', flashUrl );
	htmlString += this.getAttributeString( 'name', this.m_name );
	htmlString += this.getAttributeString( 'src', this.m_src );
	htmlString += this.getAttributeString( 'width', this.m_width );
	htmlString += this.getAttributeString( 'height', this.m_height );
	for ( eachParam in this.getParams() ) {
		htmlString += this.getAttributeString( eachParam, this.getParam( eachParam ) );
	}
	htmlString += this.getAttributeString( 'flashVars', this.getFlashVarsString() );
	htmlString += '>';

// close embed
	htmlString += '<\/embed>';

// close object
	htmlString += '<\/object>';

	return ( htmlString );
}

CNN_FlashObject.prototype.writeHtml = function () {
	document.write( this.getHtml() );
}


// Search

function CNNSI_writeSearchFields() {
	document.write('<input type="hidden" name=Coll value="si_xml">');
	document.write('<input type="hidden" name="QuerySubmit"  value="true" />');
	document.write('<input type="hidden" name="Page"  value="1" />');
	document.write('<input type="hidden" name="QueryText" value="">');
}

function CNNSI_validateSearchForm( theForm )
{
	var site = 'si';
	var queryString = theForm.query.value;

	if ( theForm.sites )
	{
		if ( theForm.sites.options ) {		//	"sites" should be a select
			site = theForm.sites.options[theForm.sites.selectedIndex].value;
		} else {
			if ( theForm.sites.length )
			{
				for ( i = 0; i < theForm.sites.length; i++ )
				{
					if ( theForm.sites[i].checked ) {
						site = theForm.sites[i].value;
					}
				}
			}
			else
			{
				site = theForm.sites.value;
			}
		}
	}

	if ( !queryString ) {
		return false;
	}

	switch ( site.toLowerCase() ) {
		case "google":
			theForm.action = "http://websearch.si.cnn.com/search/search";
			theForm.query.value = queryString;
			return true;
		case "web":
			theForm.action = "http://websearch.si.cnn.com/search/search";
			theForm.query.value = queryString;
			return true;
		case "si":
			theForm.action = "http://search.sportsillustrated.cnn.com/pages/search/advanced.jsp";
			theForm.action = "http://search.sportsillustrated.cnn.com/pages/search/advanced.jsp";
			theForm.Coll.value = 'si_xml';
			theForm.QuerySubmit.value = 'true';
			theForm.Page.value = '1';
			theForm.QueryText.value = queryString;
			return true;
		default:
			return true;						//	unsupported site?
	}
}

//Footer nav
function cnnFooterNavClick( url ) {
	window.location.href = url;
}

function cnnFooterChangeNavClass(whichSelector,whichClass) {
 whichSelector.className = whichClass;
}

// Nav Functions

var cnnCurrentVisibleNavId = ''; // The name of the current visible navbar
var cnnTimeOverNav = -1; // Amount of time over nav
var cnnCurrentDelayTimeOutPtr = ''; // The previous hidden timeout pointer


function cnnDelayedNavShow(navId, navLeftPos, navWidth)
{
	if(cnnCurrentDelayTimeOutPtr)
	{
		window.clearTimeout(cnnCurrentDelayTimeOutPtr);
	}
	cnnTimeOverNav = new Date().getTime();
	cnnCurrentDelayTimeOutPtr = window.setTimeout("cnnNavShow('"+navId+"')",250);
}

function cnnNodeContains(a, b)
{
// Return true if node a contains node b.
	while (b.parentNode)
		if ((b = b.parentNode) == a)
			return true;
	return false;
}

function cnnDetectNavPanelMouseOut(event, obj, navId)
{
	var current, related;
	if (window.event)
	{
		current = obj;
		related = window.event.toElement;
	}
	else
	{
		current = event.currentTarget;
		related = event.relatedTarget;
	}
	if (current != related && !cnnNodeContains(current, related))
	{
		cnnNavHide(navId);
	}
}


function cnnNavShow(navId)
{
// Show the navbar
	if ( cnnCurrentVisibleNavId && (cnnCurrentVisibleNavId != navId) )
	{
		cnnNavHide( cnnCurrentVisibleNavId );
	}

	var menu = cnnMenuEntries[ navId ];
	if ( menu )
	{
		var navWidth = cnnGetDhtmlMenuWidth( menu );
		var navLeftPos = menu.posX || 0;
		var subnav = cnnGetObject( navId + 'SubNav' );

		if(subnav && subnav.style)
		{
			if((navLeftPos+navWidth)>770) {navLeftPos=770-navWidth;}
			subnav.style.left = navLeftPos;
			subnav.style.width = navWidth;
			subnav.style.visibility = 'visible';
			cnnAlterAllSelects('hidden')
		}

		cnnCurrentVisibleNavId = navId;
	}
}

function cnnNavHide(navId)
{
// hide the navbar
	var subnav = cnnGetObject( navId + 'SubNav' );
	if(subnav)
	{
		subnav.style.visibility = 'hidden';
		subnav.style.width = '0px';
		cnnAlterAllSelects('visible')
	}

}

function cnnGetObject( id ) {
	var object = null;
	if ( document.getElementById )
	{
		object = document.getElementById( id );
	}
	else
	if ( document.all )
	{
		object = document.all[ id ];
	}
	return object;
}

// is this page hosted on a remote site?
document.cnnIsRemoteSite = false;
if ( location.hostname.indexOf( '.cnn.com' ) == -1 && location.hostname.indexOf( '.turner.com' ) == -1 )
{
	document.cnnIsRemoteSite = true;
}

document.cnnDhtmlNavSectionWidth = 130;
document.cnnDhtmlNavHeadlineWidth = 240;
document.cnnDhtmlNavPadding = 6;
function cnnGetDhtmlMenuWidth( menu )
{
	var sectionWidth = menu.sectionWidth || document.cnnDhtmlNavSectionWidth || 130;
	var headlineWidth = document.cnnDhtmlNavHeadlineWidth || 240;
	var navPadding = document.cnnDhtmlNavPadding || 6;
	var outerWidth = sectionWidth + headlineWidth + ( navPadding * 4 );
	var displayHeadlines = ( !document.cnnIsRemoteSite && menu.showHeadlines ) ? true : false;
	if ( !displayHeadlines )
	{	// no headlines = narrow menu
		outerWidth = sectionWidth + ( navPadding * 2 );
	}
	return outerWidth;
}

function cnnWriteMenuEntries( menuCollection )
{
// write out the dhtml panes
	var prependHost = '';
	if ( document.cnnIsRemoteSite) { prependHost = 'http://si.com'; }
	for ( eachMenu in menuCollection )
	{
		var navId = eachMenu;
		var sectionWidth = menuCollection[eachMenu].sectionWidth || document.cnnDhtmlNavSectionWidth || 130;
		var headlineWidth = document.cnnDhtmlNavHeadlineWidth || 240;
		var navPadding = document.cnnDhtmlNavPadding || 6;
		var outerWidth = cnnGetDhtmlMenuWidth( menuCollection[eachMenu] );
		var displayHeadlines = ( !document.cnnIsRemoteSite && menuCollection[eachMenu].showHeadlines ) ? true : false;
		var navLeftPos = menuCollection[eachMenu].posX || 0;
		if ( (navLeftPos+outerWidth) > 770 ) {
			navLeftPos = 770 - outerWidth;
		}

		var navHtml = "";

		navHtml += '<div class="cnnDhtmlMenu" id="'+navId+'SubNav" style="width:'+outerWidth+'px;left:'+navLeftPos+';" onmouseover="cnnNavShow(\''+navId+'\');return false;" onmouseout="cnnDetectNavPanelMouseOut(event, this, \''+navId+'\');">';

		navHtml += '<table width="' + outerWidth + '" border="0" cellspacing="0" cellpadding="' + navPadding + '" onmouseout="cnnDetectNavPanelMouseOut(event, this, \''+navId+'\');">';
		navHtml += '<tr valign="top"><td width="'+sectionWidth+'">';

		if(menuCollection[eachMenu].menuItems)
		{
			for ( var entryNo = 0; entryNo < menuCollection[eachMenu].menuItems.length; entryNo += 2 )
			{
				var menuPrependHost = prependHost;
				if(menuCollection[eachMenu].menuItems[entryNo+1].indexOf('http:/\/')>-1){ menuPrependHost='';}
				navHtml += '<div class="cnnDhtmlMenuSect" onMouseOver="cnnColorMenuItem(this,1)" onMouseOut="cnnColorMenuItem(this,0)" onclick="location.href=\''+menuPrependHost+menuCollection[eachMenu].menuItems[entryNo+1]+'\'">';
				navHtml += '<a href="'+menuPrependHost+menuCollection[eachMenu].menuItems[entryNo+1]+'">'+menuCollection[eachMenu].menuItems[entryNo].toUpperCase()+'</a>';
				navHtml += '</div>';
			}
		}

		if ( displayHeadlines )
		{
			navHtml += '</td><td width="'+headlineWidth+'">';
			navHtml += '<div id="cnnDhtmlMenuCSI'+navId+'" class="cnnDhtmlMenuHeadlines">Content is loading...</div>';
		}

		navHtml += '</td></tr></table>';
		navHtml += '</div>';

		document.write( navHtml );
	}

	if ( !document.cnnIsRemoteSite )
	{
		var prependCSIpath='';
		if((window.location.hostname.indexOf('.cnn.com')>-1) && (window.location.hostname!='sportsillustrated.cnn.com')) {prependCSIpath='http://sportsillustrated.cnn.com';}
		cnnAddCSI('cnnDhtmlMenuCSI',prependCSIpath+'/.element/ssi/nav/2.0/headlines.exclude.html');
	}
}

function cnnColorMenuItem( element, on )
{
	if ( navigator.userAgent.indexOf( "KHTML" ) == -1 )
	{
		if ( on )
		{
			element.className = "cnnDhtmlMenuSectHov";
		}
		else
		{
			element.className = "cnnDhtmlMenuSect";
		}
	}
}

function cnnAlterAllSelects(visibility)
{
	var allSelectObjs = document.getElementsByTagName('select');
	if(allSelectObjs)
	{
		for(var selectCounter = 0;selectCounter<allSelectObjs.length;selectCounter++)
		{
			var currentSelectObj = allSelectObjs.item(selectCounter);
			currentSelectObj.style.visibility=visibility;
		}
	}
}

var cnnMenuEntries = new Array();


//SI Writers pulldown
var cnnSIWriters = new Array();
function cnnPopulateWriters(selectObj)
{
	if(selectObj)
	{
		for(var optCounter=0;optCounter<cnnSIWriters.length;optCounter++)
		{
			selectObj.options[selectObj.options.length] = new Option( cnnSIWriters[ optCounter ][1], cnnSIWriters[ optCounter ][0] );
		}
	}
}


function cnnPageBodyMove()
{
}




//Onload
function cnnPageOnload()
{
	cnnPopulateWriters( cnnGetObject( 'cnnSIWriterSelect' ) );
	cnnHandleCSIs();
}

//CSI Functions
var cnnCSIs = new Array();
var cnnUseDelayedCSI = 0;
var localUserAgent = navigator.userAgent.toLowerCase();
if((localUserAgent.indexOf('msie')>-1) && (localUserAgent.indexOf('mac')>-1)){cnnUseDelayedCSI = 1;}

function cnnAddCSI(id,source,args)
{
	if(!args) { args='';}
	if(cnnUseDelayedCSI)
	{
		var newCSI = new Object();
		newCSI.src = source;
		newCSI.id  = id;
		newCSI.args = args;
		cnnCSIs[cnnCSIs.length]=newCSI;
	}
	else
	{
		var today = new Date();
		var currTime = today.getTime();
		var iframeArgs = '&time='+currTime;
		if(!document.switchDocDomain) {iframeArgs=iframeArgs+'&disableDocDom=1';}
		if(args)
		{
			iframeArgs=iframeArgs+'&'+args;
		}
		var iframeHtmlSrc='<iframe src="'+source+'?domId='+id+iframeArgs+'" name="iframe'+id+'" id="iframe'+id+'" width="0" height="0" align="right" style="position:absolute;visibility:hidden;"></iframe>';
		document.write(iframeHtmlSrc);
	}
}

function cnnUpdateCSI(html, id)
{
	var htmlContainerObj = cnnGetObject( id );
	if(htmlContainerObj)
	{
		htmlContainerObj.innerHTML = html;
	}

// force a refresh of the content area
	var htmlContentArea = document.body;
	if(htmlContentArea)
	{
		var previousTopVal = htmlContentArea.style.top || '0px';
		htmlContentArea.style.top = '1px';
		htmlContentArea.style.top = previousTopVal;
	}
}

// this is for opening pop-up windows
function CNN_openPopup( url, name, widgets, openerUrl )
{
	var host = location.hostname;
	window.top.name = "opener";
	var popupWin = window.open( url, name, widgets );
	
	if ( popupWin && popupWin.opener ) {
		if ( openerUrl )
		{
			popupWin.opener.location = openerUrl;
			popupWin.focus();
		}
	}
}

function SI_popUrl( urlString ) {
	if ( urlString.indexOf( ';' ) != -1 ) {
		var urlArray = urlString.split( ';' );
		var url = urlArray[0];
		var width = urlArray[1];
		var height = urlArray[2];
		if ( url && width && height ) {
			CNN_openPopup( url, width + 'x' + height, 'width=' + width + ',height=' + height + ',toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no' );
		}
	}
}

function cnnHandleCSIs()
{
	if(document.body && document.body.innerHTML && cnnUseDelayedCSI)
	{
		var iframeOwner = cnnGetObject( 'csiIframe' );
		var iframeHtmlSrc = '';

		for(var incCounter=0;incCounter<cnnCSIs.length;incCounter++)
		{
			var src = cnnCSIs[incCounter].src;
			var id = cnnCSIs[incCounter].id;
			var today = new Date();
			var currTime = today.getTime();
			var args = '&time='+currTime;
			if(!document.switchDocDomain) {args=args+'&disableDocDom=1';}
			if(cnnCSIs[incCounter].args)
			{
				args=args+'&'+cnnCSIs[incCounter].args;
			}

			iframeHtmlSrc+='<iframe src="'+src+'?domId='+id+args+'" name="iframe'+id+'" id="iframe'+id+'" width="0" height="0" align="right"></iframe>';
		}
		if(iframeOwner)
		{
			iframeOwner.innerHTML=iframeHtmlSrc;
		}
	}
}

// Survey
function SI_profileSurvey( popup, cookie, scope ) {
	var randomNum = MD_random(1, scope);
	if( randomNum == scope ) {
		if( WM_browserAcceptsCookies() ) {
			if( WM_readCookie( cookie ) == '') {
				window.open( popup, 'surveyInvite', 'scrollbars=no,resizable=no,width=250,height=250');
			}
		}
	}
}

function MD_random(r1, r2) {
	if (r2 > r1) return (Math.round(Math.random()*(r2-r1))+r1);
	else return (Math.round(Math.random()*(r1-r2))+r2);
}

// Cookies
function WM_browserAcceptsCookies() {
	var WM_acceptsCookies = false;
	if ( document.cookie == '' ) {
		document.cookie = 'WM_acceptsCookies=yes'; // Try to set a cookie.
		if ( document.cookie.indexOf( 'WM_acceptsCookies=yes' ) != -1 ) {
			WM_acceptsCookies = true;
		} // If it succeeds, set variable
	} else { // there was already a cookie
		WM_acceptsCookies = true;
	}

	return ( WM_acceptsCookies );
}

function WM_setCookie( name, value, hours, path, domain, secure ) {
	if ( WM_browserAcceptsCookies() ) { // Don't waste your time if the browser doesn't accept cookies.
		var numHours = 0;
		var not_NN2 = ( navigator && navigator.appName
					&& (navigator.appName == 'Netscape')
					&& navigator.appVersion
					&& (parseInt(navigator.appVersion) == 2) ) ? false : true;

		if ( hours && not_NN2 ) { // NN2 cannot handle Dates, so skip this part
			if ( (typeof(hours) == 'string') && Date.parse(hours) ) { // already a Date string
				numHours = hours;
			} else if ( typeof(hours) == 'number' ) { // calculate Date from number of hours
				numHours = ( new Date((new Date()).getTime() + hours*3600000) ).toGMTString();
			}
		}

		document.cookie = name + '=' + escape(value) + ((numHours)?(';expires=' + numHours):'') + ((path)?';path=' + path:'') + ((domain)?';domain=' + domain:'') + ((secure && (secure == true))?'; secure':''); // Set the cookie, adding any parameters that were specified.
	}
} // WM_setCookie

function WM_readCookie( name ) {
	if ( document.cookie == '' ) { // there's no cookie, so go no further
		return false;
	} else { // there is a cookie
		var firstChar, lastChar;
		var theBigCookie = document.cookie;
		firstChar = theBigCookie.indexOf(name);	// find the start of 'name'
		var NN2Hack = firstChar + name.length;
		if ( (firstChar != -1) && (theBigCookie.charAt(NN2Hack) == '=') ) { // if you found the cookie
			firstChar += name.length + 1; // skip 'name' and '='
			lastChar = theBigCookie.indexOf(';', firstChar); // Find the end of the value string (i.e. the next ';').
			if (lastChar == -1) lastChar = theBigCookie.length;
			return unescape( theBigCookie.substring(firstChar, lastChar) );
		} else { // If there was no cookie of that name, return false.
			return false;
		}
	}
} // WM_readCookie

function WM_killCookie( name, path, domain ) {
	var theValue = WM_readCookie( name ); // We need the value to kill the cookie
	if ( theValue ) {
		document.cookie = name + '=' + theValue + '; expires=Fri, 13-Apr-1970 00:00:00 GMT' + ((path)?';path=' + path:'') + ((domain)?';domain=' + domain:''); // set an already-expired cookie
	}
} // WM_killCookie

var cnnEnableCL = true;
document.switchDocDomain = true;
if(window.location.pathname.indexOf('/')==window.location.pathname.lastIndexOf('/'))
{
	document.switchDocDomain = false;
}
//This must always be at the very bottom
var cnnDocDomain = '';
if(location.hostname.indexOf('cnn.com')>0) {cnnDocDomain='cnn.com';}
if(location.hostname.indexOf('turner.com')>0) {if(document.layers){cnnDocDomain='turner.com:'+location.port;}else{cnnDocDomain='turner.com';}}
if(cnnDocDomain && document.switchDocDomain) {document.domain = cnnDocDomain;}
//Nothing should go after this
