function play(cnt)
{
	if (checkPlayer(cnt.reqplayer)) {
		var reg = util_getCookie("reg_popup");
		
		loggedIn = util_getCookie("logged_in");

		if (loggedIn=="true" && reg != 'no') {
			util_setCookie("reg_popup", "no", cnt.site, false);
			reg='no'; // Set this to prevent logged in users from being asked to sign-in
		}

		// If var gets set in switch stmt below, will be name of cookie
		// If not set, we are not tracking content plays for this keyword
		var contentPlayCookie = "0";

		// Check if this keyword is tracking content plays
		switch(cnt.keyword) {
		    case "collapse": contentPlayCookie = "content_play_" + cnt.keyword;
				     break;
		}

		if(contentPlayCookie != "0") {
		    var contentPlay = util_getCookie(contentPlayCookie);

		    if(contentPlay) {
				if(contentPlay != "no") {
					// increment play counter
					contentPlay++;
					util_setCookie(contentPlayCookie, contentPlay, cnt.site, true);
				}
		    } else {
				// First time user is seeing content, set play num to 1
				util_setCookie(contentPlayCookie, "1", cnt.site, true);
		    }
		}
		
		if(contentPlay > 4) {
			var url = "/contentPlay/download/popup_downloadprompt.jsp?returnurl="
                                + escape(cnt.url) + "&id=" + cnt.keyword
				+ "&width=" + cnt.winsize[0]
                                + "&height=" + cnt.winsize[1] + "&site=" + cnt.site 
				+ "&contentPlayCookie=" + contentPlayCookie;
				
			launchWindow(url,336,215);

		} else {
		    if (reg > 3) {
				launchRegistration("/bin/account/signin/form.jsp?returnurl="
					+ escape(cnt.url) + "&context=popup&width=" + cnt.winsize[0]
					+ "&height=" + cnt.winsize[1] + "&site=" + cnt.site, cnt.winsize[0], cnt.winsize[1]);
		    } else {
				if (reg != 'no') {
					reg++;
					util_setCookie("reg_popup", reg, cnt.site, true);
				}

				// When not fullscreen launch normal window
				if(cnt.url.indexOf("fullScreen=1")==-1) {
				
					launchWindow(cnt.url,cnt.winsize[0],cnt.winsize[1]);						
					
				} else {
					// If player is not flash, launch normal window.
					// Otherwise, launch window fullscreen
					if(cnt.reqplayer.indexOf("f=")==-1) {
						launchWindow(cnt.url,cnt.winsize[0],cnt.winsize[1]);
					} else {
						launchWindowFullscreen(cnt.url);
					}
				}
		    }
		}
	} else {
		errorRedirect(cnt.errorurl);
	}
}

function playJigsaw(cnt,month,day,year)
{	
	if (checkPlayer(cnt.reqplayer))
	{
		launchJigsawWindow(cnt.url+'&fullScreen=1&year='+year+'&month='+month+'&day='+day,cnt.winsize[0],cnt.winsize[1]);	
	}
	else
	{
		errorRedirect(cnt.errorurl);
	}
}

function playBonusJigsaw(cnt,bonusNum,month,year)
{
	if (checkPlayer(cnt.reqplayer))
	{
		launchJigsawWindow(cnt.url+bonusNum+'&year='+year+'&month='+month+'&fullScreen=1',cnt.winsize[0],cnt.winsize[1]);	
	}
	else
	{
		errorRedirect(cnt.errorurl);
	}
}


function checkPlayer(playerlist) {

	if (playerlist == "") return true;

	var playerArray = playerlist.split("&");

	for (var i=0;i<playerArray.length;i++) {
		var detect = 0;
		var player = playerArray[i].split("=");
		var type = player[0];
		var reqver = parseFloat(player[1]);

		if (type=="sw" && reqver<8.5) {
			reqver = 8.5;
		}

		if(type == "f") detect = detection_flashVersion();
		else if(type == "sw") detect = detection_shockwaveVersion();
		else if(type == "rp") detect = detection_realPlayerVersion();
		else if(type == "wm") detect = detection_windowsMediaVersion();
		else if(type == "qt") detect = detection_quickTimeVersion();
		else if(type == "java") return detection_JavaEnabled(); // No version needed for Java, return true/false

		if (detect >= reqver) return true;
	}

	return false;
}

function tellafriend(send,site)
{
	if(site=='') site='af';
	launchWindow("/landing/tellafriend/sendForm.jsp?"+send+"&site="+site,340,600,"sw_tellafriend");
}

function review(keyword, site)
{
	launchWindow("/landing/review/reviewForm.jsp?id="+keyword+"&site="+site, 340, 510, "asw_review");
}

function download(content)
{
	launchWindow("/contentPlay/download/form.jsp?"+content,340,553,"sw_download");
}

function newsletter(siteparam)
{
	launchWindow("/bin/landing/newsletters/form.jsp?"+siteparam,340,580,"sw_newsletter");
}

function launchWindow(contentUrl,winWidth,winHeight,winName)
{
   if (!winName) winName = "asw_d" + (Math.floor(Math.random() * 100000));

   window.open(contentUrl, winName, "width="+winWidth+",height="+winHeight);
}

function launchWindowFullscreen(contentUrl,winWidth,winHeight,winName)
{
   if (!winName) winName = "asw_d" + (Math.floor(Math.random() * 100000));
   
   var screenWidth = screen.width-20;
   var screenHeight = screen.height-60;

   var newWin = window.open(contentUrl, winName, "width="+screenWidth+",height="+screenHeight+ ",resizable=yes");
   
   // Move the window to the upperleft corner of the screen
   newWin.moveTo(0,0);
}

function launchJigsawWindow(contentUrl,winWidth,winHeight,winName)
{
   if (!winName) winName = "asw_d" + (Math.floor(Math.random() * 100000));
   
   var newWin = window.open(contentUrl, winName, "width="+winWidth+",height="+winHeight+ ",resizable=yes");
   
}



function launchRegistration(url, width, height)
{
	// width = 336; var height = 360
	window.open(url, "asw_regpopup", "width=" + width + ",height="
		+ height + ",resizable=no,scrollbars=no");
}

function errorRedirect(errorUrl)
{
	window.location = errorUrl;
}

