/*
This library handles video player detection for Plugins and ActiveX controls.

For activeX detection the axdetect.vbs script should also be included in the page.
*/

function detection_quickTimeVersion()
{
	return (browser_ie() && !browser_mac()) ? detection_quickTimeAxVersion() : detection_quickTimeNsVersion();
}

function detection_realPlayerVersion()
{
	return (browser_ie() && !browser_mac()) ? detection_realPlayerAxVersion() : detection_realPlayerNsVersion();
}

function detection_windowsMediaVersion()
{
	return (browser_ie() && !browser_mac()) ? detection_windowsMediaAxVersion() : detection_windowsMediaNsVersion();
}

//***************************
// Netscape detection,
// returns the version of Shockwave plugin found or 0.0

function detection_quickTimeNsVersion() {
	// this function returns a floating point value which should be the version of the Shockwave plugin or 0.0
	// this function only returns useful information if called from Netscape or IE Mac 5.0+

	// Set these local variables to avoid the Netscape 4 crashing bug.
	var thearray = navigator.plugins
	var arraylen = thearray.length

	// Step through each plugin in the array.
	for (var i=0; i < arraylen; i++) {
		// Set these local variables to avoid the Netscape 4 crashing bug.
		var theplugin = thearray[i]
		var thename	 = theplugin.name
		var thedesc	 = theplugin.description

		// QuickTime Plug-in 4.1.2

		// If the plugin is Shockwave...
		if (thename.indexOf("QuickTime") != -1) {
			var versionString = thename.substring(thename.indexOf("Plug-in ") + 8);
			if (versionString.indexOf(".") > 0) {
				var versionMajor = versionString.substring(0,versionString.indexOf("."));
				var versionMinor = versionString.substring(versionString.indexOf(".") + 1);
				if (versionMinor.indexOf(".") > 0) versionMinor = versionMinor.substring(0,versionString.indexOf(".")) + versionMinor.substring(versionMinor.indexOf(".") + 1)
				return parseFloat(versionMajor + "." + versionMinor);
			}
			else return parseFloat(versionString);
		}
	}
	return 0.0;
}

//***************************
// Netscape detection,
// returns the version of Shockwave plugin found or 0.0

function detection_realPlayerNsVersion() {
	// this function returns a floating point value which should be the version of the Shockwave plugin or 0.0
	// this function only returns useful information if called from Netscape or IE Mac 5.0+

	// Set these local variables to avoid the Netscape 4 crashing bug.
	var thearray = navigator.plugins
	var arraylen = thearray.length

	// Step through each plugin in the array.
	for (var i=0; i < arraylen; i++) {
		// Set these local variables to avoid the Netscape 4 crashing bug.
		theplugin = thearray[i]
		thename	 = theplugin.name
		thedesc	 = theplugin.description

		// If the plugin is Flash...
		if (thename.indexOf("RealPlayer") != -1) {
			// Don't know how to calculate the version for realplayer
			return 1.0;
		}
	}
	return 0.0;
}

//***************************
// Netscape detection,
// returns the version of Shockwave plugin found or 0.0

function detection_windowsMediaNsVersion() {
	// this function returns a floating point value which should be the version of the Windows
	// Media plugin or 0.0
	// this function only returns useful information if called from Netscape or IE Mac 5.0+

	// Set these local variables to avoid the Netscape 4 crashing bug.
	var thearray = navigator.plugins
	var arraylen = thearray.length

	// Step through each plugin in the array.
	for (var i=0; i < arraylen; i++) {
		// Set these local variables to avoid the Netscape 4 crashing bug.
		var theplugin = thearray[i]
		var thename	 = theplugin.name
		var thedesc	 = theplugin.description

		if (thename.indexOf("Windows Media") != -1 &&
			(thename.indexOf("Player") != -1 || thename.indexOf("Plugin") != -1)) {
			return 1.0;
		}
	}
	return 0.0;
}

//***************************
// For detecting the ActiveX of shockwave for ie win.
// Requires a vbscript function be included on the page
// to do the actual checking returns version found or 0.0

function detection_quickTimeAxVersion() {
	// this function returns a floating point value which should be the version of the Shockwave control or 0.0
	// this function should only be called from Internet Explorer for Windows
	// loop backwards through the versions until we get a bite
	for (var i=3;i>0;i--) {
		var versionNum = VBGetQuicktimeVersion(i);
		if (versionNum != 0) {
			return 1.0;
		}
	}
	return 0.0;
}

function detection_realPlayerAxVersion() {
	// this function returns a floating point value which should be the version of the Shockwave control or 0.0
	// this function should only be called from Internet Explorer for Windows

		// loop backwards through the versions until we get a bite
	for (var i=3;i>0;i--) {
		var versionString = VBGetRealMediaVersion(i);
		// if we get 1.0 we assume it is actually 5.0 or less
		if (versionString != "0.0") return (versionString == "1.0" ? 5.0 : parseFloat(versionString));
	}
	return 0.0;
}

function detection_windowsMediaAxVersion() {
	// this function returns a floating point value which should be the version of the Shockwave control or 0.0
	// this function should only be called from Internet Explorer for Windows
	// loop backwards through the versions until we get a bite
	for (var i=3;i>0;i--) {
		var versionNum = VBGetWindowsMediaVersion(i);
		if (versionNum != 0) {
			return 1.0;
		}
	}
	return 0.0;
}
