function crumb(trail)
{
	// check the alternate path cookie and render that if found.
	if (util_getCookie("breadcrumb"))
	{
		trail = util_getCookie("breadcrumb");
		util_setCookie("breadcrumb","");
	}

	if (trail.indexOf("/") == 0)
		trail = trail.substring(1);

	if (trail.lastIndexOf("/") == (trail.length - 1))
		trail = trail.substring(0,trail.lastIndexOf("/"));

	if (trail.indexOf("/home") > 0
		&& (trail.indexOf("/home") == trail.lastIndexOf("/home")))
		this.trail = trail.substring(0,trail.indexOf("/home"));
	else
		this.trail = trail;

	this.trailArray = trail.split("/");

	this.site    = this.trailArray[0];
	this.channel = this.trailArray[1];
	this.previousCrumb = '';

	this.subchannel = '';
	for(var i=0;i<this.trailArray.length;i++)
	{
		this.subchannel += this.trailArray[i];
		this.subchannel += (this.trailArray.length-1 == i) ? "" : "_";
	}

	// define methods
	this.draw                 = crumb_draw;
	this.getHtml              = crumb_getHtml;
	this.getCrumbLink         = crumb_getCrumbLink;
	this.drawSubchannelHeader = crumb_drawSubchannelHeader;
}

function crumb_draw()
{
	document.write(this.getHtml());
}

function crumb_getHtml()
{
    // Mulitplayer menu page is a JSP so we need this special check for the primary category sw/multiplayer
    if(this.trail == "sw/multiplayer") {
        return '<a href="/sw/home/" class="G-crumb">home</a>&nbsp;&gt;&nbsp<a href="/menu/multiplayer.jsp" class="G-crumb">multiplayer</a>';
    }

	var returnHTML = "";

	var currentTrail = "";

	// var trailTail = this.trailArray.length - 1;

	for (var i=0; i < this.trailArray.length; i++)
	{
		currentTrail += (i>0 ? "/" : "") + this.trailArray[i] ;

		var a = this.getCrumbLink(currentTrail,true);
		if (a) 
		{
			returnHTML += (i>0 ? "&nbsp;&gt;&nbsp;" : "") + a;
		}
	}

	if (this.trailEnd) returnHTML += "&nbsp;&gt;&nbsp;" + this.trailEnd.TITLE;

	return returnHTML;
}

function crumb_getCrumbLink(trail,linked,full)
{
	var crumb = trail.substring(trail.lastIndexOf("/") + 1);

	var name = "";

	// list naming exceptions here
	var names = new Object();
	names["actiongames"] = "action games";
	names["mindgames"] = "mind games";
        names["action_puzzles"] = "action puzzles";
        names["arcade_classics"] = "arcade classics";
        names["word_games"] = "word games";
        names["card_board"] = "card & board";
        names["musicphotos"] = "music & photos";
        names["music_mixers"] = "music mixers";
        names["photo_fun"] = "photos & art";
        names["music_videos"] = "music videos";
	names["create"] = "music & photos";
	names["gay"] = "gay & lesbian";
	names["star"] = "star powered";
	names["starwars"] = "star wars";
	names["women"] = "women auteurs";
	names["stopmotion"] = "stop motion";
	names["sex"] = "sex & sexuality";
	names["scifi"] = "sci-fi";
	names["australia"] = "australia/newzealand";
	names["france"] = "france/benelux";
	names["uk"] = "united kingdom";
	names["spain"] = "spain/portugal";
	names["wordplay"] = "word play";
	names["dailydose"] = "daily dose";
	names["gamedownloads"] = "game downloads";
	names["greedy"] = "the greedy show";
	names["videomixer"] = "SKIP";
	names["threedgames"] = "3d games";
	names["bikinibandits"] = "bikini bandits";
	names["stemsandseeds"] = "stems and seeds";
	names["greatesthits"] = "greatest hits";
	names["firstlooklounge"] = "first look lounge";
	names["madnesscombat"] = "madness combat";
	names["nickonline"] = "nick.com";

	if (crumb == "af")
	{
		name = "home";
		trail += "/home"
	}
	else if (crumb == "sw")
	{
		name = "home";
		trail += "/home"
	}
	else if (crumb == "action" && this.site == 'sw')
		name = "action/adventure";
	else if (crumb == "action" && this.site == 'af')
		name = "action";
	else if (crumb == "games" && this.previousCrumb == 'sw/games/puzzles')
		name = "puzzle games";
	else if (names[crumb])
		name = names[crumb];
	else
		name = crumb;

	this.previousCrumb = trail;
	trail = "/" + trail + "/";

	if (name == 'SKIP') { return ''; }

	if (linked) name = '<a href="' + trail + '" class="G-crumb">' + name + '</a>';

	return name;
}

function crumb_drawSubchannelHeader()
{
	document.write('<img src="/images/header/page/page_' + this.subchannel 
		+ '.gif" width="610" height="23" border="0">');
}
