var adTemplate = 255;

// Define all possible ad positions
var BANNER_TOP    = 1 << 0;
var BANNER_BOTTOM = 1 << 1;
var TOWER_LEFT    = 1 << 2;
var TOWER_RIGHT   = 1 << 3;
var BIGBOX        = 1 << 4;
var BIGBOX_LEFT = 1 << 5;
var SUPER_BANNER  = 1 << 6;
var SUPER_BANNER_BOTTOM = 1 << 7;
var GOOGLE_LINKS	= 1 << 8;
var HALFPAGE_LEFT = 1 << 9;
var TOWER_LEFT_160 = 1 << 10 ;
var FIRST_COLUMN_160 = 1 << 11 ;

// Define all possible ad templates
var STANDARD = 0 ;
var GOOGLELESS = 1 ;
var NONE = 2 ;
var HALFPAGE_ONLY = 3;
var LEADERBOARD_SKY = 4;
var LEADERBOARD_BIGBOX = 5;
var PRINTER_FRIENDLY = 6;
var FLEX_DISPLAY = 7;
var NOLEADER = 8;

var DEFAULT_TEMPLATE = FLEX_DISPLAY ;

// Allow for IE User to get google links
GOOGLE=GOOGLE_LINKS;

if (typeof commercialNode == 'undefined') {
commercialNode = '';
}
// Makes fourth column equal to true if commercial node is equal to technology
if ( (commercialNode.indexOf("technology") != -1) && (thisNode.indexOf("technology") == -1) ) {
BIGBOX = BIGBOX_LEFT;
TOWER_LEFT_160 = null;
}

// Check screen width to see if user is eligible for fourth column skyscraper (must have a resolution higher than 860 wide, and not use Netscape
if ((screen.width<=860) || (document.layers))
	{FIRST_COLUMN=null;}
else{FIRST_COLUMN=FIRST_COLUMN_160;}

// Removes google links for individual articles.  
articleUrl = document.location.href;
//if (articleUrl.indexOf('A37827-2004Feb12') != -1) GOOGLE=null; // Feb. 13, 2004
if (articleUrl.indexOf('A51640-2005Feb24') != -1) GOOGLE=null; // Black Condi Rice article
if (articleUrl.indexOf('A62496-2005Apr18') != -1) GOOGLE=null; // school bus crash


if (thisNode == 'nation/specials/aroundthenation/hurricanes') GOOGLE = null; // NO GOOGLE ON HURRICANE ARTICLES
if (thisNode == 'nation/nationalsecurity') GOOGLE = null;
if (thisNode == 'world/asia/southasia') GOOGLE = null;// NO GOOGLE ON TSUNAMI ARTICLES
if (thisNode == 'world/europe/westerneurope/holysee') GOOGLE = null;// NO GOOGLE ON POPE ARTICLES
if (thisNode == 'metro/religion') GOOGLE = null;// NO GOOGLE ON POPE ARTICLES
if (thisNode == 'metro') GOOGLE = null;


// Define contents of ad templates
var templateConfigs = new Array();

templateConfigs[ STANDARD ]   = SUPER_BANNER + FIRST_COLUMN_160 + BIGBOX_LEFT + SUPER_BANNER_BOTTOM + GOOGLE ;
templateConfigs[ GOOGLELESS ] = SUPER_BANNER + FIRST_COLUMN_160 + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM ;
templateConfigs[ NOLEADER ]   = FIRST_COLUMN_160 + BIGBOX_LEFT + GOOGLE ;
templateConfigs[ NONE ]       = 0 ;
templateConfigs[ HALFPAGE_ONLY ] = HALFPAGE_LEFT + GOOGLE;
templateConfigs[ LEADERBOARD_SKY ] = SUPER_BANNER + TOWER_LEFT_160 + SUPER_BANNER_BOTTOM  + GOOGLE;
templateConfigs[ LEADERBOARD_BIGBOX ] = SUPER_BANNER + BIGBOX_LEFT + SUPER_BANNER_BOTTOM  + GOOGLE;
templateConfigs[ PRINTER_FRIENDLY ] = TOWER_LEFT_160 + GOOGLE;
templateConfigs[ FLEX_DISPLAY ] = SUPER_BANNER + BIGBOX_LEFT + SUPER_BANNER_BOTTOM + GOOGLE;


// Make node-to-template assignments

// 120x600 Tower Ads
var nodeConfigs = new AdConfigurations();

nodeConfigs.addConfiguration('entertainment')
.addTemplateAssignment(new TemplateAssignment(LEADERBOARD_SKY,.5))
.addTemplateAssignment(new TemplateAssignment(LEADERBOARD_BIGBOX,.5))
nodeConfigs.addConfiguration('mostemailed')
.addTemplateAssignment(new TemplateAssignment(LEADERBOARD_SKY,.5))
.addTemplateAssignment(new TemplateAssignment(LEADERBOARD_BIGBOX,.5))
nodeConfigs.addConfiguration('admin/keycontent')
.addTemplateAssignment(new TemplateAssignment(LEADERBOARD_BIGBOX,1))
nodeConfigs.addConfiguration('visitorsguide')
.addTemplateAssignment(new TemplateAssignment(LEADERBOARD_SKY,1))
nodeConfigs.addConfiguration('metro')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))
nodeConfigs.addConfiguration('health')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))
nodeConfigs.addConfiguration('education')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))
nodeConfigs.addConfiguration('realestate')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))
nodeConfigs.addConfiguration('obituaries')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))
nodeConfigs.addConfiguration('sports')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))
nodeConfigs.addConfiguration('artsandliving')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))
nodeConfigs.addConfiguration('cars')
.addTemplateAssignment(new TemplateAssignment(STANDARD,1))


// For this node, select a template
adTemplate = nodeConfigs.getTemplate( thisNode );
if ( (typeof commercialNode != 'undefined') && (commercialNode != "") )
{
  if (thisNode.indexOf("technology") != -1)
    adTemplate = nodeConfigs.getTemplate( thisNode )
  else
    adTemplate = nodeConfigs.getTemplate( commercialNode );
}
else
{
  adTemplate = nodeConfigs.getTemplate( thisNode );
}

if (document.location.href.indexOf("debugAdCode") != -1) document.writeln("Ad Template: " + adTemplate);

// Define objects
// TemplateAssignment associates a template with a frequency ( 0 <= frq <= 1 )
function TemplateAssignment( tmpl, frq )
{
  this.template = tmpl;
  this.frequency = ( ( frq >= 0 ) && ( frq <= 1 ) ) ? frq : 0 ;
}

// NodeTemplateAssignment collects TemplateAssignment objects for a specific node
function NodeTemplateAssignment ( node )
{
  this.node = node;
  this.templates = new Array();
  this.templateCount = 0;
  
  this.addTemplateAssignment = _addAdTemplateAssignment;
  this.selectTemplate = _adSelectTemplate;
}

// AdConfigurations collects NodeTemplateAssignments for the site
function AdConfigurations ()
{
  this.configs = new Array();
  this.length = 0;
  
  this.addConfiguration = _addAdConfiguration;
  this.getTemplate = _adGetTemplate;
}

function _adSelectTemplate()
{
  var base = 0;
  var rNum = Math.random();
  var rTemplate = STANDARD;
  
  for (var count = 0; count < this.templates.length; count++)
  {
    if ( rNum < this.templates[count].frequency + base ) 
    {
      rTemplate = this.templates[count].template;
      break;
      //return this.templates[count].template;
    }
    else
    {
      base += this.templates[count].frequency;
    }
  }
  return rTemplate;
}

function _adGetTemplate ( node )
{
  adTemplate = DEFAULT_TEMPLATE;
  var base = 0;
  var bestMatch = 0;
  for ( var count = 0; count < this.length; count++ )
  {
    if ( this.configs[count].node == node )
    {
      adTemplate = this.configs[count].selectTemplate();
      break;
    }
    else if (( node.indexOf(this.configs[count].node) == 0 ) && ( this.configs[count].node.length > bestMatch ))
    {
      adTemplate = this.configs[count].selectTemplate();
      bestMatch = this.configs[count].node.length;
    }
  }
  return templateConfigs[adTemplate];
}

function _addAdTemplateAssignment( templateAssignment )
{
  this.templates[this.templateCount++] = templateAssignment;
  return this;
}

function _addAdConfiguration ( n )
{
  this.configs[this.length++] = new NodeTemplateAssignment (n);
  return this.configs[this.length - 1];
}