// NUMBER OF JOBS TO DISPLAY
function isTjDisplayable( node )
{
  if ( thisNode == "education/kidspost" ||
       thisNode == "metro/obituaries" )
  return false ;

  // two criteria needed: the node and whether local user is required or not
  // if isLocal is false, anyone is eligible to see the listing
  function TopJobCriterion( node,isLocal )
  {
    this.node    = node    ;
	this.isLocal = isLocal ;
  }

  function isALocalUser()
  {
    if ( typeof doLocal == "boolean" )
      return doLocal ;
    else
    {
      function getCookie(name)
      {
        var cookie = " " + unescape(document.cookie) ;
        var search = " " + name + "=" ;
        var setStr = null ;
        var offset = 0 ;
        var end = 0 ;

        if ( cookie.length > 0 )
        {
          offset = cookie.indexOf(search) ;
          if (offset != -1)
          {
            offset += search.length ;
            end = cookie.indexOf(";", offset)

            if (end == -1)
              end = cookie.length ;

            setStr = cookie.substring(offset,end) ;
          }
        }
        return(setStr) ;
      } // end function getCookie()

	  var tj_WPATC = getCookie("WPATC") ;
	
	  if ( tj_WPATC && tj_WPATC.indexOf("C=1") != -1 )
	    return true ;
	  else
	    return false ;
	} // end if doLocal doesn't exist ;
  } // end function isALocalUser()

  // set up a list of criteria
  var criteria = new Array(
    new TopJobCriterion("business/washingtonbusiness",false),
    new TopJobCriterion("education",true),
    new TopJobCriterion("jobs",false),
    new TopJobCriterion("metro",true),
    new TopJobCriterion("sports",true),
    new TopJobCriterion("style",true)
  )

  for (var i=0; i<criteria.length; i++)
  {
    var criterion = criteria[i] ;
    if ( criterion.node == node || node.indexOf( criterion.node+"/" ) == 0 )
	{
	  if (! criterion.isLocal )
	    return true ;
	  else if ( isALocalUser() )
	    return true ;
	}
  }

  // if nothing else returned true, return false
  return false ;

} // end function isTjDisplayable()
