////////////////// check items /////////////////
function checkValidDate(point) {
	if (jsTools_strTrim(point.value) != "" ) {
		if (validDate(point.value, point))
			return point.value;
		else {
			//alert("Please enter a valid date.");
			point.focus();
			return "";
		}
	}
	else 
		return "";
		
}

function DateComp(start_date, end_date){
	if (start_date != "" && end_date != ""){
		if (Date.parse(end_date) < Date.parse(start_date))
			return -1;
		if (Date.parse(end_date) == Date.parse(start_date))
			return 0;
		if (Date.parse(end_date) > Date.parse(start_date))
			return 1;
	}
	else
		return 0;
}

function checkDate_js(point, asp_year, asp_month, asp_day) {
	if (jsTools_strTrim(point.value) != "" ) {
		if (validAspDate(asp_year, asp_month, asp_day, point.value, point, ''))
			return point.value;
		else {
			//alert("Please enter a valid date.");
			point.focus();
			return "";
		}
	}
	else
		return "";
}

function checkBeforeDate_js(point, asp_year, asp_month, asp_day) {
	if (jsTools_strTrim(point.value) != "" ) {
		if (validAspDate(asp_year, asp_month, asp_day, point.value, point, 'before'))
			return point.value;
		else {
			//alert("Please enter a valid date.");
			point.focus();
			return "";
		}
	}
	else
		return "";
}

function checkMoney_js(point) {
	point.value = point.value.replace(/,/g, "");
	if (jsTools_strTrim(point.value) != "" ) {
		if (jsDV_isValidMoney(jsTools_strTrim(point.value)) != "-1")
			return jsDV_isValidMoney(jsTools_strTrim(point.value));
		else {
			alert("Please enter a valid amount.");
			point.focus();
			return "";
		}
	}
	else
		return "";
}

function checkEmail_js(point) {
	if (jsTools_strTrim(point.value) != "" ) {
		if (validEmail(jsTools_strTrim(point.value),"nomsg"))
			return point.value;
		else {
			alert("Please enter a valid email address. Email addresses must include the @ sign and at least one period. (e.g. friendname@abc.com)");
			point.focus();
			return "";
		}
	}
	else
		return "";
}

function checkNumber_js(pointer) {
	pointer.value = jsTools_strTrim(pointer.value);
	if(pointer.value != "") {		
		if(isValidNumber(pointer.value) != "-1") {
			return isValidNumber(pointer.value);
		}
		else
			alert("Please enter a valid number.");
			pointer.focus();
			return "";
	}
	else
		return "";
}

function checkInterZip_js(point) {
	if (jsTools_strTrim(point.value) != "" ) {
		if (isValidInterZip(jsTools_strTrim(point.value)))
			return point.value;
		else {
			alert("Please enter a valid zip/postal code.");
			point.focus();
			return "";
		}
	}
	else 
		return "";
}

////////////////////// special check for the custom fields ////////////////////////
function isValidInterZip(str) {
	if (str == "") return true;
	
	for (i = 0; i < str.length; i++) {
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
			(str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') ||
			(str.charAt(i) >= 'a' && str.charAt(i) <= 'z') ||
			(str.charAt(i) == '-') ||
			(str.charAt(i) == ' ')) continue;
		else return false;
	}
	return true;
}

function validAspDate(asp_year, asp_month, asp_day, val, textBox, type, msg, msg2){
	var dateErrorMsg = msg;
	var spaceErrorMsg = msg2;
	var indate = val;
	var flag = 0;
	if (indate == "") return false;
	if (dateErrorMsg == null) {
		textBox.value = "";
		dateErrorMsg = "You have entered an invalid date or date format. Please use the format MM/DD/YYYY without spaces.";
	}
	if (spaceErrorMsg == null) {
		textBox.value = "";
		spaceErrorMsg = "Please re-enter your date using the format MM/DD/YYYY without spaces.";
	}
	if (indate.indexOf(" ")!=-1) {
		if(dateErrorMsg != "nomsg") {
			textBox.value = "";
			alert(spaceErrorMsg);
			textBox.focus();
		}
		return false;
	}	
	if (indate.indexOf("-")!=-1)
		var delimeter = "-";
	else if (indate.indexOf("/")!=-1)
		var delimeter = "/";
	else if (indate.indexOf(".")!=-1)
		var delimeter = ".";
	else
		flag++;
	var dateArray = indate.split(delimeter);
	if((dateArray.length != 3) || ((dateArray[2].length != 2) && (dateArray[2].length != 4)) ||
	(dateArray[0].length < 1) || (dateArray[0].length > 2) || (dateArray[1].length < 1) ||
	(dateArray[1].length > 2)) {
		flag++;
	}
	else if ((numericCheck(dateArray[0], 0, dateErrorMsg)==false) || (numericCheck(dateArray[1], 0, dateErrorMsg)==false) || (numericCheck(dateArray[2], 0, dateErrorMsg)==false)) {  
		return false;
	}
	var intYear = parseInt(dateArray[2], 10);
	if ((intYear >= 0) & (intYear <= 29))
		dateArray[2] = 2000 + intYear;
	else if ((intYear >= 30) & (intYear <= 99))
		dateArray[2] = 1900 + intYear;
	if (isDate(dateArray[2], dateArray[0], dateArray[1])==false)
		flag++;
	if(flag != 0) {
		if(dateErrorMsg != "nomsg") {
			alert(dateErrorMsg);
			textBox.value = "";
			textBox.focus();
		}
		return false;
	}
	if ((dateArray[2] > 99) & (dateArray[2] < 1753)) {
		if(dateErrorMsg != "nomsg") {
			textBox.value = "";
			alert("We do not support dates before 1753.  Please choose a later year and try again.");
			textBox.focus();
		}
		return false;
	}
	if ( type=='before' && ( (dateArray[2] > asp_year)	
	|| (dateArray[2] == asp_year && dateArray[0] > asp_month) 
	|| (dateArray[2] == asp_year && dateArray[0] == asp_month && dateArray[1] > asp_day) ) ) {
		if(dateErrorMsg != "nomsg") {
			textBox.value = "";
			alert("We do not support dates after today.  Please try again.");
			textBox.focus();
		}
		return false;
	}
	if ( type=='after' && ( (dateArray[2] < asp_year)	
	|| (dateArray[2] == asp_year && dateArray[0] < asp_month) 
	|| (dateArray[2] == asp_year && dateArray[0] == asp_month && dateArray[1] < asp_day) ) ) {
		if(dateErrorMsg != "nomsg") {
			textBox.value = "";
			alert("We do not support dates before today.  Please try again.");
			textBox.focus();
		}
		return false;
	}
	indate = dateArray[0] + "/" + dateArray[1] + "/" + dateArray[2];
	textBox.value = indate;  // Set the date in the form to the modified date.
	return true;
}

//designed for netscape4
function itemDisable(elem) { // elem: form element to be disabled
	elem.onfocus=elem.blur;
}

function itemEnable(elem) { // elem: form element to be reenabled
	elem.onfocus=null;
}

function isValidNumber(strNum) {
	// str must not be empty string
	var zeroFlag = 1;
	var str = strNum;
	//empty input
	if (str.length < 1) return "0";

	//check the character set
	for (i = 0; i < str.length; i++) {
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9')) {
			if (str.charAt(i) != '0') zeroFlag = 0;
			continue;
		}
		else 
			return "-1";
	}

	if (str.length > 1 && zeroFlag == 0) {
		//e.g. 0898
		if (str.charAt(0) == '0') return "-1";
	}

	//multiple valid '0', just return single '0'
	if (zeroFlag) str = "0";
	return str;
}

function isFramed() {
	if ((top.location.href).toLowerCase() == (document.location.href).toLowerCase())
		return false;
	else
		return true;
}
